<?php
include_once('../../../../param.php');

// DB table to use
$table = 'SubCustomerGroups';

// Table's primary key
$primaryKey = "date_added";

$columns = array(
    array(
        'db' => 'CONCAT(g1.group_code, " - ", g1.name)',
        'dt' => 'group_column',
        'field' => 'group_column',
        'as' => 'group_column'
    ),
    array(
        'db' => 'CONCAT(g2.group_code, " - ", g2.name)',
        'dt' => 'subgroup_column',
        'field' => 'subgroup_column',
        'as' => 'subgroup_column'
    ),
    array(
        'db' => 's.group_id',
        'dt' => 'group_id',
        'field' => 'group_id'
    ),
    array(
        'db' => 's.subgroup_id',
        'dt' => 'subgroup_id',
        'field' => 'subgroup_id'
    ),

    array(
        'db' => 's.group_id',
        'dt' => 'form',
        'formatter' => function($d, $row) {
            $groupId = $row['group_id'];
            $subgroupId = $row['subgroup_id'];
            return '<button class="btn btn-primary" onclick="openEditModal('.$groupId.', '.$subgroupId.');">Edit</button>';
        },
        'field' => 'form'
    )
);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database,
    'host' => 'localhost'
);

// Get allowed groups from session
$allowedGroups = $_SESSION['Allow_CustomerGroups'];
$joinQuery = "FROM SubCustomerGroups AS s 
             LEFT JOIN CustomerGroups AS g1 ON s.group_id = g1.group_id 
             LEFT JOIN CustomerGroups AS g2 ON s.subgroup_id = g2.group_id";
if(!empty($allowedGroups)) {
    $where = "s.group_id IN ($allowedGroups)";

}

require(ROOT.'backend/core/controllers/ssp2.class.php');

echo json_encode(
    SSP::simple($_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $where)
);
?>