<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');

// DB table to use
$table = 'Price_Group_Definitions';

// Table's primary key
$primaryKey = "price_group_definition_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array(
        'db' => 'price_group_definition_id',
        'dt' => 'pgdID',
        'field' => 'price_group_definition_id'),

    array(
        'db' => 'price_group_code',
        'dt' => 'code',
        'field' => 'price_group_code',
        'formatter' => function($d, $row) {
            $uniqueID = $row['price_group_definition_id'];
            $displayValue = !empty($d) ? $d : '&nbsp;';
            $fieldName = 'code';

            return "
        <div id='editable-$uniqueID' 
             data-field-name='$fieldName' 
             data-id='$uniqueID' 
             style='position: relative; cursor: pointer;'
             onmouseover='$(this).find(\".fa-pencil\").show();'
             onmouseleave='$(this).find(\".fa-pencil\").hide();'
             onclick='openEditField(\"$uniqueID\", \"$fieldName\");'>
            <span id='value-$fieldName-$uniqueID'>$displayValue</span>
            <span id='pen-$fieldName-$uniqueID'><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
        </div>
            <div  style='white-space: nowrap;'>
	        <input type='text' class='form-control text-center' id='input-$fieldName-$uniqueID' value='' style='display:none;'>
	        <button id='save-$fieldName-$uniqueID' class='btn btn-success' style='display:none;'>
            <i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i>
        </button>
</div>
        ";
        }

    ),
    array(
        'db' => 'name',
        'dt' => 'name',
        'field' => 'name',
        'formatter' => function($d, $row) {
            $uniqueID = $row['price_group_definition_id'];
            $displayValue = !empty($d) ? $d : '&nbsp;';
            $fieldName = 'name';

            return "
        <div id='editable-$uniqueID' 
             data-field-name='$fieldName' 
             data-id='$uniqueID' 
             style='position: relative; cursor: pointer;'
             onmouseover='$(this).find(\".fa-pencil\").show();'
             onmouseleave='$(this).find(\".fa-pencil\").hide();'
             onclick='openEditField(\"$uniqueID\", \"$fieldName\");'>
            <span id='value-$fieldName-$uniqueID'>$displayValue</span>
            <span id='pen-$fieldName-$uniqueID'><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
        </div>
            <div  style='white-space: nowrap;'>
	        <input type='text' class='form-control text-center' id='input-$fieldName-$uniqueID' value='' style='display:none;'>
	        <button id='save-$fieldName-$uniqueID' class='btn btn-success' style='display:none;'>
            <i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i>
        </button>
</div>
        ";
        }

    ),
    array(
        'db' => 'type',
        'dt' => 'type',
        'field' => 'type',
        'formatter' => function($d, $row) {
            $uniqueID = $row['price_group_definition_id'];
            $displayValue = !empty($d) ? $d : '&nbsp;';
            $fieldName = 'type';

            return "
        <div id='editable-$uniqueID' 
             data-field-name='$fieldName' 
             data-id='$uniqueID' 
             style='position: relative; cursor: pointer;'
             onmouseover='$(this).find(\".fa-pencil\").show();'
             onmouseleave='$(this).find(\".fa-pencil\").hide();'
             onclick='openEditField(\"$uniqueID\", \"$fieldName\");'>
            <span id='value-$fieldName-$uniqueID'>$displayValue</span>
            <span id='pen-$fieldName-$uniqueID'><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
        </div>
            <div  style='white-space: nowrap;'>
	        <input type='text' class='form-control text-center' id='input-$fieldName-$uniqueID' value='' style='display:none;'>
	        <button id='save-$fieldName-$uniqueID' class='btn btn-success' style='display:none;'>
            <i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i>
        </button>
</div>
        ";
        }

    )

);

// SQL server connection information

global $username,$password,$database;
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM Price_Group_Definitions";
$where = '';


require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $where )
);

?>