<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */

include_once('../../../../param.php');
// DB table to use
$table = 'CRM_Opportunities';

// Table's primary key
$primaryKey = "crm_opportunity_id";

$customerID = $_GET['customer_id'];
$stageID = $_GET['stageID'];
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`o`.`crm_opportunity_id`', 'dt' => 'img', 'formatter' => function( $d, $row ) {
        $GLOBALS['crm_opportunity_id']=$d;
        return '<img class="custom-rounded-image center-canvas" src="//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/opportunityimage.png" width="30" height="30"></td>';},
        'field' => 'crm_opportunity_id' ),
    array( 'db' => '`o`.`crm_opportunity_code`', 'dt' => 'code', 'field' => 'crm_opportunity_code' ),
    array( 'db' => '`c`.`customer_company_name`', 'dt' => 'name', 'field' => 'customer_company_name' ),


    array( 'db' => '`o`.`crm_opportunity_name`', 'dt' => 'opp', 'field' => 'crm_opportunity_name' ),
    array( 'db' => '`t`.`crm_opportunity_type_name`', 'dt' => 'type', 'formatter' => function( $d, $row ) {
        $p = $GLOBALS['crm_opportunity_id'];
        global $username,$password,$database;
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");

        $stm = $db->prepare("SELECT crm_opportunity_type_color FROM CRM_Opportunity_Types,CRM_Opportunities WHERE CRM_Opportunity_Types.crm_opportunity_type_id=CRM_Opportunities.crm_opportunity_type_id AND CRM_Opportunities.crm_opportunity_id='$p' LIMIT 1");
        $stm->execute();
        $stm->bind_result($color);
        while ($stm->fetch()) {

            if(strcmp($color,"")==0)
            {
                $color="#333";
            }

        }
        $stm->close();




        return "<span style='font-weight:bold;color:$color'>$d</span>";}, 'field' => 'crm_opportunity_type_name' ),


    array( 'db' => '`st`.`stage_name`', 'dt' => 'stage', 'formatter' => function( $d, $row ) {

        $p = $GLOBALS['crm_opportunity_id'];
        $options=" <select class='form-control opportunityStage'  id='opportunityStage' name='opportunityStage' onchange='changeStage(this,$p)'>";
        global $username,$password,$database;
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");
        $check = false;
        $stm = $db->prepare("SELECT stage_id,stage_name,stage_color FROM CRM_Opportunity_Stages ORDER BY stage_position");
        $stm->execute();
        $stm->bind_result($stageID,$stageName,$stageColor);

        while ($stm->fetch()) {
            if(strcmp($d,$stageName)==0){
                $options.= "<option onclick='' style='color:$stageColor' value='$stageID' selected>$stageName</option>";
            }
            else{
                $options.= "<option onclick='' style='color:$stageColor' value='$stageID'>$stageName</option>";
            }

        }
        $stm->close();

        $options.="</select>";
        return $options;

    }, 'field' => 'stage_name' ),


    array( 'db' => '`o`.`next_step`', 'dt' => 'step', 'field' => 'next_step' ),
    array( 'db' => '`o`.`amount`', 'dt' => 'amount', 'field' => 'amount' ),
    array( 'db' => '`o`.`close_date`', 'dt' =>  'date', 'formatter' => function( $d, $row ) {

        if(strcmp($d,"0000-00-00 00:00:00") == 0)
        {
            return "";
        }

        $d = date('d-m-Y H:i:s',strtotime($d));

        $d = str_replace("00:00:00", "", $d);

        return $d;
    }, 'field' =>'close_date' ),
    array( 'db' => '`sa`.`salesperson_code`', 'dt' => 'sal', 'formatter' => function( $d, $row ) {
        $GLOBALS['salepersonCode']=$d;
        return"";

    }, 'field' => 'salesperson_code' ),
    array( 'db' => '`sa`.`first_name`', 'dt' => 'salespersonid', 'formatter' => function( $d, $row ) {

        $p = $GLOBALS['crm_opportunity_id'];
        $salesP=$GLOBALS['salepersonCode'];
        $options="";
        global $username,$password,$database;
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");
        $check = false;
        $stm = $db->prepare("SELECT salesperson_id,salesperson_code,CONCAT(salesperson_code,' ',first_name,' ',last_name) FROM SalesPersons");
        $stm->execute();
        $stm->bind_result($salespersonID,$salespersonCode,$salespersonName);

        while ($stm->fetch()) {
            if(strcmp($salesP,$salespersonCode)==0){
                $options= "$salespersonName";
            }

        }
        $stm->close();


        return $options;

    }, 'field' => 'first_name' ),
    array( 'db' => '`o`.`crm_opportunity_id`', 'dt' => 'actions', 'formatter' => function( $d, $row ) {

        return '<form id="'.$d.'" class="tableRowForm" target="_blank"  action="//'.HTML_PATH .'/cop/backend/core/views/view/view_opportunity.php" method="post" style="display:inline;">
           		<input type="hidden" class="crm_opportunity_id" name="crm_opportunity_id" value="'.$d.'">		
			</form>
			'

            ;},
        'field' => 'crm_opportunity_id' )
);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `CRM_Opportunities` AS `o` LEFT JOIN `Customers` AS `c` ON (`o`.`customer_id` = `c`.`customer_id` ) LEFT JOIN `CRM_Opportunity_Types` AS `t` ON (`o`.`crm_opportunity_type_id` = `t`.`crm_opportunity_type_id` ) LEFT JOIN `CRM_Opportunity_Stages` AS `st` ON (`o`.`crm_opportunity_stage_id` = `st`.`stage_id`) LEFT JOIN `SalesPersons` AS `sa` ON (`o`.`owner_id` = `sa`.`salesperson_id` )";
require( ROOT.'backend/core/controllers/ssp2.class.php' );
if(isset($customerID))
{
    $where="`o`.customer_id=$customerID";
}
else if(isset($stageID))
{
    $where="`o`.crm_opportunity_stage_id=$stageID";
}
else if(isset($groupID))
{
    $where="`c`.customer_id IN(SELECT customer_id AS customer_id FROM Customer_CustomersGroup WHERE group_id='$groupID')";
}
else if(isset($serialNumberID))
{
    $where="`s`.serial_number_id=$serialNumberID";
}
else if(isset($openOnly))
{
    $where="`s`.status_id IN(1,4,5)";
}
else if(isset($city))
{
    //$where="`s`.salesperson_id IN(SELECT id AS salesperson_id FROM Admin WHERE user_group='$city') AND `s`.status_id IN(1,4,5)" ;
    $where=" ((`s`.assign_to =0 AND `s`.salesperson_id IN(SELECT id AS salesperson_id FROM Admin WHERE user_group='$city')) OR (`s`.assign_to IN(SELECT id AS salesperson_id FROM Admin WHERE user_group='$city'))) AND `s`.status_id IN(1,4,5)" ;
}
else if(isset($from) && isset($to)&& isset($status))
{
    $where=" `s`.assign_to ='$to' AND `s`.salesperson_id ='$from' AND `s`.status_id IN(1,4,5)" ;
}
else{
    $where='';
}

if(isset($_SESSION['Allow_Customers']) && strcmp($_SESSION['Allow_Customers'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= "`c`.`customer_id` IN (".$_SESSION['Allow_Customers'].")";
}
if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= " `s`.`assign_to` IN (".$_SESSION['Allow_Salespersons'].")";
}


echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>