<?php
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
 include_once('../../../../param.php');
// DB table to use
$table = 'Loyalty_Types';
 
// Table's primary key
$primaryKey = "loyalty_type_id";
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`l`.`loyalty_type_id`', 'dt' => 'img', 'formatter' => function( $d, $row ) {

        return '<img class="custom-rounded-image return center-canvas" src="//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/pickinglisticon.png" width="30" height="30"></td>';

    }, 'field' => 'loyalty_type_id' ),

    array( 'db' => '`l`.`loyalty_type_code`', 'dt' =>  'code', 'field' =>'loyalty_type_code' ),
    array( 'db' => '`l`.`name`', 'dt' =>  'name', 'field' =>'name' ),
    array( 'db' => '`l`.`description`', 'dt' =>  'description', 'field' =>'description' ),
    array( 'db' => '`l`.`valid_from`', 'dt' =>  'valid_from', 'formatter' => function( $d, $row ) {return date_format( date_create_from_format('Y-m-d', $d), 'd-m-Y');}, 'field' =>'valid_from' ),
    array( 'db' => '`l`.`valid_until`', 'dt' =>  'valid_until', 'formatter' => function( $d, $row ) {return date_format( date_create_from_format('Y-m-d', $d), 'd-m-Y');}, 'field' =>'valid_until' ),
    array( 'db' => '`l`.`status`', 'dt' =>  'status', 'formatter' => function( $d, $row ) {
        $GLOBALS['status']=$d;

        if(strcmp($d,'yes')==0){
            $bullet = "<span style='height: 10px;width: 10px;background-color: #008080;border-radius: 50%;display:inline-block;' class='dot'></span>&nbsp;<b>";
        } else {
            $bullet = "<span style='height: 10px;width: 10px;background-color: firebrick;border-radius: 50%;display:inline-block;' class='dot'></span>&nbsp;<b>";
        }

        return $bullet.ucfirst($d);
        }, 'field' =>'status' ),

    array( 'db' => '`l`.`loyalty_type_id`', 'dt' => 'activate', 'formatter' => function( $d, $row ) {

        $status = $GLOBALS['status'];

        if(strcmp($status,'yes')==0){
            $button = '<button type="button" class="btn btn-danger" onclick="changeLoyaltyStatus('.$d.',\'no\')" style="display: inline-block;margin-top: 3px;width: 100px;">Deactivate</button>';
        } else {
            $button = '<button type="button" class="btn btn-success" onclick="changeLoyaltyStatus('.$d.',\'yes\')" style="display: inline-block;margin-top: 3px;width: 100px">Activate</button>';
        }

        return $button;
    }, 'field' => 'loyalty_type_id' ),


    array( 'db' => '`l`.`loyalty_type_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {

        return '<form style="display:inline;" target="_blank" id="'.$d.'" action="//'.HTML_PATH .'/cop/backend/core/views/addedit/new_loyalty_type.php" method="post">
        		    <input type="hidden" name="loyaltyID" value="'.$d.'">	           			                   
			        <input style="font-size:13px; margin-top: 3px;width: 80px;" type="submit" class="btn btn-primary btn-block" value="Edit" >
			    </form>';

    }, 'field' => 'loyalty_type_id' )
);
 
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$where = '';
if(isset($_SESSION['Allow_Customers']) && strcmp($_SESSION['Allow_Customers'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= "`c`.`customer_id` IN (".$_SESSION['Allow_Customers'].")";
}
if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= " `o`.`salesperson_id` IN (".$_SESSION['Allow_Salespersons'].")";
}
$joinQuery = "FROM `Loyalty_Types` AS `l` ";
require( ROOT.'backend/core/controllers/ssp2.class.php' );
 
echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
     );
     
     ?>