<?php
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
 include_once('../../../../param.php');
// DB table to use
$table = 'Document_Email';
 
// Table's primary key
$primaryKey = "id";
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(

    array( 'db' => '`o`.`id`', 'dt' =>  'id', 'field' =>'id' ),
    array( 'db' => '`o`.`document_id`', 'dt' =>  'document_id', 'formatter' => function( $d, $row ) {
        $GLOBALS['document_id']=$d;
        return $d;
    }, 'field' =>'document_id' ),

    array( 'db' => '`o`.`document_code`', 'dt' =>  'document_code', 'formatter' => function( $d, $row ) {
        if(strcmp($d,'Simple Mail (No Attachment)')==0){$GLOBALS['no_attachment']=true;}else{$GLOBALS['no_attachment']=false;}
        return $d;
    }, 'field' =>'document_code' ),

    array( 'db' => '`o`.`document_type`', 'dt' =>  'document_type', 'formatter' => function( $d, $row ) {
        $docType = $d;
        $isAttachment = false;
        $docType = rtrim($docType,'s');
        $noAttachment = $GLOBALS['no_attachment'];
        if(strcmp($docType,'Transfer')==0){
            $class = "invoice";
            $table = "Warehouse_Transactions";
            $codeColumn = "warehouse_transaction_code";
            $idColumn = 'warehouse_transaction_id';
            $fileView = '//' . HTML_PATH . '/cop/backend/core/views/view/view_warehouse_transaction.php';
            $fileEdit = '//' . HTML_PATH . '/cop/backend/core/views/addedit/create_warehouse_transfer.php';

        } else if(strcmp($docType,'Attachment')==0){
            $class = 'transparent';
            $docType = 'Attachment';
            $isAttachment = true;
        } else {
            $class = strtolower($docType);
            $table = $docType."s";
            $codeColumn = strtolower($docType)."_code";
            $idColumn = strtolower($docType).'_id';
            $fileEdit = '//' . HTML_PATH . '/cop/backend/core/views/addedit/create_'.$class.'.php';
            $fileView = '//' . HTML_PATH . '/cop/backend/core/views/view/view_'.$class.'.php';
        }
        if($noAttachment){$docType = 'mail';}

        $GLOBALS['isAttachment']=$isAttachment;
        $GLOBALS['class']=$class;
        $GLOBALS['table']=$table;
        $GLOBALS['idColumn']=$idColumn;
        $GLOBALS['codeColumn']=$codeColumn;
        $GLOBALS['fileView']=$fileView;
        $GLOBALS['docType']=$docType;
        $GLOBALS['fileEdit']=$fileEdit;

        return $d;
    }, 'field' =>'document_type' ),

    array( 'db' => '`o`.`timestamp`', 'dt' =>  'timestamp', 'formatter' => function( $d, $row ) {
        return date_format( date_create_from_format('Y-m-d H:i:s', $d), 'd-m-Y H:i');
        }, 'field' =>'timestamp' ),

    array( 'db' => '`o`.`id`', 'dt' =>  'form', 'formatter' => function( $d, $row ) {

        $recID = $d;
        $isAttachment = $GLOBALS['isAttachment'];
        $class = $GLOBALS['class'];
        $table = $GLOBALS['table'];
        $idColumn = $GLOBALS['idColumn'];
        $codeColumn = $GLOBALS['codeColumn'];
        $fileView = $GLOBALS['fileView'];
        $docType = $GLOBALS['docType'];
        $fileEdit = $GLOBALS['fileEdit'];
        $docID = $GLOBALS['document_id'];
        $checkTableExits = false;
        $GLOBALS['customer'] = '';
        if(strcmp($table,'')!=0){
            global $username,$password,$database;
            $db2 = new mysqli(localhost,$username,$password,$database);
            if (mysqli_connect_errno())
            {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $db2->set_charset("utf8");

            $stm2 = $db2->prepare("SELECT count(*) FROM information_schema.tables WHERE table_name = '$table' LIMIT 1");
            $stm2->execute();
            $stm2->bind_result($countTable);
            while ($stm2->fetch()) {
                if ($countTable>0){
                    $checkTableExits = true;
                }
            }
            $stm2->close();

            if ($checkTableExits){
                $stm2 = $db2->prepare("SELECT Customers.customer_code,Customers.customer_company_name FROM $table,Customers WHERE $table.customer_id=Customers.customer_id AND $idColumn = $docID LIMIT 1");
                $stm2->execute();
                $stm2->bind_result($customerCode,$customerName);
                while ($stm2->fetch()) {$GLOBALS['customer']="<br><b>$customerCode - $customerName</b>";}
                $stm2->close();
            }
        }
        $GLOBALS['tableExists'] = $checkTableExits;
        if ($checkTableExits) {

            $buttons = '<form id="' . $docID . '" action="' . $fileView . '" method="post" target="_blank" style="display: inline-block; margin: 2px;">
                                                        <input type="hidden" name="' . $idColumn . '" value="' . $docID . '">	           			                   
                                                        <input style="font-size:13px;width:55px;" type="submit" class="btn btn-return yearly" value="View" >
                                                    </form>';

            $buttons .= '<form id="' . $docID . '" action="' . $fileEdit . '" method="post" target="_blank" style="display: inline-block; margin: 2px;">
                                                        <input type="hidden" name="' . $idColumn . '" value="' . $docID . '">
                                                        <input style="font-size:13px;width:55px;" type="submit" class="btn btn-primary" value="Edit" >
                                                    </form>';
        }
        $buttons .= '<button type="button" class="btn btn-danger" id="deleteButton'.$recID.'" onclick="deleteRecord('.$recID.')" style="display: inline-block; margin: 2px;">Delete Record </button>';


        return $buttons;
    }, 'field' =>'id' ),

    array( 'db' => '`o`.`email`', 'dt' =>  'email', 'formatter' => function( $d, $row ) {
        return $d.$GLOBALS['customer'];
    }, 'field' =>'email' ),

    array( 'db' => '`o`.`id`', 'dt' =>  'image', 'formatter' => function( $d, $row ) {

        $class = $GLOBALS['class'];
        $docType = $GLOBALS['docType'];
        $checkTableExits = $GLOBALS['tableExists'];
        if(strcmp($docType,'Attachment')==0){$imageType = 'pdf';}
        else if($checkTableExits){$imageType = $docType; }
        else {$imageType = 'email';$class='';}


        return "<td><img class='custom-rounded-image ".$class." center-canvas' src='//".HTML_PATH."/cop/backend/themes/smartadmin/img/".strtolower($imageType)."icon.png' width='30' height='30'></td>";
    }, 'field' =>'id' ),


);
 
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);
$where = '';

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Document_Email` AS `o` ";
require( ROOT.'backend/core/controllers/ssp2.class.php' );
 
echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
     );
     
     ?>