<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once("../../../../param.php");


// DB table to use
$table = 'Contract_Types';

// Table's primary key
$primaryKey = "contract_type_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array(
        'db' => 'contract_type_id',
        'dt' => 'contract_type_id',
        'field' => 'contract_type_id'
    ),

    array(
        'db' => 'contract_type_code',
        'dt' => 'code',
        'field' => 'contract_type_code'
    ),
    array(
        'db' => 'contract_type_name',
        'dt' => 'name',
        'field' => 'contract_type_name'
    ),
    array(
        'db' => 'days',
        'dt' => 'days',
        'field' => 'days'
    ),

    array( 'db' => '`contract_type_id`', 'dt' =>  'form', 'formatter' => function( $d, $row ) {
        $code = $row["contract_type_code"];
        $name = $row["contract_type_name"];
        $days= $row["days"];
        $button = "<a onclick='openEditModal(\"$d\",\"$code\",\"$name\",\"$days\");'>
                        <button type='submit' class='btn btn-primary' style='width:80px'> Edit</button>
                    </a>
                    ";
        return $button;
    }, 'field' =>'contract_type_id'

    )

);

global $username, $password, $database;
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);



$joinQuery = "FROM `Contract_Types`";
$where='';

require(ROOT . 'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>