<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */

include_once('../../../../param.php');

// DB table to use
$table = 'Allow_Categories_Customers';

// Table's primary key
$primaryKey = "cycle_type";

// Array of database columns which should be read and sent back to DataTables.
// The db parameter represents the column name in the database, while the dt
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array(
        'db' => 'CONCAT(c.customer_code,"-",c.customer_company_name)',
        'dt' => 'customer',
        'field' => 'customer',
        'as' => 'customer'

    ),
    array(
        'db' => 'CONCAT(ca.category_code,"-",ca.name)',
        'dt' => 'category',
        'field' => 'category',
        'as' => 'category'
    ),

    array(
        'db' => 'a.cycle_type',
        'dt' => 'cycleType',
        'field' => 'cycle_type'
    ),
    array(
        'db' => 'a.visit_cycle_in_days',
        'dt' => 'visitCycleDays',
        'field' => 'visit_cycle_in_days'
    ),
    array(
        'db' => 'a.last_visit_date',
        'dt' => 'lastVisitDate',
        'field' => 'last_visit_date',
        'formatter' => function($d, $row) {
            return date('d/m/Y', strtotime($d));
        }
    ),
    array(
        'db' => 'a.last_action_date',
        'dt' => 'lastActionDate',
        'field' => 'last_action_date',
        'formatter' => function($d, $row) {
            return date('d/m/Y', strtotime($d));
        }
    ),

    array(
        'db' => 'a.rating',
        'dt' => 'rating',
        'field' => 'rating'
    ),
    array(
        'db' => 'a.target',
        'dt' => 'target',
        'field' => 'target'
    ),
    array(
        'db' => 'a.notes',
        'dt' => 'notes',
        'field' => 'notes'
    ),
       array(
           'db' => 'a.customer_id',
           'dt' => 'customer_id',
           'field' => 'customer_id'
       ),
    array(
        'db' => 'a.category_id',
        'dt' => 'category_id',
        'field' => 'category_id'
    ),

    array(
        'db' => 'a.customer_id',
        'dt' => 'form',
        'formatter' => function ($d, $row) {


            $editButton = '<button class="btn btn-primary" onclick="openEditModal(
                 \'' . $row['customer_id'] . '\',
                 \'' . $row['category_id'] . '\', 
                 \'' . $row['cycle_type'] . '\', 
                 \'' . $row['visit_cycle_in_days'] . '\',
                  \'' . date('Y-m-d', strtotime($row['last_visit_date'])) . '\',  
                 \'' . date('Y-m-d', strtotime($row['last_action_date'])) . '\', 
                 \'' . $row['rating'] . '\',
                 \'' . $row['target'] . '\', 
                 \'' . $row['notes'] . '\');">Edit</button>';

            return $editButton;


        },
        'field' => 'customer_id'
    )



);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM Allow_Categories_Customers as a 
             INNER JOIN Customers AS c ON c.customer_id = a.customer_id
             INNER JOIN Categories AS ca ON a.category_id = ca.category_id";
$where = ''; // Add any specific where clauses if needed


require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $where )
);

?>
