<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once("../../../../param.php");
// DB table to use
$table = 'Stock_Updates';

// Table's primary key
$primaryKey = "stock_update_id";

// Array of database columns which should be read and sent back to DataTables.
// The db parameter represents the column name in the database, while the dt
// parameter represents the DataTables column identifier. In this case, object
// parameter names.
$columns = array(
    array(
        'db' => 's.batch_number',
        'dt' => 'batch_number',
        'field' => 'batch_number'
    ),
    array(
        'db' => 's.stock_update_id',
        'dt' => 'stock_update_id',
        'field' => 'stock_update_id'
    ),
    array(
        'db' => 's.warehouse_id',
        'dt' => 'warehouse_id',
        'field' => 'warehouse_id'
    ),
    array(
        'db' => 's.item_id',
        'dt' => 'item_id',
        'field' => 'item_id'
    ),
    array(
        'db' => 'i.item_code',
        'dt' => 'item_code',
        'field' => 'item_code'
    ),
    array(
        'db' => 'i.item_sku',
        'dt' => 'item_sku',
        'field' => 'item_sku'
    ),
    array(
        'db' => 'w.warehouse_code',
        'dt' => 'warehouse_code',
        'field' => 'warehouse_code'
    ),
    array(
        'db' => 'w.name',
        'dt' => 'warehouse_name',
        'field' => 'name'
    ),
    array(
        'db' => 's.available',
        'dt' => 'available',
        'field' => 'available'
    ),
    array(
        'db' => 's.action_code',
        'dt' => 'action_code',
        'field' => 'action_code'
    ),
    array(
        'db' => 's.reason',
        'dt' => 'reason',
        'field' => 'reason'
    ),
    array(
        'db' => 's.timestamp',
        'dt' => 'timestamp',
        'field' => 'timestamp'
    )
);
global $username,$password,$database;
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
 
 $where = ''; // Add any specific where clauses if needed

$startDate = $_GET['fromDate'];
$endDate = $_GET['toDate'];

if (!empty($startDate) && !empty($endDate)) {
    $where .= " DATE(s.timestamp) >= STR_TO_DATE('$startDate', '%d.%m.%Y') AND DATE(s.timestamp) <= STR_TO_DATE('$endDate', '%d.%m.%Y')";

} else if (!empty($startDate)) {
    $where .= " DATE(s.timestamp) >= STR_TO_DATE('$startDate', '%d.%m.%Y')";
} else if (!empty($endDate)) {
    $where .= " DATE(s.timestamp) <= STR_TO_DATE('$endDate', '%d.%m.%Y')";
}


$joinQuery = "FROM Stock_Updates AS s
              LEFT JOIN Items AS i ON s.item_id = i.item_id
              LEFT JOIN Warehouses AS w ON s.warehouse_id = w.warehouse_id";


require(ROOT . 'backend/core/controllers/ssp2.class.php');

echo json_encode(
    SSP::simple($_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $where)
);

?>
