<?php
include("../../../../param.php");

// DB table to use
$table = 'Items';

// Table's primary key
$primaryKey = "item_code";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`i`.`item_id`', 'dt' => 'image', 'formatter' => function( $d, $row ) {
        global $username,$password,$database;
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");
        $check = false;
        $stm = $db->prepare("SELECT thumbnail_url FROM Items WHERE item_id='$d'");
        $stm->execute();
        $stm->bind_result($imgName);

        while ($stm->fetch()) {
            if(strcmp($imgName,'')!=0) {
                $d = "//" . HTML_PATH . "/cop/media/productImages/$imgName.jpg";
                if (file_exists(ROOT . "media/productImages/$imgName.jpg")) {
                    $check = true;
                }
            }

        }
        $stm->close();
        if(!$check) {
            $d = "//" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/itemdefaulticon.jpg";
        }
        return '<a  data-toggle="modal" data-target="#imageModal" onclick="showImage(\''.$d.'\')"><img class="img-responsive img-rounded center-canvas" src="'.$d.'" width="80" height="80"></a></td>';},
        'field' => 'item_id' ),
    array( 'db' => '`i`.`item_code`', 'dt' =>  'code', 'field' =>'item_code' ),
    array( 'db' => '`i`.`name`', 'dt' => 'name', 'field' => 'name' ),
    array( 'db' => '`i`.`item_sku`', 'dt' => 'sku' , 'field' => 'item_sku' ),

    array( 'db' => '`v`.`vat_display_name`', 'dt' => 'vat', 'field' => 'vat_display_name' ),
    array( 'db' => '`i`.`item_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {

        return "<button type='button' class='btn btn-success ActionItemListButton' onclick='addListItemLine(\"$d\");'><i class='fa fa-plus'></i> &nbsp; Add</button>";
        }, 'field' => 'item_id' )
);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$where=" NOT `i`.`status` = 'inactive' ";


if(isset($_GET['category']) && strcmp($_GET['category'],'')!=0 && strcmp($_GET['category'],'1')!=0){
    $extraQuery = "SELECT item_id FROM Category_Item WHERE category_ID='".$_GET['category']."'";
    $where .= " AND `i`.`item_id` IN ($extraQuery)";
}

if(isset($_SESSION['Allow_Items']) && strcmp($_SESSION['Allow_Items'],'')!=0){
    $where .= " AND `i`.`item_id` IN (".$_SESSION['Allow_Items'].")";
}

$joinQuery = "FROM `Items` AS `i` LEFT JOIN `Vats` AS `v` ON (`i`.`vat_id` = `v`.`vat_id`)";
require(ROOT . '/backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>