<?php
include_once('../../../../param.php');

$postID = $_POST['postID'];

global $username, $password, $database;
$db = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stmt = $db->prepare("SELECT post_text FROM CRM_Posts WHERE post_id = ?");
$stmt->bind_param("i", $postID);
$stmt->execute();
$stmt->bind_result($postText);
$stmt->fetch();
$stmt->close();

$postText = str_replace("#quote#", '"', $postText);

$customerData = json_decode($postText, true);

$htmlOutput = '
<style>
    td {
        padding:5px; 
        text-align: left !important; 
    }
</style>';


// Start building the HTML output
$htmlOutput .= '<div id="customer-info" style="margin: 20px;">';
$htmlOutput .= '<div style="display: flex; justify-content: space-between; align-items: stretch;">'; // Flex container


// Basic Information Column
$htmlOutput .= '<div style="flex: 1; padding: 10px; border-right: 1px solid #ccc;">';
$htmlOutput .= '<h2 style="margin-bottom: 30px;">Basic Information</h2>';
$htmlOutput .= '<table style="width: 100%; text-align: left;">';
$htmlOutput .= '<tr><td  style = "text-align: left !important;" ><strong>Customer Name:</strong></td><td>' . htmlspecialchars($customerData['customerReportName']) . '</td></tr>';
$htmlOutput .= '<tr><td  style = "text-align: left !important;" ><strong>VAT Code:</strong></td><td>' . htmlspecialchars($customerData['vatCode']) . '</td></tr>';
$htmlOutput .= '<tr><td  style = "text-align: left !important;" ><strong>Mobile:</strong></td><td>' . htmlspecialchars($customerData['mobile']) . '</td></tr>';
$htmlOutput .= '<tr><td  style = "text-align: left !important;" ><strong>Email:</strong></td><td>' . htmlspecialchars($customerData['email']) . '</td></tr>';
$htmlOutput .= '<tr><td  style = "text-align: left !important;" ><strong>Website:</strong></td><td>' . htmlspecialchars($customerData['website']) . '</td></tr>';
$htmlOutput .= '<tr><td  style = "text-align: left !important;" ><strong>Description:</strong></td><td>' . htmlspecialchars($customerData['description']) . '</td></tr>';
$htmlOutput .= '</table>';
$htmlOutput .= '</div>';

// Address Information Column
$htmlOutput .= '<div style="flex: 1; padding: 10px; border-right: 1px solid #ccc;">';
$htmlOutput .= '<h2 style="margin-bottom: 30px;">Address Information</h2>';
if (isset($customerData['customerAddress']) && is_array($customerData['customerAddress'])) {
    $address = $customerData['customerAddress'];
    $htmlOutput .= '<table style="width: 100%; text-align: left;">';
    $htmlOutput .= '<tr><td  style = "text-align: left !important;" ><strong>Address Line 1:</strong></td><td>' . htmlspecialchars($address['addressLine1']) . '</td></tr>';
    $htmlOutput .= '<tr><td  style = "text-align: left !important;" ><strong>Address Line 2:</strong></td><td>' . htmlspecialchars($address['addressLine2']) . '</td></tr>';
    $htmlOutput .= '<tr><td  style = "text-align: left !important;" ><strong>Country:</strong></td><td>' . htmlspecialchars($address['country']) . '</td></tr>';
    $htmlOutput .= '<tr><td  style = "text-align: left !important;" ><strong>City:</strong></td><td>' . htmlspecialchars($address['city']) . '</td></tr>';
    $htmlOutput .= '<tr><td  style = "text-align: left !important;" ><strong>Postcode:</strong></td><td>' . htmlspecialchars($address['postcode']) . '</td></tr>';
    $htmlOutput .= '<tr><td  style = "text-align: left !important;" ><strong>Region:</strong></td><td>' . htmlspecialchars($address['region']) . '</td></tr>';
    $htmlOutput .= '<tr><td  style = "text-align: left !important;" ><strong>PO Box:</strong></td><td>' . htmlspecialchars($address['pobox']) . '</td></tr>';
    $htmlOutput .= '<tr><td  style = "text-align: left !important;" ><strong>Landline:</strong></td><td>' . htmlspecialchars($address['landline']) . '</td></tr>';
    $htmlOutput .= '<tr><td  style = "text-align: left !important;" ><strong>Fax:</strong></td><td>' . htmlspecialchars($address['fax']) . '</td></tr>';
    $htmlOutput .= '</table>';
}
$htmlOutput .= '</div>';

// Group Information Column
$htmlOutput .= '<div style="flex: 1; padding: 10px;">';
$htmlOutput .= '<h2 style="margin-bottom: 30px;">Group Information</h2>';
if (isset($customerData['customerGroups']) && is_array($customerData['customerGroups'])) {
    $counter = 1;
    $htmlOutput .= '<table style="width: 100%; text-align: left;">';
    foreach ($customerData['customerGroups'] as $group) {
        $htmlOutput .= '<tr><td style = "text-align: left !important;">' . $counter . ') <strong>Group Code:</strong></td><td>' . htmlspecialchars($group['groupCode']) . '</td></tr>';
        $htmlOutput .= '<tr><td style="padding-left: 20px;text-align: left !important;"><strong>Group Name:</strong></td><td>' . htmlspecialchars($group['groupName']) . '</td></tr>';
        $htmlOutput .= '<tr><td colspan="2"><hr style="border: 0.5px solid #ccc; margin: 10px 0;"></td></tr>'; // Horizontal line
        $counter++;
    }
    $htmlOutput .= '</table>';
}
$htmlOutput .= '</div>';
$htmlOutput .= '</div>';
$htmlOutput .= '</div>';

// Output the HTML
echo $htmlOutput;
?>
