<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once("../../../../param.php");
// DB table to use
$table = 'Customers';

// Table's primary key
$primaryKey = "customer_code";



// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns=array();



array_push($columns, array( 'db' => '`c`.`logo`', 'dt' => 'logo', 'formatter' => function( $d, $row ) {

        if (isset($d) && strcmp($d, '') != 0) {
        return '<img class="center-canvas" style="width:auto;height:25px;max-width:50px" src="//' . HTML_PATH . '/cop/media/customersLogos/' . $d . '"></td>';
    } else {
        return '<img class="img-rounded img-responsive center-canvas" src="//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/customerdefault.jpg" width="25" height="25"></td>';
    }
} , 'field' => 'logo' ));

array_push($columns, array( 'db' => '`c`.`customer_code`', 'dt' =>  'code', 'field' =>'customer_code' ));
array_push($columns, array( 'db' => '`c`.`customer_company_name`', 'dt' => 'name', 'field' => 'customer_company_name' ));
array_push($columns, array( 'db' => '`c`.`type_of_business`', 'dt' => 'status', 'field' => 'type_of_business' ));
array_push($columns,   array( 'db' => '`c`.`customer_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {
    global $username,$password,$database;
    $groupID = $_GET['groupID'];
    $db = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT COUNT(*) FROM Customer_CustomersGroup WHERE group_id='$groupID' AND customer_id='$d'");
    $stm->execute();
    $stm->bind_result($counter);

    while ($stm->fetch()) {}
    $stm->close();
    if($counter>0)
    {
        return '
			<button   id="'.$d.'" class="btn btn-danger" onclick="removeCustomerFromGroup('.$d.','.$groupID.');" style="width:100px">Remove</button>
			';
    }
    else{
        return '
			<button  id="'.$d.'"  class="btn btn-success" onclick="addCustomerToGroup('.$d.','.$groupID.');"  style="width:100px">Add</button>
			';
    }
},'field' => 'customer_id' ));




// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
if($_GET['leftJoin']==1)
{
    $groupID = $_GET['groupID'];
    $joinQuery = "FROM `Customer_CustomersGroup` AS `g` LEFT JOIN `Customers` AS `c` ON (`g`.`customer_id` = `c`.`customer_id`)";
    $where ="`g`.`group_id`='$groupID'";
}else {
    $joinQuery = "FROM `Customers` AS `c`";
    $where ="";
}

require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>