<?php
session_start();
include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");

$orderID= $_POST['orderID'];

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$status="Canceled";
$stmt = $db->prepare("UPDATE Orders SET status= ? WHERE order_id=?");
$stmt->bind_param('ss',$status,$orderID);
$stmt->execute();
$stmt->close();

$stmt = $db->prepare("SELECT order_code,delivery_method FROM Orders WHERE order_id='$orderID' LIMIT 1");
$stmt->execute();
$stmt->bind_result($orderCode,$warehouseID);
while ($stmt->fetch()) {}
$stmt->close();

$deliveredOrder = false;
$stm = $db->prepare("SELECT COUNT(waybill_id) FROM Order_Waybill WHERE order_id='$orderID'");
$stm->execute();
$stm->bind_result($linkedWaybillsCounter);
while ($stm->fetch()) {if($linkedWaybillsCounter >0){$deliveredOrder = true;}}
$stm->close();

$invoicedOrder = false;
$stm = $db->prepare("SELECT COUNT(invoice_id) FROM Order_Invoice WHERE order_id='$orderID'");
$stm->execute();
$stm->bind_result($linkedInvoicesCounter);
while ($stm->fetch()) {if($linkedInvoicesCounter >0){$invoicedOrder = true;}}
$stm->close();

if($deliveredOrder || $invoicedOrder){

    $orderItemsForSockArray = array();
    $stm = $db->prepare("SELECT item_id,qty,qty_delivered,qty_invoiced FROM Order_Item WHERE order_id='$orderID'");
    $stm->execute();
    $stm->bind_result($itemID,$reserved,$delivered,$sold);
    while ($stm->fetch()) {

        $object = new stdClass();
        $object->warehouseID = $warehouseID;
        $object->itemID = $itemID;
        $object->batchNumber = '0';
        $object->available = 0;
        $object->reserved = $reserved - $delivered - $sold;
        $object->delivered = 0;
        $object->onOrder = 0;
        $object->requested = 0;
        $object->sold = $sold;

        array_push($orderItemsForSockArray,$object);
    }
    $stm->close();

} else {
    $orderItemsForSockArray = getStockUpdateLinesOfDocument($db, 2, $orderID);
}


foreach ($orderItemsForSockArray as $itemObject) {

    $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $itemObject->warehouseID, $itemObject->itemID, $itemObject->batchNumber, -$itemObject->available, -$itemObject->reserved, -$itemObject->delivered, -$itemObject->onOrder, -$itemObject->requested, -$itemObject->sold, "0000-00-00", 2, $orderID, $orderCode, 'Canceled Order', 0, null, null, 0, null);

    $insertStockStatementResult = insertStockRecord($db, $itemObject->warehouseID,  $itemObject->itemID, $itemObject->batchNumber, -$itemObject->available, -$itemObject->reserved, -$itemObject->delivered, -$itemObject->onOrder, -$itemObject->requested, -$itemObject->sold, '0000-00-00');

}





redirect("//" .  HTML_PATH . "/cop/backend/core/views/manage/manage_orders.php");






function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}



?>