<?php
include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");
require_once(ROOT . "backend/core/model/CustomForm.php");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);

$invoiceID = trim($_POST['invoiceID']);
$myfile = fopen(ROOT."/logs/deletedRecords-".date('d-m-Y').".txt", "a") or die("Unable to open file!");
global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}

$stmt = $db->prepare("SELECT invoice_id,invoice_code,company_id,customer_id,salesperson_id,paymenttype_id,order_id,tender_id,subtotal,grand_total,vat_amount,vat_i_e,discount_amount,invoice_address_id,delivery_address_id,print_count,invoice_date,details,invoice_type,due_date,status,currency_id,global_discount_percentage,timestamp FROM Invoices WHERE invoice_id='$invoiceID'");
$stmt->execute();
$stmt->bind_result($invoiceID, $invoiceCode, $companyID, $customerID, $salespersonID, $paymentTypeID, $orderID, $tenderID, $subtotal, $grandTotal, $vatAmount, $vatIorE, $discountAmount, $invoiceAddressID, $deliveryAdressID, $printCount, $invoiceDATE, $details, $invoiceType, $dueDate, $status, $currencyID, $globalDiscountPercentage, $timestamp);
while ($stmt->fetch()) {}
$stmt->close();



$invoiceItemsForSockArray = getStockUpdateLinesOfDocument($db, 5, $invoiceID);

foreach ($invoiceItemsForSockArray as $itemObject) {

    $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $itemObject->warehouseID, $itemObject->itemID, $itemObject->batchNumber, -$itemObject->available, -$itemObject->reserved, -$itemObject->delivered, -$itemObject->onOrder, -$itemObject->requested, -$itemObject->sold, "0000-00-00", 5, $invoiceID, $invoiceCode, 'Cancel Invoice (Remove)', 0, null, null, 0, null);
    if(!$insertStockUpdateStatementResult){throw new Exception();}

    $insertStockStatementResult = insertStockRecord($db, $itemObject->warehouseID, $itemObject->itemID, $itemObject->batchNumber, -$itemObject->available, -$itemObject->reserved, -$itemObject->delivered, -$itemObject->onOrder, -$itemObject->requested, -$itemObject->sold, '0000-00-00');
    if(!$insertStockStatementResult){throw new Exception();}

}

$invoiceOrderItemsForSockArray = getStockUpdateLinesOfConnectedDocument($db, 5, $invoiceID,2);

foreach ($invoiceOrderItemsForSockArray as $itemObject) {

    $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $itemObject->warehouseID, $itemObject->itemID, $itemObject->batchNumber, 0, 0, 0, 0, 0, 0, "0000-00-00", 5, $invoiceID, $invoiceCode, 'Invoice Order (Remove)', 2, $itemObject->fromActionID,  $itemObject->fromActionCode,  -$itemObject->fromActionQty,  $itemObject->fromActionField);
    if(!$insertStockUpdateStatementResult){throw new Exception();}


    $linkedForReservedItems = array();
    $stmt = $db->prepare("SELECT order_item_id,qty_invoiced FROM Order_Item WHERE order_id=? AND item_id=?");
    $stmt->bind_param('ii',  $itemObject->fromActionID,$itemObject->itemID);
    $stmt->execute();
    $stmt->bind_result($linkedOrderItemID,$linkedForReserved);
    while ($stmt->fetch()) {

        if($linkedForReserved <= $itemObject->fromActionQty){
            $reverseFromActionQty = $linkedForReserved;
            $itemObject->fromActionQty -= $reverseFromActionQty;
        } else {
            $reverseFromActionQty = $itemObject->fromActionQty;
            $itemObject->fromActionQty = 0;
        }

        $lineReservation = new stdClass();
        $lineReservation->lineID = $linkedOrderItemID;
        $lineReservation->reserved = $reverseFromActionQty;

        array_push($linkedForReservedItems,$lineReservation);

    }
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->close();

    foreach ($linkedForReservedItems as $lineReservation){

        $reverseFromActionQty=-$lineReservation->reserved;

        $stmt = $db->prepare("UPDATE Order_Item SET ".$itemObject->fromActionField." = ".$itemObject->fromActionField."+? WHERE order_item_id = ?");
        $stmt->bind_param('di', $reverseFromActionQty, $lineReservation->lineID);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception();}
        $stmt->close();
    }

}

$invoiceWaybillItemsForSockArray = getStockUpdateLinesOfConnectedDocument($db, 5, $invoiceID,3, $invoiceCode);

foreach ($invoiceWaybillItemsForSockArray as $itemObject) {

    $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $itemObject->warehouseID, $itemObject->itemID, $itemObject->batchNumber, 0, 0, 0, 0, 0, 0, "0000-00-00", 5, $invoiceID, $invoiceCode, 'Invoice Waybill (Remove)', 3, $itemObject->fromActionID,  $itemObject->fromActionCode,  -$itemObject->fromActionQty,  $itemObject->fromActionField);
    if(!$insertStockUpdateStatementResult){throw new Exception();}


    $linkedForReservedItems = array();
    $stmt = $db->prepare("SELECT waybill_item_id,qty_invoiced FROM Waybill_Item WHERE waybill_id=? AND item_id=?");
    $stmt->bind_param('ii',  $itemObject->fromActionID,$itemObject->itemID);
    $stmt->execute();
    $stmt->bind_result($linkedWaybillItemID,$linkedForReserved);
    while ($stmt->fetch()) {

        if($linkedForReserved <= $itemObject->fromActionQty){
            $reverseFromActionQty = $linkedForReserved;
            $itemObject->fromActionQty -= $reverseFromActionQty;
        } else {
            $reverseFromActionQty = $itemObject->fromActionQty;
            $itemObject->fromActionQty = 0;
        }

        $lineReservation = new stdClass();
        $lineReservation->lineID = $linkedWaybillItemID;
        $lineReservation->reserved = $reverseFromActionQty;

        array_push($linkedForReservedItems,$lineReservation);

    }
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->close();

    foreach ($linkedForReservedItems as $lineReservation){

        $reverseFromActionQty=-$lineReservation->reserved;

        $stmt = $db->prepare("UPDATE Waybill_Item SET ".$itemObject->fromActionField." = ".$itemObject->fromActionField."+? WHERE waybill_item_id = ?");
        $stmt->bind_param('di', $reverseFromActionQty, $lineReservation->lineID);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception();}
        $stmt->close();
    }

}

$stmt = $db->prepare("DELETE FROM Stock_Updates WHERE action_id=? AND action_type=5");
$stmt->bind_param('i',$invoiceID);
$stmt->execute();
$stmt->close();

$deleteID = getNextKey("Deletes", "delete_id");
$statement ="DELETE FROM Stock_Updates WHERE action_id=$invoiceID AND action_type=5";
$stmt2 = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
$stmt2->bind_param('is',$deleteID,$statement);
$stmt2->execute();
$stmt2->close();


$hasWaybill = false;
$stmt = $db->prepare("SELECT waybill_id FROM Waybill_Invoice WHERE invoice_id='$invoiceID' LIMIT 1");
$stmt->execute();
$stmt->bind_result($connectedWaybillID);
while ($stmt->fetch()) {if($connectedWaybillID > 0){$hasWaybill = true;}}
$stmt->close();

$hasOrder = false;
$stmt = $db->prepare("SELECT order_id FROM Order_Invoice WHERE invoice_id='$invoiceID' LIMIT 1");
$stmt->execute();
$stmt->bind_result($connectedOrderID);
while ($stmt->fetch()) {if($connectedOrderID > 0){$hasOrder = true;}}
$stmt->close();

$type = 'Invoice';
$adminID=$_SESSION['adminID'];
$cancelledID = getNextKey("Cancelled_Actions", "cancelled_id");
$stmt = $db->prepare("INSERT INTO Cancelled_Actions (cancelled_id,type,code,customer_id,salesperson_id,user_id,discount_amount,subtotal,vat_amount,grand_total,date,time_canceled,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,NOW(),NOW())");
$stmt->bind_param('issiiidddds',$cancelledID,$type,$invoiceCode,$customerID,$salespersonID,$adminID,$discountAmount,$subtotal,$vatAmount,$grandTotal,$invoiceDATE);
$stmt->execute();
$stmt->close();

fwrite($myfile,"\n$type|$invoiceCode|$invoiceType|$subtotal|$discountAmount|$vatAmount|$grandTotal|");

if(strcmp($invoiceType,"Credit")==0) {
    updateCustomerBalance($customerID, -$grandTotal);
    fwrite($myfile,"Update Customer Balance|");
} else {
    fwrite($myfile,"Keep Customer Balance|");
}

$lockedDocumentType = "Invoices";
$stmt = $db->prepare("DELETE FROM ZD_Lock_Document WHERE document_id=? AND document_type=?");
$stmt->bind_param('is', $invoiceID, $documentType);
$stmt->execute();
$stmt->close();
fwrite($myfile,"Remove Locked Document|");

$stmt = $db->prepare("DELETE FROM Invoices WHERE invoice_id=?");
$stmt->bind_param('i',$invoiceID);
$stmt->execute();
$stmt->close();

$deleteID = getNextKey("Deletes", "delete_id");
$statement ="DELETE FROM Invoices WHERE invoice_id=$invoiceID";
$stmt2 = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
$stmt2->bind_param('is',$deleteID,$statement);
$stmt2->execute();
$stmt2->close();
fwrite($myfile,"Remove Header|");

$detailsTra="Invoice $invoiceCode";
$stmt = $db->prepare("DELETE FROM Transactions WHERE transaction_code=?");
$stmt->bind_param('s',$invoiceCode);
$stmt->execute();
$stmt->close();

$deleteID = getNextKey("Deletes", "delete_id");
$statement ="DELETE FROM Transactions WHERE transaction_code=\"$invoiceCode\"";
$stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
$stmt->bind_param('is',$deleteID,$statement);
$stmt->execute();
$stmt->close();
fwrite($myfile,"Remove Transactions|");

if($hasOrder){

    $stmt = $db->prepare("SELECT Order_Item.order_id, sum(qty-qty_invoiced) ,sum(qty_invoiced)  FROM Order_Invoice, Order_Item WHERE Order_Invoice.invoice_id='$invoiceID' AND Order_Invoice.order_id= Order_Item.order_id GROUP BY Order_Item.order_id ");
    $stmt->execute();
    $stmt->bind_result($connectedOrderID,$remainingQtyInvoiced,$remainingQtyInvoiced2);
    while ($stmt->fetch()) {
        if($remainingQtyInvoiced > 0){
            if($remainingQtyInvoiced2 > 0){
                $status = 'Partially Invoiced';
            } else {
                $status = 'Placed';
            }
        } else {
            $status ='Fully Invoiced';
        }

        $db2 = new mysqli('localhost', $username, $password, $database);
        if(mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        $db2->set_charset("utf8");
        $stmt2 = $db2->prepare("UPDATE Orders SET status=? WHERE order_id=?");
        $stmt2->bind_param('si', $status,$connectedOrderID);
        $stmt2->execute();
        $stmt2->close();
    }

    $stmt = $db->prepare("DELETE FROM Order_Invoice WHERE invoice_id=?");
    $stmt->bind_param('i',$invoiceID);
    $stmt->execute();
    $stmt->close();

    $deleteID = getNextKey("Deletes", "delete_id");
    $statement ="DELETE FROM Order_Invoice WHERE invoice_id=$invoiceID";
    $stmt2 = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
    $stmt2->bind_param('is',$deleteID,$statement);
    $stmt2->execute();
    $stmt2->close();
    fwrite($myfile,"Remove Order Link|");
}

if($hasWaybill){

    $stmt = $db->prepare("SELECT Waybill_Item.waybill_id, sum(qty-qty_invoiced) ,sum(qty_invoiced)  FROM Waybill_Invoice, Waybill_Item WHERE Waybill_Invoice.invoice_id='$invoiceID' AND Waybill_Invoice.waybill_id= Waybill_Item.waybill_id GROUP BY Waybill_Item.waybill_id ");
    $stmt->execute();
    $stmt->bind_result($waybillID,$remainingQtyInvoiced,$remainingQtyInvoiced2);
    while ($stmt->fetch()) {
        if($remainingQtyInvoiced > 0){
            if($remainingQtyInvoiced2 > 0){
                $status = 'Partially Invoiced';
            } else {
                $status = 'Placed';
            }
        } else {
            $status ='Fully Invoiced';
        }

        $db2 = new mysqli('localhost', $username, $password, $database);
        if(mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        $db2->set_charset("utf8");
        $stmt2 = $db2->prepare("UPDATE Waybills SET status=? WHERE waybill_id=?");
        $stmt2->bind_param('si', $status,$waybillID);
        $stmt2->execute();
        $stmt2->close();
    }

    $stmt = $db->prepare("DELETE FROM Waybill_Invoice WHERE invoice_id=?");
    $stmt->bind_param('i',$invoiceID);
    $stmt->execute();
    $stmt->close();

    $deleteID = getNextKey("Deletes", "delete_id");
    $statement ="DELETE FROM Waybill_Invoice WHERE invoice_id=$invoiceID";
    $stmt2 = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
    $stmt2->bind_param('is',$deleteID,$statement);
    $stmt2->execute();
    $stmt2->close();
    fwrite($myfile,"Remove Waybill Link|");
}

$stmt = $db->prepare("DELETE FROM Invoice_Item WHERE invoice_id=?");
$stmt->bind_param('i',$invoiceID);
$stmt->execute();
$stmt->close();

$deleteID = getNextKey("Deletes", "delete_id");
$statement ="DELETE FROM Invoice_Item WHERE invoice_id=$invoiceID";
$stmt2 = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
$stmt2->bind_param('is',$deleteID,$statement);
$stmt2->execute();
$stmt2->close();
fwrite($myfile,"Remove Invoice Lines|");
fwrite($myfile,"Removed");

redirect("//" .  HTML_PATH . "/cop/backend/core/views/manage/manage_invoices.php");

function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}

function updateCustomerBalance($customerID,$amount)
{
    global $username;
    global $password;
    global $database;
    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");
    $stmt1 = $db1->prepare("UPDATE  Customers SET balance = balance + ? WHERE customer_id=?");
    $stmt1->bind_param('di',$amount,$customerID);
    $stmt1->execute();
    $stmt1->close();

}



?>