<?php
include_once("../../../../param.php");

if (empty($_POST['customerId']) || empty($_POST['subcustomerId']) || empty($_POST['type']) ) {
    echo "emptyFields";
    exit;
}

$customerId = trim($_POST['customerId']);
$subcustomerId = trim($_POST['subcustomerId']);
$type = trim($_POST['type']);
$position = intval(trim($_POST['position']));
$notes = trim($_POST['notes']);
$userId = $_SESSION['adminID'] ;
$dateAdded = date("Y-m-d H:i:s");

global $username, $password, $database;
$db = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

if($customerId == $subcustomerId) {
    echo "selfReference";
    exit;
}

$stmt = $db->prepare("SELECT COUNT(*) FROM SubCustomers 
                      WHERE customer_id = ? AND subcustomer_id = ? AND type = ? ");
$stmt->bind_param('iis', $customerId, $subcustomerId, $type);
$stmt->execute();
$stmt->bind_result($existingCount);
$stmt->fetch();
$stmt->close();

if($existingCount > 0) {
    echo "existingRelation";
    exit;
}

// Check for circular relationship
$stmt = $db->prepare("SELECT COUNT(*) FROM SubCustomers 
                      WHERE customer_id = ? AND subcustomer_id = ? ");
$stmt->bind_param('ii', $subcustomerId, $customerId);
$stmt->execute();
$stmt->bind_result($circularCount);
$stmt->fetch();
$stmt->close();

if($circularCount > 0) {
    echo "circularReference";
    exit;
}

$stmt = $db->prepare("INSERT INTO SubCustomers (customer_id, subcustomer_id, date_added, position, type, notes,timestamp) 
                      VALUES (?, ?,?, ?, ?, ?,NOW())");
$stmt->bind_param("iisiss", $customerId, $subcustomerId,$dateAdded, $position, $type, $notes);
if ($stmt->execute()) {
    echo "success";
} else {
    echo "error";
}
$stmt->close();

