<?php
include_once("../../../../param.php");
require_once(ROOT . "concc/dbhelpers/dbhelper.php");
require_once(ROOT . "backend/core/model/CustomForm.php");

$companyID = $_SESSION['companyID'];
$customerID= trim(''.$_POST['customerID']);
$returnAddress= trim(''.$_POST['returnAddress']);
$returnType= trim(''.$_POST['returnType']);
$returnDate= trim(''.$_POST['returnDate']);
$serviceCallID = trim(''.$_POST['serviceCallID']);
$paymentMethod= trim(''.$_POST['paymentMethod']);
$salespersonSearch= trim(''.$_POST['salespersonSearch']);
$warehouseSearch= trim(''.$_POST['warehouseSearch']);
$subtotal= trim(''.$_POST['subtotal']);
$discount= trim(''.$_POST['discount']);
$vatTotal= trim(''.$_POST['vatTotal']);
$grandTotal= trim(''.$_POST['grandTotal']);
$details= trim(''.$_POST['details']);

$returnItems = array();
$returnItems =$_POST['returnItems'];

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
try {
    $db->begin_transaction();

    if(isset($returnDate)) {
        $date = DateTime::createFromFormat('d/m/Y', $returnDate);
        $returnDate = $date->format('Y-m-d');
    }

    if(strpos($discount, '%') !== false) {
        $globalDiscountPercentage=str_replace("%","",$discount);
        $discount=$subtotal*$globalDiscountPercentage/100;
    } else {
        $globalDiscountPercentage=0;
    }

    $status = "Placed";

    $returnID = getNextKeySingleTransaction("Purchase_Returns","return_id",$db);
    $returnCode = getNextCodeSingleTransaction("Purchase_Returns", "return_code", "N", "CLOUD", $db,"Devices_Pop");

    if (strcmp($returnCode, '') == 0) {
        $returnCode = getNextPurchaseReturnCode("CLOUD", $db);
    }


    $stmt = $db->prepare("INSERT INTO Purchase_Returns (return_id, return_code, company_id, customer_id, salesperson_id, paymenttype_id, subtotal, grand_total, vat_amount, discount_amount, return_address_id,return_date, details,  global_discount_percentage, status) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
    $stmt->bind_param('isiiiiddddissds',$returnID,$returnCode,$companyID,$customerID,$salespersonSearch,$paymentMethod,$subtotal,$grandTotal,$vatTotal,$discount,$returnAddress,$returnDate,$details,$globalDiscountPercentage,$status);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->close();

    lockDocumentSingleTransaction($returnID,"Purchase_Returns",$db);

    $detailsTra="Purchase Return $returnCode";


    $lineTotals =0;
    $lineDiscountTotals =0;

    foreach($returnItems as $returnItem) {

        $itemID = $returnItem['itemID'];
        if($itemID > 0) {
            $itemNotes = $returnItem['Notes'];
            $qty = floatval($returnItem['Qty']);
            $unitPrice = floatval($returnItem['UP']);
            $lineDiscount = $returnItem['LD'];
            $itemStatus = $returnItem['Condition'];
            $priceType = $returnItem['PC'];
            $globalDiscount = $returnItem['globalDiscount'];
            $vatTotal = $returnItem['vatLine'];
            $vatCode = $returnItem['VAT'];

            $subunits=getSubUnits($itemID,$db);
            $vatID = getVatID($vatCode,$db);

            if(strpos($lineDiscount, '%') !== false) {
                $lineDiscountSelectedPercentage=str_replace("%","",$lineDiscount);
                $lineDiscount = ($qty/$subunits)*$unitPrice *($lineDiscountSelectedPercentage/100);
            } else {
                $lineDiscountSelectedPercentage=0;
            }

            $lineTotals += $unitPrice*$qty/$subunits;
            $lineDiscountTotals += floatval($lineDiscount);

            $returnItemID = getNextKeySingleTransaction("Purchase_Return_Item", "return_item_id",$db);

            $batchNumber='0';

            $stmt = $db->prepare("INSERT INTO Purchase_Return_Item (return_item_id, return_id, item_id, warehouse_id, qty, unit_price, line_discount, global_discount,  vat_amount, pricetype_id, vat_id, line_discount_percentage, status,description,batch_number) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('iiiidddddiidsss', $returnItemID, $returnID, $itemID, $warehouseSearch, $qty, $unitPrice, $lineDiscount, $globalDiscount, $vatTotal, $priceType, $vatID,$lineDiscountSelectedPercentage,$itemStatus,$itemNotes,$batchNumber);
            $stmt->execute();
            if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
            $stmt->close();


            if (true) {
                $available = -$qty;
                $insertStockStatementResult = insertStockRecord($db, $warehouseSearch, $itemID, $batchNumber, $available, 0, 0, 0, 0, 0, '0000-00-00');
                if(!$insertStockStatementResult){throw new Exception();}

                $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $warehouseSearch, $itemID, $batchNumber, $available, 0, 0, 0, 0, 0, "0000-00-00", 12, $returnID, $returnCode, 'Insert P.Return', 0, null, null, 0, null);
                if(!$insertStockUpdateStatementResult){throw new Exception();}
            }

        }

    }
    $discount = floatval($discount);
    $discount+=$lineDiscountTotals;

    $stmt = $db->prepare("UPDATE Purchase_Returns SET subtotal =? ,discount_amount=? WHERE return_id=?");
    $stmt->bind_param('ddi',$lineTotals,$discount,$returnID);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->close();

    if($serviceCallID>0) {

        date_default_timezone_set('Europe/Athens');
        $serviceCallReplyID = getNextKeySingleTransaction("Service_Call_Reply", "service_call_reply_id",$db);
        $status=0;
        $timezone=2;
        $date = date("Y-m-d H:i:s");
        $replyTypeID=3;
        $details ="New Purchase Return Issued";
        $documentType="Purchase_Return";
        $salespersonTo=0;
        $emailResponse="";
        $priorityID=0;
        $stmt = $db->prepare("INSERT INTO Service_Call_Reply (service_call_reply_id,service_call_id,salesperson_id,status_id,date,reply_type_id,details,document_id,document_type,salesperson_to,email_response,priority_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('iiiisisisisi',$serviceCallReplyID,$serviceCallID,$salespersonSearch,$status,$date,$replyTypeID,$details,$returnID,$documentType,$salespersonTo,$emailResponse,$priorityID);
        $stmt->execute();
        if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
        $stmt->close();
    }

    $sign=-1;
    $transactionID = getNextKeySingleTransaction("Transactions","transaction_id",$db);
    $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
    $stmt->bind_param('isisssids',$transactionID,$returnCode,$customerID,$returnDate,$returnDate,$returnCode,$sign,$grandTotal,$detailsTra);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->close();

    $sign=1;
    $transactionID = getNextKeySingleTransaction("Transactions","transaction_id",$db);
    $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
    $stmt->bind_param('isisssids',$transactionID,$returnCode,$customerID,$returnDate,$returnDate,$returnCode,$sign,$grandTotal,$detailsTra);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->close();

    $db->commit(true);

    echo"$returnID";

} catch (Exception  $e) {
    echo 'error '.$e->getLine();
    $db->rollback();
}


$custForm = new CustomForm('Purchase_Returns',$returnID);
$codes = array();
$codes = $custForm->getFormCodes();
foreach ($codes as $code) {
    $custForm->insertVariablesToCustomForm($_POST[$code], $code);
}
						
 
				
	
	

	
function redirect($url)
{
	if (headers_sent())
	{
		die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
	}
	else
	{
		header('Location: ' . $url);
		die();
	}    
}

function getVatID($vatCode,$db){

 $z="";

 $stm1 = $db->prepare("SELECT vat_id FROM Vats WHERE vat_code='$vatCode'");
 $stm1-> execute();
 $stm1-> bind_result($counter);
 while ($stm1->fetch()) {
  $z=$counter;
 }
 $stm1->close();


 return $z;



}

function getSubUnits($itemID,$db) {

 $stm1 = $db->prepare("SELECT subunits FROM Items WHERE item_id='$itemID'");
 $stm1-> execute();
 $stm1-> bind_result($sub);
 while ($stm1->fetch()) {
  return $sub;
 }
 $stm1->close();
 return $sub;


}

function updateCustomerBalance($customerID,$amount,$db)
{

 $stmt = $db->prepare("UPDATE  Suppliers SET balance = balance - ? WHERE customer_id=?");
 $stmt->bind_param('di',$amount,$customerID);
 $stmt->execute();
 $stmt->close();

}
?>