<?php
include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");
require_once(ROOT . "backend/core/model/CustomForm.php");
require_once(ROOT . "backend/core/model/CustomTable.php");

$draftID = trim(''.$_POST['invoiceID']);
$companyID = $_SESSION['companyID'];
$customerID= trim(''.$_POST['customerID']);
$deliveryAddress= trim(''.$_POST['deliveryAddress']);
$billingAddress= trim(''.$_POST['billingAddress']);
$invoiceType= trim(''.$_POST['invoiceType']);
$invoiceDate= trim(''.$_POST['invoiceDate']);
$serviceCallID = trim(''.$_POST['serviceCallID']);
$dueDate = trim(''.$_POST['dueDate']);
$paymentMethod= trim(''.$_POST['paymentMethod']);
$salespersonSearch= trim(''.$_POST['salespersonSearch']);
$warehouseSearch= trim(''.$_POST['warehouseSearch']);
$subtotal= trim(''.$_POST['subtotal']);
$discount= trim(''.$_POST['discount']);
$vatTotal= trim(''.$_POST['vatTotal']);
$grandTotal= trim(''.$_POST['grandTotal']);
$details= trim(''.$_POST['details']);
$orderID= trim(''.$_POST['orderID']);

$invoiceItems = array();
$invoiceItems =$_POST['invoiceItems'];


global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
     printf("Connect failed: %s\n", mysqli_connect_error());
     exit();
}
$db->set_charset("utf8");

try {
    $db->begin_transaction();

    if(isset($invoiceDate) && strcmp($invoiceDate,"")!=0) {
        $date = DateTime::createFromFormat('d/m/Y', $invoiceDate);
        $invoiceDate = $date->format('Y-m-d');
    }

    if(isset($dueDate) && strcmp($dueDate,"")!=0) {
        $date = DateTime::createFromFormat('d/m/Y', $dueDate);
        $dueDate = $date->format('Y-m-d');
    }

    if(strpos($discount, '%') !== false) {
        $globalDiscountPercentage=str_replace("%","",$discount);
        $discount=$subtotal*$globalDiscountPercentage/100;
    } else {
        $globalDiscountPercentage=0;
    }

    if(strcmp($invoiceType,'Cash')==0) {
        $status = "Paid";
    } else {
        $status = "Not Paid";
    }

    if (isset($orderID) && $orderID > 0){
        $stmt = $db->prepare("SELECT order_code FROM Orders WHERE order_id='$orderID'");
        $stmt->execute();
        if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
        $stmt->bind_result($orderCode);
        while ($stmt->fetch()) {}
        $stmt->close();
    }

    $invoiceID = getNextKeySingleTransaction("Purchase_Invoices","invoice_id",$db);
    $invoiceCode = getNextCodeSingleTransaction("Purchase_Invoices", "invoice_code", "PI", "CLOUD", $db,"Devices_Pop");

    if (strcmp($invoiceCode, '') == 0) {
        $invoiceCode = getNextPurchaseInvoiceCode("CLOUD", $db);
    }

    $stmt = $db->prepare("INSERT INTO Purchase_Invoices (invoice_id,invoice_code,company_id,customer_id,salesperson_id,paymenttype_id,subtotal,grand_total,vat_amount,discount_amount,invoice_address_id,delivery_address_id,invoice_date,due_date,details,invoice_type,global_discount_percentage,status) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
    $stmt->bind_param('isiiiiddddiissssds',$invoiceID,$invoiceCode,$companyID,$customerID,$salespersonSearch,$paymentMethod,$subtotal,$grandTotal,$vatTotal,$discount,$billingAddress,$deliveryAddress,$invoiceDate,$dueDate,$details,$invoiceType,$globalDiscountPercentage,$status);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
    $stmt->close();

    lockDocumentSingleTransaction($invoiceID,"Purchase_Invoices",$db);

    $detailsTra="Purchase Invoice $invoiceCode";
    $lineTotals =0;
    $lineDiscountTotals =0;

    foreach($invoiceItems as $invoiceItem)
    {
        $itemID = $invoiceItem['itemID'];

        if($itemID > 0) {
            $itemNotes = $invoiceItem['Notes'];
            $qty = floatval($invoiceItem['Qty']);
            $unitPrice = floatval($invoiceItem['UP']);
            $lineDiscount = $invoiceItem['LD'];
            $priceType = $invoiceItem['PC'];
            $globalDiscount = $invoiceItem['globalDiscount'];
            $vatTotal = $invoiceItem['vatLine'];
            $vatCode = $invoiceItem['VAT'];
            $orderItemID    = $invoiceItem['orderItemID'];

            $subunits=getSubUnits($itemID,$db);
            $vatID = getVatID($vatCode,$db);

            if(strpos($lineDiscount, '%') !== false) {
                $lineDiscountSelectedPercentage=str_replace("%","",$lineDiscount);
                $lineDiscount = ($qty/$subunits)*$unitPrice *($lineDiscountSelectedPercentage/100);
            } else {
                $lineDiscountSelectedPercentage=0;
            }

            $lineTotals += $unitPrice*$qty/$subunits;
            $lineDiscountTotals +=floatval($lineDiscount);


            if (isset($orderID) && $orderID > 0 && isset($orderItemID) && $orderItemID > 0) {

                $stmt = $db->prepare("SELECT (qty-Purchase_Order_Item.qty_invoiced-Purchase_Order_Item.qty_delivered) as available FROM Purchase_Order_Item WHERE order_item_id='$orderItemID'");
                $stmt->execute();
                if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
                $stmt->bind_result($orderAvailableQty);
                while ($stmt->fetch()) {}
                $stmt->close();

                if($orderAvailableQty <= $qty){
                    $reserved  = $orderAvailableQty;
                } else {
                    $reserved  = $qty;
                }

                $stmt = $db->prepare("UPDATE Purchase_Order_Item SET qty_invoiced=qty_invoiced+? WHERE order_item_id=?");
                $stmt->bind_param('di', $reserved, $orderItemID);
                $stmt->execute();
                if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
                $stmt->close();

                $batchNumber = '0';
                $fromActionQty = $reserved;
                $available = $qty;
                $onorder = -$reserved;

                $insertStockStatementResult = insertStockRecord($db, $warehouseSearch, $itemID, $batchNumber, $available, 0, 0, $onorder, 0, 0, '0000-00-00');
                if(!$insertStockStatementResult){throw new Exception();}

                $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $warehouseSearch, $itemID, $batchNumber, $available, 0, 0, $onorder, 0, 0, "0000-00-00", 11, $invoiceID, $invoiceCode, 'Insert P.Invoice', 9, $orderID, $orderCode, "$fromActionQty", 'qty_invoiced');
                if(!$insertStockUpdateStatementResult){throw new Exception();}

            } else {

                $batchNumber = '0';
                $available = $qty;

                $insertStockStatementResult = insertStockRecord($db, $warehouseSearch, $itemID, $batchNumber, $available, 0, 0, 0, 0, 0, '0000-00-00');
                if(!$insertStockStatementResult){throw new Exception();}

                $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $warehouseSearch, $itemID, $batchNumber, $available, 0, 0, 0, 0, 0, "0000-00-00", 11, $invoiceID, $invoiceCode, 'Insert P.Invoice', 0, null, null, 0, null);
                if(!$insertStockUpdateStatementResult){throw new Exception();}

            }


            $invoiceItemID = getNextKeySingleTransaction("Purchase_Invoice_Item", "invoice_item_id",$db);

            $stmt = $db->prepare("INSERT INTO Purchase_Invoice_Item (invoice_item_id,invoice_id,item_id,warehouse_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,line_discount_percentage,description,batch_number) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('iiiidddddiidss', $invoiceItemID, $invoiceID, $itemID, $warehouseSearch, $qty, $unitPrice, $lineDiscount, $globalDiscount, $vatTotal, $priceType, $vatID,$lineDiscountSelectedPercentage,$itemNotes,$batchNumber);
            $stmt->execute();
            if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
            $stmt->close();

            $lineDiscount = floatval($lineDiscount);
            $globalDiscount = floatval($globalDiscount);
            $subunits = floatval($subunits);

            $purchasedUnitPrice = ($unitPrice*$qty/$subunits - $lineDiscount - $globalDiscount)/($qty/$subunits);
            $leadTime = 0;
            $stmt = $db->prepare("INSERT INTO Item_Supplier (item_id, supplier_id, price, lead_time) VALUES(?,?,?,?) ON DUPLICATE KEY UPDATE price=?");
            $stmt->bind_param('iidid', $itemID, $customerID,$purchasedUnitPrice,$leadTime,$purchasedUnitPrice);
            $stmt->execute();
            if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
            $stmt->close();


            $custTable = new CustomTable('Purchase_Invoice_Item',$invoiceItemID);
            $codes = array();
            $codes = $custTable->getCustomTableCodes($db);
            foreach ($codes as $code) {
                $custTable->insertVariablesToCustomTableLine($invoiceItem, $code->tableCode,$db);
            }

        }

    }
    $discount = floatval($discount);
    $discount+=$lineDiscountTotals;

    $stmt = $db->prepare("UPDATE Purchase_Invoices SET subtotal =? ,discount_amount=? WHERE invoice_id=?");
    $stmt->bind_param('ddi',$lineTotals,$discount,$invoiceID);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
    $stmt->close();


    if($serviceCallID>0) {

        date_default_timezone_set('Europe/Athens');
        $serviceCallReplyID = getNextKeySingleTransaction("Service_Call_Reply", "service_call_reply_id",$db);
        $status=0;
        $timezone=2;
        $date = date("Y-m-d H:i:s");
        $replyTypeID=3;
        $details ="New Purchase Invoice Issued";
        $documentType="Purchase_Invoice";
        $salespersonTo=0;
        $emailResponse="";
        $priorityID=0;

        $stmt = $db->prepare("INSERT INTO Service_Call_Reply (service_call_reply_id,service_call_id,salesperson_id,status_id,date,reply_type_id,details,document_id,document_type,salesperson_to,email_response,priority_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('iiiisisisisi',$serviceCallReplyID,$serviceCallID,$salespersonSearch,$status,$date,$replyTypeID,$details,$invoiceID,$documentType,$salespersonTo,$emailResponse,$priorityID);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
        $stmt->close();
    }

    if(strcmp($invoiceType,"Credit")==0) {
        $sign=-1;
        $transactionID = getNextKeySingleTransaction("Transactions","transaction_id",$db);
        $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('isisssids',$transactionID,$invoiceCode,$customerID,$invoiceDate,$invoiceDate,$invoiceCode,$sign,$grandTotal,$detailsTra);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
        $stmt->close();
        updateCustomerBalance($customerID, -$grandTotal,$db);
    }
    else{
        $sign=-1;
        $transactionID = getNextKeySingleTransaction("Transactions","transaction_id",$db);
        $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('isisssids',$transactionID,$invoiceCode,$customerID,$invoiceDate,$invoiceDate,$invoiceCode,$sign,$grandTotal,$detailsTra);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
        $stmt->close();
        $sign=1;
        $transactionID = getNextKeySingleTransaction("Transactions","transaction_id",$db);
        $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('isisssids',$transactionID,$invoiceCode,$customerID,$invoiceDate,$invoiceDate,$invoiceCode,$sign,$grandTotal,$detailsTra);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
        $stmt->close();
    }


    $custTable = new CustomTable('Purchase_Invoices',$invoiceID);
    $codes = array();
    $codes = $custTable->getCustomTableCodes($db);
    foreach ($codes as $code) {
        $custTable->insertVariablesToCustomTable($_POST[$code->formCode], $code->tableCode,$db);
    }

    if (isset($orderID) && $orderID > 0) {
        $stmt = $db->prepare("INSERT IGNORE INTO Purchase_Order_Purchase_Invoice (order_id,invoice_id, timestamp) VALUES(?,?,NOW())");
        $stmt->bind_param('ii', $orderID, $invoiceID);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
        $stmt->close();
    }

    $db->commit(true);

    echo"$invoiceID";

} catch (Exception  $e) {
    echo 'error';
    $db->rollback();
}


$custForm = new CustomForm('Purchase_Invoices',$invoiceID);
$codes = array();
$codes = $custForm->getFormCodes();
foreach ($codes as $code) {
    $custForm->insertVariablesToCustomForm($_POST[$code], $code);
}


function getVatID($vatCode,$db){

     $z="";
     $stm1 = $db->prepare("SELECT vat_id FROM Vats WHERE vat_code='$vatCode'");
     $stm1-> execute();
     $stm1-> bind_result($counter);
     while ($stm1->fetch()) {
      $z=$counter;
     }
     $stm1->close();


     return $z;

}

function getSubUnits($itemID,$db) {

     $stm1 = $db->prepare("SELECT subunits FROM Items WHERE item_id='$itemID'");
     $stm1-> execute();
     $stm1-> bind_result($sub);
     while ($stm1->fetch()) {
      return $sub;
     }
     $stm1->close();
     return $sub;


}

function updateCustomerBalance($customerID,$amount,$db){

     $stmt = $db->prepare("UPDATE  Suppliers SET balance = balance + ? WHERE customer_id=?");
     $stmt->bind_param('di',$amount,$customerID);
     $stmt->execute();
     $stmt->close();

}
?>