<?php
include_once("../../../../param.php");

global $username, $password, $database;

$promotionCode = trim($_POST['promotionCode']);
$promotionName = trim($_POST['promotionName']);
$promotionDescription = trim($_POST['promotionDescription']);
$promoType = intval($_POST['promoType']);
$primaryItemID = intval($_POST['primaryItemID']);
$primaryItemPriceType = intval($_POST['primaryItemPriceType']);
$promoStartDate = trim($_POST['promoStartDate']);
$promoEndDate = trim($_POST['promoEndDate']);
$quantity = intval($_POST['quantity']);
$fixedDiscAmount = floatval($_POST['fixedDiscAmount']);
$fixedDiscPercent = floatval($_POST['fixedDiscPercent']);
$price = floatval($_POST['price']);
$discountQty = floatval($_POST['discountQty']);
$discountPercentQty = floatval($_POST['discountPercentQty']);
$extraItems = $_POST['extraItems'];
$matchingRules = $_POST['matchingRules'] ;
$status = $_POST['promoStatus'];

$customers =$_POST['customers'];
$salesPersons =$_POST['salesPersons'];
$customerGroups =$_POST['customerGroups'];

$all_customers = '';
$all_salespersons = '';
if (strpos($customers, 'all_customers') !== false) {
    $all_customers = 'yes';
    $customers ='';
}

if (strpos($salesPersons, 'all_salespersons') !== false) {
    $all_salespersons = 'yes';
    $salesPersons ='';
}


$db = new mysqli("localhost", $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

// Check if promotion already exists
$stm = $db->prepare("SELECT promotion_id FROM Promotions WHERE promotion_code = ? LIMIT 1");
$stm->bind_param("s", $promotionCode);
$stm->execute();
$stm->bind_result($existingPromoID);
$stm->fetch();
$stm->close();

$existingPromoID = intval($existingPromoID);
if ($existingPromoID > 0) {
    echo "existingCode";
} else {

    // Find next promotionID
    $stmt = $db->prepare("SELECT MAX(promotion_id) + 1  FROM Promotions");
    $stmt->execute();
    $stmt->bind_result($promotionID);
    $stmt->fetch();
    $stmt->close();

    $stmt = $db->prepare(" INSERT INTO Promotions 
                                ( promotion_id,promotion_code, promotion_name, description, type, item_id, qty, fixed_discount_amount, fixed_discount_percent, pricetype_id, price, discount_qty, discount_percent_on_qty, valid_from, valid_until, status, all_customers,all_salespersons,timestamp)
                                VALUES (?, ?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?, NOW())");
    $stmt->bind_param('isssiidddiiddsssss', $promotionID,$promotionCode, $promotionName, $promotionDescription, $promoType, $primaryItemID, $quantity, $fixedDiscAmount, $fixedDiscPercent, $primaryItemPriceType, $price, $discountQty, $discountPercentQty, $promoStartDate, $promoEndDate, $status,$all_customers,$all_salespersons);
    $stmt->execute();
    $stmt->close();




    if (in_array($promoType, [1, 7]) && !empty($extraItems)) {
        foreach ($extraItems as $extraItem) {
            $stmt = $db->prepare(" INSERT INTO Promotion_Extra_Item (promotion_id, item_id, pricetype_id, timestamp) VALUES (?, ?, ?, NOW())    ");
            $itemID = intval($extraItem['itemID']);
            $priceTypeID = intval($extraItem['priceTypeID']);
            $stmt->bind_param('iii',$promotionID, $itemID,$priceTypeID);
            $stmt->execute();
        }
        $stmt->close();
    }

    if (in_array($promoType, [3, 7]) && !empty($matchingRules)) {
        foreach ($matchingRules as $rule) {
            $stmt = $db->prepare(" INSERT INTO Promotion_Matching_Rule (promotion_id, category_id, item_id, credit_limit, value, timestamp) VALUES (?, ?, ?, ?, ?, NOW())");
            $itemID = intval($rule['itemID']);
            $categoryID = intval($rule['categoryID']);
            $creditLimit = intval($rule['creditLimit']);
            $matchingRuleValue = $rule['matchingRuleValue'];
            $stmt->bind_param('iiidd', $promotionID, $categoryID, $itemID,$creditLimit,$matchingRuleValue);
            $stmt->execute();
            $stmt->execute();
        }
        $stmt->close();
    }

    if($all_customers!='yes'&& !empty($customers)) {
        $customersArray = explode(",", $customers);
        foreach ($customersArray as $customerID) {
            $stmt = $db->prepare("INSERT  INTO Promotion_Customer (customer_id, promotion_id) VALUES (?, ?)");
            $stmt->bind_param('ii', $customerID, $promotionID);
            $stmt->execute();
            $stmt->close();
        }
    }

    if(!empty($customerGroups)) {
        $customersGroupsArray = explode(",", $customerGroups);
        foreach ($customersGroupsArray as $groupID) {
            $stmt = $db->prepare("INSERT  INTO Promotion_Customer_Group (group_id, promotion_id) VALUES (?, ?)");
            $stmt->bind_param('ii', $groupID, $promotionID);
            $stmt->execute();
            $stmt->close();
        }
    }

    if($all_salespersons!='yes' && !empty($salesPersons)) {
        $salesPersonsArray = explode(",", $salesPersons);
        foreach ($salesPersonsArray as $salesPersonID) {
            $stmt = $db->prepare("INSERT  INTO Promotion_Salesperson ( salesperson_id, promotion_id,timestamp) VALUES (?, ?,NOW())");
            $stmt->bind_param('ii', $salesPersonID, $promotionID);
            $stmt->execute();
            $stmt->close();
        }
    }


    echo $promotionID;
}

$db->close();
?>
