<?php



include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");
require_once(ROOT . "backend/core/model/CustomForm.php");
require_once(ROOT . "backend/core/model/CustomTable.php");

$invoiceID = trim(''.$_POST['invoiceID']);
$companyID = $_SESSION['companyID'];
$customerID= trim(''.$_POST['customerID']);
$deliveryAddress= trim(''.$_POST['deliveryAddress']);
$billingAddress= trim(''.$_POST['billingAddress']);
$invoiceType= trim(''.$_POST['invoiceType']);
$invoiceDate= trim(''.$_POST['invoiceDate']);
$serviceCallID = trim(''.$_POST['serviceCallID']);
$currencyID = trim(''.$_POST['currencyID']);
$paymentMethod= trim(''.$_POST['paymentMethod']);
$salespersonSearch= trim(''.$_POST['salespersonSearch']);
$warehouseSearch= trim(''.$_POST['warehouseSearch']);
$subtotal= trim(''.$_POST['subtotal']);
$discount= trim(''.$_POST['discount']);
$vatTotal= trim(''.$_POST['vatTotal']);
$grandTotal= trim(''.$_POST['grandTotal']);
$details= trim(''.$_POST['details']);
$orderID= trim(''.$_POST['orderID']);
$waybillID= trim(''.$_POST['waybillID']);

$status = "Draft";

$invoiceItems = array();
$invoiceItems =$_POST['invoiceItems'];

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

try {
    $db->begin_transaction();

    if (isset($invoiceDate) && strcmp($invoiceDate, "") != 0) {
        $date = DateTime::createFromFormat('d/m/Y', $invoiceDate);
        $invoiceDate = $date->format('Y-m-d');
    }

    $dueDate = trim(''.$_POST['dueDate']);

    if (isset($dueDate) && strcmp($dueDate, "") != 0) {
        $date = DateTime::createFromFormat('d/m/Y', $dueDate);
        $dueDate = $date->format('Y-m-d');
    }


    if (strpos($discount, '%') !== false) {
        $globalDiscountPercentage = str_replace("%", "", $discount);
        $discount = $subtotal * $globalDiscountPercentage / 100;
    } else {
        $globalDiscountPercentage = 0;
    }

    if (!isset($invoiceID) || $invoiceID < 1) {
        $invoiceID = getNextKeySingleTransaction("Invoices_Draft", "invoice_id", $db);
    }

    $invoiceCode = "Draft$invoiceID";

    $stmt = $db->prepare("DELETE FROM Invoices_Draft WHERE invoice_id=?");
    $stmt->bind_param('i', $invoiceID);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->close();

    $stmt = $db->prepare("DELETE FROM Invoice_Item_Draft WHERE invoice_id=?");
    $stmt->bind_param('i', $invoiceID);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->close();

    $stmt = $db->prepare("INSERT INTO Invoices_Draft (invoice_id,invoice_code,company_id,customer_id,salesperson_id,paymenttype_id,subtotal,grand_total,vat_amount,discount_amount,invoice_address_id,delivery_address_id,invoice_date,due_date,details,invoice_type,global_discount_percentage,status,currency_id,order_id,waybill_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
    $stmt->bind_param('isiiiiddddiissssdsiii', $invoiceID, $invoiceCode, $companyID, $customerID, $salespersonSearch, $paymentMethod, $subtotal, $grandTotal, $vatTotal, $discount, $billingAddress, $deliveryAddress, $invoiceDate, $dueDate, $details, $invoiceType, $globalDiscountPercentage, $status, $currencyID,$orderID,$waybillID);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->close();

    lockDocumentSingleTransaction($invoiceID, "Invoices_Draft", $db);

    $lineTotals = 0;
    $lineDiscountTotals = 0;

    foreach ($invoiceItems as $invoiceItem) {

        $itemID = $invoiceItem['itemID'];

        if ($itemID > 0) {
            $itemNotes = $invoiceItem['Notes'];
            $qty = $invoiceItem['Qty'];
            $unitPrice = $invoiceItem['UP'];
            $lineDiscount = $invoiceItem['LD'];
            $priceType = $invoiceItem['PC'];
            $globalDiscount = $invoiceItem['globalDiscount'];
            $vatTotal = $invoiceItem['vatLine'];
            $vatCode = $invoiceItem['VAT'];
            $orderItemID    = $invoiceItem['orderItemID'];

            $vatID = getVatID($vatCode, $db);
            $subunits = getSubUnits($itemID, $db);

            if (strpos($lineDiscount, '%') !== false) {
                $lineDiscountSelectedPercentage = str_replace("%", "", $lineDiscount);
                $lineDiscount = ($qty / $subunits) * $unitPrice * ($lineDiscountSelectedPercentage / 100);
            } else {
                $lineDiscountSelectedPercentage = 0;
            }

            $lineDiscount = floatval($lineDiscount);
            $unitPrice = floatval($unitPrice);
            $qty = floatval($qty);

            $lineTotals += $unitPrice * $qty / $subunits;
            $lineDiscountTotals += $lineDiscount;

            $invoiceItemID = getNextKeySingleTransaction("Invoice_Item_Draft", "invoice_item_id", $db);

            $stmt = $db->prepare("INSERT INTO Invoice_Item_Draft (invoice_item_id,invoice_id,item_id,warehouse_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,line_discount_percentage,description,order_item_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('iiiidddddiidsi', $invoiceItemID, $invoiceID, $itemID, $warehouseSearch, $qty, $unitPrice, $lineDiscount, $globalDiscount, $vatTotal, $priceType, $vatID, $lineDiscountSelectedPercentage, $itemNotes,$orderItemID);
            $stmt->execute();
            if(strcmp("$stmt->error","")!=0) {throw new Exception();}
            $stmt->close();

            $custTable = new CustomTable('Invoice_Item', '88' . $invoiceItemID);
            $codes = array();
            $codes = $custTable->getCustomTableCodes($db);
            foreach ($codes as $code) {
                $custTable->insertVariablesToCustomTableLine($invoiceItem, $code->tableCode, $db);
            }

        }
    }
    $discount = floatval($discount);
    $discount += $lineDiscountTotals;

    $stmt = $db->prepare("UPDATE Invoices_Draft SET subtotal =? ,discount_amount=? WHERE invoice_id=?");
    $stmt->bind_param('ddi', $lineTotals, $discount, $invoiceID);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->close();


    $custTable = new CustomTable('Invoices', '88' . $invoiceID);
    $codes = array();
    $codes = $custTable->getCustomTableCodes($db);
    foreach ($codes as $code) {
        $custTable->insertVariablesToCustomTable($_POST[$code->formCode], $code->tableCode, $db);
    }

    $db->commit(true);

    echo "$invoiceID";

} catch (Exception  $e) {
    echo 'error';
    $db->rollback();
}

$custForm = new CustomForm('Invoices_Draft',$invoiceID);
$codes = array();
$codes = $custForm->getFormCodes();
foreach ($codes as $code) {
    $custForm->insertVariablesToCustomForm($_POST[$code], $code);
}



function getVatID($vatCode,$db)
{

    $z="";
    $stm1 = $db->prepare("SELECT vat_id FROM Vats WHERE vat_code='$vatCode'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        $z=$counter;
    }
    $stm1->close();


    return $z;



}

function getSubUnits($itemID,$db) {

    $stm1 = $db->prepare("SELECT subunits FROM Items WHERE item_id='$itemID'");
    $stm1-> execute();
    $stm1-> bind_result($sub);
    while ($stm1->fetch()) {
        return $sub;
    }
    $stm1->close();
    return $sub;


}

function updateCustomerBalance($customerID,$amount,$db)
{

    $stmt = $db->prepare("UPDATE  Customers SET balance = balance + ? WHERE customer_id=?");
    $stmt->bind_param('di',$amount,$customerID);
    $stmt->execute();
    $stmt->close();

}
?>