<?php 

include_once('../../param.php');
require_once("../dbaccess/dbhelper.php");
include_once('../dbaccess/emailOrder.php');

session_start();
$customerID = $_SESSION['customerID'];
$orderID = $_SESSION['ORDERSIXID'];
$token = $_SESSION["TOKENSIX"];
    
    
if(isset($orderID) && strcmp($orderID,'')!=0){
       
    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    
    $stm = $db->prepare("SELECT merchant_id,password,currency_iso_code,acquirer_id,post_url FROM B2C_Payment_Methods WHERE payment_method_code = 'SIX'");
    $stm->execute();
    $stm->bind_result($sixCustomerID, $SIXpassword, $SIXcurrency, $terminalID, $postURL);
    while ($stm->fetch()) {}
    $stm->close();
    
    $stm = $db->prepare("SELECT order_code,order_date,subtotal,vat_amount,grand_total,details,order_address_id,status,delivery_method FROM Orders WHERE order_id='$orderID'");
    $stm->execute();
    $stm->bind_result($orderCode, $orderDate, $subtotal, $vatAmount, $grandTotal, $details, $orderAddressID, $orderStatus, $deliveryMethod);
    while ($stm->fetch()) {}
    $stm->close();
   
    $api_url = $postURL."Payment/v1/PaymentPage/Assert";
    
    //to requestId prepei na einai enas monadikos auxon arithmos (dwsame auto)
    $transaction = array(
        'RequestHeader' => array(
        'SpecVersion' => "1.7",
        'CustomerId' => "$sixCustomerID",
        'RequestId' => "$orderCode-$orderID",
        'RetryIndicator'=> 0
        ),
        'Token' =>$token
    );
    $curl = curl_init($api_url);
    curl_setopt($curl, CURLOPT_HEADER, false);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_HTTPHEADER,array("Content-type: application/json","Accept: application/json; charset=utf-8"));
    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($transaction));
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, true);
    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
    curl_setopt($curl, CURLOPT_USERPWD, $SIXpassword);
    $jsonResponse = curl_exec($curl);
    $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    if ($status != 200) {
        $body = json_decode(curl_multi_getcontent($curl), true);
        $response = array(
            "status" => $status . " <|> " . curl_error($curl),
            "body" => $body
        );
    }else{
        $body = json_decode($jsonResponse, true);
        $response = array(
            "status" => $status,
            "body" => $body
        );
    }
    $_SESSION["TOKENSIX"] ='';
    $_SESSION['ORDERSIXID']='';
    $res = $response['body']['Transaction']['Type'];
    curl_close($curl);
       

    $payedStatus = "Placed";
    $db->set_charset("utf8");
    $stmt = $db->prepare("UPDATE Orders SET status=?,timestamp=NOW() WHERE order_code=? AND customer_id=?");
    $stmt->bind_param('ssi',$payedStatus, $orderCode,$customerID);
    $stmt->execute();
    $stmt->close();

    $companyID = 0;
    $salespersonID = $_SESSION['userID'];
    $invoiceID = 0;
    $receiptAddress = 0;
    $amount = 0;
    $cashDiscount = 0;
    $bank = 'SIX';
    $branch = " ";
    $chequeNumber = "";
    $chequeDate = date('Y-m-d');

    $receiptDate = date('Y-m-d');
    $paymentMethod ="SIX";
    $notes = "For Online Order $orderCode";
    $receiptStatus = "Confirmed";

    $stm = $db->prepare("SELECT order_id,delivery_address_id,grand_total FROM Orders WHERE order_code=? AND customer_id=?");
    $stm-> bind_param('si', $orderCode,$customerID);
    $stm-> execute();
    $stm-> bind_result($orderID,$receiptAddress,$amount);
    while ($stm->fetch()) {}
        $stm->close();
        $stm = $db->prepare("SELECT salesperson_for_order FROM B2B_Configuration LIMIT 1");
        $stm-> execute();
        $stm-> bind_result($defaultSalesPerson);
        while ($stm->fetch()) {
            if(strcmp($defaultSalesPerson,'')!=0 && $defaultSalesPerson > 0){
                $salespersonID = $defaultSalesPerson;
            } else {
                $salespersonID = 0;
            }
        }
    $stm->close();

    if($amount > 0) {
        $receiptID   = getNextKey("Receipts","receipt_id");
        $receiptCode = getNextCodeSingleTransaction("Receipts", "receipt_code", "R", "CLOUD", $db);
        if (strcmp($receiptCode, '') == 0) {
            $receiptCode = getReceiptPrefix("CLOUD").getNextReceiptCode("CLOUD");
        }

        $db->set_charset("utf8");
        $stmt = $db->prepare("INSERT INTO Receipts (receipt_id, receipt_code, customer_id, company_id, salesperson_id, order_id, invoice_id, address_id, amount, payment_method, cash_discount, bank, branch, cheque_number, cheque_date, receipt_date, notes,status) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('isiiiiiidsdsssssss', $receiptID, $receiptCode, $customerID, $companyID, $salespersonID, $orderID, $invoiceID, $receiptAddress, $amount, $paymentMethod, $cashDiscount, $bank, $branch, $chequeNumber, $chequeDate, $receiptDate, $notes,$receiptStatus);
        $stmt->execute();
        $stmt->close();
        setNextReceiptCode("CLOUD");

        $detailsTra="Online Payment Receipt $receiptCode";
        $sign = -1;
        $payment -= $cashDiscount;
        $transactionID = getNextKey("Transactions", "transaction_id");
        $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('isisssids', $transactionID, $receiptCode, $customerID, $receiptDate, $receiptDate, $receiptCode, $sign, $amount, $detailsTra);
        $stmt->execute();
        $stmt->close();
        updateCustomerBalance($customerID, $amount);
    }
    sendEmail($orderID, $receiptID);
    $pFlag = 1;
}else{
    $pFlag = 0;
}
header("Location: //".HTML_PATH."/cop/b2b/viewsingleorder.php?p=$pFlag&Order=$orderCode");
 
function updateCustomerBalance($customerID,$amount)
{
    global $username;
    global $password;
    global $database;
    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stmt = $db->prepare("UPDATE  Customers SET balance = balance - ? WHERE customer_id=?");
    $stmt->bind_param('di',$amount,$customerID);
    $stmt->execute();
    $stmt->close();
}
?>