<?php
// Andreas Spanos @ 08/08/2019 Added Custom Fields after Price
session_start();
include_once("../param.php");
include_once("headerImports.php");
require("./dbaccess/dbhelper.php");
$currencySign = getCurrencySign();
global $username,$password,$database,$langu;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$useMaxStock=false;
$denyOrderOverStock = true;
$showPricesWithVAT=false;
$includeVatOnPrice=false;
$isB2C = false;
$usePackingOnItem = false;
$showAnonymousPrices = false;
$allowAnonymousOrder = false;
$enableAddToCartButtonOnFirstClick = false;

$addWatermark = false;
$stm = $db->prepare("SELECT watermark_id,file_url,position,opacity FROM B2B_Image_Watermark WHERE watermark_id=1 AND active='yes'");
$stm-> execute();
$stm-> bind_result($watermarkID,$watermarkURL,$watermarkPosition,$watermarkOpacity);
while ($stm->fetch()) {
    if($watermarkID > 0){$addWatermark = true;}
}
$stm->close();

$stm = $db->prepare("SELECT allow_anonymous,use_max_stock_on_item,allow_order_over_stock,max_stock_limit,show_prices_with_vat,use_as_b2c,css_theme,theme,use_packing,show_prices_anonymous,anonymous_order,logo_link FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($anonymous,$useMaxStockOnItem,$allowOrderOverStockOnItem,$maxStockLimit,$showPricesIncludingVAT,$useAsB2C,$cssTheme,$labelThemeColor,$usePacking,$showB2BAnonymousPrices,$anonymousOrder,$logoLink);

while ($stm->fetch()) {

    if(strcmp($showB2BAnonymousPrices,'yes')==0){
        $showAnonymousPrices = true;
    }
    if(strcmp($anonymousOrder,'yes')==0){
        $allowAnonymousOrder = true;
    }

    if(strcmp($usePacking,'yes')==0){
        $usePackingOnItem = true;
    }
    if(strcmp($useMaxStockOnItem,'yes')==0){
        $useMaxStock = true;
    }
    if(strcmp($allowOrderOverStockOnItem,'yes')==0){
        $denyOrderOverStock = false;
    }
    if(strcmp($showPricesIncludingVAT,"yes")==0 || strcmp($showPricesIncludingVAT,"both")==0)
    {
        $showPricesWithVAT=true;
        if(strcmp($showPricesIncludingVAT,"yes")==0){
            $includeVatOnPrice = true;
        }
    }
    if(strcmp($useAsB2C,"yes")==0){$isB2C = true;}

    if($cssTheme <= 1){
        $cssTheme = '';
    }

}
$stm-> close();
$textColor = "white";
if(strcmp($labelThemeColor,'')!=0){
    if(strcmp($labelThemeColor,'red')==0 || strcmp($labelThemeColor,'Red')==0 ){
        $labelThemeColor = "firebrick";
    } else if(strcmp($labelThemeColor,'NavyBlue')==0 || strcmp($labelThemeColor,'NavyBlue')==0){
        $labelThemeColor = "#000080";
    } else if(strcmp($labelThemeColor,'black')==0 || strcmp($labelThemeColor,'Black')==0){
        $labelThemeColor = "black";
    } else if(strcmp($labelThemeColor,'gold')==0 || strcmp($labelThemeColor,'Gold')==0){
        $labelThemeColor = "goldenrod";
    } else if(strcmp($labelThemeColor,'yellow')==0 || strcmp($labelThemeColor,'Yellow')==0){
        $themeColor = "yellow";
        $textColor = "black";
    } else {
        if(strpos($labelThemeColor,'#')===false && strcmp($labelThemeColor,'Yellow')!=0) {
            $labelThemeColor = "dark$labelThemeColor";
        }
    }

} else {
    $labelThemeColor = "#6796d3";
}

$isB2CUser = '';
if(isset($_SESSION['userID'])) {
    $userID = $_SESSION['userID'];

    $stm = $db->prepare("SELECT username,email,first_name,last_name,mobile,B2C_User FROM B2B_User WHERE b2b_user_id='$userID'");
    $stm->execute();
    $stm->bind_result($userName, $email, $firstName, $lastName, $mobile, $isB2CUser);
    while ($stm->fetch()) {}
    $stm->close();
}

if(strcmp($isB2CUser,"yes")==0 && $isB2C){$isB2CUser = true;}else{$isB2CUser = false;}

if(strcmp($anonymous,'no')==0) {
    if (!isset($_SESSION['customerID'])||$_SESSION['customerID']==0) {
        redirect("login.php");
    }
}
function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}



if(!isset($_SESSION['customerID']))
{
    $_SESSION['customerID']=0;
}
if(isset($_SESSION['orderID'])){$orderID=$_SESSION['orderID'];}

$customerID=$_SESSION['customerID'];
$itemID= $_GET['code'];
$itemStatement = "SELECT item_code,name,short_description,long_description,packing,item_sku,max_stock,vat_id,status,sellable  FROM Items WHERE item_id = '$itemID'";

$result="";
$showPrices=true;


$stm = $db->prepare("SELECT primary_language,show_prices,footer FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($primaryLanguage,$showPricesConfig,$footerLabel);

while ($stm->fetch()) {
    if(strcmp($showPricesConfig,"no")==0 || (isset($_SESSION['showPrices']) && $_SESSION['showPrices']==false))
    {
        $showPrices=false;
    }
}
$stm-> close();





$stm = $db->prepare("SELECT recommended_retail_price,numeric_stock,stock_warning_qty,show_add_to_cart_button FROM B2B_Page_Catalogue");
$stm-> execute();
$stm-> bind_result($recommendedRetailPrice,$numericStock,$stockWarningQty,$showAddToCartButton);

while ($stm->fetch()) {
    if(strcmp($showAddToCartButton,'yes')==0){
        $enableAddToCartButtonOnFirstClick = true;
    }
}
$stm-> close();

$stm = $db->prepare($itemStatement);
$stm-> execute();
$stm-> bind_result($itemCode,$itemName,$shortDescription,$longDescription,$packing,$sku,$maxStockOfItem,$vatID,$status,$b2bAvailable);
while ($stm->fetch()) {
   $itemCodeString =$itemCode;
   $itemNameString =$itemName;

    if(is_numeric(trim($longDescription))){$longDescription = '';}

    $longDescription = str_replace("*NEW**NEW*","*NEW*",$longDescription);
    $longDescription = str_replace("*NEW*","<br>",$longDescription);
    $longDescription = str_replace('#newline#'."\n" ,'#newline#',$longDescription);
    $longDescription = str_replace('#newline#' ,'<br>',$longDescription);
    $longDescription = str_replace("\n" ,'<br>',$longDescription);

    $shortDescription = str_replace("*NEW**NEW*","*NEW*",$shortDescription);
    $shortDescription = str_replace("*NEW*","<br>",$shortDescription);
    $shortDescription = str_replace('#newline#'."\n" ,'#newline#',$shortDescription);
    $shortDescription = str_replace('#newline#' ,'<br>',$shortDescription);
    $shortDescription = str_replace("\n" ,'<br>',$shortDescription);

    if(strcmp($status,'inactive')==0){
        $isInactive = true;
    } else {
        $isInactive = false;
    }
    if(strcmp($b2bAvailable,'notavailable')==0){
        $isInactive = true;
        $nonStock = true;
    } else if(strcmp($b2bAvailable,'nonstock')==0){
        $nonStock = true;
    } else {
        $nonStock = false;
    }
}
$stm-> close();



if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 && isset($shortDescription) && strcmp($shortDescription,'')!=0 )
{
    $itemNameString=$shortDescription;
}





$imageStatement = "SELECT image_name,image_url FROM Item_Images WHERE item_id = '$itemID' ORDER BY image_order";

$stm = $db->prepare($imageStatement);
$stm-> execute();
$stm-> bind_result($imageName,$imageUrl);

$imagesArray = array();

while ($stm->fetch()) {
    $fullImageUrl = "//" . HTML_PATH . "/cop/media/productImages/$imageUrl.jpg";
    $rz = ROOT."/media/productImages/$imageUrl.jpg";

    if(!file_exists($rz))
    {
        $fullImageUrl = "//" . HTML_PATH . "/cop/media/productImages/$imageUrl.png";
        $rz = ROOT."/media/productImages/$imageUrl.png";

    }
    if(file_exists($rz))
    {
        array_push($imagesArray,$fullImageUrl);
    }

}
$stm-> close();

if(count($imagesArray)==0)
{
    $fullImageUrl = "./assets/img/noimage.jpg";
    array_push($imagesArray,$fullImageUrl);
}


$barcodeStatement= "SELECT barcode FROM Item_Barcode WHERE item_id = '$itemID'";

$stm = $db->prepare($barcodeStatement);
$stm-> execute();
$stm-> bind_result($barcode);

while ($stm->fetch()) {

}

$stm-> close();

if(isset($orderID)) {
    $qty = getQtyFromCart($orderID, $itemID);
} else {
    $qty = 0;
}

if(isset($userID) && $userID > 0){
    $oldPrice = getDefaultPriceInclPriceTypesNoOffer($itemID,$customerID,false,$qty);
    $price =getDefaultPriceInclPriceTypes($itemID,$customerID,false,$qty);
} else {
    $oldPrice = getDefaultPriceInclPriceTypesNoOffer($itemID,$customerID,true,$qty);
    $price = getDefaultPriceInclPriceTypes($itemID,$customerID,true,$qty);
}






if($oldPrice > $price && $oldPrice > 0 && !$isB2CUser){
    $prevPrice = number_format(floatval($oldPrice),2);
} else {
    $prevPrice = '';
}


if($showPricesWithVAT) {
    $vatPercentage = getVatPercentage($vatID);
    $priceWithVAT = (float)$price + (float)$price*($vatPercentage/100);
    $priceWithVAT = number_format(floatval($priceWithVAT),2);

    $oldPriceWithVAT = (float)$oldPrice + (float)$oldPrice*($vatPercentage/100);
    $oldPriceWithVAT = number_format(floatval($oldPriceWithVAT),2);

    $inc = $langu['incl_label'];
    $vat = $langu['vat_label'];
    $PriceWithVatText = "&nbsp;<span  style='font-size:17px;color: #0aa66e '>($currencySign$priceWithVAT &nbsp;$inc $vat)</span>";
    if($includeVatOnPrice){
        $PriceWithVatText='';
        $price= $priceWithVAT;
        $price= $priceWithVAT;

    }
}

if($oldPrice > $price){
    $percentDiscount = round((1 - ($price/$oldPrice))*100);
    $price = number_format(floatval($price),2);
    $oldPrice = number_format(floatval($oldPrice),2);

    $price = "<del style='color: grey;font-size: 26px;'>$currencySign".$oldPrice."</del><br>$currencySign".$price." <span style='color: $textColor;background-color: $labelThemeColor;border-radius: 10%;margin-left: 20px;'>&nbsp;-$percentDiscount%&nbsp;</span>";
} else {
    if(isset($prevPrice) && $prevPrice > $price){
        $percentDiscount = round((1 - ($price/$prevPrice))*100);
        $price = number_format(floatval($price),2);
        $prevPrice = number_format(floatval($prevPrice),2);
        $price = "<del style='color: grey;font-size: 26px;'>$currencySign".$prevPrice."</del><br>$currencySign".$price."<span style='color: $textColor;background-color: $labelThemeColor;border-radius: 10%;margin-left: 20px;'>&nbsp;-$percentDiscount%&nbsp;</span>";
    } else {
        $price = number_format(floatval($price),2);
        $price = "$currencySign" . $price;
    }
}

if(isset($_COOKIE['currentCategory']) && $_COOKIE['currentCategory'] > 0){
    $categoryStatementCategoryFilter = ' WHERE Categories.category_id = '.$_COOKIE['currentCategory'];
} else {
    $categoryStatementCategoryFilter = " WHERE category_id IN(SELECT category_id AS category_id FROM Category_Item WHERE item_id = '$itemID') AND (Categories.category_id IN (SELECT category_id FROM B2B_Categories) OR Categories.category_id IN(SELECT subcategory_id FROM Subcategories,B2B_Categories WHERE Subcategories.category_id=B2B_Categories.category_id))";
}
$categoryStatement= "SELECT category_id,category_code,name,description FROM Categories $categoryStatementCategoryFilter";

$stm = $db->prepare($categoryStatement);
$stm-> execute();
$stm-> bind_result($categoryid,$categoryCode,$categoryName,$categoryDescription);

while ($stm->fetch()) {
    if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 &&isset($categoryDescription) && strcmp($categoryDescription,'')!=0 )
    {
        $categoryName=$categoryDescription;
    }
    $_SESSION['cc'] = $categoryCode;
}

$stm-> close();
if(isset($orderID)) {
    $itemsLabel = $langu['item'];
    $stm = $db->prepare("SELECT SUM(qty) FROM Online_Order_Item WHERE order_id='$orderID'");
    $stm->execute();
    $stm->bind_result($count);

    while ($stm->fetch()) {
    //    $cartCounter="<input id='cartCounter' value='$count $itemsLabel' type='hidden'/>";
    }
    $stm->close();
}

$stm = $db->prepare("SELECT custom_form_id,custom_form_code,custom_form_name FROM  ZA_Custom_Form_Definition,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Definition.custom_form_definition_id=ZA_Custom_Form_Usage.custom_form_id  AND linked_table='Items'");
$stm->execute();
$stm->bind_result($customFormID,$customFormCode,$customFormName);
while ($stm->fetch()) {

    //include_once("../backend/dbhelper.php");


    $db2= new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $columns = array();
    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT ZA_Custom_Field_Definition.custom_field_id,custom_field_name,type,values_range,css_style,position,required,editable,class FROM  ZA_Custom_Field_Definition,ZA_Custom_Form_Custom_Field WHERE ZA_Custom_Field_Definition.custom_field_id=ZA_Custom_Form_Custom_Field.custom_field_id  AND ZA_Custom_Form_Custom_Field.custom_form_id='$customFormID' ORDER BY position");
    $stm2->execute();
    $stm2->bind_result($customFieldID,$customFieldName,$type,$valuesRange,$cssStyle,$position,$required,$editable,$class);
    while ($stm2->fetch()) {


       $formatter = getLastValueOfCustomForm($customFormID, $customFieldID, "Items", $itemID);



        $column['field'] = $customFieldName;
        $column['value'] = $formatter;

        array_push($columns,$column);
    }
    $stm2->close();

}
$stm->close();

$stm = $db->prepare("SELECT category_id FROM B2B_Brands WHERE slider_position='variants' AND category_id IN (SELECT category_id FROM Category_Item WHERE item_id = '$itemID') ORDER BY position ASC LIMIT 1");
$stm->execute();
$stm->bind_result($brandID);
while ($stm->fetch()) {}
$stm->close();

if($brandID > 0 && strcmp($_GET['singleVariant'],'yes')!=0){

    redirect("index.php?variants=$brandID");
}

?>

    <body id="home" class="wide">
        <!-- PRELOADER -->
        <div id="preloader">
            <div id="preloader-status">
                <div class="spinner">
                    <div class="rect1"></div>
                    <div class="rect2"></div>
                    <div class="rect3"></div>
                    <div class="rect4"></div>
                    <div class="rect5"></div>
                </div>
                <div id="preloader-title">Loading</div>
            </div>
        </div>
        <!-- /PRELOADER -->

        <!-- WRAPPER -->
        <div class="wrapper">

            <!-- Popup: Shopping cart items -->
            <div class="modal fade popup-cart" id="popup-cart" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog">
                    <div id='cartItems' class="container">

                    </div>
                </div>
            </div>
            <!-- /Popup: Shopping cart items -->

            <!-- Popup: Videos -->
            <div class="modal fade video-modal" id="video-modal" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog" >
                    <div class="modal-content" >
                        <div class="modal-body" style="margin-top:5px;padding-top:5px;">
                            <div  id='divVideo' >
                                <center>
                                <video autoplay loop controls style="display: block;width: 95%;margin: 0 auto; " >
                                    <source src="" />
                                </video>
                                </center>
                            </div>
                            <div  id='divYoutube' >
                                <center>
                                    <iframe height="450" id="youtubePlayer" src="" style="width: 95%;" ></iframe>
                                </center>
                            </div>
                            <footer class="modal-footer" >

                                <button onclick="$('#video-modal').modal('toggle');" class="btn btn-default" type="button" style="margin-right:10px;">
                                    Close
                                </button>
                            </footer>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Popup: Videos -->


            <!-- HEADER -->

                <?php
                $topmenu = "topMenu$cssTheme.php";

                if(strcmp($topmenu,"topMenu2.php")==0){
                    echo '<header class="header fixed" style="border: 0px;">';
                } else {
                    echo '<header class="header fixed" >';
                }

                include_once("$topmenu");
                if(strcmp($topmenu,"topMenu.php")==0) {
                    include_once("navigationMenu.php");
                }
                ?>
            </header>
            <!-- /HEADER -->

            <!-- CONTENT AREA -->
            <div class="content-area" style="min-height:805px;">

                <!-- PAGE -->
                <section class="page-section">
                    <div class="container" style="width: 90%">

                        <div class="row product-single">
                            <div class="back-to-category" style="margin: 20px;">
                                <span class="link"><a href="index.php?cc=<?php echo $categoryCode?>" style="font-weight: bolder;font-size: 16px;"><i class="fa fa-angle-left"></i> <?php echo $langu['back_to_catalogue_label'];?></a></span>
                                <div class="pull-right">
                                    <a class="btn btn-theme btn-theme-transparent btn-previous" href="<?php $previousItemId = $itemID-1;echo "./product-details.php?code=$previousItemId";?>"><i class="fa fa-angle-left"></i></a>
                                    <a class="btn btn-theme btn-theme-transparent btn-next" href="<?php $nextItemId = $itemID+1;echo "./product-details.php?code=$nextItemId";?>"><i class="fa fa-angle-right"></i></a>
                                </div>
                            </div>
                            <div class="col-md-1 hidden-xs hidden-sm">
                                <div class="row product-thumbnails" >
                                    <?php
                                    $counter = 0;

                                    foreach($imagesArray as $image) {
                                        if($addWatermark) {

                                            if(strcmp($watermarkURL,'')==0){$watermarkURL = $logoLink;};
                                            if(strcmp($watermarkPosition,'')==0){$watermarkPosition = 'center';}
                                            if(strcmp($watermarkOpacity,'')==0){$watermarkOpacity = '0.5';}
                                            if(strcmp($image,'./assets/img/noimage.jpg')!=0) {
                                                $watermarks .= "
                                                watermark(['$image','$watermarkURL'])
                                                .image(watermark.image.$watermarkPosition($watermarkOpacity))
                                                .then(function (img) {
                                                    img.id = 'thmImage$counter';
                                                    img.style.cssText = document.getElementById('thmImage$counter').style.cssText;
                                                    document.getElementById('thmImage$counter').remove();
                                                    document.getElementById('thm$counter').appendChild(img);
                                        
                                                });
                                        
                                                ";
                                            }

                                            $imageUrl = './assets/img/noimage.jpg';
                                        }

                                        echo " <div class='col-xs-12 col-sm-12 col-md-12 pull-right' style='width: 90%;margin: 1px;'><a href='#' class='thm' onclick='assignTrigger($counter);' id='thm$counter' style='border: 2px solid lightgrey;border-radius: 15%;'><img src='$image' alt='' id='thmImage$counter' style='border-radius: 15%'/></a></div>";
                                        $counter++;
                                    }
                                    ?>

                                </div>
                            </div>
                            <div class="col-md-5">

                                <div class="badges">
<!--                                    <div class="hot">hot</div>-->
<!--                                    <div class="new">new</div>-->
                                </div>
                                <div class="img-carousel-manual" id="single-image-carousel">
                                    <?php
                                    $counter = 0;
                                    foreach($imagesArray as $image) {

                                        if($addWatermark) {

                                            if(strcmp($watermarkURL,'')==0){$watermarkURL = $logoLink;};
                                            if(strcmp($watermarkPosition,'')==0){$watermarkPosition = 'center';}
                                            if(strcmp($watermarkOpacity,'')==0){$watermarkOpacity = '0.5';}
                                            if(strcmp($image,'./assets/img/noimage.jpg')!=0) {
                                                $watermarks .= "
                                                    watermark(['$image','$watermarkURL'])
                                                    .image(watermark.image.$watermarkPosition($watermarkOpacity))
                                                    .then(function (img) {
                                                        img.id = 'thmDisplay$counter';
//                                                        img.style.cssText = document.getElementById('thmDisplay$counter').style.cssText;
                                                        document.getElementById('thmDisplay$counter').remove();
                                                        document.getElementById('thmDisplayParent$counter').appendChild(img);
                                            
                                                    });
                                            
                                                    ";
                                            }
                                            $imageUrl = './assets/img/noimage.jpg';
                                        }

                                        echo "<div class='item' id='thmDisplayParent$counter'>
                                                <a href='$image' data-gal='prettyPhoto'><img class='img-responsive' id='thmDisplay$counter' src='$image' alt='' style='max-height:700px;width:auto; display: block;margin-left: auto;margin-right: auto;'/></a>
                                              </div>";

                                        $counter++;
                                    }
                                    ?>

                                </div>

                            </div>
                            <div class="col-md-6">

                                <h1 class="product-title" style="font-weight: bolder;font-size: 36px;"><?php echo "$itemNameString";?></h1>
                                <input id='relatedCategory' type='hidden' value='<?php echo "$categoryid";?>'/>
                                <table>
                                    <tr>
                                        <td class="title" style="font-size: 18px;" ><?php echo $langu['category_label'];?>:</td>

                                        <td style="padding:3px;text-align:center;border-radius:10px;color:<?php echo $textColor;?>;background-color: <?php echo $themeColor;?>"><?php echo "$categoryName";?></td>
                                    </tr>
                                    <tr>
                                        <td class="title" style="font-size: 18px;"><?php echo $langu['product_code'];?>:</td>
                                        <td>&nbsp;<?php echo "$itemCodeString";?></td>
                                    </tr>
                                    <tr >
                                        <td class="title" style="font-size: 18px;"><?php echo $langu['product_barcode'];?>:</td>
                                        <td>&nbsp;<?php echo "$barcode";?></td>
                                    </tr>
                                    <tr style="<?php if((int)$packing > 0){echo "display:block;";}else{echo "display:none;";}?>">
                                        <td class="title" style="font-size: 18px;"><?php echo $langu['product_packing'];?>:</td>
                                        <td>&nbsp;<?php echo "$packing";?></td>
                                    </tr>
                                    <tr>
                                        <td class="title" style="font-size: 18px;">SKU:</td>
                                        <td>&nbsp;<?php echo "$sku";?></td>
                                    </tr>

                                    <?php
                                    $stm = $db->prepare("SELECT brochure_name FROM Item_Brochures WHERE item_id='$itemID'");
                                    $stm-> execute();
                                    $stm-> bind_result($brochureName);
                                    while ($stm->fetch()) {

                                        $brochures .="&nbsp;<a  target='_blank' href='//" . HTML_PATH . "/cop/media/brochures/$brochureName'><img style='height:40px;width:40px;' src='//" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/pdficon.png' alt='Attachment' title='$brochureName'/></a>";

                                    }
                                    $stm-> close();

                                    if(strcmp($brochures,'') != 0){
                                        echo"<tr style='margin-top:10px'><td style='height: 5px;'> </td><td></td></tr>";
                                        echo"<tr style='margin-top:10px'><td class='title'>Specifications</td><td>$brochures</td></tr>";
                                        echo"<tr style='margin-top:10px'><td style='height: 5px;'> </td><td></td></tr>";
                                    }

                                    ?>

                                    <?php
                                    $stm = $db->prepare("SELECT video_url FROM Item_Videos WHERE item_id='$itemID'");
                                    $stm-> execute();
                                    $stm-> bind_result($videoName);
                                    while ($stm->fetch()) {
                                        if(strpos($videoName,'youtu')!=false && strpos($videoName,'be')!=false){
                                             $videoID = substr($videoName, -11);

                                                $videoURL = "https://www.youtube.com/embed/".$videoID."?autoplay=1 ";
                                            $videos .= "<button onclick='playVideo(\"$videoURL\",true)' class='btn btn-theme btn-theme' style='border-radius: 50%;width: 38px;height: 44px;font-size: 44px;padding-left: 14px;padding-top: 11px;'><i class=' fa fa-play'></i></button> ";

                                        }else {
                                            $videoFile = "../media/productVideos/$videoName";
                                            if (file_exists($videoFile)) {
                                                $videos .= "<button onclick='playVideo(\"$videoFile\",false)' class='btn btn-theme btn-theme' style='border-radius: 50%;width: 44px;height: 44px;font-size: 16px;padding-left: 14px;padding-top: 11px;'><i class='fa fa-play'></i></button> ";
                                            }
                                        }
                                    }
                                    $stm-> close();

                                    if(strcmp($videos,'') != 0){
                                        echo" <tr style='margin-top:10px'><td style='height: 5px;'> </td><td></td></tr>
                                              <tr style='margin-top:10px'><td class='title'>Videos</td>
                                                <td>
                                                    $videos
                                                </td>
                                              </tr>
                                              <tr style='margin-top:10px'><td style='height: 5px;'> </td><td></td></tr>";
                                    }

                                    ?>


                                    <?php
                                    if($nonStock){
                                        $stock = 0;
                                        $useMaxStock = 0;
                                        $maxStockOfItem = 0;
                                        $denyOrderOverStock = true;
                                    } else {
                                        $stock = getStock($itemID);
                                    }

                                    if($denyOrderOverStock && $maxStockLimit > 0 && $useMaxStock){
                                        if($maxStockOfItem > $maxStockLimit || $maxStockOfItem == 0){
                                            $maxStockOfItem = $maxStockLimit;
                                            $useMaxStock = true;
                                        }
//
                                    } else if ($denyOrderOverStock && !$useMaxStock && $maxStockLimit > 0) {
                                        if($stock > $maxStockLimit){
                                            $maxStockOfItem = $maxStockLimit;
                                            $useMaxStock = true;
                                        }
                                    } else {
                                        $maxStockOfItem = $stock;

                                    }

                                    $displayStock = '<table>';
                                    if($_SESSION['showStock'])
                                    {
                                        if(strcmp($numericStock,"yes")==0) {
                                            $label = $langu['product_available_stock'];
                                            $displayStock .= " <tr>
                                        <td class='title' style='color:#008080'>$label:</td>
                                        <td style='color:#008080;font-size:15px;font-weight:bold;'>$stock</td>
                                    </tr>";
                                        }
                                        else
                                        {
                                            if ($stock < $stockWarningQty && $stock > 0) {
                                                $label = $langu['product_available_stock'];
                                                $displayStock .= " <tr>
                                        <td class='title' style='color:#B98502FF'>$label :</td>
                                        <td style='color:#B98502FF;font-size:15px;font-weight:bold;'><span style='color: #B98502FF;font-weight:bold;display:inline-block;'><h6 style='height: 12px;width: 12px;background-color: #B98502FF;border-radius: 50%;display:inline-block;margin:-1px !important;margin-right: 0px !important;' class='dot'></h6> $stock</td>
                                    </tr>";
                                            } else if($stock>0)
                                            {
                                                $label = $langu['product_available_stock'];
                                                $displayStock .= " <tr>
                                        <td class='title' style='color:#008080'>$label :</td>
                                        <td style='color:#008080;font-size:15px;font-weight:bold;'><span style='height: 12px;width: 12px;background-color: #008080;border-radius: 50%;display:inline-block;' class='dot'></span></td>
                                    </tr>";
                                            }
                                            else
                                            {
                                                $label = $langu['product_out_of_stock'];
                                                $displayStock .= " <tr>
                                        <td class='title' style='color:#b22222'>$label:</td>
                                        <td style='color:#b22222;font-size:15px;font-weight:bold;'> <span style='height: 12px;width: 12px;background-color: #b22222;border-radius: 50%;display:inline-block;' class='dot'></span></td>
                                    </tr>";
                                            }

                                        }
                                    }
                                    $displayStock .= '</table>';

                                    if($nonStock){$stock = -1;}
                                    ?>

                                </table>
<!--                                <div class="product-availability">Availability: <strong>In stock</strong> 21 Item(s)</div>-->
                                <hr class="page-divider small"/>
                                <?php
                                echo "<div class='pull-right' style='font-size: 18px;font-weight: bolder;margin-right: 30px;margin-top: 5px;'>$displayStock</div>";
                                if(isset($recommendedRetailPrice)&& $recommendedRetailPrice>0 && $showPrices && $customerID!=0 && $showPrices && !$isB2CUser) {
                                    echo "<div>".$langu['column_price_label'] ."</div>";
                                }


                                ?>
                                <div class="product-price">
                                    <?php
                                    if($customerID!=0&&$showPrices) {

                                        echo"$price $PriceWithVatText";
                                    } else if($showAnonymousPrices){
                                        echo"$price $PriceWithVatText";
                                    } ?></div>


                                <?php

                                if(isset($recommendedRetailPrice)&& $recommendedRetailPrice>0 && $showPrices && !$isB2CUser) {
                                    $recommendedRetailPriceDouble = getPriceFromPriceType($itemID, $recommendedRetailPrice);
                                    $recommendedRetailPriceDouble = number_format(floatval($recommendedRetailPriceDouble),2);

                                    if($showPricesWithVAT) {
                                        $vatPercentage = getVatPercentage($vatID);
                                        $priceWithVAT = (float)$recommendedRetailPriceDouble + (float)$recommendedRetailPriceDouble*($vatPercentage/100);
                                        $priceWithVAT = number_format(floatval($priceWithVAT),2);
                                        $inc = $langu['incl_label'];
                                        $vat = $langu['vat_label'];
                                        $recommendedPriceWithVatText = "&nbsp;<span  style='font-size:17px;color: #0aa66e '>($currencySign$priceWithVAT &nbsp;$inc $vat)</span>";
                                        if($includeVatOnPrice){
                                            $recommendedPriceWithVatText="&nbsp;<span  style='font-size:14px;color: #0aa66e '>*$inc $vat</span>";
                                            $recommendedRetailPriceDouble= $priceWithVAT;
                                        }
                                    }
                                    echo "<div>".$langu['recommended_retail_price'] ."</div>";
                                    echo"<div class=\"product-price\">$currencySign$recommendedRetailPriceDouble $recommendedPriceWithVatText</div>";

                                }

                                if(count($columns) > 0){
                                    echo '<hr class="page-divider small"/>';
                                }

                                ?>



                                <table>
                                <?php
                                foreach ($columns as $column) {

                                    echo"<tr style='padding-top: 20px;'>
                                            <td class='title' >" .$column['field']. ": </td>
                                            <td>". $column['value'] ."</td>
                                         </tr>";
                                }
                                ?>
                                </table>

                                <hr class="page-divider"/>
                                <?php
                                 if(strcmp($shortDescription,"")!=0)
                                 {
                                     echo" <div class='product-text'>
                                    <p style='color:#222'>$shortDescription</p>
                                   </div>
                                    <hr class='page-divider'/>";

                                 }
                                ?>
<?php

if($useMaxStock && $maxStockOfItem > 0 && $maxStockOfItem < $qty){
    $stockForError = "<input style='display:none;' type='hidden' id='max' value='$maxStockOfItem'>" ;
    $overMessage = "<span style='color: firebrick;font-weight:bolder;width: 100%;font-size:17px;margin-left:15px;display:inline-block;' class='insStock' id='maxError'>".$langu['insufficient_stock']."</span>";
} else if($denyOrderOverStock && $stock < $qty && $qty > 0) {
    $stockForError = "<input style='display:none;' type='hidden' id='max' value='$stock'>" ;
    $overMessage = "<span style='color: firebrick;font-weight:bolder;width: 100%;font-size:17px;margin-left:15px;display:inline-block;' class='insStock' id='maxError'>".$langu['insufficient_stock']."!</span>";
} else if(!$denyOrderOverStock){
    $stockForError = "" ;
    $overMessage = "";
} else if($denyOrderOverStock && $maxStockLimit > 0) {
    if($stock < $maxStockLimit){$maxStockLimit = $stock;}
    $stockForError = "<input style='display:none;' type='hidden' id='max' value='$maxStockLimit'>" ;
    $overMessage = "<span style='color: firebrick;font-weight:bolder;width: 100%;font-size:17px;margin-left:15px;display:none;' class='insStock' id='maxError'>".$langu['insufficient_stock']."!</span>";
}

if($customerID!=0 || $allowAnonymousOrder)
{

    if($usePackingOnItem){
        $packingAttr= "data-packing='$packing'";
    } else {
        $packingAttr='';
    }
    if($isInactive){
        echo "<h3>* ".$langu['product_not_available']."</h3>";
    } else {

        $uomQty = 0;
        if(true) {
            $itemUOMs = getItemUOMs($orderID,$itemID);
            if (!empty($itemUOMs)) {
                $itemUomElement = "<div style='height: 30px;margin-bottom:5px;'><select class='uom-element' style='display: inline-block;border: 2px solid $themeColor;border-radius: 3px;color: $themeColor;font-size: 18px;background-color: transparent;padding: 1px;' onMouseOver=\"this.style.background='$themeColor';this.style.color='white'\"  onMouseOut=\"this.style.background='transparent';this.style.color='$themeColor'\">";
                foreach ($itemUOMs as $uom) {
                    $itemUomElement .= "<option value='$uom->name' data-multiplier='$uom->multiplier' data-id='$uom->id' $uom->selected>$uom->name&nbsp;</option>";
                    $uomQty = $uom->qty;
                }
                $itemUomElement .= "</select></div>";
            } else {
                $itemUomElement = "<div style='height: 30px;'>
                                    <select class='uom-element pull-right' style='display: none;' >
                                        <option  value='' data-multiplier='1' data-id='0' selected></option>
                                    </select>
                                </div>";
            }
            if($uomQty > 0){$qty = $uomQty;}
        }

        if($enableAddToCartButtonOnFirstClick) {
            if ($qty > 0) {
                $hideAddButton = "display:none;";
                $hideButtonsDiv = "";
            } else {
                $hideAddButton = "";
                $hideButtonsDiv = "display:none;";
            }
            $addToCartButton = "<button type='button' class='btn btn-block btn-theme addButton' onclick='$(this).siblings(\"div.quantity\").show();$(\"#plusButtonSingleProduct\").click();$(this).hide();' style='text-transform: none !important;border-radius: 3px;width: 80%;min-width:fit-content;max-width:170px;padding:15px 10px;$hideAddButton'><i class='fa fa-shopping-cart'></i>&nbsp;&nbsp; ".$langu['add_to_cart']."</button>";

        }

        echo "<div class='buttons'>$itemUomElement$addToCartButton
                                    <div class='quantity' style='border: 2px solid $themeColor;border-radius: 5%;$hideButtonsDiv'>
                                        <button id='minusButtonSingleProduct' class='btn btn-theme btn-theme-transparent' style='display:inline-block;width:40px;height:45px;margin: 0px;padding:0px;font-weight:bolder;font-size:18px;border: 1px solid transparent;color:$themeColor;background-color: transparent'  onMouseOver=\"this.style.background='$themeColor';this.style.color='white'\"  onMouseOut=\"this.style.background='white';this.style.color='$themeColor'\" $packingAttr><i class='fa fa-minus'></i></button>
                                        <input id='productQtyInput' class='form-control qty' data-value='$itemID' style='display:inline-block;width:80px;height:45px;margin: 0px;text-align: center;font-weight:bolder;border: 3px solid transparent ;background-color:white;color:black;font-size:16px;border-radius: 15px;'  $packingAttr type='number' name='quantity' value='$qty' title='Qty'>
                                        <button id='plusButtonSingleProduct'  class='btn btn-theme btn-theme-transparent' style='display:inline-block;width:40px;height:45px;margin: 0px;padding:0px;font-weight:bolder;font-size:18px;border: 1px solid transparent;color:$themeColor;background-color: transparent'  onMouseOver=\"this.style.background='$themeColor';this.style.color='white'\"  onMouseOut=\"this.style.background='white';this.style.color='$themeColor'\" $packingAttr><i class='fa fa-plus'></i></button>
                                    </div>
                                   
                                </div>$overMessage$stockForError";
    }

}


?>

                                <hr class="page-divider small"/>

                                <?php

                                if(strcmp($longDescription,"")!=0)
                                {
                                    $label = $langu['product_details'];
                                    echo " <h4 style='color:black;margin-top:30px;font-size:24px;'>$label</h4>

                                   <div><span style='color:#222'>$longDescription</span></div>
                                   <hr class='page-divider'/>";
                                }

                                ?>


                            </div>
                        </div>

                    </div>
                </section>
                <!-- /PAGE -->

                <!-- PAGE -->

                <?php

                    $label = $langu['related_products_label'];
                    echo" <section class='page-section'>
                    <div class='container'>
                        <h2 class='section-title section-title-lg'><span>$label</span></h2>
                        <div class='featured-products-carousel'>
                            <div class='owl-carousel' id='featured-products-carousel'>
                            </div>
                        </div>
                        <hr class='page-divider half'/>

                    </div>
                </section>";

                ?>

                <!-- /PAGE -->

            </div>
            <!-- /CONTENT AREA -->

            <!-- FOOTER -->
            <?php
            if(strcmp($footerLabel,'')==0){$footerLabel = 'Powered by Coprime - 25311504';}
            if(strcmp($topmenu,"topMenu2.php")==0 || strcmp($topmenu,"topMenu3.php")==0) {
                echo '<footer class="footer" style="border: 0px;" >
                            <div class="footer-meta footer-custom" style="background: linear-gradient(to bottom, white  0%, whitesmoke 5%, '.$themeColor.' 15%);border: 0px;">
                                <div class="container" style="width: 100%" >
                                    <div class="row" >
            
                                        <div class="col-sm-6 footer-copyright-outer" >
                                            <div class="copyright footer-copyright-text" style="color: '.$textColor.';border-color: transparent">
                                                 '.$footerLabel.'
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </footer>';
            } else {
                echo '<footer class="footer">
                            <div class="footer-meta footer-custom">
                                <div class="container">
                                    <div class="row">
            
                                        <div class="col-sm-6 footer-copyright-outer" >
                                            <div class="copyright footer-copyright-text" >
                                                '.$footerLabel.'
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </footer>';
            }

            ?>
            <!-- /FOOTER -->

            <div id="to-top" class="to-top"><i class="fa fa-angle-up"></i></div>

        </div>
        <!-- /WRAPPER -->

        <!-- JS Global -->
        <script src="assets/plugins/jquery/jquery-1.11.1.min.js"></script>
        <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
        <script src="assets/plugins/bootstrap-select/js/bootstrap-select.min.js"></script>
        <script src="assets/plugins/superfish/js/superfish.min.js"></script>
        <script src="assets/plugins/prettyphoto/js/jquery.prettyPhoto.js"></script>
        <script src="assets/plugins/owl-carousel2/owl.carousel.min.js"></script>
        <script src="assets/plugins/jquery.sticky.min.js"></script>
        <script src="assets/plugins/jquery.easing.min.js"></script>
        <script src="assets/plugins/jquery.smoothscroll.min.js"></script>
        <script src="assets/plugins/smooth-scrollbar.min.js"></script>

        <!-- JS Page Level -->
        <script src="assets/js/theme.js"></script>
        <script src="assets/js/watermark.min.js"></script>


        <!--[if (gte IE 9)|!(IE)]><!-->
        <script src="assets/plugins/jquery.cookie.js"></script>
        <script src="assets/js/waitMe.min.js"></script>
        <!--<![endif]-->

    <script>
        jQuery(document).ready(function () {

            initThemeParameters();

            getRelatedItems($('#relatedCategory').val());
            addButtonListenersProductDetails();
            setItemsCartCounter();
            assignTrigger(0);

            var owlCarousel = $('.img-carousel-manual').owlCarousel({loop: false,responsive: { 0: {items: 1}}});
            owlCarousel.trigger('refresh.owl.carousel');

            <?php
            if($addWatermark) {


                echo $watermarks;
            }
            ?>

        });

        function playVideo(src, youtube){
            if(youtube){
                $('#divVideo').hide();
                $('#divYoutube').show();

                $('#youtubePlayer').attr('src', '');
                $('#youtubePlayer').attr('src', src);
                $('#video-modal').modal('toggle');
                $('#video-modal').on('hidden.bs.modal', function () {
                    $('#youtubePlayer').attr('src', '');
                });
            } else {
                $('#divYoutube').hide();
                $('#divVideo').show();

                $('#divVideo video source').attr('src', '');
                $('#divVideo video source').attr('src', src);
                $("#divVideo video").load();
                $('#video-modal').modal('toggle');
                $('#video-modal').on('hidden.bs.modal', function () {
                    $('#divVideo video source').attr('src', '');
                    $("#divVideo video").load();
                });
            }
        }

        function assignTrigger(start)
        {
            $('.img-carousel-manual').trigger('to.owl.carousel', [start, 300]);
            $('.thm').css('border', '2px solid lightgrey');
            $('#thm'+start).css('border', '2px solid <?php echo $themeColor; ?>');
        }

        function setItemsCartCounter()
        {
            $("#modalCartButtonText").html( $('#cartCounter').val());
        }

    </script>

    </body>
</html>