<?php

include_once("../../param.php");
require("dbhelper.php");

global  $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

global  $username,$password,$database;
$db2 = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db2->set_charset("utf8");



$loggedInUserID = intval($_SESSION['userID']);
$loggedInCustomerID = intval($_SESSION['customerID']);

if(isset($loggedInUserID) && $loggedInUserID > 0 && isset($loggedInCustomerID) && $loggedInCustomerID > 0){
    $loggedin = true;
} else {
    $loggedin = false;
}

if (!$loggedin) {
    http_response_code(401);
    exit;
}


if(isset($_POST['serviceCallID'])) {
    $serviceID = $_POST['serviceCallID'];
    $query = "SELECT 
             sc.service_call_code, sc.schedule_start_date, sc.schedule_end_date, sc.date, sc.due_date, 
            sc.topic, sc.details, 
            scs.status_id, scs.status_code, scs.status_name, scs.status_color, 
            sct.type_id, sct.type_code, sct.type_name, sct.color, 
            sc.salesperson_id as createBy, sc.assign_to
          FROM Service_Call AS sc
          LEFT JOIN SC_Status AS scs ON sc.status_id = scs.status_id
          LEFT JOIN SC_Types AS sct ON sct.type_id = sc.type_id
          WHERE sc.service_call_id = ? LIMIT 1";


    $stm = $db->prepare($query);
    $stm->bind_param('i', $serviceID);
    $stm->execute();
    $stm->bind_result($serviceCode, $scheduleStartDate, $scheduleEndDate,$serviceDate,$serviceDueDate, $topic,$details, $statusID, $statusCode, $statusName, $statusColor, $typeID, $typeCode, $typeName, $typeColor,$createdBy, $assignedTo );

    $serviceCall = new stdClass();
    while ($stm->fetch()) {



        $serviceCall->serviceCallID = $serviceID;
        $serviceCall->serviceCallCode = $serviceCode;

        $serviceCall->scStatus = new stdClass();
        $serviceCall->scStatus->statusID = $statusID;
        $serviceCall->scStatus->statusCode = $statusCode;
        $serviceCall->scStatus->name = $statusName;
        $serviceCall->scStatus->color = $statusColor;

        $serviceCall->topic = $topic;
        $serviceCall->date = $serviceDate;

        $serviceCall->scType = new stdClass();
        $serviceCall->scType->typeID = $typeID;
        $serviceCall->scType->typeCode = $typeCode;
        $serviceCall->scType->name = $typeName;
        $serviceCall->scType->color = $typeColor;

        $serviceCall->details = $details;
        $serviceCall->dueDate = $serviceDueDate;
        $serviceCall->scheduleStart = $scheduleStartDate;
        $serviceCall->scheduleEnd = $scheduleEndDate;

        $serviceCall->assignTo = new stdClass();
        $salespersonDetails = getSalespersonDetails($assignedTo,$db2);
        $serviceCall->assignTo->userID = $salespersonDetails->salesperson_id;
        $serviceCall->assignTo->userCode = $salespersonDetails->salesperson_code;
        $serviceCall->assignTo->firstName = $salespersonDetails->first_name;
        $serviceCall->assignTo->lastName = $salespersonDetails->last_name;

        $serviceCall->createdBy = new stdClass();
        $salespersonDetails = getSalespersonDetails($createdBy,$db2);
        $serviceCall->createdBy->userID = $salespersonDetails->salesperson_id;
        $serviceCall->createdBy->userCode = $salespersonDetails->salesperson_code;
        $serviceCall->createdBy->firstName = $salespersonDetails->first_name;
        $serviceCall->createdBy->lastName = $salespersonDetails->last_name;

        $serviceCall->serviceCallReplies = [];
        $serviceCallReplies = getServiceCallReplies($serviceID,$db2);

        foreach ($serviceCallReplies as $serviceCallReply) {
            $serviceCall->serviceCallReplies[] = $serviceCallReply;
        }
        

    }
    $stm->close();
    echo json_encode($serviceCall);
}

function getSalesPersonDetails($salespersonID,$db) {
    $stm = $db->prepare("SELECT salesperson_id,salesperson_code, first_name,last_name FROM SalesPersons WHERE salesperson_id = ? LIMIT 1");
    $stm->bind_param('i', $salespersonID);
    $stm->execute();
    $stm->bind_result($salespersonID,$salespersonCode, $firstName, $lastName);
    while ($stm->fetch()) {
        $salesperson = new stdClass();
        $salesperson->salesperson_id = $salespersonID;
        $salesperson->salesperson_code = $salespersonCode;
        $salesperson->first_name = $firstName;
        $salesperson->last_name = $lastName;
    }

    $stm->close();
    return $salesperson;
}

function getAttachmentURLs($replyID,$db) {
    $stm = $db->prepare("SELECT attachment_name FROM Service_Call_Reply_Attachments WHERE service_call_reply_id = ?");
    $stm->bind_param('i', $replyID);
    $stm->execute();
    $stm->bind_result($attachmentName);
    $attachments = array();
    while ($stm->fetch()) {
        $attachments[] = "//" . HTML_PATH . "/cop/media/serviceCallAttachments/".$attachmentName;
    }
    $stm->close();
    return $attachments;
}

function getDocumentDetails($documentID, $documentType, $db) {
    $tables = ['Tenders', 'Orders', 'Waybills', 'Invoices', 'Returns', 'Receipts', 'Customer_Stock_Taking', 'Visits'];

    $documentData = new stdClass();

    if(in_array($documentType, $tables)) {
        $table = $documentType;

        $fieldName = strtolower(preg_replace('/s$/', '', $table)); //removes last 's' char
        $fieldNameCode = $fieldName . '_code';
        $fieldNameId = $fieldName . '_id';

        if (in_array($table, ['Customer_Stock_Taking', 'Visits'])) {
            $statusFieldExists = false;
        } else {
            $statusFieldExists = true;
        }

        $sql = "SELECT $fieldNameCode" . ($statusFieldExists ? ", status" : "") . " FROM $table WHERE $fieldNameId = ? LIMIT 1";

        if ($stmt = $db->prepare($sql)) {
            $stmt->bind_param("i", $documentID);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($row = $result->fetch_assoc()) {
              $documentData->code = $row['code'];
                if ($statusFieldExists) {
                    $documentData->status = $row['status'];
                } else {
                    $documentData->status = "";
                }
            }
            $stmt->close();
        }
    }
    else if($documentType == 'Transfer') {
        $stmt = $db->prepare("SELECT warehouse_transaction_code FROM Warehouse_Transactions where warehouse_transaction_id = ? LIMIT 1" );
        $stmt->bind_param("i", $documentID);
        $stmt->execute();
        $stmt->bind_result($warehouseTransactionCode);
        while ($stmt->fetch()) {
          $documentData->code = $warehouseTransactionCode;
          $documentData->status = '';
        }
    }
    else if($documentType == 'Contract') {
        $stmt = $db->prepare("SELECT s.serial_number, s.status FROM Contracts AS c  INNER JOIN Serial_Numbers AS s ON c.serial_number_id = s.serial_number_id WHERE contract_id = ? LIMIT 1" );
        $stmt->bind_param("i", $documentID);
        $stmt->execute();
        $stmt->bind_result($serialNumber,$status);
        while ($stmt->fetch()) {
          $documentData->code = $serialNumber;
          $documentData->status = $status;
        }
    }
    else if($documentType == 'Picks') {
        $stmt = $db->prepare("SELECT pick_code, status FROM Pick WHERE pick_id = ? LIMIT 1" );
        $stmt->bind_param("i", $documentID);
        $stmt->execute();
        $stmt->bind_result($code,$status);
        while ($stmt->fetch()) {
            $documentData->code = $code;
            $documentData->status = $status;
        }
    }


    return $documentData;
}

function getServiceCallReplies($serviceID,$db2) {
    global  $username,$password,$database;
    $db3 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db3->set_charset("utf8");


    $stm = $db2->prepare("SELECT  r.service_call_reply_id, r.date, r.details, r.reply_type_id, r.salesperson_id, r.salesperson_to, r.email_response, scs.status_id, scs.status_code, scs.status_name, scs.status_color, scp.priority_id, scp.priority_code, scp.priority_name, scp.priority_color, r.document_id, r.document_type
                            FROM Service_Call_Reply as r  
                            LEFT JOIN SC_Status as scs ON r.status_id = scs.status_id
                            LEFT JOIN SC_Priorities as scp ON r.priority_id = scp.priority_id
                          WHERE r.service_call_id = ? ");
    $stm->bind_param('i', $serviceID);
    $stm->execute();
    $stm->bind_result($replyID, $replyDate, $replyDetails, $replyTypeID, $createdBy, $assignedTo, $emailResponse, $statusID, $statusCode, $statusName, $statusColor, $priorityID, $priorityCode, $priorityName, $priorityColor, $documentID, $documentType);
    $serviceCallReplies = [];
    while ($stm->fetch()) {
        $reply = new stdClass();

        $reply->createdBy = new stdClass();
        $salespersonDetails = getSalespersonDetails($assignedTo,$db3);
        $reply->createdBy->userID = $salespersonDetails->salesperson_id;
        $reply->createdBy->userCode = $salespersonDetails->salesperson_code;
        $reply->createdBy->firstName = $salespersonDetails->first_name;
        $reply->createdBy->lastName = $salespersonDetails->last_name;

        $reply->assignTo = new stdClass();
        $salespersonDetails = getSalespersonDetails($assignedTo,$db3);
        $reply->assignTo->userID = $salespersonDetails->salesperson_id;
        $reply->assignTo->userCode = $salespersonDetails->salesperson_code;
        $reply->assignTo->firstName = $salespersonDetails->first_name;
        $reply->assignTo->lastName = $salespersonDetails->last_name;

        $reply->date = $replyDate;
        $reply->details = $replyDetails;
        $reply->replyTypeID = $replyTypeID;

        $reply->scStatus = new stdClass();
        $reply->scStatus->statusID = $statusID;
        $reply->scStatus->statusCode = $statusCode;
        $reply->scStatus->name = $statusName;
        $reply->scStatus->color = $statusColor;

        $reply->scPriority = new stdClass();
        $reply->scPriority->priorityID = $priorityID;
        $reply->scPriority->priorityCode = $priorityCode;
        $reply->scPriority->name = $priorityName;
        $reply->scPriority->color = $priorityColor;

        $reply->document = new stdClass();
        $reply->document->documentID = $documentID;
        $reply->document->documentType = $documentType;
        $documentDetails = getDocumentDetails($documentID,$documentType,$db3);
        $reply->document->documentCode = $documentDetails->code;
        $reply->document->documentStatus = $documentDetails->status;


        $reply->email_response = $emailResponse;

        $reply->attachments = getAttachmentURLs($replyID,$db3);

        $serviceCallReplies[] = $reply;
}

    $stm->close();

    return $serviceCallReplies;
}



?>