<?php
session_start();
include_once("../../param.php");
require("dbhelper.php");
$oldOrderID=$_POST['orderIDToCopy'];
$orderID=$_SESSION['orderID'];
$customerID =$_SESSION['customerID'];
$cancelPreviousOrder = $_POST['cancelPreviousOrder'];
$fromApp = $_POST['fromApp'];

clearCart($orderID);
$db = new mysqli('localhost', $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

// Check Items Exists In Categories START

function getB2BCategories($db){

    $categoriesArray = array();
    $counterOfCategories = 0;
    $categoryID = 0;

    if(isset($_SESSION['userID'])) {
        $user=$_SESSION['userID'];
        $stm = $db->prepare("SELECT COUNT(*) FROM B2B_Allow_Categories_User WHERE b2b_user_id='$user'");
        $stm-> execute();
        $stm-> bind_result($counterOfCategories);
        while ($stm->fetch()) {}
        $stm-> close();
        if($counterOfCategories>0)
        {
            $query="SELECT Categories.category_id FROM Categories INNER JOIN B2B_Allow_Categories_User ON(Categories.category_id=B2B_Allow_Categories_User.category_id) LEFT JOIN B2B_Categories ON (Categories.category_id=B2B_Categories.category_id) WHERE b2b_user_id='$user' ORDER BY B2B_Categories.position,category_code";
        } else {
            $query="SELECT Categories.category_id FROM Categories,B2B_Categories WHERE Categories.category_id=B2B_Categories.category_id ORDER BY B2B_Categories.position,category_code";
        }
    } else {
        $query="SELECT Categories.category_id FROM Categories,B2B_Categories WHERE Categories.category_id=B2B_Categories.category_id AND Categories.category_id > 100 ORDER BY B2B_Categories.position,category_code";
    }

    $stm = $db->prepare($query);
    $stm-> execute();
    $stm-> bind_result($categoryID);
    while ($stm->fetch()) {
        $categoriesArray = array_unique(array_merge($categoriesArray,getSubCategories($categoryID,$categoriesArray)));
    }
    $stm->close();

    return $categoriesArray;
}

function getSubCategories($categoryID,$categoriesArray){

    if(!in_array($categoryID,$categoriesArray)){
        array_push($categoriesArray,$categoryID);
    }

    global $username,$password,$database;
    $db2 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT Categories.category_id FROM Categories,Subcategories WHERE  Subcategories.category_id =\"$categoryID\" AND Categories.category_id=Subcategories.subcategory_id ");
    $stm2-> execute();
    $stm2-> bind_result($subCategoryID);
    while ($stm2->fetch()) {
        if(!in_array($subCategoryID,$categoriesArray)){
            array_push($categoriesArray,$subCategoryID);
            $categoriesArray = array_unique(array_merge($categoriesArray,getSubCategories($subCategoryID,$categoriesArray)));
        }
    }
    $stm2-> close();

    return $categoriesArray;

}

function itemExistsInCategories($itemID,$categoriesArray){

    $z = false;
    $categories = implode(',',$categoriesArray);

    if(strcmp($categories,'')!=0) {
        global $username, $password, $database;
        $db2 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        $db2->set_charset("utf8");
        $stm2 = $db2->prepare("SELECT count(item_id) FROM Category_Item WHERE Category_Item.item_id='$itemID' AND Category_Item.category_id IN ($categories) ");
        $stm2->execute();
        $stm2->bind_result($counter);
        while ($stm2->fetch()) {
            if($counter > 0){
                $z = true;
            }
        }
        $stm2->close();
    }

    return $z;
}

$categoriesArray = getB2BCategories($db);

// Check Items Exists In Categories END



$deliveryMethodItems = array();
$stm = $db->prepare("SELECT weight_fee_item_id FROM B2B_Configuration LIMIT 1");
$stm-> execute();
$stm-> bind_result($weightFeeItemID);
while ($stm->fetch()) {array_push($deliveryMethodItems, $weightFeeItemID);}
$stm->close();

$stm = $db->prepare("SELECT item_id FROM B2C_Configuration,Category_Item WHERE Category_Item.category_id=B2C_Configuration.delivery_method_category_id");
$stm-> execute();
$stm-> bind_result($deliveryMethodItem);
while ($stm->fetch()) {array_push($deliveryMethodItems, $deliveryMethodItem);}
$stm->close();

$stm = $db->prepare("SELECT item_id FROM Delivery_Cost WHERE item_id > 0");
$stm-> execute();
$stm-> bind_result($deliveryFeeItem);
while ($stm->fetch()) {array_push($deliveryMethodItems, $deliveryFeeItem);}
$stm->close();

if(!empty($deliveryMethodItems)){
    $deliveryMethodItems = implode(',',$deliveryMethodItems);
    $filterDeliveryMethods = " AND item_id NOT IN ($deliveryMethodItems)";
}

$stm = $db->prepare("SELECT item_id,qty,promotion_id,promotion_number,master_item,unit_price,description FROM Order_Item WHERE order_id='$oldOrderID' $filterDeliveryMethods");
$stm-> execute();
$stm-> bind_result($itemID,$qty,$promotionID,$promotionNumber,$masterItem,$unitPrice,$description);


while ($stm->fetch()) {

    if(!itemExistsInCategories($itemID,$categoriesArray)){continue;}

    if($promotionID==0)
    {
        $unitPrice = getDefaultPrice($itemID, $customerID) / getPriceRate();
    }

//$onlineOrderItemID=getNextKey("Online_Order_Item","order_item_id");
    $db2 = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");

    $stmt2 = $db2->prepare("INSERT INTO Online_Order_Item (order_id,item_id,qty,unit_price,promotion_id,promotion_number,master_item,description,timestamp) VALUES(?,?,?,?,?,?,?,?,NOW())");
    $stmt2->bind_param('iiddiiss', $orderID, $itemID, $qty, $unitPrice, $promotionID, $promotionNumber, $masterItem,$description);
    $stmt2->execute();
    $stmt2->close();

}
$stm->close();

if(strcmp($cancelPreviousOrder,'yes')==0) {
    $stmt = $db->prepare("UPDATE Orders SET status = 'Canceled' WHERE order_id=?  ");
    $stmt->bind_param('i', $oldOrderID);
    $stmt->execute();
    $stmt->close();
}

redirect("../checkout.php");

function redirect($url)
{
    global $fromApp;

    if(strcmp($fromApp,'yes')==0){

        $rawParamArray = explode('&', explode('?', $url)[1]);
        $parameters    = array();

        foreach ($rawParamArray as $parameter) {
            $parameter = explode('=', $parameter);
            $parameters[$parameter[0]] = $parameter[1];
        }

        $response = new stdClass();
        $response->redirectUrl = basename($url);
        $response->function = str_replace('.php','',explode('?',basename($url))[0]);
        $response->parameters = $parameters;
        $response->message = "".$_SESSION['appMessage'];
        $response->sessionID = session_id();

        echo json_encode($response);
    } else {
        if (headers_sent()) {
            die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
        } else {
            header('Location: ' . $url);
            die();
        }
    }
}

?>