<?php
session_start();
include_once("../../param.php");
include_once("headerImports.php");
require("./dbhelper.php");

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$db2= new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$columns = array();
$db2->set_charset("utf8");

$productJson= new stdClass();
$useMaxStock=false;
$denyOrderOverStock = true;
$showPrices=true;
$showPricesWithVAT=false;
$includeVatOnPrice=false;
$isB2C = false;
$usePackingOnItem = false;
$showAnonymousPrices = false;
$allowAnonymousOrder = false;
$currencySign = getCurrencySign();

$stm = $db->prepare("SELECT allow_anonymous,use_max_stock_on_item,allow_order_over_stock,max_stock_limit,show_prices_with_vat,use_as_b2c,css_theme,theme,use_packing,show_prices_anonymous,anonymous_order,logo_link,b2b_price_list,b2c_price_list,b2b_offer_price_list,b2c_offer_price_list,primary_language,show_prices,footer FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($anonymous,$useMaxStockOnItem,$allowOrderOverStockOnItem,$maxStockLimit,$showPricesIncludingVAT,$useAsB2C,$cssTheme,$labelThemeColor,$usePacking,$showB2BAnonymousPrices,$anonymousOrder,$logoLink,$fromB2BPriceList,$fromB2CPriceList,$offerB2BPriceList,$offerB2CPriceList,$primaryLanguage,$showPricesConfig,$footerLabel);
while ($stm->fetch()) {

    if(strcmp($showB2BAnonymousPrices,'yes')==0){
        $showAnonymousPrices = true;
    }
    if(strcmp($anonymousOrder,'yes')==0){
        $allowAnonymousOrder = true;
    }

    if(strcmp($usePacking,'yes')==0){
        $usePackingOnItem = true;
    }
    if(strcmp($useMaxStockOnItem,'yes')==0){
        $useMaxStock = true;
    }
    if(strcmp($allowOrderOverStockOnItem,'yes')==0){
        $denyOrderOverStock = false;
    }
    if(strcmp($showPricesIncludingVAT,"yes")==0 || strcmp($showPricesIncludingVAT,"both")==0) {
        $showPricesWithVAT=true;
        if(strcmp($showPricesIncludingVAT,"yes")==0){
            $includeVatOnPrice = true;
        }
    }
    if(strcmp($useAsB2C,"yes")==0){
        $isB2C = true;
    }

    if($cssTheme <= 1){
        $cssTheme = '';
    }

    if(strcmp($showPricesConfig,"no")==0 || (isset($_SESSION['showPrices']) && $_SESSION['showPrices']==false)) {
        $showPrices=false;
    }

}
$stm-> close();

$textColor = "white";
if(strcmp($labelThemeColor,'')!=0){
    if(strcmp($labelThemeColor,'red')==0 || strcmp($labelThemeColor,'Red')==0 ){
        $labelThemeColor = "firebrick";
    } else if(strcmp($labelThemeColor,'navyBlue')==0 || strcmp($labelThemeColor,'NavyBlue')==0){
        $labelThemeColor = "#000080";
    } else if(strcmp($labelThemeColor,'black')==0 || strcmp($labelThemeColor,'Black')==0){
        $labelThemeColor = "black";
        $textColor = "white";
    } else if(strcmp($labelThemeColor,'gold')==0 || strcmp($labelThemeColor,'Gold')==0){
        $labelThemeColor = "goldenrod";
    } else if(strcmp($labelThemeColor,'yellow')==0 || strcmp($labelThemeColor,'Yellow')==0){
        $themeColor = "yellow";
        $textColor = "black";
    } else {
        if(strpos($labelThemeColor,'#')===false && strcmp($labelThemeColor,'Yellow')!=0) {
            $labelThemeColor = "dark$labelThemeColor";
        }
    }

} else {
    $labelThemeColor = "#6796d3";
}

$isB2CUser = '';
if(isset($_SESSION['userID'])) {
    $userID = $_SESSION['userID'];
    $stm = $db->prepare("SELECT username,email,first_name,last_name,mobile,B2C_User FROM B2B_User WHERE b2b_user_id='$userID'");
    $stm->execute();
    $stm->bind_result($userName, $email, $firstName, $lastName, $mobile, $isB2CUser);
    while ($stm->fetch()) {}
    $stm->close();
}

if(strcmp($isB2CUser,"yes")==0 && $isB2C){$isB2CUser = true;}else{$isB2CUser = false;}

if(strcmp($anonymous,'no')==0) {
    if (!isset($_SESSION['customerID'])||$_SESSION['customerID']==0) {
        redirect("login.php");
    }
}
function redirect($url){
    if (headers_sent()) {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    } else {
        header('Location: ' . $url);
        die();
    }
}

if(!isset($_SESSION['customerID'])) {$_SESSION['customerID']=0;}
if(isset($_SESSION['orderID'])){$orderID=$_SESSION['orderID'];}

$customerID=$_SESSION['customerID'];
$itemID= $_POST['itemID'];


$stm = $db->prepare("SELECT recommended_retail_price,numeric_stock,show_non_stock_items FROM B2B_Page_Catalogue LIMIT 1");
$stm-> execute();
$stm-> bind_result($recommendedRetailPrice,$numericStock,$show_non_stock_items);
while ($stm->fetch()) {}
$stm-> close();

switch ("$show_non_stock_items") {
    case "no":
        $hideNonStockItems = true;
        $notAvailableNonStockItems = false;
        break;
    case 'notavailable':
        $hideNonStockItems = false;
        $notAvailableNonStockItems = true;
        break;
    default:
        $hideNonStockItems = false;
        $notAvailableNonStockItems = false;
}

$filteredItemsQueryFilter = '';
if($hideNonStockItems){
    $stm = $db->prepare("SELECT get_stock_from,stock_from_warehouse FROM B2B_Page_Catalogue LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($getStockFrom,$fromWarehouses);
    while ($stm->fetch()) {}
    $stm-> close();

    if(strcmp($getStockFrom,'both')==0){$getStockFrom = "available+reserved";}
    else if(strcmp($getStockFrom,'ignoreReserved')==0){$getStockFrom = "available";}
    else {$getStockFrom = 'available-reserved';}

    if(strcmp($fromWarehouses,'all')==0){$whFilter = "1=1";}
    else if(strcmp($fromWarehouses,'')==0){$whFilter = "1=1";}
    else {$whFilter = " warehouse_id IN($fromWarehouses) ";}

    $filteredItemsQueryFilter .= " AND Items.item_id IN (SELECT item_id FROM Stock WHERE $whFilter GROUP BY item_id HAVING SUM($getStockFrom) > 0 ) ";

}

$stm = $db->prepare("SELECT item_code,name,short_description,long_description,packing,item_sku,max_stock,vat_id,status,sellable,sales_units  FROM Items WHERE item_id = '$itemID' $filteredItemsQueryFilter LIMIT 1");
$stm-> execute();
$stm-> bind_result($itemCode,$itemName,$shortDescription,$longDescription,$packing,$sku,$maxStockOfItem,$vatID,$status,$b2bAvailable,$salesUnits);
while ($stm->fetch()) {
   $itemCodeString =$itemCode;
   $itemNameString =$itemName;

    $longDescription = str_replace("*NEW**NEW*","*NEW*",$longDescription);
    $longDescription = str_replace("*NEW*","<br>",$longDescription);
    $longDescription = str_replace('#newline#'."\n" ,'#newline#',$longDescription);
    $longDescription = str_replace('#newline#' ,'<br>',$longDescription);
    $longDescription = str_replace("\n" ,'<br>',$longDescription);

    $shortDescription = str_replace("*NEW**NEW*","*NEW*",$shortDescription);
    $shortDescription = str_replace("*NEW*","<br>",$shortDescription);
    $shortDescription = str_replace('#newline#'."\n" ,'#newline#',$shortDescription);
    $shortDescription = str_replace('#newline#' ,'<br>',$shortDescription);
    $shortDescription = str_replace("\n" ,'<br>',$shortDescription);

}
$stm-> close();

$stock = getStock($itemID);

if($notAvailableNonStockItems && $stock <= 0){
    $b2bAvailable = 'notavailable';
}

if(strcmp($status,'inactive')==0){
    $isInactive = true;
} else {
    $isInactive = false;
}
if(strcmp($b2bAvailable,'notavailable')==0){
    $isInactive = true;
    $nonStock = true;
} else if(strcmp($b2bAvailable,'nonstock')==0){
    $nonStock = true;
} else {
    $nonStock = false;
}


if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 && isset($shortDescription) && strcmp($shortDescription,'')!=0 ) {
    $itemNameString=$shortDescription;
}


$imagesArray = array();
$stm = $db->prepare("SELECT image_name,image_url FROM Item_Images WHERE item_id = '$itemID' ORDER BY image_order");
$stm-> execute();
$stm-> bind_result($imageName,$imageUrl);
while ($stm->fetch()) {
    $fullImageUrl = "//" . HTML_PATH . "/cop/media/productImages/$imageUrl.jpg";
    $rz = ROOT."/media/productImages/$imageUrl.jpg";

    if(!file_exists($rz)) {
        $fullImageUrl = "//" . HTML_PATH . "/cop/media/productImages/$imageUrl.png";
        $rz = ROOT."/media/productImages/$imageUrl.png";
    }
    if(file_exists($rz)) {
        array_push($imagesArray,$fullImageUrl);
    }

}
$stm-> close();

if(count($imagesArray)==0) {
    $fullImageUrl = "./assets/img/noimage.jpg";
    array_push($imagesArray,$fullImageUrl);
}


$stm = $db->prepare("SELECT barcode FROM Item_Barcode WHERE item_id = '$itemID'");
$stm-> execute();
$stm-> bind_result($barcode);
while ($stm->fetch()) {}
$stm-> close();


$qty = getQtyFromCart($orderID, $itemID);

$prices = getCalculatedPrices($fromB2BPriceList,$offerB2BPriceList,$fromB2CPriceList,$offerB2CPriceList,$isB2CUser,$customerID,$itemID,$qty);
$oldPrice = $prices->prevPrice;
$price = $prices->price;

if($showPricesWithVAT) {
    $vatPercentage = getVatPercentage($vatID);
    $priceWithVAT = floatval($price) + floatval($price*($vatPercentage/100));
    $priceWithVAT = number_format(floatval($priceWithVAT),2);

    $oldPriceWithVAT = floatval($oldPrice) + floatval($oldPrice*($vatPercentage/100));
    $oldPriceWithVAT = number_format(floatval($oldPriceWithVAT),2);

    $inc = $langu['incl_label'];
    $vat = $langu['vat_label'];
    $PriceWithVatText = "&nbsp;<span  style='font-size:17px;color: #0aa66e '>($currencySign$priceWithVAT &nbsp;$inc $vat)</span>";
    if($includeVatOnPrice){
        $PriceWithVatText='';
        $price= $priceWithVAT;
        $oldPrice = $oldPriceWithVAT;
    }
}

if($oldPrice > $price){
    $percentDiscount = round((1 - ($price/$oldPrice))*100);
} else if(isset($prevPrice) && $prevPrice > $price){
    $percentDiscount = round((1 - ($price/$prevPrice))*100);
} else {
    $percentDiscount = 0;
}

$oldPrice = number_format(floatval($oldPrice),2);
$price = number_format(floatval($price),2);

$showRecommendedRetailPrice = false;
if(isset($recommendedRetailPrice)&& $recommendedRetailPrice>0) {
    $recommendedRetailPriceDouble=getPriceFromPriceType($itemID,$recommendedRetailPrice);

    if($includeVatOnPrice) {
        $vat = floatval($recommendedRetailPriceDouble) * ($vatPercentage / 100);
        $recommendedRetailPriceDouble = floatval($recommendedRetailPriceDouble) + $vat;
    }

    $showRecommendedRetailPrice = true;
    $recommendedRetailPriceFormatted = number_format($recommendedRetailPriceDouble,2);

} else {
    $recommendedRetailPriceFormatted = number_format(0,2);
}


$stm = $db->prepare("SELECT custom_form_id,custom_form_code,custom_form_name FROM  ZA_Custom_Form_Definition,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Definition.custom_form_definition_id=ZA_Custom_Form_Usage.custom_form_id  AND linked_table='Items'");
$stm->execute();
$stm->bind_result($customFormID,$customFormCode,$customFormName);
while ($stm->fetch()) {

    $stm2 = $db2->prepare("SELECT ZA_Custom_Field_Definition.custom_field_id,custom_field_name,type,values_range,css_style,position,required,editable,class FROM  ZA_Custom_Field_Definition,ZA_Custom_Form_Custom_Field WHERE ZA_Custom_Field_Definition.custom_field_id=ZA_Custom_Form_Custom_Field.custom_field_id  AND ZA_Custom_Form_Custom_Field.custom_form_id='$customFormID' ORDER BY position");
    $stm2->execute();
    $stm2->bind_result($customFieldID,$customFieldName,$type,$valuesRange,$cssStyle,$position,$required,$editable,$class);
    while ($stm2->fetch()) {

       $formatter = getLastValueOfCustomForm($customFormID, $customFieldID, "Items", $itemID);

       $column['field'] = $customFieldName;
       $column['value'] = $formatter;

       array_push($columns,$column);
    }
    $stm2->close();

}
$stm->close();

if($packing==0) {
    $packing=1;
}
$variant=false;


$stm = $db->prepare("SELECT category_code FROM Categories,Category_Item WHERE Categories.category_id=Category_Item.category_id AND category_code LIKE 'L6%' AND item_id='$itemID' LIMIT 1 ");
$stm->execute();
$stm->bind_result($redirectCategoryCode);
while ($stm->fetch()) {}
$stm->close();

//if(isset($_COOKIE['currentCategory']) && $_COOKIE['currentCategory'] > 0 && false){
//    $categoryStatementCategoryFilter = ' WHERE Categories.category_id = '.$_COOKIE['currentCategory'];
//} else {
    $categoryStatementCategoryFilter = " WHERE category_id IN(SELECT category_id AS category_id FROM Category_Item WHERE item_id = '$itemID') AND (Categories.category_id IN (SELECT category_id FROM B2B_Categories) OR Categories.category_id IN(SELECT subcategory_id FROM Subcategories,B2B_Categories WHERE Subcategories.category_id=B2B_Categories.category_id))";
//}
$categoryStatement= "SELECT category_id,category_code,name,description FROM Categories $categoryStatementCategoryFilter";

$stm = $db->prepare($categoryStatement);
$stm-> execute();
$stm-> bind_result($categoryid,$categoryCode,$categoryName,$categoryDescription);
while ($stm->fetch()) {
    if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 &&isset($categoryDescription) && strcmp($categoryDescription,'')!=0 ) {
        $categoryName=$categoryDescription;
    }
    if(strcmp($redirectCategoryCode,$categoryCode)!=0){
        $_SESSION['cc'] = $categoryCode;
    }
}
$stm->close();

$brochures = array();
$stm = $db->prepare("SELECT brochure_name FROM Item_Brochures WHERE item_id='$itemID'");
$stm-> execute();
$stm-> bind_result($brochureName);
while ($stm->fetch()) {
    array_push($brochures,"../media/brochures/$brochureName");
}
$stm-> close();

$videos = array();
$stm = $db->prepare("SELECT video_url FROM Item_Videos WHERE item_id='$itemID'");
$stm-> execute();
$stm-> bind_result($videoName);
while ($stm->fetch()) {
    if(strpos($videoName,'youtu')!=false && strpos($videoName,'be')!=false){
        $videoID = substr($videoName, -11);
        $videoURL = "https://www.youtube.com/embed/".$videoID."?autoplay=1 ";
        array_push($videos,$videoURL);
    }else {
        $videoFile = "../media/productVideos/$videoName";
        array_push($videos,$videoFile);
    }
}
$stm-> close();

if(strcmp($redirectCategoryCode,'')!=0){
   $variant=true;
}

if(is_numeric(trim($longDescription))){$longDescription = '';}

$extraFields = array();
$extraFields['Packing'] = $salesUnits;

$productJson->itemCode=$itemCodeString;
$productJson->itemName=$itemNameString;
$productJson->useMaxStock=$useMaxStock;
$productJson->denyOrderOverStock=$denyOrderOverStock;
$productJson->showPrices=$showPrices;
$productJson->showPricesWithVAT=$showPricesWithVAT;
$productJson->includeVatOnPrice=$includeVatOnPrice;
$productJson->isB2C=$isB2C;
$productJson->usePackingOnItem=$usePackingOnItem;
$productJson->showAnonymousPrices=$showAnonymousPrices;
$productJson->allowAnonymousOrder=$allowAnonymousOrder;
$productJson->labelThemeColor=$labelThemeColor;
$productJson->recommendedRetailPrice=$recommendedRetailPriceFormatted;
$productJson->numericStock=$numericStock;
$productJson->shortDescription=$shortDescription;
$productJson->longDescription=$longDescription;
$productJson->packing=$packing;
$productJson->sku=$sku;
$productJson->maxStockOfItem=$maxStockOfItem;
$productJson->vatID=$vatID;
$productJson->status=$status;
$productJson->b2bAvailable=$b2bAvailable;
$productJson->imagesArray=$imagesArray;
$productJson->barcode=$barcode;
$productJson->oldPrice=$oldPrice;
$productJson->price=$price;
$productJson->qty=$qty;
$productJson->stock = $stock;
$productJson->percentDiscount=$percentDiscount;
$productJson->customFields=$columns;
$productJson->extraFields=$extraFields;
$productJson->variant=$variant;
$productJson->categoryID=$categoryid;
$productJson->brochures=$brochures;
$productJson->videos=$videos;
$productJson->isFavorite = isItemFavorite($itemID,$userID,$customerID);
$productJson->contractPricing = getContractPricesPerQty($itemID,$customerID, $userID, $vatPercentage, $includeVatOnPrice);

echo json_encode($productJson);


function getCalculatedPrices($fromB2BPriceList,$offerB2BPriceList,$fromB2CPriceList,$offerB2CPriceList,$isB2C,$customerID,$itemID,$qty){

    $prevPrice = 0;
    $price = 0;

    if (isset($fromB2BPriceList) && $fromB2BPriceList > 0 && !$isB2C) {
        $b2bPrice = getDefaultPriceFromPriceType($itemID, $customerID, $fromB2BPriceList, $isB2C, $qty);
    }

    if (isset($offerB2BPriceList) && $offerB2BPriceList > 0 && !$isB2C) {
        $offerB2bPrice = getDefaultPriceFromPriceType($itemID, $customerID, $offerB2BPriceList, $isB2C, $qty);
    }

    if (isset($fromB2CPriceList) && $fromB2CPriceList > 0 && $isB2C) {
        $b2cPrice = getDefaultPriceFromPriceType($itemID, $customerID, $fromB2CPriceList, $isB2C, $qty);
    }

    if (isset($offerB2CPriceList) && $offerB2CPriceList > 0 && $isB2C) {
        $offerB2cPrice = getDefaultPriceFromPriceType($itemID, $customerID, $offerB2CPriceList, $isB2C, $qty);
    }

    if (isset($b2bPrice) && $b2bPrice > 0) {
        $price = $b2bPrice;
    } else if (isset($b2cPrice) && $b2cPrice > 0) {
        $price = $b2cPrice;
    } else {
        $price = getDefaultPrice($itemID, $customerID, '', $qty);
    }

    if (isset($offerB2BPriceList) && $offerB2BPriceList > 0 && !$isB2C) {
        $offerPrice = $offerB2bPrice;
    } else if (isset($offerB2CPriceList) && $offerB2CPriceList > 0 && $isB2C) {
        $offerPrice = $offerB2cPrice;
    } else {
        $offerPrice = $price;
    }

    if ($offerPrice < $price && $offerPrice > 0) {
        $prevPrice = $price;
        $price = $offerPrice;
    } else {
        $defaultPrice = getDefaultPriceFromDefaultPriceType($itemID);
        if ($defaultPrice > $price && $defaultPrice > 0 && !$isB2C) {
            $prevPrice = $defaultPrice;
        }
    }

    $pricingObject = new stdClass();
    $pricingObject->price = $price;
    $pricingObject->prevPrice = $prevPrice;
    return $pricingObject;
}


function getContractPricesPerQty($itemID,$customerID, $userID, $vatPercentage, $includeVatOnPrice){

    $pricingArray = array();

    if(isset($userID) && $userID > 0){
        $singlePrice = getDefaultPriceInclPriceTypes($itemID,$customerID,false,1);
    } else {
        $singlePrice = getDefaultPriceInclPriceTypes($itemID,$customerID,true,1);
    }

    if($includeVatOnPrice){
        $singlePrice = floatval($singlePrice) + floatval($singlePrice*($vatPercentage/100));
    }

    $singlePrice = number_format(floatval($singlePrice), 2);

    global $username,$password,$database;
    $db2 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");


    $stm2 = $db2->prepare("SELECT min_qty,price FROM ContractPrices WHERE item_id = ? AND (customer_id = ? OR customer_id = 1) AND DATE(valid_from) <= DATE(NOW()) AND DATE(valid_until) >= DATE(NOW()) AND min_qty > 1 ORDER BY min_qty ASC");
    $stm2->bind_param('ii', $itemID,$customerID);
    $stm2-> execute();
    $stm2-> bind_result($minQty,$price);
    while ($stm2->fetch()) {

        if($price > 0) {
            $price = $price / getPriceRate();

            if($includeVatOnPrice){
                $price = floatval($price) + floatval($price*($vatPercentage/100));
            }

            $price = number_format(floatval($price), 2);

            $pricingObject = new stdClass();
            $pricingObject->qty = $minQty;
            $pricingObject->price = $price;
            array_push($pricingArray,$pricingObject);
        }
    }
    $stm2-> close();

    if(count($pricingArray)>0){

        $pricingObject = new stdClass();
        $pricingObject->qty = 1;
        $pricingObject->price = $singlePrice;
        array_push($pricingArray,$pricingObject);

        usort($pricingArray, function($a, $b) {
            return $a->qty - $b->qty;
        });

    }
    return $pricingArray;
}
?>

