<?php
session_start();
include_once("../../param.php");
require("dbhelper.php");
$orderID=$_SESSION['orderID'];
$customerID=$_SESSION['customerID'];
$categoryID = $_POST['category'];
$relatedItemID = $_POST['relatedItem'];
$currencySign = getCurrencySign();
if(!isset($_SESSION['lang']))
{
    $_SESSION['lang'] = 'en';
}
include_once('../langs/'.$_SESSION['lang'].'.php');

$relatedItemFilter = "";
if(strcmp("$relatedItemID",'')!=0 && $relatedItemID > 0){
    $relatedItemFilter = "AND NOT Items.item_id ='$relatedItemID' ";
}


$result="";

$showPrices=true;
$showPricesWithVAT=false;
$includeVatOnPrice=false;
$usePackingOnItem=false;
global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

function make_greeklish($text) {
    $expressions = array(
        '/[αΑ][ιίΙΊ]/u' => 'e',
        '/[οΟΕε][ιίΙΊ]/u' => 'i',
        '/[αΑ][υύΥΎ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/u' => 'af$1',
        '/[αΑ][υύΥΎ]/u' => 'av',
        '/[εΕ][υύΥΎ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/u' => 'ef$1',
        '/[εΕ][υύΥΎ]/u' => 'ev',
        '/[οΟ][υύΥΎ]/u' => 'ou',
        '/(^|\s)[μΜ][πΠ]/u' => '$1b',
        '/[μΜ][πΠ](\s|$)/u' => 'b$1',
        '/[μΜ][πΠ]/u' => 'mp',
        '/[νΝ][τΤ]/u' => 'nt',
        '/[τΤ][σΣ]/u' => 'ts',
        '/[τΤ][ζΖ]/u' => 'tz',
        '/[γΓ][γΓ]/u' => 'ng',
        '/[γΓ][κΚ]/u' => 'gk',
        '/[ηΗ][υΥ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/u' => 'if$1',
        '/[ηΗ][υΥ]/u' => 'iu',
        '/[θΘ]/u' => 'th',
        '/[χΧ]/u' => 'ch',
        '/[ψΨ]/u' => 'ps',
        '/[αά]/u' => 'a',
        '/[βΒ]/u' => 'v',
        '/[γΓ]/u' => 'g',
        '/[δΔ]/u' => 'd',
        '/[εέΕΈ]/u' => 'e',
        '/[ζΖ]/u' => 'z',
        '/[ηήΗΉ]/u' => 'i',
        '/[ιίϊΙΊΪ]/u' => 'i',
        '/[κΚ]/u' => 'k',
        '/[λΛ]/u' => 'l',
        '/[μΜ]/u' => 'm',
        '/[νΝ]/u' => 'n',
        '/[ξΞ]/u' => 'x',
        '/[οόΟΌ]/u' => 'o',
        '/[πΠ]/u' => 'p',
        '/[ρΡ]/u' => 'r',
        '/[σςΣ]/u' => 's',
        '/[τΤ]/u' => 't',
        '/[υύϋΥΎΫ]/u' => 'i',
        '/[φΦ]/iu' => 'f',
        '/[ωώ]/iu' => 'o',
    );

    $text = preg_replace( array_keys($expressions), array_values($expressions), $text);
    return $text;
}

function transliterateString($txt) {
    $transliterationTable = array('á' => 'a', 'Á' => 'A', 'à' => 'a', 'À' => 'A', 'ă' => 'a', 'Ă' => 'A', 'â' => 'a', 'Â' => 'A', 'å' => 'a', 'Å' => 'A', 'ã' => 'a', 'Ã' => 'A', 'ą' => 'a', 'Ą' => 'A', 'ā' => 'a', 'Ā' => 'A', 'ä' => 'ae', 'Ä' => 'AE', 'æ' => 'ae', 'Æ' => 'AE', 'ḃ' => 'b', 'Ḃ' => 'B', 'ć' => 'c', 'Ć' => 'C', 'ĉ' => 'c', 'Ĉ' => 'C', 'č' => 'c', 'Č' => 'C', 'ċ' => 'c', 'Ċ' => 'C', 'ç' => 'c', 'Ç' => 'C', 'ď' => 'd', 'Ď' => 'D', 'ḋ' => 'd', 'Ḋ' => 'D', 'đ' => 'd', 'Đ' => 'D', 'ð' => 'dh', 'Ð' => 'Dh', 'é' => 'e', 'É' => 'E', 'è' => 'e', 'È' => 'E', 'ĕ' => 'e', 'Ĕ' => 'E', 'ê' => 'e', 'Ê' => 'E', 'ě' => 'e', 'Ě' => 'E', 'ë' => 'e', 'Ë' => 'E', 'ė' => 'e', 'Ė' => 'E', 'ę' => 'e', 'Ę' => 'E', 'ē' => 'e', 'Ē' => 'E', 'ḟ' => 'f', 'Ḟ' => 'F', 'ƒ' => 'f', 'Ƒ' => 'F', 'ğ' => 'g', 'Ğ' => 'G', 'ĝ' => 'g', 'Ĝ' => 'G', 'ġ' => 'g', 'Ġ' => 'G', 'ģ' => 'g', 'Ģ' => 'G', 'ĥ' => 'h', 'Ĥ' => 'H', 'ħ' => 'h', 'Ħ' => 'H', 'í' => 'i', 'Í' => 'I', 'ì' => 'i', 'Ì' => 'I', 'î' => 'i', 'Î' => 'I', 'ï' => 'i', 'Ï' => 'I', 'ĩ' => 'i', 'Ĩ' => 'I', 'į' => 'i', 'Į' => 'I', 'ī' => 'i', 'Ī' => 'I', 'ĵ' => 'j', 'Ĵ' => 'J', 'ķ' => 'k', 'Ķ' => 'K', 'ĺ' => 'l', 'Ĺ' => 'L', 'ľ' => 'l', 'Ľ' => 'L', 'ļ' => 'l', 'Ļ' => 'L', 'ł' => 'l', 'Ł' => 'L', 'ṁ' => 'm', 'Ṁ' => 'M', 'ń' => 'n', 'Ń' => 'N', 'ň' => 'n', 'Ň' => 'N', 'ñ' => 'n', 'Ñ' => 'N', 'ņ' => 'n', 'Ņ' => 'N', 'ó' => 'o', 'Ó' => 'O', 'ò' => 'o', 'Ò' => 'O', 'ô' => 'o', 'Ô' => 'O', 'ő' => 'o', 'Ő' => 'O', 'õ' => 'o', 'Õ' => 'O', 'ø' => 'oe', 'Ø' => 'OE', 'ō' => 'o', 'Ō' => 'O', 'ơ' => 'o', 'Ơ' => 'O', 'ö' => 'oe', 'Ö' => 'OE', 'ṗ' => 'p', 'Ṗ' => 'P', 'ŕ' => 'r', 'Ŕ' => 'R', 'ř' => 'r', 'Ř' => 'R', 'ŗ' => 'r', 'Ŗ' => 'R', 'ś' => 's', 'Ś' => 'S', 'ŝ' => 's', 'Ŝ' => 'S', 'š' => 's', 'Š' => 'S', 'ṡ' => 's', 'Ṡ' => 'S', 'ş' => 's', 'Ş' => 'S', 'ș' => 's', 'Ș' => 'S', 'ß' => 'SS', 'ť' => 't', 'Ť' => 'T', 'ṫ' => 't', 'Ṫ' => 'T', 'ţ' => 't', 'Ţ' => 'T', 'ț' => 't', 'Ț' => 'T', 'ŧ' => 't', 'Ŧ' => 'T', 'ú' => 'u', 'Ú' => 'U', 'ù' => 'u', 'Ù' => 'U', 'ŭ' => 'u', 'Ŭ' => 'U', 'û' => 'u', 'Û' => 'U', 'ů' => 'u', 'Ů' => 'U', 'ű' => 'u', 'Ű' => 'U', 'ũ' => 'u', 'Ũ' => 'U', 'ų' => 'u', 'Ų' => 'U', 'ū' => 'u', 'Ū' => 'U', 'ư' => 'u', 'Ư' => 'U', 'ü' => 'ue', 'Ü' => 'UE', 'ẃ' => 'w', 'Ẃ' => 'W', 'ẁ' => 'w', 'Ẁ' => 'W', 'ŵ' => 'w', 'Ŵ' => 'W', 'ẅ' => 'w', 'Ẅ' => 'W', 'ý' => 'y', 'Ý' => 'Y', 'ỳ' => 'y', 'Ỳ' => 'Y', 'ŷ' => 'y', 'Ŷ' => 'Y', 'ÿ' => 'y', 'Ÿ' => 'Y', 'ź' => 'z', 'Ź' => 'Z', 'ž' => 'z', 'Ž' => 'Z', 'ż' => 'z', 'Ż' => 'Z', 'þ' => 'th', 'Þ' => 'Th', 'µ' => 'u', 'а' => 'a', 'А' => 'a', 'б' => 'b', 'Б' => 'b', 'в' => 'v', 'В' => 'v', 'г' => 'g', 'Г' => 'g', 'д' => 'd', 'Д' => 'd', 'е' => 'e', 'Е' => 'E', 'ё' => 'e', 'Ё' => 'E', 'ж' => 'zh', 'Ж' => 'zh', 'з' => 'z', 'З' => 'z', 'и' => 'i', 'И' => 'i', 'й' => 'j', 'Й' => 'j', 'к' => 'k', 'К' => 'k', 'л' => 'l', 'Л' => 'l', 'м' => 'm', 'М' => 'm', 'н' => 'n', 'Н' => 'n', 'о' => 'o', 'О' => 'o', 'п' => 'p', 'П' => 'p', 'р' => 'r', 'Р' => 'r', 'с' => 's', 'С' => 's', 'т' => 't', 'Т' => 't', 'у' => 'u', 'У' => 'u', 'ф' => 'f', 'Ф' => 'f', 'х' => 'h', 'Х' => 'h', 'ц' => 'c', 'Ц' => 'c', 'ч' => 'ch', 'Ч' => 'ch', 'ш' => 'sh', 'Ш' => 'sh', 'щ' => 'sch', 'Щ' => 'sch', 'ъ' => '', 'Ъ' => '', 'ы' => 'y', 'Ы' => 'y', 'ь' => '', 'Ь' => '', 'э' => 'e', 'Э' => 'e', 'ю' => 'ju', 'Ю' => 'ju', 'я' => 'ja', 'Я' => 'ja');
    return str_replace(array_keys($transliterationTable), array_values($transliterationTable), $txt);
}

$categoryPathURL = '';
if($categoryID >0){
    $stm = $db->prepare("SELECT name FROM Categories WHERE category_id=? LIMIT 1");
    $stm->bind_param('i', $categoryID);
    $stm->execute();
    $stm->bind_result($categoryName);
    while ($stm->fetch()) {
        $categoryName = make_greeklish($categoryName);
        $categoryName = transliterateString($categoryName);
        $categoryName = str_replace(' ','-',strtolower($categoryName));
        $categoryName = str_replace('&','and',$categoryName);
        $categoryName = preg_replace('/[^A-Za-z0-9\-]/', '', $categoryName);


        $categoryPathURL = "$categoryName/";
    }
    $stm->close();

}

$stm = $db->prepare("SELECT show_non_stock_items FROM B2B_Page_Catalogue LIMIT 1");
$stm-> execute();
$stm-> bind_result($show_non_stock_items);
while ($stm->fetch()) {}
$stm-> close();

$nonStockItemsQueryFilter = "";
if(strcmp("$show_non_stock_items","no")==0){
    $stm = $db->prepare("SELECT get_stock_from,stock_from_warehouse FROM B2B_Page_Catalogue LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($getStockFrom,$fromWarehouses);
    while ($stm->fetch()) {}
    $stm-> close();

    if(strcmp($getStockFrom,'both')==0){$getStockFrom = "available+reserved";}
    else if(strcmp($getStockFrom,'ignoreReserved')==0){$getStockFrom = "available";}
    else {$getStockFrom = 'available-reserved';}

    if(strcmp($fromWarehouses,'all')==0){$whFilter = "1=1";}
    else if(strcmp($fromWarehouses,'')==0){$whFilter = "1=1";}
    else {$whFilter = " warehouse_id IN($fromWarehouses) ";}

    $nonStockItemsQueryFilter .= " AND Items.item_id IN (SELECT item_id FROM Stock WHERE $whFilter GROUP BY item_id HAVING SUM($getStockFrom) > 0 ) ";

}

$stm = $db->prepare("SELECT related_item_id FROM Related_Items WHERE item_id='$relatedItemID' ORDER BY related_item_id DESC LIMIT 1");
$stm-> execute();
$stm-> bind_result($relatedTableCheck);
while ($stm->fetch()) {}
$stm-> close();

if($relatedTableCheck > 0){

    $categoriesImplode = implode(',',getB2BCategories($db));

    if (strcmp($categoriesImplode,'')!=0) {

        $restriction = "AND Items.item_id IN(SELECT DISTINCT(item_id) FROM Category_Item WHERE Category_Item.category_id IN ($categoriesImplode) )";
    } else {
        $restriction = " AND 0=1 ";
    }

    $statement = "SELECT Items.item_id,item_code,name,short_description,vat_id,packing,sellable FROM Items,Related_Items WHERE Items.item_id=Related_Items.related_item_id AND Related_Items.item_id='$relatedItemID' AND NOT status ='inactive' AND sellable='yes' $relatedItemFilter $restriction $nonStockItemsQueryFilter ORDER BY Related_Items.position LIMIT 10";
} else {
    $statement = "SELECT item_id,item_code,name,short_description,vat_id,packing,sellable FROM Items WHERE item_id IN (SELECT item_id AS item_id FROM Category_Item WHERE category_id='$categoryID' AND category_id > 0) AND NOT status ='inactive' AND sellable='yes' $relatedItemFilter $nonStockItemsQueryFilter LIMIT 10";
}

$addWatermark = false;
$stm = $db->prepare("SELECT watermark_id,file_url,position,opacity FROM B2B_Image_Watermark WHERE watermark_id=1 AND active='yes'");
$stm-> execute();
$stm-> bind_result($watermarkID,$watermarkURL,$watermarkPosition,$watermarkOpacity);
while ($stm->fetch()) {
    if($watermarkID > 0){$addWatermark = true;}
}
$stm->close();

$stm = $db->prepare("SELECT primary_language,show_prices,show_prices_with_vat,use_packing,logo_link,theme FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($primaryLanguage,$showPrices,$showPricesIncludingVAT,$usePacking,$logoLink,$themeColor);

while ($stm->fetch()) {
    if(strcmp($usePacking,"yes")==0){
        $usePackingOnItem = true;
    }
    if(strcmp($showPrices,"no")==0 || $_SESSION['showPrices']==false)
    {
        $showPrices=false;
    }
    if(strcmp($showPricesIncludingVAT,"yes")==0 || strcmp($showPricesIncludingVAT,"both")==0)
    {
        $showPricesWithVAT=true;
        if(strcmp($showPricesIncludingVAT,"yes")==0){
            $includeVatOnPrice = true;
        }
    }
}
$stm-> close();

switch (strtolower("$themeColor")){
    case '':
        $themeColor = "#6796d3";
        break;
    case 'red':
        $themeColor = "firebrick";
        break;
    case 'darkslateblue':
        $themeColor = "#1d4f9c";
        break;
    case 'navyblue':
        $themeColor = "#000080";
        break;
    case 'black':
        $themeColor = "black";
        break;
    case 'gold':
        $themeColor = "goldenrod";
        break;
    case 'yellow':
        $themeColor = "yellow";
        break;
    default:
        if(strpos($themeColor,'#')===false) {
            $themeColor = str_replace('darkdark','dark',"dark$themeColor");
        } else {
            $themeColor = strtolower($themeColor);
        }
}

$stm = $db->prepare("SELECT SUM(qty) FROM Online_Order_Item WHERE order_id='$orderID'");
$stm-> execute();
$stm-> bind_result($count);

while ($stm->fetch()) {
  //  $result.="<input id='cartCounter' value='$count Item(s)' type='hidden'/>";
}
$stm-> close();

$stm = $db->prepare("$statement");
$stm-> execute();
$stm-> bind_result($itemID,$itemCode,$name,$shortDescription,$vatID,$packing,$b2bAvailable);
$i = 0;
$userID = $_SESSION['userID'];
while ($stm->fetch()) {
    $i++;
    $itemCodeUrl = urlencode(str_replace('/','--CP2F--',$itemCode));
    $imageUrl = getDefaultImage($itemID);
    $qty = getQtyFromCart($orderID, $itemID);
//    $price = getDefaultPrice($itemID,$customerID,'',$qty);
    if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 && isset($shortDescription) && strcmp($shortDescription,'')!=0 )
    {
        $name=$shortDescription;
    }

    if($customerID > 0) {
        $name = getCustomerSynonym($customerID,$itemID,'name',$name);
        $itemCode = getCustomerSynonym($customerID,$itemID,'code',$itemCode);
    }

    if(isset($userID) && $userID > 0){
        $price = getDefaultPriceInclPriceTypes($itemID,$customerID);
    } else {
        $price = getDefaultPriceInclPriceTypes($itemID,$customerID,true);
    }

    $stock = getStock($itemID);

    if(strcmp("$show_non_stock_items","no")==0 && $stock <= 0){
        $b2bAvailable = 'notavailable';
    }

    if(strcmp("$show_non_stock_items","notavailable")==0 && $stock <= 0){
        $b2bAvailable = 'notavailable';
    }

    if(strcmp($b2bAvailable,'notavailable')==0){
        $notCurrentlyAvailable = $langu['not_available_label'];
        $name ="<span style='color:firebrick;font-size: 14px;'>$notCurrentlyAvailable</span><br>$name";
        $grayImage = "filter: gray; -webkit-filter: grayscale(1); filter: grayscale(1); ";
        $grayBox = '#fafafa';
        $disabledButton = 'disabled readonly';
        $hidePlusMinus = "display:none;";
        $hideButtons = "display:none;";
        $stock = 0;
    } else if(strcmp($b2bAvailable,'nonstock')==0){
        $grayImage = '';
        $grayBox = '#ffffff';
        $disabledButton = '';
        $hidePlusMinus = "border-radius:3px;padding:12px;width:40px !important;height:41px !important;font-weight:bolder;color:$themeColor;margin:0px;' onMouseOver=\"this.style.background='$themeColor';this.style.color='white'\"  onMouseOut=\"this.style.background='';this.style.color='$themeColor'\" '";
        $hideButtons = "";
        $stock = 0;
    } else {
        $grayImage = '';
        $grayBox = '#ffffff';
        $disabledButton = '';
        $hideButtons = "";
        $hidePlusMinus = "border-radius:3px;padding:12px;width:40px !important;height:41px !important;font-weight:bolder;color:$themeColor;' onMouseOver=\"this.style.background='$themeColor';this.style.color='white'\"  onMouseOut=\"this.style.background='';this.style.color='$themeColor'\" '";
    }



    if($showPrices)
    {
        if($showPricesWithVAT){

            $inc = $langu['incl_label'];
            $vat = $langu['vat_label'];
            $PriceWithVatText = "";

            $displayunitPriceIncVat= "<br><span  style='font-size: 11px;color: #0aa66e;text-align: right;'>$currencySign".number_format((float)$price + (float)$price*getVatPercentage($vatID)/100,2)." &nbsp;$inc $vat</span>";

            if($includeVatOnPrice){
                $displayunitPriceIncVat='';
                $price= number_format((float)$price+(float)$price*getVatPercentage($vatID)/100,2);
            }
        }
        $price = number_format(floatval($price),2);
        $pricing="$currencySign".$price;
    }
    else
    {
        $pricing="";
    }
    if($usePackingOnItem){
        $packingAttribute= "data-value='$packing'";
        $packingAttributeItem= "data-packing='$packing'";
    } else {
        $packingAttributeItem='';
        $packingAttribute='';
    }

    if($addWatermark) {

        if(strcmp($watermarkURL,'')==0){$watermarkURL = $logoLink;};
        if(strcmp($watermarkPosition,'')==0){$watermarkPosition = 'center';}
        if(strcmp($watermarkOpacity,'')==0){$watermarkOpacity = '0.5';}
        if(strcmp($imageUrl,'./assets/img/noimage.jpg')!=0) {
            $watermarks .= "
            watermark(['$imageUrl','$watermarkURL'])
            .image(watermark.image.$watermarkPosition($watermarkOpacity))
            .then(function (img) {
                img.id = 'watermark-img-r-$itemID';
                img.style.cssText = document.getElementById('media-link-img-r-$itemID').style.cssText;
                document.getElementById('media-link-img-r-$itemID').remove();
                document.getElementById('media-link-r-$itemID').appendChild(img);
                delete document.getElementById('media-link-r-$itemID').dataset.featherlight;
                document.getElementById('media-link-r-$itemID').href = './products/$categoryPathURL$itemCodeUrl';

    
            });
    
            ";
        }

        $imageUrl = './assets/img/noimage.jpg';
        $prettyPhoto = "";
    } else {
        $prettyPhoto = "data-gal='prettyPhoto' rel='prettyPhoto'";
    }
    
        $result = $result . " <div class='thumbnail no-border no-padding'>
                                    <div class='media' style='height:300px;'>
                                        <a class='media-link' href='$imageUrl' id='media-link-r-$itemID' $prettyPhoto>
                                            <img src='$imageUrl' id='media-link-img-r-$itemID' alt='' style='max-height:250px;width:auto;vertical-align: middle;$grayImage'/>
                                            <span class='icon-view'>
                                                <strong><i class='fa fa-eye'></i></strong>
                                            </span>
                                        </a>
                                    </div>
                                    <div class='caption text-center'>
                                        <a href='./products/$categoryPathURL$itemCodeUrl'> <h4 style='white-space:nowrap;font-size:14px;color:#000;font-weight:400;' class='pointer productCode caption-title' data-value='$itemID' data-product='$itemCodeUrl' data-category='$categoryPathURL'>$name</h4></a>

                                        <div class='price'><ins>$pricing $displayunitPriceIncVat </ins></div>
                                        <div class='buttons'>";
    if($customerID!=0){
        $result = $result . "       <center>
                                        <div class='buttons' style='border: 1px solid $themeColor;border-radius:3px;width: fit-content !important;white-space: nowrap !important;$hideButtons'>
                                            <a class='minusButton pull-left btn' style='$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-minus'></i></a>
                                            <input type='text' value='$qty' data-value='$itemID' $packingAttributeItem class='productQtyInput form-control' style='display:inline;width:50px;height:40px;text-align:center;border-color: transparent;padding: 0;' $disabledButton />
                                            <a  class='plusButton pull-right btn' style='$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-plus'></i></a>
                                        </div>
                                    </center>
                                        ";
    } else {
        $result = $result . "              <a class='btn btn-theme' style='' href='products/".$categoryPathURL.$itemCodeUrl."'>View More</a>";

    }
        $result = $result . "            </div>
                                    </div>
                                </div>";



}
$stm-> close();

if($addWatermark) {
    $result .= "<!--watermarks-->
    <script type='text/javascript'>
        $watermarks
    </script>

    ";
}

echo $result;


function getB2BCategories($db){

    $categoriesArray = array();
    $counterOfCategories = 0;
    $categoryID = 0;

    if(isset($_SESSION['userID'])) {
        $user=$_SESSION['userID'];
        $stm = $db->prepare("SELECT COUNT(*) FROM B2B_Allow_Categories_User WHERE b2b_user_id='$user'");
        $stm-> execute();
        $stm-> bind_result($counterOfCategories);
        while ($stm->fetch()) {}
        $stm-> close();
        if($counterOfCategories>0)
        {
            $query="SELECT Categories.category_id FROM Categories INNER JOIN B2B_Allow_Categories_User ON(Categories.category_id=B2B_Allow_Categories_User.category_id) LEFT JOIN B2B_Categories ON (Categories.category_id=B2B_Categories.category_id) WHERE b2b_user_id='$user' ORDER BY B2B_Categories.position,category_code";
        } else {
            $query="SELECT Categories.category_id FROM Categories,B2B_Categories WHERE Categories.category_id=B2B_Categories.category_id ORDER BY B2B_Categories.position,category_code";
        }
    } else {
        $query="SELECT Categories.category_id FROM Categories,B2B_Categories WHERE Categories.category_id=B2B_Categories.category_id AND Categories.category_id > 100 ORDER BY B2B_Categories.position,category_code";
    }

    $stm = $db->prepare($query);
    $stm-> execute();
    $stm-> bind_result($categoryID);
    while ($stm->fetch()) {
        $categoriesArray = array_unique(array_merge($categoriesArray,getSubCategories($categoryID,$categoriesArray)));
    }
    $stm->close();

    return $categoriesArray;
}

function getSubCategories($categoryID,$categoriesArray){

    if(!in_array($categoryID,$categoriesArray)){
        array_push($categoriesArray,$categoryID);
    }

    global $username,$password,$database;
    $db2 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT Categories.category_id FROM Categories,Subcategories WHERE  Subcategories.category_id =\"$categoryID\" AND Categories.category_id=Subcategories.subcategory_id ");
    $stm2-> execute();
    $stm2-> bind_result($subCategoryID);
    while ($stm2->fetch()) {
        if(!in_array($subCategoryID,$categoriesArray)){
            array_push($categoriesArray,$subCategoryID);
            $categoriesArray = array_unique(array_merge($categoriesArray,getSubCategories($subCategoryID,$categoriesArray)));
        }
    }
    $stm2-> close();

    return $categoriesArray;

}
?>