<?php
include_once("../../param.php");
require("dbhelper.php");

session_start();
$selectedDate = $_POST['postDate'];
$customerID = $_SESSION['customerID'];
$linkedSchedules = $_POST['linkedSchedules'];

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");


$holidays = array();
$stm = $db->prepare("SELECT date FROM B2B_Scheduled_Holidays WHERE date >= DATE(NOW()) ORDER BY date ASC");
$stm-> execute();
$stm-> bind_result($holidayDate);
while ($stm->fetch()) {
    array_push($holidays, $holidayDate);
}
$stm-> close();

if(strcmp("$linkedSchedules","yes") == 0) {
    $daysAfterObject = calculateNextScheduleDate($db, $selectedDate, $customerID, 0);
    $daysAfter = $daysAfterObject->daysAfter;
    $calculatedDate = $daysAfterObject->date;

    foreach ($holidays as $holiday) {
        if ($holiday == $calculatedDate) {
            $nextDate = date('Y-m-d', strtotime($calculatedDate . ' +1 days'));
            $daysAfterObject = calculateNextScheduleDate($db, $nextDate, $customerID, $daysAfter);
            $calculatedDate = $daysAfterObject->date;
        }
    }

    $daysAfter = calculateDaysBetweenDates($selectedDate, $calculatedDate);

} else {
    $daysAfter = 0;
    foreach ($holidays as $holiday) {
        $calculatedDate = date('Y-m-d', strtotime($selectedDate . " +$daysAfter days"));
        if ($holiday == $calculatedDate) {$daysAfter++;}
    }
}

echo $daysAfter;

function calculateNextScheduleDate($db,$selectedDate,$customerID,$daysAfterFinal = 0){


    $stm = $db->prepare("SELECT distinct(Schedules.schedule_id),type,date,repeat_period,day,week,month FROM Schedules,Schedule_Customer WHERE Schedule_Customer.schedule_id=Schedules.schedule_id AND customer_id='$customerID' AND type='Custom' AND week=0 AND month=0  ");
    $stm-> execute();
    $stm-> bind_result($schedule_id,$type,$date,$repeatPeriod,$day,$week,$month);
    while ($stm->fetch()) {


        $requested_day = date('N', strtotime($selectedDate));

        if($day >= $requested_day){
            $daysAfter = $day - $requested_day;
        } else {
            $daysAfter =7-$requested_day+$day;
        }

        if($daysAfter == 0){
            $daysAfterFinal = $daysAfter;
        }
        if($daysAfterFinal > $daysAfter || $daysAfterFinal == 0){
            $daysAfterFinal = $daysAfter;
        }


    }
    $stm-> close();

    $object = new stdClass();
    $object->daysAfter = $daysAfterFinal;
    $object->date = date('Y-m-d', strtotime($selectedDate. ' + '.$daysAfterFinal.' days'));
    return $object;
}
function getWeeks($date, $rollover)
{
    $cut = substr($date, 0, 8);
    $daylen = 86400;

    $timestamp = strtotime($date);
    $first = strtotime($cut . "00");
    $elapsed = ($timestamp - $first) / $daylen;

    $weeks = 1;

    for ($i = 1; $i <= $elapsed; $i++)
    {
        $dayfind = $cut . (strlen($i) < 2 ? '0' . $i : $i);
        $daytimestamp = strtotime($dayfind);

        $day = strtolower(date("l", $daytimestamp));

        if($day == strtolower($rollover))  $weeks ++;
    }

    return $weeks;
}

function calculateDaysBetweenDates($date1,$date2){
    $date1 = strtotime($date1);
    $date2 = strtotime($date2);
    $diff = $date2 - $date1;
    return floor($diff/(60*60*24));
}