<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);
session_start();
include_once("../../param.php");
require_once("dbhelper.php");
require_once("../assets/mobiledetect/Mobile_Detect.php");

if(!isset($_SESSION['lang'])) {$_SESSION['lang'] = 'en';}
include_once('../langs/'.$_SESSION['lang'].'.php');

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$db2 = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db2->set_charset("utf8");

$currencySign = getCurrencySign();
$userID = $_SESSION['userID'] ;
$orderID = $_SESSION['orderID'];
$customerID = $_SESSION['customerID'];
$subunitsForce = $_SESSION['subunitsForce'];

$pageNumber = $_POST['pageNumber'];
$numOfItemsInPage = $_POST['numItemsInPage'];
$offset = ($pageNumber-1)*$numOfItemsInPage;

$extraCredit = false;


$stm = $db->prepare("SELECT product_code_to_show,use_packing,primary_language,show_prices,use_max_stock_on_item,allow_order_over_stock,max_stock_limit,show_prices_with_vat,show_prices_anonymous,b2b_price_list,b2c_price_list,b2b_offer_price_list,b2c_offer_price_list,anonymous_order,use_as_b2c,theme,css_theme,logo_link,show_discount_bubble FROM B2B_Configuration LIMIT 1");
$stm-> execute();
$stm-> bind_result($productShow,$usePacking,$primaryLanguage,$showPrices,$useMaxStock,$allowOrderOverStock,$maxStockLimit,$showPricesIncludingVAT,$showB2BAnonymousPrices,$fromB2BPriceList,$fromB2CPriceList,$offerB2BPriceList,$offerB2CPriceList,$anonymousOrder,$useAsB2C,$themeColor,$cssTheme,$logoLink,$show_discount_bubble);
while ($stm->fetch()) {}
$stm-> close();

$stm = $db->prepare("SELECT recommended_retail_price,numeric_stock,promotion_everywhere,sub_categories_with_items,stock_warning_qty,show_add_to_cart_button,sort_items_by,include_subcategory_products,popular_products_from,show_non_stock_items,allow_user_favorites,allow_product_history FROM B2B_Page_Catalogue LIMIT 1");
$stm-> execute();
$stm-> bind_result($recommendedRetailPrice,$numericStock,$promotionsEveryWhere,$sub_categories_with_items,$stockWarningQty,$showAddToCartButton,$orderBySelection,$includeSubcategoryProducts,$popularItemsSelection,$show_non_stock_items,$allowUserFavorites,$allowOrderProductHistory);
while ($stm->fetch()) {}
$stm-> close();

$detect = new Mobile_Detect;
if($detect->isMobile()) {
    $gridPreference = "mobile";
    $isMobile = true;
} else if($detect->isTablet()) {
    $gridPreference = "tablet";
    $isMobile = false;
} else {
    $isMobile = false;
}

if(isset($_SESSION['app']) && strcmp($_SESSION['app'],'yes')==0 ) {
    $gridPreference = "app";
}


if(strcmp($sub_categories_with_items,'yes')==0){
    $splitSubcategories = true;
} else {
    $splitSubcategories = false;
}

if(strcmp($showAddToCartButton,'yes')==0){
    $enableAddToCartButton = true;
} else {
    $enableAddToCartButton = false;
}

if(strcmp($useAsB2C,"yes")==0){
    $isB2C = true;
} else {
    $isB2C = false;
}

if(strcmp($anonymousOrder,'yes')==0){
    $allowAnonymousOrder = true;
} else {
    $allowAnonymousOrder = false;
}

if(strcmp($showB2BAnonymousPrices,'yes')==0){
    $showAnonymousPrices = true;
} else {
    $showAnonymousPrices = false;
}

if(strcmp($allowOrderOverStock,"yes")==0) {
    $maxStockAlert=false;
} else {
    $maxStockAlert=true;
}

if(strcmp($useMaxStock,"yes")==0) {
    $useMaxStockOnItems=true;
} else {
    $useMaxStockOnItems=false;
}

if(strcmp($allowUserFavorites,"yes")==0) {
    $favoritesShow=true;
} else {
    $favoritesShow=false;
}

if(intval($userID)==0 || intval($customerID)==0) {
    $historyShow = false;
}
else {
    if (strcmp($allowOrderProductHistory, "yes") == 0) {
        $historyShow = true;
    } else {
        $historyShow = false;
    }
}



if($customerID == 0) {
    if ($showAnonymousPrices) {
        $_SESSION['showPrices'] = true;
    } else {
        $_SESSION['showPrices'] = false;
    }
}

if(strcmp($showPrices,"no")==0) {
    $showPrices=false;
} else if($_SESSION['showPrices']==false) {
    $showPrices=false;
} else {
    $showPrices=true;
}

switch ($showPricesIncludingVAT){
    case 'yes':
        $showPricesWithVAT = true;
        $includeVatOnPrice = true;
        break;
    case 'both':
        $showPricesWithVAT = true;
        $includeVatOnPrice = false;
        break;
    default:
        $showPricesWithVAT = false;
        $includeVatOnPrice = false;
}

switch ("$show_discount_bubble") {
    case "no":
        $showDiscountBubble = false;
        $showPrevPrice = false;
        break;
    case 'bubble':
        $showDiscountBubble = true;
        $showPrevPrice = false;
        break;
    case 'price':
        $showDiscountBubble = false;
        $showPrevPrice = true;
        break;
    default:
        $showDiscountBubble = true;
        $showPrevPrice = true;
}

switch ("$show_non_stock_items") {
    case "no":
        $hideNonStockItems = true;
        $notAvailableNonStockItems = false;
        break;
    case 'notavailable':
        $hideNonStockItems = false;
        $notAvailableNonStockItems = true;
        break;
    default:
        $hideNonStockItems = false;
        $notAvailableNonStockItems = false;
}

switch (strtolower("$themeColor")){
    case '':
        $themeColor = "#6796d3";
        break;
    case 'red':
        $themeColor = "firebrick";
        break;
    case 'darkslateblue':
        $themeColor = "#1d4f9c";
        break;
    case 'navyblue':
        $themeColor = "#000080";
        break;
    case 'black':
        $themeColor = 'black';
        break;
    case 'gold':
        $themeColor = "goldenrod";
        break;
    case 'yellow':
        $themeColor = "yellow";
        break;
    default:
        if(strpos($themeColor,'#')===false) {
            $themeColor = str_replace('darkdark','dark',"dark$themeColor");
        } else {
            $themeColor = strtolower($themeColor);
        }
}

if(isset( $_POST['gridPreference']) && strcmp($_POST['gridPreference'],"")!=0) {
    $gridPreference = $_POST['gridPreference'];
    $_SESSION['gridPreference'] = $gridPreference;
} else {
    $gridPreference = $_SESSION['gridPreference'];
}

$orderBy = "sellable DESC,item_code";
$orderBy2= "sellable DESC,item_code";
if(isset($_POST['sorting']) && strcmp($_POST['sorting'],"")!=0) {
    $orderBy = 'sellable DESC,'.$_POST['sorting'];
    $orderBy2= 'sellable DESC,'.$_POST['sorting'];
} else if(strcmp($orderBySelection,'Category_Item.position')==0){
        $orderBy2 = "sellable DESC,$orderBySelection";
} else {
    $orderBy = "sellable DESC,$orderBySelection";
    $orderBy2= "sellable DESC,$orderBySelection";
}

if(isset($_SESSION['urlOptionFilters']) && strcmp($_SESSION['urlOptionFilters'],"")!=0){

    $urlOptionsFiltersWithCategory = explode(',',$_SESSION['urlOptionFilters']);
    $urlOptionsFilters = array();

    foreach($urlOptionsFiltersWithCategory as $urlOptionFilter){

        $urlOptionFilterExplode = explode('-',$urlOptionFilter);
        $urlOptionFilterID = $urlOptionFilterExplode[1];
        $urlOptionFilterType = $urlOptionFilterExplode[0];

        if(strcmp($urlOptionFilterType,'C')==0){
            $_POST['category'] = $urlOptionFilterID;
        } else {
            array_push($urlOptionsFilters,$urlOptionFilter);
        }
    }
    $_POST['optionFilters'] = $urlOptionsFilters;
    $_SESSION['urlOptionFilters'] = '';
}

$selectedFilters = '';
$filteredItemsQueryFilter = '';
if(isset($_POST['optionFilters']) && count(array_filter($_POST['optionFilters'])) > 0){

    $selectedFilters = implode(',',array_filter($_POST['optionFilters']));

    $filterOptionsArray = implode(',',$_POST['optionFilters']);
    $filterOptionsArray = explode(',',trim($filterOptionsArray));

    $filterRadioArray    = array_filter($filterOptionsArray, function($v) {return strpos($v, 'S-') !== false;});
    $filterCheckboxArray = array_filter($filterOptionsArray, function($v) {return strpos($v, 'M-') !== false;});
    $filterRangesArray   = array_filter($filterOptionsArray, function($v) {return strpos($v, 'R-') !== false;});
    $filterPriceArray    = array_filter($filterOptionsArray, function($v) {return strpos($v, 'P-') !== false;});

    $filteredItemsArray = array();

    if(is_array($filterRadioArray) && count($filterRadioArray) > 0) {

        $filterRadioPerFilterIDArray = array();
        foreach ($filterRadioArray as $filter) {
            $filterElements = explode('-', $filter);
            $filterID = $filterElements[1];
            $filterOptionID = $filterElements[2];
            $filterRadioPerFilterIDArray[$filterID][$filterOptionID] = $filterOptionID;
        }

        foreach ($filterRadioPerFilterIDArray as $filterArray) {

            $filterRadioImplode = implode(',',$filterArray);

            if (count($filteredItemsArray) > 0) {
                $extraFilterImplode = implode(',', $filteredItemsArray);
                $extraFilter = "AND item_id IN ($extraFilterImplode)";
                $filteredItemsArray = array();
            } else {
                $extraFilter = '';
            }

            $stm = $db->prepare("SELECT item_id FROM Filter_Item WHERE filter_option_id IN ($filterRadioImplode) $extraFilter");
            $stm->execute();
            $stm->bind_result($filteredItemID);
            while ($stm->fetch()) {array_push($filteredItemsArray, $filteredItemID);}
            $stm->close();

        }

    }

    if(is_array($filterCheckboxArray) && count($filterCheckboxArray) > 0) {

        $filterCheckboxPerFilterIDArray = array();
        foreach ($filterCheckboxArray as $filter) {
            $filterElements = explode('-', $filter);
            $filterID = $filterElements[1];
            $filterOptionID = $filterElements[2];
            $filterCheckboxPerFilterIDArray[$filterID][$filterOptionID] = $filterOptionID;
        }


        foreach ($filterCheckboxPerFilterIDArray as $filterArray) {

            $filterOptionsImplode = implode(',', $filterArray);

            if (count($filteredItemsArray) > 0) {
                $extraFilterImplode = implode(',', $filteredItemsArray);
                $extraFilter = "AND item_id IN ($extraFilterImplode)";
                $filteredItemsArray = array();
            } else {
                $extraFilter = '';
            }

            $stm = $db->prepare("SELECT item_id FROM Filter_Item WHERE filter_option_id IN ($filterOptionsImplode) $extraFilter");
            $stm->execute();
            $stm->bind_result($filteredItemID);
            while ($stm->fetch()) {array_push($filteredItemsArray, $filteredItemID);}
            $stm->close();

        }
    }

    if(is_array($filterPriceArray) && count($filterPriceArray) > 0){

        $filterPriceElement = reset($filterPriceArray);
        $filterPriceElement = explode('-',$filterPriceElement);

        $filterPriceCategoryID  = $filterPriceElement[1];
        $filterPricePriceTypeID = $filterPriceElement[2];
        $filterPriceFilterID    = $filterPriceElement[3];
        $filterPriceMinPrice    = $filterPriceElement[4];
        $filterPriceMaxPrice    = $filterPriceElement[5];

        if(count($filteredItemsArray) > 0){
            $extraFilter = implode(',',$filteredItemsArray);
            $extraFilter = "AND Category_Item.item_id IN ($extraFilter)";
            $filteredItemsArray = array();
        } else {
            $extraFilter = '';
        }

        $stm = $db->prepare("SELECT Category_Item.item_id FROM Category_Item,Prices WHERE Category_Item.item_id=Prices.item_id AND category_id='$filterPriceCategoryID' AND pricetype_id='$filterPricePriceTypeID' AND price >='$filterPriceMinPrice' AND price <= '$filterPriceMaxPrice' $extraFilter GROUP BY Category_Item.item_id");
        $stm-> execute();
        $stm-> bind_result($filteredItemID);
        while ($stm->fetch()) {array_push($filteredItemsArray,$filteredItemID);}
        $stm->close();


    }

    $filteredItemsImplode = implode(',',$filteredItemsArray);

    if(strcmp($filteredItemsImplode,'')!=0) {
        $filteredItemsQueryFilter = " AND Items.item_id IN ($filteredItemsImplode) ";
    } else {
        $filteredItemsQueryFilter = " AND 0=1 ";
    }
}

if($hideNonStockItems){
    $stm = $db->prepare("SELECT get_stock_from,stock_from_warehouse FROM B2B_Page_Catalogue LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($getStockFrom,$fromWarehouses);
    while ($stm->fetch()) {}
    $stm-> close();

    if(strcmp($getStockFrom,'both')==0){$getStockFrom = "available+reserved";}
    else if(strcmp($getStockFrom,'ignoreReserved')==0){$getStockFrom = "available";}
    else {$getStockFrom = 'available-reserved';}

    if(strcmp($fromWarehouses,'all')==0){$whFilter = "1=1";}
    else if(strcmp($fromWarehouses,'')==0){$whFilter = "1=1";}
    else {$whFilter = " warehouse_id IN($fromWarehouses) ";}

    $filteredItemsQueryFilter .= " AND Items.item_id IN (SELECT item_id FROM Stock WHERE $whFilter GROUP BY item_id HAVING SUM($getStockFrom) > 0 ) ";

} else if(strcmp("$show_non_stock_items","notavailable")==0){

    $stm = $db->prepare("SELECT get_stock_from,stock_from_warehouse FROM B2B_Page_Catalogue LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($getStockFrom,$fromWarehouses);
    while ($stm->fetch()) {}
    $stm-> close();

    if(strcmp($getStockFrom,'both')==0){$getStockFrom = "available+reserved";}
    else if(strcmp($getStockFrom,'ignoreReserved')==0){$getStockFrom = "available";}
    else {$getStockFrom = 'available-reserved';}

    if(strcmp($fromWarehouses,'all')==0){$whFilter = "1=1";}
    else if(strcmp($fromWarehouses,'')==0){$whFilter = "1=1";}
    else {$whFilter = " Stock.warehouse_id IN($fromWarehouses) ";}

    $joinStockTable = ',Stock ';
    $joinStockWhere = " AND Items.item_id=Stock.item_id AND $whFilter";
    $orderBy = "SUM($getStockFrom) DESC,".$orderBy;
    $orderBy2 = "SUM($getStockFrom) DESC,".$orderBy2;
}


//$statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items WHERE NOT status='inactive' AND NOT sellable='no' $filteredItemsQueryFilter LIMIT 50";
////$statement = "SELECT Items.item_id,item_code,item_sku,name FROM Items,Item_Images WHERE NOT status='inactive' AND Items.item_id=Item_Images.item_id LIMIT 50";
//$statementCount ="SELECT COUNT(DISTINCT(Items.item_id)) FROM Items LIMIT 50";

if(isset($_POST['category'])) {

    $categoryID = $_POST['category'];

    if(strcmp($categoryID,"1")==0) {

        $categoriesArray = getB2BCategories($db);
        $categoriesStringFilter = implode(',',$categoriesArray);

        if(strcmp("$categoriesStringFilter","")!=0){
            $b2bItemsFilter = " AND Category_id IN ($categoriesStringFilter)";
        } else {
            $b2bItemsFilter = " AND 0=1";
        }

        $statement = "SELECT DISTINCT(Items.item_id),item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Category_Item $joinStockTable WHERE Items.item_id = Category_Item.item_id $joinStockWhere AND NOT status='inactive' AND NOT sellable='no' $b2bItemsFilter $filteredItemsQueryFilter ORDER BY $orderBy2 LIMIT $numOfItemsInPage OFFSET $offset";
        $statementCount="SELECT COUNT(DISTINCT(Items.item_id)) FROM Category_Item,Items $joinStockTable WHERE NOT status='inactive' $joinStockWhere AND NOT sellable='no' AND Items.item_id = Category_Item.item_id $b2bItemsFilter $filteredItemsQueryFilter";
    }
    else if(strcmp($categoryID,"2")==0) {

        // ---------------- DELIVERY METHOD ITEMS ----------------
        $deliveryMethodItemsArray = array();
        $stm = $db->prepare("SELECT Category_Item.item_id FROM B2C_Configuration,Category_Item WHERE Category_Item.category_id=B2C_Configuration.delivery_method_category_id AND delivery_method_category_id > 0");
        $stm-> execute();
        $stm-> bind_result($deliveryMethodItemID);
        while ($stm->fetch()) {array_push($deliveryMethodItemsArray,$deliveryMethodItemID);}
        $stm->close();

        $deliveryMethodItemsImplode = implode(',',$deliveryMethodItemsArray);
        if(strcmp($deliveryMethodItemsImplode,'')!=0){
            $deliveryMethodFilter = " AND Items.item_id NOT IN ($deliveryMethodItemsImplode)";
        }
        // ---------------- DELIVERY METHOD ITEMS/----------------


        $categoriesArray = getB2BCategories($db);
        $allowedCategories = implode(',',$categoriesArray);

        if(strcmp(trim("$allowedCategories"),'')!=0){
            $allowedItemsFilters = " AND Items.item_id IN (SELECT item_id AS item_id FROM Category_Item WHERE category_id IN ($allowedCategories))";
        } else {
            $allowedItemsFilters = " AND 0=1";
        }

        switch($popularItemsSelection) {
            case 1:
                $statement = "SELECT ERP_Popular_Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,ERP_Popular_Items $joinStockTable WHERE ERP_Popular_Items.item_id = Items.item_id $joinStockWhere AND NOT status='inactive' AND NOT sellable='no' AND customer_id='$customerID' $allowedItemsFilters $deliveryMethodFilter $filteredItemsQueryFilter GROUP BY ERP_Popular_Items.item_id ORDER BY COUNT(ERP_Popular_Items.item_id) DESC  LIMIT $numOfItemsInPage OFFSET $offset ";
                $statementCount = "SELECT COUNT(DISTINCT ERP_Popular_Items.item_id) FROM Items,ERP_Popular_Items $joinStockTable WHERE ERP_Popular_Items.item_id = Items.item_id $joinStockWhere AND NOT status='inactive' AND NOT sellable='no' AND customer_id='$customerID' $allowedItemsFilters $deliveryMethodFilter $filteredItemsQueryFilter";
                break;
            case 2:
                $statement = "SELECT Invoice_Item.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Invoice_Item,Invoices $joinStockTable WHERE Invoice_Item.item_id = Items.item_id $joinStockWhere AND Invoices.invoice_id=Invoice_Item.invoice_id AND NOT Items.status='inactive' AND NOT Items.sellable='no' AND customer_id='$customerID' $allowedItemsFilters $deliveryMethodFilter $filteredItemsQueryFilter GROUP BY Invoice_Item.item_id ORDER BY COUNT(Invoice_Item.item_id) DESC  LIMIT $numOfItemsInPage OFFSET $offset ";
                $statementCount = "SELECT COUNT(DISTINCT Invoice_Item.item_id) FROM Items,Invoice_Item,Invoices $joinStockTable WHERE Invoice_Item.item_id = Items.item_id $joinStockWhere AND Invoices.invoice_id=Invoice_Item.invoice_id AND NOT Items.status='inactive' AND NOT Items.sellable='no' AND customer_id='$customerID' $allowedItemsFilters $deliveryMethodFilter $filteredItemsQueryFilter";
                break;
            default:
                $statement = "SELECT Order_Item.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Order_Item,Orders $joinStockTable WHERE Order_Item.item_id = Items.item_id $joinStockWhere AND Orders.order_id=Order_Item.order_id AND NOT Items.status='inactive' AND NOT Items.sellable='no' AND customer_id='$customerID' $allowedItemsFilters $deliveryMethodFilter $filteredItemsQueryFilter GROUP BY Order_Item.item_id ORDER BY COUNT(Order_Item.item_id) DESC  LIMIT $numOfItemsInPage OFFSET $offset ";
                $statementCount = "SELECT COUNT(DISTINCT Order_Item.item_id) FROM Items,Order_Item,Orders $joinStockTable WHERE Order_Item.item_id = Items.item_id $joinStockWhere AND Orders.order_id=Order_Item.order_id AND NOT Items.status='inactive' AND NOT Items.sellable='no' AND customer_id='$customerID' $allowedItemsFilters $deliveryMethodFilter $filteredItemsQueryFilter";

        }


    }
    else if(strcmp($categoryID,"3")==0) {
        $categoryID=5;
        $statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Category_Item $joinStockTable WHERE Items.item_id = Category_Item.item_id $joinStockWhere AND NOT status='inactive' AND NOT sellable='no' AND category_id='$categoryID' $filteredItemsQueryFilter ORDER BY $orderBy2 LIMIT $numOfItemsInPage OFFSET $offset";
        $statementCount="SELECT COUNT(DISTINCT(Items.item_id)) FROM Category_Item,Items $joinStockTable WHERE category_id='$categoryID' $joinStockWhere AND NOT status='inactive' AND NOT sellable='no' AND Items.item_id = Category_Item.item_id";
    }
    else if(strcmp($categoryID,"5")==0) {
        $categoriesArray = getB2BCategories($db);
        $categoriesStringFilter = implode(',',$categoriesArray);
        $categoryID=5;
        $statement = "SELECT DISTINCT(Items.item_id),item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Category_Item,ContractPrices $joinStockTable WHERE Items.item_id = Category_Item.item_id $joinStockWhere AND Items.item_id=ContractPrices.item_id AND ContractPrices.customer_id='$customerID' AND ContractPrices.valid_from <= CURDATE() AND ContractPrices.valid_until >= CURDATE() AND NOT status='inactive' AND NOT sellable='no' AND category_id IN ($categoriesStringFilter) $filteredItemsQueryFilter ORDER BY $orderBy2 LIMIT $numOfItemsInPage OFFSET $offset";
        $statementCount="SELECT COUNT(DISTINCT(Items.item_id)) FROM Category_Item,Items,ContractPrices $joinStockTable WHERE Items.item_id = Category_Item.item_id $joinStockWhere AND Items.item_id=ContractPrices.item_id AND ContractPrices.customer_id='$customerID' AND ContractPrices.valid_from <= CURDATE() AND ContractPrices.valid_until >= CURDATE() AND category_id IN ($categoriesStringFilter) AND NOT status='inactive' AND NOT sellable='no'";
    }
    else if(strcmp($categoryID,"12")==0) {

        // ---------------- DELIVERY METHOD ITEMS ----------------
        $deliveryMethodItemsArray = array();
        $stm = $db->prepare("SELECT Category_Item.item_id FROM B2C_Configuration,Category_Item WHERE Category_Item.category_id=B2C_Configuration.delivery_method_category_id AND delivery_method_category_id > 0");
        $stm-> execute();
        $stm-> bind_result($deliveryMethodItemID);
        while ($stm->fetch()) {array_push($deliveryMethodItemsArray,$deliveryMethodItemID);}
        $stm->close();

        $deliveryMethodItemsImplode = implode(',',$deliveryMethodItemsArray);
        if(strcmp($deliveryMethodItemsImplode,'')!=0){
            $deliveryMethodFilter = " AND Items.item_id NOT IN ($deliveryMethodItemsImplode)";
        }
        // ---------------- DELIVERY METHOD ITEMS/----------------

        $categoryID=12;
        $statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items $joinStockTable WHERE timestamp BETWEEN CURDATE() - INTERVAL 30 DAY AND CURDATE() $joinStockWhere AND NOT status='inactive' AND NOT sellable='no' $deliveryMethodFilter $filteredItemsQueryFilter ORDER BY $orderBy LIMIT $numOfItemsInPage OFFSET $offset";
        $statementCount="SELECT COUNT(DISTINCT(Items.item_id)) FROM Items $joinStockTable WHERE Items.timestamp BETWEEN CURDATE() - INTERVAL 30 DAY AND CURDATE() AND NOT status='inactive' $joinStockWhere AND NOT sellable='no' $deliveryMethodFilter $filteredItemsQueryFilter";
    }
    else if(strcmp($categoryID,"-12")==0) {
        $categoryID=-12;
        $statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Item_Back_In_Stock $joinStockTable WHERE Items.item_id = Item_Back_In_Stock.item_id $joinStockWhere AND NOT status='inactive' AND NOT sellable='no' AND (back_in_stock_date BETWEEN DATE_SUB(NOW(), INTERVAL 10 DAY) AND NOW()) $filteredItemsQueryFilter ORDER BY $orderBy LIMIT $numOfItemsInPage OFFSET $offset";
        $statementCount="SELECT COUNT(DISTINCT(Items.item_id)) FROM Item_Back_In_Stock,Items $joinStockTable WHERE NOT status='inactive' $joinStockWhere AND NOT sellable='no' AND Items.item_id = Item_Back_In_Stock.item_id AND (back_in_stock_date BETWEEN DATE_SUB(NOW(), INTERVAL 10 DAY) AND NOW()) $filteredItemsQueryFilter";
    }
    else if(strcmp($categoryID,"-10")==0) {
        $categoryID=-10;
        $statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items $joinStockTable WHERE  NOT status='inactive' $joinStockWhere AND NOT sellable='no' AND category_id='$categoryID' $filteredItemsQueryFilter ORDER BY item_code LIMIT $numOfItemsInPage OFFSET $offset";
        $statementCount="SELECT COUNT(DISTINCT(Items.item_id)) FROM Category_Item,Items $joinStockTable WHERE category_id='$categoryID' $joinStockWhere AND NOT status='inactive' AND NOT sellable='no' AND Items.item_id = Category_Item.item_id $filteredItemsQueryFilter";
    }
    else if(strcmp($categoryID,"28")==0) {
        $userID=  $_SESSION['userID'] ;
        $statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Customer_Favorite_Items $joinStockTable  WHERE NOT status='inactive' $joinStockWhere AND Items.item_id = Customer_Favorite_Items.item_id AND Customer_Favorite_Items.customer_id = '$customerID' AND Customer_Favorite_Items.user_id = '$userID' AND NOT sellable='no'  $filteredItemsQueryFilter GROUP BY (Items.item_id) ORDER BY item_code LIMIT $numOfItemsInPage OFFSET $offset";
        $statementCount = "SELECT COUNT(DISTINCT(Items.item_id)) FROM Customer_Favorite_Items,Items $joinStockTable WHERE NOT status='inactive' $joinStockWhere AND Items.item_id = Customer_Favorite_Items.item_id AND Customer_Favorite_Items.customer_id = '$customerID' AND Customer_Favorite_Items.user_id = '$userID' AND NOT sellable='no' $filteredItemsQueryFilter GROUP BY (Items.item_id)";
    }
    else {

        if (strcmp($includeSubcategoryProducts, 'yes') == 0) {
            $categories = $categoryID.getSubCategoriesID($categoryID);
            $statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Category_Item $joinStockTable WHERE Items.item_id = Category_Item.item_id $joinStockWhere AND NOT status='inactive' AND NOT sellable='no' AND category_id IN ($categories) $filteredItemsQueryFilter GROUP BY Items.item_id ORDER BY $orderBy2  LIMIT $numOfItemsInPage OFFSET $offset";
            $statementCount="SELECT COUNT(DISTINCT(Items.item_id)) FROM Category_Item,Items $joinStockTable WHERE category_id IN ($categories) $joinStockWhere AND NOT status='inactive' AND NOT sellable='no' AND Items.item_id = Category_Item.item_id $filteredItemsQueryFilter";
        } else {
            $statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Category_Item $joinStockTable WHERE Items.item_id = Category_Item.item_id $joinStockWhere AND NOT status='inactive' AND NOT sellable='no' AND category_id='$categoryID' $filteredItemsQueryFilter ORDER BY $orderBy2 LIMIT $numOfItemsInPage OFFSET $offset";
            $statementCount = "SELECT COUNT(DISTINCT(Items.item_id)) FROM Category_Item,Items $joinStockTable WHERE category_id='$categoryID' $joinStockWhere AND NOT status='inactive' AND NOT sellable='no' AND Items.item_id = Category_Item.item_id $filteredItemsQueryFilter";

        }
    }
}
else if(isset($_POST['search'])) {

    if(strcmp(trim(str_replace(' ','',$_POST['text'])),'')==0){return;}

    $text =$_POST['text'];
    $keyword_tokens = trim($_POST['text']);

    //------- Customer Synonyms ----------------
    if($customerID>0){
        $keyword = "%$keyword_tokens%";
        $customerSynonymItems = array();

        $stm = $db->prepare("SELECT DISTINCT(item_id) FROM Customer_Item_Synonyms WHERE customer_id=? AND (code_synonym LIKE ? OR name_synonym LIKE ? )");
        $stm->bind_param('iss', $customerID,$keyword, $keyword);
        $stm->execute();
        $stm->bind_result($customerSynonymItem);
        while ($stm->fetch()) {array_push($customerSynonymItems,$customerSynonymItem);}
        $stm->close();

        $customerSynonymItemsFilter = implode(',',$customerSynonymItems);
        if(strcmp($customerSynonymItemsFilter,'')!=0){$customerSynonymItemsQueryFilter = " Items.item_id IN ($customerSynonymItemsFilter) OR ";}
    }
    //-----------------/Customer Synonyms/--------------------

    $text = str_replace("'","%",$text);
    $keyword_tokens = str_replace("'","%",$keyword_tokens);

    $categorySelect = $_POST['categorySelect'];
    $categoriesArray = getB2BCategories($db);
    $allowedCategories = implode(',',$categoriesArray);

    if(strcmp(trim("$allowedCategories"),'')!=0 && strcmp(trim("$categorySelect"),"")==0){
        $whereCategory = " item_id IN (SELECT item_id AS item_id FROM Category_Item WHERE category_id IN($allowedCategories)) $filteredItemsQueryFilter AND ";
    } else if(strcmp(trim("$categorySelect"),"")!=0 && intval($categorySelect) > 0) {
        $whereCategory=" item_id IN (SELECT item_id AS item_id FROM Category_Item WHERE category_id=\"$categorySelect\") $filteredItemsQueryFilter AND ";
    } else {
        $whereCategory = " 0=1 $filteredItemsQueryFilter AND";
    }

    $keyword_tokens = explode(' ', $keyword_tokens);
    $final_text = implode(' ',$keyword_tokens);

    $statement  = "SELECT item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items WHERE $whereCategory NOT status =\"inactive\" AND NOT sellable=\"no\" $filteredItemsQueryFilter AND( $customerSynonymItemsQueryFilter item_code LIKE '%";
    $statement .= implode("%' AND item_code LIKE '%", $keyword_tokens)    ."%' OR name LIKE '%";
    $statement .= implode("%' AND name LIKE '%", $keyword_tokens) ."%' OR item_sku LIKE '%";
    $statement .= implode("%' AND item_sku LIKE '%", $keyword_tokens) ."%'  OR long_description LIKE '%";
    $statement .= implode("%' AND long_description LIKE '%", $keyword_tokens) ."%'  OR short_description LIKE '%";
    $statement .= implode("%' AND short_description LIKE '%", $keyword_tokens) ."%'";
    $statement .=") ORDER BY CASE";
    $statement.=" WHEN item_code = '$final_text' THEN 1";
    $statement.=" WHEN name = '$final_text' THEN 1";
    $statement.=" WHEN item_sku = '$final_text' THEN 1";
    $statement.=" WHEN item_code LIKE '$final_text%' THEN 2";
    $statement.=" WHEN name LIKE '$final_text%' THEN 2";
    $statement.=" WHEN name LIKE '%$final_text%' THEN 3";
    $statement.=" WHEN short_description LIKE '$final_text%' THEN 2";
    $statement.=" WHEN short_description LIKE '%$final_text%' THEN 3";
    $statement.=" WHEN item_code LIKE '%$final_text%' THEN 3  WHEN item_code LIKE '%";
    $statement .= implode("%'THEN 4 WHEN item_code LIKE '%", $keyword_tokens)."%' THEN 4 ";
    $statement.=" WHEN name LIKE '$final_text%' THEN 2";
    $statement.=" WHEN name LIKE '%$final_text%' THEN 3  WHEN name LIKE '%";
    $statement .= implode("%'THEN 4 WHEN name LIKE '%", $keyword_tokens)."%' THEN 4 ";
    $statement.="  ELSE 6 END,$orderBy LIMIT $numOfItemsInPage OFFSET $offset";

    $statementCount  = "SELECT COUNT(item_id) FROM Items WHERE $whereCategory NOT status =\"inactive\" AND NOT sellable=\"no\" $filteredItemsQueryFilter AND( item_code LIKE '%";
    $statementCount .= implode("%' AND item_code LIKE '%", $keyword_tokens)    ."%' OR name LIKE '%";
    $statementCount .= implode("%' AND name LIKE '%", $keyword_tokens) ."%' OR item_sku LIKE '%";
    $statementCount .= implode("%' AND item_sku LIKE '%", $keyword_tokens) ."%'  OR long_description LIKE '%";
    $statementCount .= implode("%' AND long_description LIKE '%", $keyword_tokens) ."%'  OR short_description LIKE '%";
    $statementCount .= implode("%' AND short_description LIKE '%", $keyword_tokens) ."%'";
    $statementCount .= ") ORDER BY CASE";
    $statementCount .= " WHEN item_code = '$final_text' THEN 1";
    $statementCount .= " WHEN name = '$final_text' THEN 1";
    $statementCount .= " WHEN item_sku = '$final_text' THEN 1";
    $statementCount .= " WHEN item_code LIKE '$final_text%' THEN 2";
    $statementCount .= " WHEN name LIKE '$final_text%' THEN 2";
    $statementCount .= " WHEN name LIKE '%$final_text%' THEN 3";
    $statementCount .= " WHEN item_code LIKE '%$final_text%' THEN 3  WHEN item_code LIKE '%";
    $statementCount .=  implode("%'THEN 4 WHEN item_code LIKE '%", $keyword_tokens)."%' THEN 4 ";
    $statementCount .= " WHEN name LIKE '$final_text%' THEN 2";
    $statementCount .= " WHEN name LIKE '%$final_text%' THEN 3  WHEN name LIKE '%";
    $statementCount .= implode("%'THEN 4 WHEN name LIKE '%", $keyword_tokens)."%' THEN 4 ";
    $statementCount .= "  ELSE 6 END";


}
else if(isset($_POST['advancedSearch'])) {

    $customTableName = $_POST['custTable'];
    $customTable = " INNER JOIN $customTableName ON (Items.item_id=$customTableName.id) ";

    require_once(ROOT . "backend/core/model/CustomTable.php");
    $custTable = new CustomTable('Items');
    $custTableFields = $custTable->getCustomTableB2BFields($_POST['ctid']);

    $categorySelect = $_POST['categorySelect'];
    $categoriesArray = getB2BCategories($db);
    $allowedCategories = implode(',',$categoriesArray);

    if(strcmp("$allowedCategories","")!=0 && strcmp(trim("$categorySelect"),"")==0) {
        $whereCategory = " item_id IN (SELECT item_id AS item_id FROM Category_Item WHERE category_id IN($allowedCategories)) AND ";
    } else if(strcmp(trim("$categorySelect"),"")!=0 && intval($categorySelect) > 0){
        $categoryID = $categorySelect;
        $whereCategory = " item_id IN (SELECT item_id AS item_id FROM Category_Item WHERE category_id=\"$categorySelect\") AND ";
    } else {
        $whereCategory = " 0=1 AND ";
    }

    $statement  = "SELECT item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items $customTable WHERE $whereCategory NOT status =\"inactive\" AND NOT sellable=\"no\" $filteredItemsQueryFilter ";
    $statementCount  = "SELECT COUNT(item_id) FROM Items $customTable WHERE $whereCategory NOT status =\"inactive\" AND NOT sellable=\"no\" ";

    foreach ($custTableFields as $custTableField) {
        if(strcmp($_POST["$custTableField->customTableField"],'')!=0) {
            $statement .= " AND $customTableName.$custTableField->customTableField='" . $_POST["$custTableField->customTableField"] . "' ";
            $statementCount .= " AND $customTableName.$custTableField->customTableField='" . $_POST["$custTableField->customTableField"] . "' ";
        }
    }

    $statement .= " LIMIT $numOfItemsInPage OFFSET $offset";


}
else {
    $categoryID=10000;
    $statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Category_Item $joinStockTable WHERE Items.item_id = Category_Item.item_id $joinStockWhere AND NOT status='inactive' AND NOT sellable='no' AND category_id='$categoryID' $filteredItemsQueryFilter ORDER BY Items.sellable DESC,item_code LIMIT $numOfItemsInPage OFFSET $offset";
    $statementCount="SELECT COUNT(DISTINCT(Items.item_id)) FROM Category_Item,Items $joinStockTable WHERE category_id='$categoryID' $joinStockWhere AND NOT status='inactive' AND NOT sellable='no' AND Items.item_id = Category_Item.item_id $filteredItemsQueryFilter";
}

$result="";

$stm = $db->prepare("SELECT brand_id,brand_code,brand_name,brand_image_url,brand_link_url,popup_text,slider_position FROM B2B_Brands WHERE (slider_position='grid' OR slider_position='variants')  AND category_id='$categoryID' ORDER BY position ASC");
$stm->execute();
$stm->bind_result($brandID, $brandCode, $brandName, $brandImageUrl, $brandLinkUrl, $popupText,$brandType);
while ($stm->fetch()) {
    $gridSideImage = "<img src='assets/brandslider/$brandImageUrl' alt='' style='height: auto;width: 100%;'/>";
}
$stm->close();

$tableTop = '';
if(strcmp("$brandType", 'grid') == 0 && strcmp("$gridSideImage", '') != 0) {
    $gridPreference = 'categoryGroup';
    if($isMobile){
        $tableTop = "<script>$('.price').css('text-align','center');$('.productCode').css('text-align','center').css('width','100%');</script>
                        <center>
                            <table style='width: 99%;margin-top:15px;'>
                                <tr>
                                    <td style='vertical-align:top;padding: 0px;border: 1px solid transparent;'>
                                        <div class='header-theme text-center' style='font-size: 24px;'>$brandName</div>
                                        $gridSideImage
                                        <div style='width: 100%' >$popupText</div>
                                    </td>
                                </tr>
                                <tr>
                                    <td style='vertical-align:top;'>";

        $tableBottom = '            </td>
                                </tr>
                            </table>
                        </center>';
    } else {
        $tableTop = "<style>.categoryGroupLine:hover{background-color: #DEDEDE !important;}</style>
                        <center>
                            <table style='width: 99%;margin-top:15px;'>
                                <tr>
                                    <td style='width: 35%;vertical-align:top;padding: 5px;padding-top:0px;border: 1px solid transparent;'>
                                        <div class='header-theme text-center' style='font-size: 24px;'>$brandName</div>
                                        $gridSideImage
                                        <div style='width: 100%' >$popupText</div>
                                    </td>
                                    <td style='vertical-align:top;'>";

        $tableBottom = '            </td>
                                </tr>
                            </table>
                        </center>';
    }
}
if(strcmp("$brandType", 'variants') == 0) {
    $gridPreference = 'categoryVariants';
    $tableTop = "<script>$('.price').css('text-align','center');$('.productCode').css('text-align','center').css('width','100%');</script>
                    <center>
                        <table style='width: 99%;margin-top:15px;box-shadow: rgba(0, 0, 0, 0.1) 0px 4px 6px -1px, rgba(0, 0, 0, 0.06) 0px 2px 4px -1px;'>
                            <tr>
                                <td style='vertical-align:top;padding: 0px;border: 1px solid transparent;'>
                                    <div class='header-theme text-center' style='font-size: 24px;'>$brandName</div>
                                    <div style='width: 100%' >$popupText</div>
                                </td>
                            </tr>
                            <tr>
                                <td style='vertical-align:top;'>";

    $tableBottom = '            </td>
                            </tr>
                        </table>
                    </center>';

}


$result .= $tableTop;


if(isset($categoryID)) {

    $stm = $db->prepare("SELECT COUNT(category_id),banner_text FROM B2B_Categories_Promotions WHERE category_id='$categoryID'");
    $stm-> execute();
    $stm-> bind_result($counter,$bannetText);

    while ($stm->fetch()) {
        if($counter>0)
        {
            $extraCredit=true;
        }

    }
    $stm-> close();

}
$styleHidden="btn ";
if($extraCredit)
{
    $styleHidden="hidden";
}

$stm = $db->prepare($statementCount);
$stm-> execute();
$stm-> bind_result($count);

while ($stm->fetch()) {
    $result.="<input id='counter' value='$count' type='hidden'/>";
}
$stm-> close();

if(!isset($count))
{

    $stm2 = $db->prepare("SELECT category_id FROM B2B_Categories WHERE category_id>1000 ORDER BY position LIMIT 1");
    $stm2-> execute();
    $stm2-> bind_result($categoryID);
    while ($stm2->fetch()) {}
    $stm2-> close();

    $statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Category_Item $joinStockTable WHERE Items.item_id = Category_Item.item_id $joinStockWhere AND category_id='$categoryID' LIMIT $numOfItemsInPage OFFSET $offset";
    $statementCount="SELECT COUNT(DISTINCT(Items.item_id)) FROM Items,Category_Item $joinStockTable WHERE Items.item_id = Category_Item.item_id $joinStockWhere AND category_id='$categoryID'";

    $stm2 = $db->prepare($statementCount);
    $stm2-> execute();
    $stm2-> bind_result($count);

    while ($stm2->fetch()) {
        $result.="<input id='counter' value='$count' type='hidden'/>";
    }
    $stm2-> close();

    $result.="<input id='counter' value='$count' type='hidden'/>";
}

if($extraCredit)
{
    $result = $result . $bannetText;
}

if(isset($_POST['title']))
{
    $result = $result . $_POST['title'];
}

$testFile=fopen('getItemsStatement.txr', 'w');
fwrite($testFile,"$statement");
fclose($testFile);

$userID=$_SESSION['userID'];
if($userID > 0) {
    $stm = $db->prepare("SELECT B2C_User FROM B2B_User WHERE b2b_user_id='$userID'");
    $stm->execute();
    $stm->bind_result($isB2CUser);
    while ($stm->fetch()) {
    }
    $stm->close();

    if (strcmp("$isB2CUser", "yes") == 0 && $isB2C) {
        $isB2C = true;
    } else {
        $isB2C = false;
    }
}

$addWatermark = false;
$stm = $db->prepare("SELECT watermark_id,file_url,position,opacity FROM B2B_Image_Watermark WHERE watermark_id=1 AND active='yes'");
$stm-> execute();
$stm-> bind_result($watermarkID,$watermarkURL,$watermarkPosition,$watermarkOpacity);
while ($stm->fetch()) {
    if($watermarkID > 0){$addWatermark = true;}
}
$stm->close();

$hasItemResult = false;
$statementRows = array();
$stm = $db->prepare("$statement");
$stm-> execute();
$stm-> bind_result($itemID,$itemCode,$itemSKU,$name,$shortDescription,$longDescription,$thumbnail_url,$b2bAvailable);
$userFavoriteItems = getUserFavoriteItems($userID,$customerID);
while ($stm->fetch()) {

    $qty = getQtyFromCart($orderID, $itemID);

    $stock = getStock($itemID);

    $subUnits = getSubUnits($itemID);

    $itemPrices = getCalculatedPrices($fromB2BPriceList,$offerB2BPriceList,$fromB2CPriceList,$offerB2CPriceList,$isB2C,$customerID,$itemID,$qty);

    $vatPercent = getVatPercentageByItemID($db2,$itemID);

    $isFavorite = false;
    if (in_array($itemID, $userFavoriteItems)) {
        $isFavorite = true;
    }

    $contractPriceTimestamp = $contractPrice = '';
    if ($customerID > 0 && $categoryID == 5) {
        $customerActiveContractPrice = getCustomerActiveContractPriceInfo($db2,$customerID,$itemID,$qty);
        $contractPriceTimestamp = $customerActiveContractPrice->contractPriceTimestamp;
        $contractPrice = $customerActiveContractPrice->contractPrice;
    }

    if(strcmp($usePacking,'yes')==0) {
        $packing = getPacking($itemID);
    } else {
        $packing = 1;
    }


    $itemUOMs = getItemUOMs($orderID,$itemID);
    $uomQty   = 0;
    foreach ($itemUOMs as $uom) {$uomQty = $uom->qty;}
    if($uomQty > 0){$qty = $uomQty;}


    switch ($productShow){
        case 'barcode':$itemCode = $longDescription;break;
        case 'sku':$itemCode = $itemSKU;break;
        case 'none':$itemCode = '';break;
    }

    if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 && isset($shortDescription) && strcmp($shortDescription,'')!=0 ) {
        $name=$shortDescription;
    }

    if($customerID > 0) {
        $itemCode = getCustomerSynonym($customerID,$itemID,'code',$itemCode);
        $name = getCustomerSynonym($customerID,$itemID,'name',$name);
    }

    if(file_exists(ROOT."/media/productImages/$thumbnail_url.jpg")){
        $imageUrl = "//" . HTML_PATH . "/cop/media/productImages/" . $thumbnail_url . ".jpg";
    } else if(file_exists(ROOT."/media/productImages/$thumbnail_url.png")){
        $imageUrl = "//" . HTML_PATH . "/cop/media/productImages/" . $thumbnail_url . ".png";
    } else if(file_exists(ROOT."/media/productImages/$thumbnail_url.gif")){
        $imageUrl = "//" . HTML_PATH . "/cop/media/productImages/" . $thumbnail_url . ".gif";
    } else if(file_exists(".$logoLink")){
        $imageUrl = "$logoLink";
    } else {
        $imageUrl = "./assets/img/noimage.jpg";
    }

    if($notAvailableNonStockItems && $stock <= 0){
        $b2bAvailable = 'notavailable';
    }

    if(strcmp($b2bAvailable,'')==0){
        $b2bAvailable = 'yes';
    }

    $statementRow = new stdClass();
    $statementRow->itemID = $itemID;
    $statementRow->itemCode = $itemCode;
    $statementRow->itemSKU = $itemSKU;
    $statementRow->name = $name;
    $statementRow->shortDescription = $shortDescription;
    $statementRow->longDescription = $longDescription;
    $statementRow->imageUrl = $imageUrl;
    $statementRow->b2bAvailable = $b2bAvailable;
    $statementRow->price = $itemPrices->price;
    $statementRow->prevPrice = $itemPrices->prevPrice;
    $statementRow->qty = $qty;
    $statementRow->subUnits = $subUnits;
    $statementRow->packing = $packing;
    $statementRow->itemUOMs = $itemUOMs;
    $statementRow->contractPrice = $contractPrice;
    $statementRow->contractPriceTimestamp = $contractPriceTimestamp;
    $statementRow->vatPercent = intval($vatPercent);
    $statementRow->stock = $stock;
    $statementRow->isFavorite = $isFavorite;

    array_push($statementRows,$statementRow);

}
$stm-> close();

if(strcmp(''.$_POST['sortingFilter'],'')==0 && strcmp(''.$_SESSION['sortingFilter'],'')!=0){
    $_POST['sortingFilter'] = $_SESSION['sortingFilter'];
}

if(isset($_POST['sortingFilter']) && strcmp(''.$_POST['sortingFilter'],'')!=0) {
    $_SESSION['sortingFilter'] = $_POST['sortingFilter'];
    switch ($_POST['sortingFilter']){
        case 'priceAsc':
            usort($statementRows, function($a, $b) {
                if($a->b2bAvailable != $b->b2bAvailable){
                    if($a->b2bAvailable > $b->b2bAvailable){return -1;} else {return 1;}
                }
                if(floatval($b->price) < floatval($a->price)){return -1;} else {return 1;}
            });
            break;
        case 'priceDesc':
            usort($statementRows, function($a, $b) {
                if($a->b2bAvailable != $b->b2bAvailable){
                    if($a->b2bAvailable > $b->b2bAvailable){return -1;} else {return 1;}
                }
                if(floatval($a->price) < floatval($b->price)){return -1;} else {return 1;}
            });
            break;
        case 'newest':
            usort($statementRows, function($a, $b) {
                if($a->b2bAvailable != $b->b2bAvailable){
                    if($a->b2bAvailable > $b->b2bAvailable){return -1;} else {return 1;}
                }
                if(floatval($a->itemID) < floatval($b->itemID)){return -1;} else {return 1;}
            });
            break;
        default:

            if(isset($_POST['sorting']) && strcmp($_POST['sorting'],"")!=0) {$sortBy = $_POST['sorting'];}
            else {$sortBy = "$orderBySelection";}
            $sortBy = lcfirst(str_replace(' ', '', ucwords(str_replace('_', ' ', $sortBy))));

            usort($statementRows, function($a, $b) use($sortBy,$show_non_stock_items) {
                if($a->b2bAvailable != $b->b2bAvailable){
                    if($a->b2bAvailable > $b->b2bAvailable){return -1;} else {return 1;}
                }

                if(strcmp("$show_non_stock_items","notavailable")==0) {
                    if (isset($a->$sortBy)) {
                        if ($a->$sortBy < $b->$sortBy) {return -1;} else {return 1;}
                    }
                }
            });
            break;
    }
}


if(isset($_POST['category'])) {
    $categoryID = $_POST['category'];
    $result .= "<input id='loadedCategory' type='hidden' value='$categoryID'/>";
}

if($categoryID >0){
    $categoryPathURL = '';
    $stm = $db->prepare("SELECT name FROM Categories WHERE category_id=? LIMIT 1");
    $stm->bind_param('i', $categoryID);
    $stm->execute();
    $stm->bind_result($categoryName);
    while ($stm->fetch()) {
        $categoryName = make_greeklish($categoryName);
        $categoryName = transliterateString($categoryName);
        $categoryName = str_replace(' ','-',strtolower($categoryName));
        $categoryName = str_replace('&','and',$categoryName);
        $categoryName = preg_replace('/[^A-Za-z0-9\-]/', '', $categoryName);
        $categoryPathURL = "$categoryName/";
    }
    $stm->close();

}

$i = 0;
foreach($statementRows as $statementRow) {
    $i++;
    $itemID = $statementRow->itemID;
    $itemCode = $statementRow->itemCode;
    $itemSKU = $statementRow->itemSKU;
    $name = $statementRow->name;
    $shortDescription = $statementRow->shortDescription;
    $longDescription = $statementRow->longDescription;
    $imageUrl = $statementRow->imageUrl;
    $b2bAvailable = $statementRow->b2bAvailable;
    $qty = $statementRow->qty;
    $vatPercent = $statementRow->vatPercent;
    $price = $statementRow->price;
    $prevPrice = $statementRow->prevPrice;
    $packing = $statementRow->packing;
    $itemUOMs = $statementRow->itemUOMs;
    $subUnits = $statementRow->subUnits;
    $stock = $statementRow->stock;
    $isFavorite= $statementRow->isFavorite;


    if($itemID>0){$hasItemResult = true;}

    $itemCodeUrl = urlencode(str_replace('/','--CP2F--',$itemCode));


    if($addWatermark) {
        if(strcmp($watermarkURL,'')==0){$watermarkURL = $logoLink;};
        if(strcmp($watermarkPosition,'')==0){$watermarkPosition = 'center';}
        if(strcmp($watermarkOpacity,'')==0){$watermarkOpacity = '0.5';}
        if(strcmp($imageUrl,'./assets/img/noimage.jpg')!=0) {
            $watermarks .= "
            watermark(['$imageUrl','$watermarkURL'])
            .image(watermark.image.$watermarkPosition($watermarkOpacity))
            .then(function (img) {
                img.id = 'watermark-img-$itemID';
                img.style.cssText = document.getElementById('media-link-img-$itemID').style.cssText;
                document.getElementById('media-link-img-$itemID').remove();
                document.getElementById('media-link-$itemID').appendChild(img);
                document.getElementById('media-link-$itemID').href = './products/$categoryPathURL$itemCodeUrl';
                delete document.getElementById('media-link-$itemID').dataset.featherlight;
            });";
        }
        $imageUrl = './assets/img/noimage.jpg';
    }

    if(strcmp($b2bAvailable,'notavailable')==0){
        $notCurrentlyAvailable = $langu['not_available_label'];
        $name ="<span style='color:firebrick;font-size: 14px;'>$notCurrentlyAvailable</span><br>$name";
        $grayImage = "filter: gray; -webkit-filter: grayscale(1); filter: grayscale(1); ";
        $grayBox = '#fafafa';
        $disabledButton = 'disabled readonly';
        $hidePlusMinus = "display:none;";
        $stock = 0;
    } else if(strcmp($b2bAvailable,'nonstock')==0){
        $grayImage = '';
        $grayBox = '#ffffff';
        $disabledButton = '';
        $hidePlusMinus = "border-radius:3px;padding:12px;width:40px !important;height:41px !important;font-weight:bolder;color:$themeColor;margin:0px;' onMouseOver=\"this.style.background='$themeColor';this.style.color='white'\"  onMouseOut=\"this.style.background='';this.style.color='$themeColor'\" '";
        $stock = 0;
    } else {
        $grayImage = '';
        $grayBox = '#ffffff';
        $disabledButton = '';
        $hidePlusMinus = "border-radius:3px;padding:12px;width:40px !important;height:41px !important;font-weight:bolder;color:$themeColor;' onMouseOver=\"this.style.background='$themeColor';this.style.color='white'\"  onMouseOut=\"this.style.background='';this.style.color='$themeColor'\" '";
    }

    if (!empty($itemUOMs)) {
        $itemUomElementOptions = '';
        foreach ($itemUOMs as $uom) {
            $itemUomElementOptions .= "<option value='$uom->name' data-multiplier='$uom->multiplier' data-id='$uom->id' $uom->selected>$uom->name&nbsp;</option>";
        }
        $itemUomElement = "<div style='height: 30px;'>
                                <select class='uom-element' style='display: inline-block;border-color: $themeColor;border-radius: 4px;font-weight: bold;color: $themeColor;font-size: 15px;background-color: transparent;padding: 1px;' onMouseOver=\"this.style.background='$themeColor';this.style.color='white'\"  onMouseOut=\"this.style.background='transparent';this.style.color='$themeColor'\">
                                    $itemUomElementOptions
                                </select>
                           </div>";
    } else {
        $itemUomElement = "<div style='height: 30px;'>
                                <select class='uom-element pull-right' style='display: none;' >
                                    <option value='' data-multiplier='1' data-id='0' selected></option>
                                </select>
                           </div>";
    }

    if($prevPrice > $price && $price > 0 && $showDiscountBubble){
        $percentDiscount = round((1 - ($price/$prevPrice))*100);
        $discountLabel = "<span style='height: 24px;vertical-align: top;margin-bottom: 0px;font-size: 17px;padding:2px 15px;border-radius: 3px;' class='pull-right btn-theme'><center>-$percentDiscount%</center></span>";
    } else {
        $discountLabel = '';
    }

    if($showPricesWithVAT) {
        $vat = floatval($price) * ($vatPercent / 100);
        $priceWithVAT =  number_format(floatval($price + $vat),2);
        $prevVat = floatval($prevPrice) * ($vatPercent / 100);
        $prevPriceWithVAT =  number_format(floatval(floatval($prevPrice) + $prevVat),2);

        $inc = $langu['incl_label'];
        $vat = $langu['vat_label'];
        $PriceWithVatText = "<span  style='font-size: 11px;color: #0aa66e '>$currencySign$priceWithVAT &nbsp;$inc $vat</span>";

        if(floatval($prevPrice) > 0 && $showPrevPrice) {
            $prevPrice = number_format(floatval($prevPrice),2);
            if ($includeVatOnPrice) {
                $prevPrice = "<del style='color: gray;'>$currencySign$prevPriceWithVAT</del><br>";
            } else {
                $prevPrice = "<del style='color: gray;'>$currencySign$prevPrice</del><br>";
            }
        } else {
            $prevPrice = "<del></del><br>";
        }

    } else if(floatval($prevPrice) > 0 && $showPrevPrice) {
        $prevPrice = number_format(floatval($prevPrice),2);
        $prevPrice = "<del style='color: gray;'>$currencySign$prevPrice</del><br>";
    } else {
        $prevPrice = "<del></del><br>";
    }

    if($showAnonymousPrices){
        if($price > 0) {
            $price = number_format(floatval($price),2);
            $pricing = "$currencySign$price<br>$PriceWithVatText";
            if($includeVatOnPrice) {$pricing = "$currencySign$priceWithVAT";}
            $anonymousPricesText = " <div class='price'><ins>$prevPrice$pricing</ins></div>";
        } else {
            if(strcmp($PriceWithVatText,'')!=0){$PriceWithVatText="<br>";}
            $anonymousPricesText = " <div class='price'><ins><br><br>$PriceWithVatText</ins></div>";
        }
    } else {
        $anonymousPricesText = '';
    }



    if($showPrices) {
        $price = number_format(floatval($price),2);
        $pricing="$currencySign$price<br>$PriceWithVatText";
        if($includeVatOnPrice){$pricing="$currencySign$priceWithVAT";}
    } else {
        $pricing="";
    }

    if(isset($recommendedRetailPrice)&& $recommendedRetailPrice>0) {
        $recommendedRetailPriceDouble=getPriceFromPriceType($itemID,$recommendedRetailPrice);
        $recommendedRetailPriceFormatted = '-';

        if($includeVatOnPrice) {
            $vat = floatval($recommendedRetailPriceDouble) * ($vatPercent / 100);
            $recommendedRetailPriceDouble = floatval($recommendedRetailPriceDouble) + $vat;
        }

        if($recommendedRetailPriceDouble>0) {
            $recommendedRetailPriceFormatted = $currencySign.number_format(floatval($recommendedRetailPriceDouble), 2);
        }

        $recommendedRetailPriceText = "<center>
                                          <div  style='background-color:rgba(210,223,245,0.4);margin: 0;border-radius: 5px;width: fit-content;white-space: nowrap;padding: 4px 12px;'>
                                              <label style='font-size:12px;text-decoration:none;text-transform:none;'>" . $langu['recommended_retail_price'] . "</label>
                                              <div class='price' style='text-align:center;color:#4682b4;margin:2px;color: black'>$recommendedRetailPriceFormatted</div>
                                          </div>
                                       </center>";
    } else {
        $recommendedRetailPriceText = "";
    }

    if($useMaxStockOnItems) {
        $itemMaxStock = 0;
        $db2->set_charset("utf8");
        $stm2 = $db2->prepare("SELECT max_stock,vat_id FROM Items WHERE item_id='$itemID' LIMIT 1");
        $stm2->execute();
        $stm2->bind_result($itemMaxStock, $vatID);
        while ($stm2->fetch()) {}
        $stm2->close();
    }

    if ($maxStockAlert) {
        $maxStock = $stock;
        $maxStockAlertLabel = $langu['insufficient_stock'];
        $maxStockAlertDisplay = 'none';

        if($maxStockLimit > 0 && $maxStockLimit < $stock){
            $maxStock = $maxStockLimit;
            $maxStockAlertLabel = $langu['no_orders_allowed_over'] . " $maxStockLimit " .$langu['pieces'];
        }

        if($useMaxStockOnItems && $maxStock > $itemMaxStock && $itemMaxStock > 0){
            $maxStock = $itemMaxStock;
            $maxStockAlertLabel = $langu['no_orders_allowed_over'] . " $itemMaxStock " .$langu['pieces'];
        }

        if($qty > $maxStock && $qty > 0){$maxStockAlertDisplay = 'inline-block';}

        $stockTextOverAlert = "<div style='height: 20px;'>
                                   <span style='color: firebrick;font-weight:bold;margin-top:0px;width: 100%;display:$maxStockAlertDisplay;' class='insStock'>$maxStockAlertLabel!</span>
                                   <input type='hidden' id='max$itemID' value='$maxStock'>
                               </div>";
    } else {
        $stockTextOverAlert = '';
    }

    if(($customerID!=0 || $allowAnonymousOrder)&&onAfterCartPromotion($itemID,$customerID)&&(strcmp($extraCredit,"yes")==0||strcmp($promotionsEveryWhere,"yes")==0)) {

        $mixandmatchButton = $langu['mix_and_match_button'];
        $promotions = getAvailableAfterCartPromotions($itemID,$customerID);
        $promotionText= "<button style='display:inline-block;height:24px;padding-top:2px;padding-bottom:2px;padding-left:5px;padding-right:5px;margin-left:5px;' class=' btn btn-invoice abc' data-toggle='popover-x' data-target='#myPopover1$itemID' data-placement='top'>$mixandmatchButton</button>
                            <div id='myPopover1$itemID' class='popover popover-x popover-default' >
                                <div class='arrow'></div>
                                    <h3 style='background-color: #008080;padding:10px;color:#ffffff;' class='popover-header popover-title'><span style='margin-left:10px;margin-bottom:10px;' class='close'  data-dismiss='popover-x'>&times;</span>".$langu['available_promotions']."</h3>
                                        <div class='popover-body popover-content' style='padding:5px;' >
                                            <table style='width:100%'>
                                                <thead></thead>
                                                <tbody>";


        $title="'<div class=\'row\'><div class=\'col-sm-12 col-md-12 col-lg-12\'><h3 style=\'background-color: #008080;padding:10px;color:#ffffff;font-size:16px;margin-bottom:0\' >Mix and Match Info <span onclick=\'getItemsInCategory($categoryID,1,96);\' class=\'btn btn-primary\' style=\'position:absolute;right:20px;top:22px\'>Back to Products</span></h3><table class=\'table table-striped\'><tr><th style=\'color:#222222;font-weight:bold;text-align:right\'>Qty</th><th style=\'color:#222222;font-weight:bold;text-align:right\'>Discount(%)</th><th style=\'color:#222222;font-weight:bold;text-align:right\'>Qty in Cart</th></tr>";
        $firstTime = true;
        foreach ($promotions as $promotion) {
            if($firstTime) {
                $firstTime = false;
                $promotionCategory=$promotion->categoryID;
                $stm2 = $db2->prepare("SELECT SUM(qty) FROM Online_Order_Item,Items,Category_Item WHERE Category_Item.category_id='$promotionCategory' AND Items.item_id=Category_Item.item_id AND  Online_Order_Item.item_id=Items.item_id AND Online_Order_Item.order_id='$orderID' AND Online_Order_Item.promotion_number=0");
                $stm2->execute();
                $stm2->bind_result($promoQtyTotal);
                while ($stm2->fetch()) {}
                $stm2->close();
                $title.="<tr><td style=\'text-align:right\'>$promotion->qty</td><td style=\'text-align:right\'>$promotion->discount</td><td  style=\'text-align:right;font-weight:bold;color: #222222;\'><span class=\'mix$promotion->categoryID\'>$promoQtyTotal</span></td>";
            } else {
                $title.="<tr><td style=\'text-align:right\'>$promotion->qty</td><td style=\'text-align:right\'>$promotion->discount</td><td style=\'text-align:right\'></td>";
            }
        }
        $title.="</table></div></div>'";

        foreach ($promotions as $promotion) {
            $promotionText.=" <tr><td style='padding:5px;'> <a class=\"btn btn-primary center-canvas\" style=\"width:100%\" onclick=\"document.getElementById('myPopover1$itemID').style.display='none';getItemsInCategoryMixAndMatch($promotion->categoryID,1,96,$title);\">$promotion->name</a></td></tr>";
        }

        $promotionText.="</tbody></table></div></div>$discountLabel";

    }
    else if(($customerID!=0 || $allowAnonymousOrder)&&onPromotion($itemID,$customerID)&&(strcmp($extraCredit,"yes")==0||strcmp($promotionsEveryWhere,"yes")==0)) {

        $mixandmatchButton = $langu['promotion_button'];
        $promotions = getAvailablePromotions($itemID,$customerID);
        $promotionText= "<button style='display:inline-block;height:24px;padding-top:2px;margin-left:5px;padding-left: 5px; padding-right: 5px;' class=' btn btn-invoice abc' data-toggle='popover-x' data-target='#myPopover1$itemID' data-placement='top'  >$mixandmatchButton</button>
                         <div id='myPopover1$itemID' class='popover popover-x popover-default' >
                             <div class='arrow'></div>
                             <h3 style='background-color: #008080;padding:10px;color:#ffffff;' class='popover-header popover-title'><span style='margin-left:10px;margin-bottom:10px;' class='close'  data-dismiss='popover-x'>&times;</span>".$langu['available_promotions']."</h3>
                             <div class='popover-body popover-content' style='padding:5px;' >
                                <table style='width:100%'>
                                    <thead></thead>
                                    <tbody>";

        foreach ($promotions as $promotion) {
            $promotionText.="        <tr>
                                        <td style='padding:5px;'>
                                            <a class=\"btn btn-primary center-canvas\" style=\"width:100%\" onclick=\"document.getElementById('myPopover1$itemID').style.display='none';addPromotionToCart($promotion->id,$itemID);\">$promotion->name</a>
                                        </td>
                                     </tr>";
        }

        $promotionText.="           </tbody>
                                </table>
                            </div>
                         </div>
                         $discountLabel";

    }
    else {
        $promotionText="<div style='height:24px;'>$discountLabel</div>";
    }

    if($enableAddToCartButton) {
        if ($qty > 0) {
            $hideAddButton = "display:none;";
            $hideButtonsDiv = "height:43px;";
        } else {
            $hideAddButton = "";
            $hideButtonsDiv = "height:43px;display:none;";
        }

        if(strcmp($b2bAvailable,'notavailable')==0){
            $addButtonCSS = 'background-color:white;border-color:white;color:gray;text-decoration: line-through;';
        } else {
            $addButtonCSS = '';
        }

        if($isMobile){
            $addButtonCSS .="width: 100%;height:43px;";
        } else {
            $addButtonCSS .="width: 80%;height:43px;";
        }

        $addToCartButton = "<button type='button' class='btn btn-block btn-theme addButton' onclick='$(this).siblings(\"div.buttons\").show().find(\".plusButton\").click();$(this).hide();' style='text-transform: none !important;border-radius: 3px;min-width:fit-content;max-width:270px;padding:11px 5px;$hideAddButton$addButtonCSS' $disabledButton><i class='fa fa-shopping-cart'></i>&nbsp;&nbsp; ".$langu['add_to_cart']."</button>";
    }

    $favoriteButton ="";
    if($favoritesShow) {
        if ($isFavorite) {
            $iconColor = "color:red;-webkit-text-stroke:0px;";
        } else {
            $iconColor = "color:white;-webkit-text-stroke:1px black;";
        }
        if ($userID == 0 || $customerID == 0) {
            $onclick = "$('#loginModal').modal('show');";
        } else {
            $onclick = "updateFavorites($itemID);";
        }
        $favoriteButton .= "  <div id= 'favoriteText$itemID' onclick= " . $onclick . " style='cursor:pointer;color:black;padding-top:15px;display:inline-block;'>
                                <i id ='favoriteIcon$itemID' class='fa fa-heart' style='cursor:pointer;font-size:14px !important;$iconColor'></i> &nbsp; 
                              " . $langu['favorites'] . "
                            </div>";
    }

    $historyButton = "";
    if($historyShow) {



        $historyButton = "<div id='showHistoryModal' onclick='showOrderHistory($itemID);'  style='cursor:pointer;color:black;padding-top:15px;display:inline-block;'>
                     <i class='fa fa-history' style='cursor:pointer;font-size:14px !important;'></i> &nbsp; 
                    " . $langu['history'] . "
                </div>";


    }



    $stockText = "";
    if($_SESSION['showStock'] == true) {
        if ($customerID > 0 || $allowAnonymousOrder) {
            if (strcmp($numericStock, "yes") == 0) {
                if ($stock < $stockWarningQty && $stock > 0) {
                    $stockText = "<h6 style='white-space:nowrap;font-size:14px;color:#B98502FF;font-weight:400;' class='productCode caption-title pointer' data-value = '$itemID' data-product='$itemCodeUrl' data-category='$categoryPathURL'>Stock: $stock </h6 >";
                } else if (intval($stock) > 0){
                    $stockText = "<h6 style='white-space:nowrap;font-size:14px;color:#008080;font-weight:400;' class='productCode caption-title pointer' data-value = '$itemID' data-product='$itemCodeUrl' data-category='$categoryPathURL'>Stock: $stock </h6 >";
                } else {
                    $stockText = "<h6 style='white-space:nowrap;font-size:14px;color:#b22222;font-weight:400;' class='productCode caption-title pointer' data-value = '$itemID' data-product='$itemCodeUrl' data-category='$categoryPathURL'>Stock: 0 </h6 >";
                }
            } else if (strcmp($numericStock, "dot") == 0) {
                if ($stock < $stockWarningQty && $stock > 0) {
                    $stockText = "<h6 style='font-size:11px;color: #B98502FF;font-weight:bold;display:inline-block;' ><span style='height: 8px;width: 8px;background-color: #B98502FF;border-radius: 50%;display:inline-block;' class='dot'></span> $stock</h6>";
                } else if ($stock > 0) {
                    $stockText = "<h6 style='height: 8px;width: 8px;background-color: #008080;border-radius: 50%;display:inline-block;' class='dot'></h6>";
                } else {
                    $stockText = "<h6 style='height: 8px;width: 8px;background-color: #b22222;border-radius: 50%;display:inline-block;' class='dot'></h6>";
                }
            }
        }
    }

    if (strcmp($gridPreference,'grid')==0) {


        if($customerID!=0 || $allowAnonymousOrder) {

            $pricing .= $statementRow->contractPriceTimestamp;

            if($subUnits==1 && $subunitsForce) {
                $pricesTextInput =  "<input type='number'  onkeyup='this.value=this.value.replace(/[^\d]/,\"\")' value='$qty' data-value='$itemID'  class='productQtyInput form-control $styleHidden' style='display:inline;width:48px;height:40px;text-align:center;border-color: transparent;padding: 0;' $disabledButton/>";
            } else {
                $pricesTextInput =  "<input type='number'  value='$qty' data-value='$itemID' class='productQtyInput form-control' style='display:inline;width:48px;height:40px;text-align:center;border-color: transparent;padding: 0;' $disabledButton/>";
            }

            $pricesText = "<div class='price'>
                               <ins>$prevPrice$pricing</ins>
                           </div>
                           <center>
                           $recommendedRetailPriceText
                           $itemUomElement
                           $addToCartButton
                           <div class='buttons' style='border: 1px solid $themeColor;border-radius:3px;width: fit-content;white-space: nowrap;$hideButtonsDiv'>
                               <a class='minusButton pull-left $styleHidden' style='$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-minus'></i></a>
                               <a  class='plusButton pull-right $styleHidden' style='$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-plus'></i></a>
                               $pricesTextInput
                           </div>
                           </center>";
        }
        else {
            $pricesText = "$anonymousPricesText
                           <div class='buttons'>
                              <a class='btn btn-theme' style='padding: 2px;margin-bottom: 8px;display: block;width:auto;' href='products/".$categoryPathURL.$itemCodeUrl."' $disabledButton>View</a>
                           </div>";
        }

        $result .= "<div class='col-md-2 col-sm-6 ' id='div$i' style='margin-top:8px; padding: 0 4px;'>
                         <div class='thumbnail no-border no-padding' style='background-color:$grayBox;border: #f4f4f4 2px solid;border-radius: 5px;padding-bottom: 5px;' onmouseenter='this.style.border=\"$themeColor 2px solid\"' onmouseleave='this.style.border=\"#f4f4f4 2px solid\"'>
                              <div class='media '>
                                 $promotionText                                      
                                  <a class='media-link' id='media-link-$itemID' style='height:100px;' href='#' data-featherlight='$imageUrl'>
                                     <img class='img-fluid'  id='media-link-img-$itemID' src='$imageUrl' alt='' style='max-height:100px;width:auto;margin-top:5px;$grayImage' />
                                     <span class='icon-view'><strong><i class='fa fa-eye'></i></strong></span>
                                  </a>
                              </div>    

                              <div class='caption text-center'>
                                  <input type='hidden' value='$itemID'/>
                                  <p style='line-height: 1.5em;    height: 4.6em;overflow: hidden;font-size:12px;color:#000;font-weight:bold;font-family:Arial, Helvetica, sans-serif' class='pointer productCode caption-title' data-value='$itemID' data-product='$itemCodeUrl' data-category='$categoryPathURL'><a href='products/$categoryPathURL$itemCodeUrl'>$name</a></p>
                                  <p style='white-space:nowrap;font-size:12px;Arial, Helvetica, sans-serif;font-weight:400' class='productCode caption-title pointer' data-value='$itemID' data-product='$itemCodeUrl' data-category='$categoryPathURL'>$itemCode</p>
                                  <div  style='margin-top:10px' >
                                  $stockText
                                  </div>
                                  $pricesText
                                  $stockTextOverAlert
                                  $favoriteButton
                                  <br> $historyButton


                              </div>
                         </div>
                     </div>";
    }
    else if (strcmp($gridPreference,'grid1PerRow')==0) {



        if($customerID!=0 || $allowAnonymousOrder) {

            if($subUnits==1 && $subunitsForce) {
                $pricesTextInput =  "<input type='number'  onkeyup='this.value=this.value.replace(/[^\d]/,\"\")' value='$qty' data-value='$itemID'  class='productQtyInput form-control $styleHidden' style='display:inline;width:180px;height:40px;text-align:center;border-color: transparent;' $disabledButton/>";
            } else {
                $pricesTextInput =  "<input type='number'  value='$qty' data-value='$itemID' class='productQtyInput form-control $styleHidden' style='display:inline;width:180px;height:40px;text-align:center;border-color: transparent;' $disabledButton/>";
            }

            $pricesText = "<div class='price'>
                               <ins>$prevPrice$pricing</ins>
                           </div>
                           $recommendedRetailPriceText
                           $itemUomElement
                           <center>
                           $addToCartButton
                           <div class='buttons' style='border: 1px solid $themeColor;border-radius:3px;width: fit-content;$hideButtonsDiv'>
                               <a class='minusButton pull-left $styleHidden' style='$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-minus'></i></a>
                               <a class='plusButton pull-right $styleHidden' style='$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-plus'></i></a>
                               $pricesTextInput
                           </div>
                           </center>";
        }
        else {
            $pricesText ="$anonymousPricesText
                          <div class='buttons'>
                              <a class='btn btn-theme center-canvas' style='padding: 2px;margin-bottom: 8px;width:30%;max-width: 250px;' href='products/".$categoryPathURL.$itemCodeUrl."' $disabledButton>View</a>
                          </div>";
        }

        $result .= "<div class='col-md-12 col-sm-6' id='div$i' style='margin-top:8px;padding: 0 4px;'>
                        <div class='thumbnail no-border no-padding' style='background-color:$grayBox;border: #f4f4f4 2px solid;border-radius: 5px;padding-bottom: 5px;' onmouseenter='this.style.border=\"$themeColor 2px solid\"' onmouseleave='this.style.border=\"#f4f4f4 2px solid\"'>
                            <div class='media'>
                               $promotionText               
                                <a class='media-link' id='media-link-$itemID' style='height:350px;' href='#' data-featherlight='$imageUrl'>
                                    <img class='img-fluid'  id='media-link-img-$itemID' src='$imageUrl' alt='' style='max-height:350px;width:auto;margin-top:5px;$grayImage' />
                                    <span class='icon-view'>
                                        <strong><i class='fa fa-eye'></i></strong>
                                    </span>
                                </a>
                            </div>

                            <div class='caption text-center'>
                                <input type='hidden' value='$itemID'/>
                                <p style='line-height: 1.5em;height: 4.5em;overflow: hidden;font-size:12px;color:#000;font-weight:bold;font-family:Arial, Helvetica, sans-serif' class='pointer productCode caption-title' data-value='$itemID' data-product='$itemCodeUrl' data-category='$categoryPathURL'><a href='products/$categoryPathURL$itemCodeUrl'>$name</a></p>
                                <p style='white-space:nowrap;font-size:12px;Arial, Helvetica, sans-serif;font-weight:400' class='productCode caption-title pointer' data-value='$itemID' data-product='$itemCodeUrl' data-category='$categoryPathURL'>$itemCode</p>
                                $stockText
                                $pricesText
                                $stockTextOverAlert
                                $favoriteButton
                                <br> $historyButton
                                
                            </div>
                        </div>
                    </div>";
    }
    else if (strcmp($gridPreference,'grid2PerRow')==0) {

        if($customerID!=0 || $allowAnonymousOrder) {

            if($subUnits==1 && $subunitsForce) {
                $pricesTextInput =  "<input type='number'  onkeyup='this.value=this.value.replace(/[^\d]/,\"\")' value='$qty' data-value='$itemID'  class='productQtyInput form-control $styleHidden' style='display:inline;width:50%;height:40px;text-align:center;border-color: transparent;' $disabledButton/>";
            } else {
                $pricesTextInput =  "<input type='number'  value='$qty' data-value='$itemID' class='productQtyInput form-control' style='display:inline;width:50%;height:40px;text-align:center;border-color: transparent;' $disabledButton/>";
            }
            $pricesText = "<div class='price'>
                              <ins>$prevPrice$pricing</ins>
                           </div>
                           $recommendedRetailPriceText
                           $itemUomElement
                           <center>
                           $addToCartButton
                           <div class='buttons' style='border: 1px solid $themeColor;border-radius:3px;width: fit-content;$hideButtonsDiv'>
                                <a class='minusButton pull-left $styleHidden' style='$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-minus'></i></a>
                                <a class='plusButton pull-right $styleHidden' style='$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-plus'></i></a>
                                $pricesTextInput
                           </div>
                           </center>";
        }
        else {
            $pricesText ="$anonymousPricesText
                          <div class='buttons'>
                              <a class='btn btn-theme' style='padding: 2px;margin-bottom: 8px;width:35%;max-width: 250px;' href='products/".$categoryPathURL.$itemCodeUrl."' $disabledButton>View</a>
                          </div>";
        }

        $result .= "<div class='col-md-6 col-sm-6' id='div$i' style='margin-top:8px;padding: 0 4px;'>
                        <div class='thumbnail no-border no-padding' style='background-color:$grayBox;border: #f4f4f4 2px solid;border-radius: 5px;padding-bottom: 5px;' onmouseenter='this.style.border=\"$themeColor 2px solid\"' onmouseleave='this.style.border=\"#f4f4f4 2px solid\"'>
                            <div class='media'>
                               $promotionText              
                                <a class='media-link' id='media-link-$itemID' style='height:200px;' href='#' data-featherlight='$imageUrl'>
                                    <img class='img-fluid'  id='media-link-img-$itemID' src='$imageUrl' alt='' style='max-height:200px;width:auto;margin-top:5px;$grayImage' />
                                    <span class='icon-view'>
                                        <strong><i class='fa fa-eye'></i></strong>
                                    </span>
                                </a>
                            </div>

                            <div class='caption text-center'>
                                <input type='hidden' value='$itemID'/>
                                <p style='line-height: 1.5em;    height: 4.5em;overflow: hidden;font-size:12px;color:#000;font-weight:bold;font-family:Arial, Helvetica, sans-serif' class='pointer productCode caption-title' data-value='$itemID' data-product='$itemCodeUrl' data-category='$categoryPathURL'><a href='products/$categoryPathURL$itemCodeUrl'>$name</a></p>
                                <p style='white-space:nowrap;font-size:12px;Arial, Helvetica, sans-serif;font-weight:400' class='productCode caption-title pointer' data-value='$itemID' data-product='$itemCodeUrl' data-category='$categoryPathURL'>$itemCode</p>
                                $stockText
                                $pricesText
                                $stockTextOverAlert
                                $favoriteButton
                                <br> $historyButton
                                
                            </div>
                        </div>
                    </div>";
    }
    else if (strcmp($gridPreference,'grid3PerRow')==0) {

        if($customerID!=0 || $allowAnonymousOrder) {

            if($subUnits==1 && $subunitsForce) {
                $pricesTextInput =  "<input type='number'  onkeyup='this.value=this.value.replace(/[^\d]/,\"\")' value='$qty' data-value='$itemID'  class='productQtyInput form-control $styleHidden' style='display:inline;width:50%;height:40px;text-align:center;border-color: transparent;' $disabledButton/>";
            } else {
                $pricesTextInput =  "<input type='number'  value='$qty' data-value='$itemID' class='productQtyInput form-control $styleHidden' style='display:inline;width:50%;height:40px;text-align:center;border-color: transparent;' $disabledButton/>";
            }

            $pricesText = "<div class='price'>
                                <ins>$prevPrice$pricing</ins>
                           </div>
                           $recommendedRetailPriceText
                           $itemUomElement
                           <center>
                           $addToCartButton
                           <div class='buttons'  style='border: 1px solid $themeColor;border-radius:3px;width: fit-content;$hideButtonsDiv'>
                                <a class='minusButton pull-left $styleHidden' style='$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-minus'></i></a>
                                <a class='plusButton pull-right $styleHidden' style='$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-plus'></i></a>
                                $pricesTextInput
                           </div>
                           </center>";
        }
        else {
            $pricesText ="$anonymousPricesText
                          <div class='buttons' style='margin-bottom:5px;'>
                               <a class='btn btn-theme' style='padding: 2px;margin-bottom: 8px;width:80%;max-width: 250px;' href='products/".$categoryPathURL.$itemCodeUrl."' $disabledButton>View</a>
                          </div>";
        }

        $result .= "<div class='col-md-4 col-sm-6' id='div$i' style='margin-top:8px;padding: 0 4px;'>
                        <div class='thumbnail no-border no-padding' style='background-color:$grayBox;border: #f4f4f4 2px solid;border-radius: 5px;padding-bottom: 5px;' onmouseenter='this.style.border=\"$themeColor 2px solid\"' onmouseleave='this.style.border=\"#f4f4f4 2px solid\"'>
                            <div class='media'>
                               $promotionText              
                                <a class='media-link' id='media-link-$itemID' style='height:120px;' href='#' data-featherlight='$imageUrl'>
                                    <img class='img-fluid'  id='media-link-img-$itemID' src='$imageUrl' alt='' style='max-height:120px;width:auto;margin-top:5px;$grayImage' />
                                    <span class='icon-view'>
                                        <strong><i class='fa fa-eye'></i></strong>
                                    </span>
                                </a>
                            </div>

                            <div class='caption text-center'>
                                <input type='hidden' value='$itemID'/>
                                <p style='line-height: 1.5em;    height: 4.5em;overflow: hidden;font-size:12px;color:#000;font-weight:bold;font-family:Arial, Helvetica, sans-serif' class='pointer productCode caption-title' data-value='$itemID' data-product='$itemCodeUrl' data-category='$categoryPathURL'><a href='products/$categoryPathURL$itemCodeUrl'>$name</a></p>
                                <p style='white-space:nowrap;font-size:12px;Arial, Helvetica, sans-serif;font-weight:400' class='productCode caption-title pointer' data-value='$itemID' data-product='$itemCodeUrl' data-category='$categoryPathURL'>$itemCode</p>
                                $stockText
                                $pricesText
                                $stockTextOverAlert
                                $favoriteButton
                                 <br> $historyButton
                            </div>
                            
                        </div>
                    </div>";
    }
    else if (strcmp($gridPreference,'mobile')==0) {


        if($customerID!=0 || $allowAnonymousOrder) {

            if($subUnits==1 && $subunitsForce) {
                $pricesTextInput = "<input type='number' onkeyup='this.value=this.value.replace(/[^\d]/,\"\")' value='$qty' data-value='$itemID' class='productQtyInput form-control $styleHidden' style='display:inline;width:60px;height:40px;text-align:center;padding:0;border-color: transparent;' $disabledButton/>";
            } else {
                $pricesTextInput = "<input type='number' value='$qty' data-value='$itemID' class='productQtyInput form-control' style='display:inline;width:60px;height:40px;text-align:center;padding:0;border-color: transparent;' $disabledButton/>";
            }

            $pricesText = "<div style='margin-top:10px;text-align:center'>
                                    <div class='price' style='text-align:left;color:#4682b4'>$prevPrice$pricing</div>
                               </div>
                               $recommendedRetailPriceText
                               <div style='margin-top:0' >
                                  $itemUomElement
                                  $addToCartButton
                                  <div class='buttons' style='border: 1px solid $themeColor;border-radius:3px;width: fit-content;padding:0px;$hideButtonsDiv'>
                                        <a class='minusButton pull-left $styleHidden' style='$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-minus'></i></a>
                                        <a  class='plusButton pull-right $styleHidden' style='$hidePlusMinus' href='#' data-value='$packing'>&nbsp;<i class='fa fa-plus'></i></a>
                                        $pricesTextInput
                                  </div>
                               </div>";
        }
        else {
            $pricesText ="$anonymousPricesText
                          <div class='buttons'>
                              <a class='btn btn-theme' style='padding: 2px;width:100px' href='products/".$categoryPathURL.$itemCodeUrl."' id='placeOrderButton' $disabledButton>View</a>
                          </div>";
        }

        $result .= "<div class='col-xs-12 col-sm-6' id='div$i' style='margin-top:8px;padding: 0;background-color:$grayBox;border: #f4f4f4 2px solid;border-radius: 5px;padding-bottom: 5px;' onmouseenter='this.style.border=\"$themeColor 2px solid\"' onmouseleave='this.style.border=\"#f4f4f4 2px solid\"''>
                        <div class='thumbnail no-border no-padding'>
                            $promotionText
                            <div class='col-xs-4' style='margin-top:0;padding-left:3px;padding-right:3px;' >
                                <div class='media'>                                                             
                                    <a class='media-link' id='media-link-$itemID' href='#' data-featherlight='$imageUrl'>
                                        <img src='$imageUrl' alt='' style='max-height:150px;width:auto;$grayImage'/>
                                        <span class='icon-view'>
                                            <strong><i class='fa fa-eye'></i></strong>
                                        </span>
                                    </a>
                                </div>
                           </div>
                           <div class='col-xs-8' style='margin-top:0;padding: 4px;' >
                                <h4 style='font-size:12px;color:#000;font-weight:bold;text-align:left;font-family:Arial, Helvetica, sans-serif' class='pointer productCode caption-title' data-value='$itemID' data-product='$itemCodeUrl' data-category='$categoryPathURL'><a href='products/$categoryPathURL$itemCodeUrl'>$name</a></h4>
                                <h6 style='white-space:nowrap;font-size:10px;text-align:left;font-weight:400;font-family:Arial, Helvetica, sans-serif' class='productCode caption-title pointer' data-value='$itemID' data-product='$itemCodeUrl' data-category='$categoryPathURL'>$itemCode</h6>
                                <div style='margin-top:10px'>
                                $stockText
                                </div>
                                $pricesText
                                $stockTextOverAlert
                                $favoriteButton
                                <br> $historyButton
                           </div>
                        </div>
                    </div>";
    }
    else if (strcmp($gridPreference,'app')==0) {

        if($customerID!=0 || $allowAnonymousOrder) {

            if($subUnits==1 && $subunitsForce){
                $pricesTextInput = "<input type='number' onkeyup='this.value=this.value.replace(/[^\d]/,\"\")' value='$qty' data-value='$itemID' class='productQtyInput form-control $styleHidden' style='display:inline;width:100px;height:36px;padding:0;text-align:center;border-color:transparent;' $disabledButton/>";
            } else {
                $pricesTextInput = "<input type='number' value='$qty' data-value='$itemID' class='productQtyInput form-control' style='display:inline;width:100px;height:36px;padding:0;text-align:center;border-color:transparent;' $disabledButton/>";
            }

            $pricesText = "<div style='margin-top:10px;text-align:center'>
                                <div class='price' style='text-align:left;color:#4682b4'>$prevPrice$pricing</div>
                           </div>
                           $recommendedRetailPriceText
                           <div style='margin-top:0' >
                               $addToCartButton
                               <div class='buttons' style='text-align:left;margin-top:8px;$hideButtonsDiv'>
                                    <a class='minusButton pull-left $styleHidden' style='$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-minus'></i></a>
                                    <a class='plusButton pull-right $styleHidden' style='$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-plus'></i></a>
                                    $pricesTextInput
                               </div>
                           </div>";
        }
        else {
            $pricesText ="$anonymousPricesText
                          <div class='buttons'>
                              <a class='btn btn-theme' style='padding: 2px;width:100px' href='products/".$categoryPathURL.$itemCodeUrl."' id='placeOrderButton' $disabledButton>View</a>
                          </div>";
        }

        $result .= "<div class='col-xs-12 col-sm-6' id='div$i' style='margin-top:8px;padding: 0;background-color:$grayBox;border: #f4f4f4 2px solid;border-radius: 5px;padding-bottom: 5px;' onmouseenter='this.style.border=\"$themeColor 2px solid\"' onmouseleave='this.style.border=\"#f4f4f4 2px solid\"'>
                        $promotionText
                        <div class='thumbnail no-border no-padding'>
                           <div class='col-xs-4' style='margin-top:0;padding-left:3px;padding-right:3px;' >
                                <div class='media'>                                                             
                                    <a class='media-link' id='media-link-$itemID' href='#' data-featherlight='$imageUrl'>
                                        <img src='$imageUrl' alt='' style='max-height:100px;width:auto;$grayImage'/>
                                        <span class='icon-view'>
                                            <strong><i class='fa fa-eye'></i></strong>
                                        </span>
                                    </a>
                                </div>
                           </div>
                           <div class='col-xs-8' style='margin-top:0;padding: 4px;' >
                                <h4 style='font-size:12px;color:#000;font-weight:bold;text-align:left;font-family:Arial, Helvetica, sans-serif' class='pointer productCode caption-title' data-value='$itemID' data-product='$itemCodeUrl' data-category='$categoryPathURL'><a href='products/$categoryPathURL$itemCodeUrl'>$name</a></h4>
                                <h6 style='white-space:nowrap;font-size:10px;text-align:left;font-weight:400;font-family:Arial, Helvetica, sans-serif' class='productCode caption-title pointer' data-value='$itemID' data-product='$itemCodeUrl' data-category='$categoryPathURL'>$itemCode</h6>                                    
                                <div style='margin-top:10px'>
                                $stockText
                                </div>
                                $pricesText
                                $stockTextOverAlert
                                $favoriteButton
                                <br> $historyButton
                           </div>
                        </div>
                    </div>";
    }
    else if (strcmp($gridPreference,'tablet')==0) {


        if($customerID!=0 || $allowAnonymousOrder) {

            if($subUnits==1 && $subunitsForce){
                $pricesTextInput = "<input type='number' onkeyup='this.value=this.value.replace(/[^\d]/,\"\")' value='$qty' data-value='$itemID' class='productQtyInput form-control $styleHidden' style='display:inline;width:100px;height:36px;padding:0;text-align:center;border-color:transparent;' $disabledButton/>";
            } else {
                $pricesTextInput = "<input type='number' value='$qty' data-value='$itemID' class='productQtyInput form-control' style='display:inline;width:100px;height:36px;padding:0;text-align:center;border-color:transparent;' $disabledButton/>";
            }

            $pricesText = "<div style='margin-top:10px;text-align:center'>
                              <div class='price' style='text-align:left;color:#4682b4'>$prevPrice$pricing</div>
                           </div>
                           $recommendedRetailPriceText
                           <div class='col-sm-8' style='margin-top:0;padding-left: 0;padding-bottom: 4px;' >
                                $addToCartButton
                                <div class='buttons' style='text-align:left;margin-top:0px;width: fit-content;white-space: nowrap;$hideButtonsDiv'>
                                    <a class='minusButton pull-left $styleHidden' style='width:20%;margin:0;margin-right:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-minus'></i></a>
                                    <a  class='plusButton pull-right $styleHidden' style='width:20%;margin:0;margin-left:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-plus'></i></a>
                                    $pricesTextInput
                                </div>
                           </div>";
        }
        else {
            $pricesText ="$anonymousPricesText
                          <div class='buttons'>
                              <a class='btn btn-theme' style='padding: 2px;width:100px' href='products/".$categoryPathURL.$itemCodeUrl."' id='placeOrderButton' $disabledButton>View</a>
                          </div>";
        }

        $result .= "<div class='col-sm-6' id='div$i' style='margin-top:8px;padding: 0;background-color:$grayBox;border: #f4f4f4 2px solid;border-radius: 5px;padding-bottom: 5px;' onmouseenter='this.style.border=\"$themeColor 2px solid\"' onmouseleave='this.style.border=\"#f4f4f4 2px solid\"'>
                        $promotionText
                        <div class='thumbnail no-border no-padding'>
                            <div class='col-sm-4' style='margin-top:0;padding-left:3px;padding-right:3px;' >
                                <div class='media'>                                                             
                                    <a class='media-link' id='media-link-$itemID' href='#' data-featherlight='$imageUrl'>
                                        <img src='$imageUrl' alt='' style='max-height:200px;width:auto;$grayImage'/>
                                        <span class='icon-view'>
                                            <strong><i class='fa fa-eye'></i></strong>
                                        </span>
                                    </a>
                                </div>
                            </div>
                            <div class='col-sm-8' style='margin-top:0;padding-top:0' >
                                <h4 style='font-size:12px;color:#000;font-weight:bold;text-align:left;font-family:Arial, Helvetica, sans-serif' class='pointer productCode caption-title' data-value='$itemID' data-product='$itemCodeUrl' data-category='$categoryPathURL'><a href='products/$categoryPathURL$itemCodeUrl'>$name</a></h4>
                                <h6 style='white-space:nowrap;font-size:10px;text-align:left;font-weight:400;font-family:Arial, Helvetica, sans-serif' class='productCode caption-title pointer' data-value='$itemID' data-product='$itemCodeUrl' data-category='$categoryPathURL' >$itemCode</h6>
                                <div style='margin-top:10px'>
                                $stockText
                                </div>
                                $pricesText
                                $stockTextOverAlert
                                $favoriteButton
                                <br> $historyButton
                            </div>
                        </div>
                    </div>";
    }
    else if (strcmp($gridPreference,'categoryGroup')==0){
        if(strcmp($promotionText,"<div style='height:24px;'></div>")==0){$promotionText='';}
        $stockTextOverAlert = str_replace("<div style='height: 20px;'>",'',$stockTextOverAlert);
        $stockTextOverAlert = str_replace("</div>",'',$stockTextOverAlert);
        if(!isset($rowColor) || strcmp("$rowColor",'')==0){$rowColor = 'background-color:whitesmoke;';}
        else {$rowColor = '';}

//        $nameLength = strlen($name);
//        if($nameLength >= 80) {$name = substr($name, 0, 79).'...';}

        if($customerID!=0 || $allowAnonymousOrder) {


            if(strcmp($prevPrice,'<del></del><br>')==0){$prevPrice = '';}
            $prevPrice = str_replace("<br>"," &nbsp;",$prevPrice);

            if($subUnits==1 && $subunitsForce){
                $pricesTextInput = "<input type='number' onkeyup='this.value=this.value.replace(/[^\d]/,\"\")' value='$qty' data-value='$itemID' class='productQtyInput form-control $styleHidden' style='display:inline;width:100px;height:36px;padding:0;text-align:center;border-color:transparent;' $disabledButton/>";
            } else {
                $pricesTextInput = "<input type='number' value='$qty' data-value='$itemID' class='productQtyInput form-control' style='display:inline;width:100px;height:36px;padding:0;text-align:center;border-color:transparent;' $disabledButton/>";
            }

            $pricesText = "<div class='col-sm-12 col-md-12 col-lg-2' style='margin-top:1px;text-align:center;padding:0px;'>
                                <div class='price' style='text-align:right;color:#4682b4;margin: 1px;margin-top: 3px;font-size: 13px;'>$prevPrice$pricing</div>
                           </div>
                           
                           <div class='col-sm-12 col-md-12 col-lg-3' style='margin-top:0;padding:0px;padding-left:10px;' >
                                <center>
                                    $addToCartButton
                                    <div class='buttons' style='width:fit-content;white-space:nowrap;text-align:center;margin-top:1px;$hideButtonsDiv'>
                                        <a class='minusButton pull-left $styleHidden' style='width:20%;margin:0;margin-right:0px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-minus'></i></a>
                                        <a class='plusButton pull-right $styleHidden' style='width:20%;margin:0;margin-left:0px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-plus'></i></a>
                                        $pricesTextInput
                                    </div>
                                </center>
                           </div>";
        }
        else {
            $pricesText ="$anonymousPricesText
                          <div class='buttons pull-right'>
                              <a class='btn btn-theme' style='margin-right:20px;padding: 2px;width:100px' href='products/".$categoryPathURL.$itemCodeUrl."' id='placeOrderButton' $disabledButton>View</a>
                          </div>";
        }

        $result .= "<div class='col-sm-12 categoryGroupLine' id='div$i' style='margin-top:1px;padding:0px;border-bottom: #ddd 1px solid;$rowColor'>
                        <div class='thumbnail no-border no-padding categoryGroupLine'>
                            <div class='col-sm-12 col-md-12 col-lg-6 ' style='margin-top:1px;padding:0px;' >
                                <h4 style='width:100%;padding:0px;padding-left:3px;font-size:12px;color:#000;font-weight:bold;text-align:left;font-family:Arial, Helvetica, sans-serif' class='pointer productCode caption-title pull-left' data-value='$itemID'>
                                    <a href='products/$categoryPathURL$itemCodeUrl' data-product='$itemCodeUrl' data-category='$categoryPathURL'>$name</a>
                                    <div class='pull-right'>$promotionText</div>
                                </h4>
                            </div>
                            <div class='col-sm-12 col-md-12 col-lg-1' style = 'margin-top:1px;padding: 0px 5px;text-align: center' >
                            $stockText
                            </div>
                            $pricesText
                            $stockTextOverAlert
                            $favoriteButton
                            <br> $historyButton
                        </div>
                    </div>";
    }
    else if (strcmp($gridPreference,'categoryVariants')==0) {

        if($customerID!=0 || $allowAnonymousOrder) {

            if(strcmp($prevPrice,'<del></del><br>')==0){$prevPrice = '';}
            $prevPrice = str_replace("<br>"," &nbsp;",$prevPrice);



            if($subUnits==1 && $subunitsForce) {
                $pricesTextInput = "<input type='number' onkeyup='this.value=this.value.replace(/[^\d]/,\"\")' value='$qty' data-value='$itemID' class='productQtyInput form-control $styleHidden' style='display:inline;width:30%;height:40px;text-align:center;padding: 0;border-color: transparent;' $disabledButton/>";
            } else {
                $pricesTextInput = "<input type='number' value='$qty' data-value='$itemID' class='productQtyInput form-control $styleHidden' style='display:inline;width:30%;height:40px;text-align:center;padding: 0;border-color: transparent;' $disabledButton/>";
            }

            $pricesText = "<div class='col-sm-2' style='margin-top:8px;text-align:center'>
                                <div class='price' style='text-align:center;color:#4682b4;margin-bottom:0'>$prevPrice$pricing</div>
                           </div>
                           <div class='col-sm-3' style='margin-top:0px;' >
                                <center style='height: 1px;'>
                                $addToCartButton
                                <div class='buttons text-center' style='border: 1px solid $themeColor;border-radius:3px;width: 150px;$hideButtonsDiv'>
                                    <a class='minusButton pull-left $styleHidden' style='width:20px;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-minus'></i></a>
                                    <a class='plusButton pull-right $styleHidden' style='width:20px;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-plus'></i></a>
                                    $pricesTextInput
                                </div>
                                
                           </div>
                           ";

        }
        else{
            $pricesText ="<div class='col-sm-2' style='margin-top:-20px;text-align:center'> 
                                $anonymousPricesText 
                          </div>
                          <div class='col-sm-3' style='margin-top:8px;' ><div class='buttons'>
                                <a class='btn btn-theme' style='padding: 2px;width:100px' href='products/".$categoryPathURL.$itemCodeUrl."' id='placeOrderButton' $disabledButton>View</a>
                          </div>";
        }

        $result .= "<div class='col-sm-12' id='div$i' style='background-color:$grayBox;margin-top:10px;padding-bottom:5px;border-bottom: #ddd 1px solid'>
                        $promotionText
                        <div class='thumbnail no-border '>
                            <div class='col-sm-1' style='margin-top:0;padding-left:0;padding-right:0' >
                                <div class='media'>
                                    <a class='media-link' id='media-link-$itemID' href='#' data-featherlight='$imageUrl'>
                                        <img src='$imageUrl' alt='' id='media-link-img-$itemID' style='max-height:36px;width:auto;$grayImage'/>
                                        <span class='icon-view'>
                                            <strong><i class='fa fa-eye'></i></strong>
                                        </span>
                                    </a>
                                </div>
                            </div>
                            <div class='col-sm-3' style='margin-top:10px' >
                                <h4 style='font-size:12px;color:#000;font-weight:bold;text-align:center;font-family:Arial, Helvetica, sans-serif' class='pointer productCode caption-title' data-value='$itemID' data-product='$itemCodeUrl' data-category='$categoryPathURL'><a href='./product-details.php?singleVariant=yes&product=$itemCodeUrl'>$name</a></h4>
                            </div>
                            <div class='col-sm-2' style='margin-top:10px' >
                                 <h6 style='white-space:nowrap;font-size:10px;text-align:center;font-weight:400;font-family:Arial, Helvetica, sans-serif' class='productCode caption-title pointer' data-value='$itemID' data-product='$itemCodeUrl' data-category='$categoryPathURL'>$itemCode</h6>
                            </div>
                            $stockTextOverAlert
                            <div class='col-sm-1' style = 'margin-top:10px;padding:1px;text-align: center' >
                                $stockText
                            </div>
                            $pricesText 
                            $favoriteButton
                            <br> $historyButton
                            
                        </div>
                    </div>";
    }
    else {

        if($customerID!=0 || $allowAnonymousOrder) {

            if(strcmp($prevPrice,'<del></del><br>')==0){$prevPrice = '';}
            $prevPrice = str_replace("<br>"," &nbsp;",$prevPrice);

            if($subUnits==1 && $subunitsForce) {
                $pricesTextInput = "<input type='number' onkeyup='this.value=this.value.replace(/[^\d]/,\"\")' value='$qty' data-value='$itemID' class='productQtyInput form-control $styleHidden' style='display:inline;width:30%;height:40px;text-align:center;padding: 0;border-color: transparent;' $disabledButton/>";
            } else {
                $pricesTextInput = "<input type='number' value='$qty' data-value='$itemID' class='productQtyInput form-control $styleHidden' style='display:inline;width:30%;height:40px;text-align:center;padding: 0;border-color: transparent;' $disabledButton/>";
            }

            $pricesText = "<div class='col-sm-2' style='margin-top:5px;text-align:center'>
                               <div class='price' style='text-align:center;color:#4682b4'>$prevPrice$pricing</div>
                           </div>
                                       
                           <div class='col-sm-3' style='margin-top:0' >
                               <center>
                               $addToCartButton
                               <div class='buttons text-center' style='border: 1px solid $themeColor;border-radius:3px;width: 150px;$hideButtonsDiv'>
                                    <a class='minusButton pull-left $styleHidden' style='width:20px;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-minus'></i></a>
                                    <a class='plusButton pull-right $styleHidden' style='width:20px;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-plus'></i></a>
                                    $pricesTextInput
                               </div>
                               </center>
                           </div>";

        }
        else {

            $pricesText ="<div class='col-sm-2' style='margin-top:-11px;text-align:center'> $anonymousPricesText </div>
                          <div class='col-sm-3' style='margin-top:8px;' >
                              <div class='buttons'>
                                  <a class='btn btn-theme' style='padding: 2px;width:100px' href='products/".$categoryPathURL.$itemCodeUrl."' id='placeOrderButton' $disabledButton>View</a>
                              </div>
                          </div>";
        }

        $result .= "<div class='col-sm-12' id='div$i' style='background-color:$grayBox;margin-top:10px;padding-bottom:5px;border-bottom: #ddd 1px solid'>
                        $promotionText
                        <div class='thumbnail no-border '>
                            <div class='col-sm-1' style='margin-top:0;padding-left:0;padding-right:0' >
                                <div class='media'>
                                    <a class='media-link' id='media-link-$itemID' href='#' data-featherlight='$imageUrl'>
                                        <img src='$imageUrl' alt='' id='media-link-img-$itemID' style='max-height:36px;width:auto;$grayImage'/>
                                        <span class='icon-view'>
                                            <strong><i class='fa fa-eye'></i></strong>
                                        </span>
                                    </a>
                                </div>
                           </div>
                           <div class='col-sm-3' style='margin-top:10px' >
                                <h4 style='font-size:12px;color:#000;font-weight:bold;text-align:center;font-family:Arial, Helvetica, sans-serif' class='pointer productCode caption-title' data-value='$itemID' data-product='$itemCodeUrl' data-category='$categoryPathURL'><a href='products/$categoryPathURL$itemCodeUrl'>$name</a></h4>
                           </div>
                           <div class='col-sm-2' style='margin-top:10px' >
                                 <h6 style='white-space:nowrap;font-size:10px;text-align:center;font-weight:400;font-family:Arial, Helvetica, sans-serif' class='productCode caption-title pointer' data-value='$itemID' data-product='$itemCodeUrl' data-category='$categoryPathURL'>$itemCode</h6>	
                           </div>
                           <div class='col-sm-1 text-center' style='margin-top:10px'>
                              $stockText
                           </div>
                           $pricesText
                           $stockTextOverAlert
                           $favoriteButton
                           <br> $historyButton
                        </div>
                     </div>";
    }
}


if($splitSubcategories){
    $result = getNextLevelCategories($categoryID,$cssTheme,$themeColor,$primaryLanguage,$langu['sub_categories_label']).$result;
}

if($addWatermark) {
    $watermarkScript = "<script type='text/javascript'>$watermarks</script>";
}

if(isset($_POST['search'])) {
    $result .= "<script type='text/javascript' > $('#categoriesFilters').html('');</script>";
}

if(strcmp("$categoryID",'')!=0){
    $stm = $db->prepare("SELECT category_code FROM Categories WHERE category_id = ? LIMIT 1");
    $stm->bind_param('i', $categoryID);
    $stm->execute();
    $stm->bind_result($catCode);
    while ($stm->fetch()) {}
    $stm->close();

    if(strcmp("$catCode",'')!=0) {
        $catCode = str_replace(' ','__',$catCode);
        $result .= "<script type='text/javascript' >
                        $.cookie(\"currentCategory\",\"$categoryID\");
                        var uri = window.location.toString();
                        var clean_uri = uri.substring(0, uri.indexOf(\"?\"));
                        if(clean_uri.includes('index.php')){
                            clean_uri = clean_uri.replace('index.php','') + 'catalogue/' + '$catCode';
                        } else {
                            clean_uri = clean_uri + 'catalogue/' + '$catCode';
                        }
                        window.history.replaceState({}, document.title, clean_uri);
                        var selectedFilters = '$selectedFilters';
                        
                        $.ajax({
                            type: 'POST',
                            url: './dbaccess/getCategoriesFilters.php',
                            data: {'category': $categoryID,'selectedFilters':selectedFilters},
                            success: function (result) {
                                $('#categoriesFilters').html(result);
                                $('#categoriesFilters').show();
                            }
                        });
                    </script>";
    }
}

if (!$hasItemResult){
    if(isset($keyword_tokens)) {
        if (is_array($keyword_tokens) && count($keyword_tokens) > 0) {
            $searchInput = implode(" ", $keyword_tokens);
            $searchCount = strlen("$searchInput");
        } else {
            $searchInput = $keyword_tokens;
            $searchCount = strlen("$searchInput");
        }
    } else {
        $searchCount = 0;
    }

}

if (!$hasItemResult){
    echo "<center>
                   <div style='text-align: left;width:fit-content'>
                       <h4 style=''>".$langu['no_products_found_label']."<br></h4>
                   </div>
               </center>";
}

$result .= $tableBottom . $watermarkScript;
echo $result;

function getSubCategoriesID($categoryID){

    global $username,$password,$database;
    $db2 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT Categories.category_id FROM Categories,Subcategories WHERE  Subcategories.category_id =\"$categoryID\" AND Categories.category_id=Subcategories.subcategory_id ORDER BY name");
    $stm2-> execute();
    $stm2-> bind_result($subCategoryID);
    while ($stm2->fetch()) {

        global $username,$password,$database;
        $db3 = new mysqli('localhost',$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $stm3 = $db3->prepare("SELECT COUNT(Categories.category_id) FROM Categories,Subcategories WHERE  Subcategories.category_id =\"$subCategoryID\" AND Categories.category_id=Subcategories.subcategory_id");
        $stm3-> execute();
        $stm3-> bind_result($subCounter);
        while ($stm3->fetch()) {}
        $stm3-> close();

        if(strcmp($subCategoryID,'')!=0){

            $subCategoriesSt.=",$subCategoryID";

            if($subCounter > 0){
                $subCategoriesSt.= getSubCategoriesID($subCategoryID);
            }
        }

    }
    $stm2-> close();

    return $subCategoriesSt;

}

function getNextLevelCategories($categoryID,$cssTheme,$themeColor,$primaryLanguage,$subcategoriesLabel){
    $result = '';
    $resultPrev = '';
    global $username,$password,$database;
    $db2 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT name,description FROM Categories WHERE  Categories.category_id =\"$categoryID\" LIMIT 1");
    $stm2-> execute();
    $stm2-> bind_result($name,$description);
    while ($stm2->fetch()) {
        if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 && isset($description) && strcmp($description,'')!=0 )
        {
            $name=$description;
        }
    }
    $stm2-> close();

    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT Categories.category_id,name,description FROM Categories,Subcategories WHERE  Subcategories.category_id =\"$categoryID\" AND Categories.category_id=Subcategories.subcategory_id ORDER BY name");
    $stm2-> execute();
    $stm2-> bind_result($subCategoryID,$subName,$subDescription);
    while ($stm2->fetch()) {
        if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 && isset($subDescription) && strcmp($subDescription,'')!=0 )
        {
            $subName=$subDescription;
        }
        $result .= "<li class='cop-category' style='padding: 3px 5px 3px 12px;text-transform:capitalize;'>
                        <a style='padding-top:3px;padding-bottom:3px;font-weight:bold;font-size:13px;' class='selectCategoryStandard pointer' data-index='$subCategoryID'><i class='fa' style='background-color:$themeColor;border: 4.7px solid $themeColor; border-radius: 2px;transform: rotate(45deg); '></i class='fa fa-circle-o-notch'>&nbsp;&nbsp;&nbsp;&nbsp;$subName</a>
                    </li>";
    }
    $stm2-> close();

    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT Categories.category_id,name,description FROM Categories,Subcategories WHERE  Subcategories.subcategory_id =\"$categoryID\" AND Categories.category_id=Subcategories.category_id ORDER BY name");
    $stm2-> execute();
    $stm2-> bind_result($prevCategoryID,$prevName,$prevDescription);
    while ($stm2->fetch()) {
        if (strcmp($_SESSION['lang'], $primaryLanguage) != 0 && isset($prevDescription) && strcmp($prevDescription, '') != 0) {
            $prevName = $prevDescription;
        }
        if($prevCategoryID != $categoryID){
            $resultPrev .= "<li class='cop-category' style='padding: 3px 5px 3px 14px;text-transform:capitalize;background-color: $themeColor;color: white;'>
                            <a style='padding-top:3px;padding-bottom:3px;font-weight:bold;font-size:13px;background-color: $themeColor;color: white;' class='selectCategoryStandard pointer' data-index='$prevCategoryID'><i class='fa fa-arrow-left'></i>&nbsp; $prevName</a>
                        </li>";
        }
    }
    $stm2-> close();

    if($cssTheme == 3){
        $themeBorderStyle = 'border-left:0;border-right:0;';
    }

    if(strcmp($resultPrev,'')!=0){
        $resultPrev = "<div class=\"widget shop-categories category-container-outer\" style='border-bottom: 0;$themeBorderStyle' >
                       <div class=\"widget-content\"  >
                       <ul style='text-transform:capitalize;'>".$resultPrev."</ul>
                       </div>
                       </div>
                       <script>
                         $('.selectCategoryStandard').unbind(\"click\").click(function () {
                            var valueCategry = $(this).data(\"index\");
                            var categoryName = $(this).text();
        
                            $('.mainslidersection').css('display','none');
                            if( screen.width <= 480 ) {
                                $('.content-area').css('margin-top', '5px');
                                document.getElementById('productGrid').scrollIntoView();
                            }
                            else
                            {
                                $('.content-area').css('margin-top', '75px');
                            }
        
                            $('#categoryPath').html(\"<i class='fa-fw fa fa-info'></i><b>Catalogue / \" + categoryName + \"</b>\");
                            $('#categoryPath').show();
        
                            $.cookie(\"currentCategoryName\", categoryName);
        
                            $.cookie(\"currentCategory\", valueCategry);
                            $.cookie(\"pageNumber\", 1);
                            getItemsInCategory(valueCategry,1,recordsPerPage);
                            $('#promoCategoriesContainer').show();
                            $(this).parent().find('.arrow').click();
                        });
                        </script>";

    }
    if(strcmp($result,'')!=0){


        $result="
                <div class=\"widget shop-categories category-container-outer\" style='margin-top: 0;$themeBorderStyle' >
                 <h4 class=\"widget-title category-title-custom\" style='background-color: $themeColor;color: white;text-transform: none' >$name $subcategoriesLabel</h4>
                 <div class=\"widget-content\"  >
                 <ul style='text-transform:capitalize;'>".$result."</ul>
                 </div>
                 </div>
                 <script>
                 $('.selectCategoryStandard').unbind(\"click\").click(function () {
                    var valueCategry = $(this).data(\"index\");
                    var categoryName = $(this).text();

                    $('.mainslidersection').css('display','none');
                    if( screen.width <= 480 ) {
                        $('.content-area').css('margin-top', '5px');
                        document.getElementById('productGrid').scrollIntoView();
                    }
                    else
                    {
                        $('.content-area').css('margin-top', '75px');
                    }

                    $('#categoryPath').html(\"<i class='fa-fw fa fa-info'></i><b>Catalogue / \" + categoryName + \"</b>\");
                    $('#categoryPath').show();

                    $.cookie(\"currentCategoryName\", categoryName);

                    $.cookie(\"currentCategory\", valueCategry);
                    $.cookie(\"pageNumber\", 1);
                    getItemsInCategory(valueCategry,1,recordsPerPage);
                    $('#promoCategoriesContainer').show();
                    $(this).parent().find('.arrow').click();
                });
                </script>
                 ";
    }

    return $resultPrev.$result;

}

function getB2BCategories($db){

    $categoriesArray = array();
    $counterOfCategories = 0;
    $categoryID = 0;

    if(isset($_SESSION['userID'])) {
        $user=$_SESSION['userID'];
        $stm = $db->prepare("SELECT COUNT(*) FROM B2B_Allow_Categories_User WHERE b2b_user_id='$user'");
        $stm-> execute();
        $stm-> bind_result($counterOfCategories);
        while ($stm->fetch()) {}
        $stm-> close();
        if($counterOfCategories>0)
        {
            $query="SELECT Categories.category_id FROM Categories INNER JOIN B2B_Allow_Categories_User ON(Categories.category_id=B2B_Allow_Categories_User.category_id) LEFT JOIN B2B_Categories ON (Categories.category_id=B2B_Categories.category_id) WHERE b2b_user_id='$user' ORDER BY B2B_Categories.position,category_code";
        } else {
            $query="SELECT Categories.category_id FROM Categories,B2B_Categories WHERE Categories.category_id=B2B_Categories.category_id ORDER BY B2B_Categories.position,category_code";
        }
    } else {
        $query="SELECT Categories.category_id FROM Categories,B2B_Categories WHERE Categories.category_id=B2B_Categories.category_id AND Categories.category_id > 100 ORDER BY B2B_Categories.position,category_code";
    }

    $stm = $db->prepare($query);
    $stm-> execute();
    $stm-> bind_result($categoryID);
    while ($stm->fetch()) {
        $categoriesArray = array_unique(array_merge($categoriesArray,getSubCategories($categoryID,$categoriesArray)));
    }
    $stm->close();

    return $categoriesArray;
}

function getSubCategories($categoryID,$categoriesArray){

    if(!in_array($categoryID,$categoriesArray)){
        array_push($categoriesArray,$categoryID);
    }

    global $username,$password,$database;
    $db2 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT Categories.category_id FROM Categories,Subcategories WHERE  Subcategories.category_id =\"$categoryID\" AND Categories.category_id=Subcategories.subcategory_id ");
    $stm2-> execute();
    $stm2-> bind_result($subCategoryID);
    while ($stm2->fetch()) {
        if(!in_array($subCategoryID,$categoriesArray)){
            array_push($categoriesArray,$subCategoryID);
            $categoriesArray = array_unique(array_merge($categoriesArray,getSubCategories($subCategoryID,$categoriesArray)));
        }
    }
    $stm2-> close();

    return $categoriesArray;

}

function make_greeklish($text) {
    $expressions = array(
        '/[αΑ][ιίΙΊ]/u' => 'e',
        '/[οΟΕε][ιίΙΊ]/u' => 'i',
        '/[αΑ][υύΥΎ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/u' => 'af$1',
        '/[αΑ][υύΥΎ]/u' => 'av',
        '/[εΕ][υύΥΎ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/u' => 'ef$1',
        '/[εΕ][υύΥΎ]/u' => 'ev',
        '/[οΟ][υύΥΎ]/u' => 'ou',
        '/(^|\s)[μΜ][πΠ]/u' => '$1b',
        '/[μΜ][πΠ](\s|$)/u' => 'b$1',
        '/[μΜ][πΠ]/u' => 'mp',
        '/[νΝ][τΤ]/u' => 'nt',
        '/[τΤ][σΣ]/u' => 'ts',
        '/[τΤ][ζΖ]/u' => 'tz',
        '/[γΓ][γΓ]/u' => 'ng',
        '/[γΓ][κΚ]/u' => 'gk',
        '/[ηΗ][υΥ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/u' => 'if$1',
        '/[ηΗ][υΥ]/u' => 'iu',
        '/[θΘ]/u' => 'th',
        '/[χΧ]/u' => 'ch',
        '/[ψΨ]/u' => 'ps',
        '/[αά]/u' => 'a',
        '/[βΒ]/u' => 'v',
        '/[γΓ]/u' => 'g',
        '/[δΔ]/u' => 'd',
        '/[εέΕΈ]/u' => 'e',
        '/[ζΖ]/u' => 'z',
        '/[ηήΗΉ]/u' => 'i',
        '/[ιίϊΙΊΪ]/u' => 'i',
        '/[κΚ]/u' => 'k',
        '/[λΛ]/u' => 'l',
        '/[μΜ]/u' => 'm',
        '/[νΝ]/u' => 'n',
        '/[ξΞ]/u' => 'x',
        '/[οόΟΌ]/u' => 'o',
        '/[πΠ]/u' => 'p',
        '/[ρΡ]/u' => 'r',
        '/[σςΣ]/u' => 's',
        '/[τΤ]/u' => 't',
        '/[υύϋΥΎΫ]/u' => 'i',
        '/[φΦ]/iu' => 'f',
        '/[ωώ]/iu' => 'o',
    );

    $text = preg_replace( array_keys($expressions), array_values($expressions), $text);
    return $text;
}

function transliterateString($txt) {
    $transliterationTable = array('á' => 'a', 'Á' => 'A', 'à' => 'a', 'À' => 'A', 'ă' => 'a', 'Ă' => 'A', 'â' => 'a', 'Â' => 'A', 'å' => 'a', 'Å' => 'A', 'ã' => 'a', 'Ã' => 'A', 'ą' => 'a', 'Ą' => 'A', 'ā' => 'a', 'Ā' => 'A', 'ä' => 'ae', 'Ä' => 'AE', 'æ' => 'ae', 'Æ' => 'AE', 'ḃ' => 'b', 'Ḃ' => 'B', 'ć' => 'c', 'Ć' => 'C', 'ĉ' => 'c', 'Ĉ' => 'C', 'č' => 'c', 'Č' => 'C', 'ċ' => 'c', 'Ċ' => 'C', 'ç' => 'c', 'Ç' => 'C', 'ď' => 'd', 'Ď' => 'D', 'ḋ' => 'd', 'Ḋ' => 'D', 'đ' => 'd', 'Đ' => 'D', 'ð' => 'dh', 'Ð' => 'Dh', 'é' => 'e', 'É' => 'E', 'è' => 'e', 'È' => 'E', 'ĕ' => 'e', 'Ĕ' => 'E', 'ê' => 'e', 'Ê' => 'E', 'ě' => 'e', 'Ě' => 'E', 'ë' => 'e', 'Ë' => 'E', 'ė' => 'e', 'Ė' => 'E', 'ę' => 'e', 'Ę' => 'E', 'ē' => 'e', 'Ē' => 'E', 'ḟ' => 'f', 'Ḟ' => 'F', 'ƒ' => 'f', 'Ƒ' => 'F', 'ğ' => 'g', 'Ğ' => 'G', 'ĝ' => 'g', 'Ĝ' => 'G', 'ġ' => 'g', 'Ġ' => 'G', 'ģ' => 'g', 'Ģ' => 'G', 'ĥ' => 'h', 'Ĥ' => 'H', 'ħ' => 'h', 'Ħ' => 'H', 'í' => 'i', 'Í' => 'I', 'ì' => 'i', 'Ì' => 'I', 'î' => 'i', 'Î' => 'I', 'ï' => 'i', 'Ï' => 'I', 'ĩ' => 'i', 'Ĩ' => 'I', 'į' => 'i', 'Į' => 'I', 'ī' => 'i', 'Ī' => 'I', 'ĵ' => 'j', 'Ĵ' => 'J', 'ķ' => 'k', 'Ķ' => 'K', 'ĺ' => 'l', 'Ĺ' => 'L', 'ľ' => 'l', 'Ľ' => 'L', 'ļ' => 'l', 'Ļ' => 'L', 'ł' => 'l', 'Ł' => 'L', 'ṁ' => 'm', 'Ṁ' => 'M', 'ń' => 'n', 'Ń' => 'N', 'ň' => 'n', 'Ň' => 'N', 'ñ' => 'n', 'Ñ' => 'N', 'ņ' => 'n', 'Ņ' => 'N', 'ó' => 'o', 'Ó' => 'O', 'ò' => 'o', 'Ò' => 'O', 'ô' => 'o', 'Ô' => 'O', 'ő' => 'o', 'Ő' => 'O', 'õ' => 'o', 'Õ' => 'O', 'ø' => 'oe', 'Ø' => 'OE', 'ō' => 'o', 'Ō' => 'O', 'ơ' => 'o', 'Ơ' => 'O', 'ö' => 'oe', 'Ö' => 'OE', 'ṗ' => 'p', 'Ṗ' => 'P', 'ŕ' => 'r', 'Ŕ' => 'R', 'ř' => 'r', 'Ř' => 'R', 'ŗ' => 'r', 'Ŗ' => 'R', 'ś' => 's', 'Ś' => 'S', 'ŝ' => 's', 'Ŝ' => 'S', 'š' => 's', 'Š' => 'S', 'ṡ' => 's', 'Ṡ' => 'S', 'ş' => 's', 'Ş' => 'S', 'ș' => 's', 'Ș' => 'S', 'ß' => 'SS', 'ť' => 't', 'Ť' => 'T', 'ṫ' => 't', 'Ṫ' => 'T', 'ţ' => 't', 'Ţ' => 'T', 'ț' => 't', 'Ț' => 'T', 'ŧ' => 't', 'Ŧ' => 'T', 'ú' => 'u', 'Ú' => 'U', 'ù' => 'u', 'Ù' => 'U', 'ŭ' => 'u', 'Ŭ' => 'U', 'û' => 'u', 'Û' => 'U', 'ů' => 'u', 'Ů' => 'U', 'ű' => 'u', 'Ű' => 'U', 'ũ' => 'u', 'Ũ' => 'U', 'ų' => 'u', 'Ų' => 'U', 'ū' => 'u', 'Ū' => 'U', 'ư' => 'u', 'Ư' => 'U', 'ü' => 'ue', 'Ü' => 'UE', 'ẃ' => 'w', 'Ẃ' => 'W', 'ẁ' => 'w', 'Ẁ' => 'W', 'ŵ' => 'w', 'Ŵ' => 'W', 'ẅ' => 'w', 'Ẅ' => 'W', 'ý' => 'y', 'Ý' => 'Y', 'ỳ' => 'y', 'Ỳ' => 'Y', 'ŷ' => 'y', 'Ŷ' => 'Y', 'ÿ' => 'y', 'Ÿ' => 'Y', 'ź' => 'z', 'Ź' => 'Z', 'ž' => 'z', 'Ž' => 'Z', 'ż' => 'z', 'Ż' => 'Z', 'þ' => 'th', 'Þ' => 'Th', 'µ' => 'u', 'а' => 'a', 'А' => 'a', 'б' => 'b', 'Б' => 'b', 'в' => 'v', 'В' => 'v', 'г' => 'g', 'Г' => 'g', 'д' => 'd', 'Д' => 'd', 'е' => 'e', 'Е' => 'E', 'ё' => 'e', 'Ё' => 'E', 'ж' => 'zh', 'Ж' => 'zh', 'з' => 'z', 'З' => 'z', 'и' => 'i', 'И' => 'i', 'й' => 'j', 'Й' => 'j', 'к' => 'k', 'К' => 'k', 'л' => 'l', 'Л' => 'l', 'м' => 'm', 'М' => 'm', 'н' => 'n', 'Н' => 'n', 'о' => 'o', 'О' => 'o', 'п' => 'p', 'П' => 'p', 'р' => 'r', 'Р' => 'r', 'с' => 's', 'С' => 's', 'т' => 't', 'Т' => 't', 'у' => 'u', 'У' => 'u', 'ф' => 'f', 'Ф' => 'f', 'х' => 'h', 'Х' => 'h', 'ц' => 'c', 'Ц' => 'c', 'ч' => 'ch', 'Ч' => 'ch', 'ш' => 'sh', 'Ш' => 'sh', 'щ' => 'sch', 'Щ' => 'sch', 'ъ' => '', 'Ъ' => '', 'ы' => 'y', 'Ы' => 'y', 'ь' => '', 'Ь' => '', 'э' => 'e', 'Э' => 'e', 'ю' => 'ju', 'Ю' => 'ju', 'я' => 'ja', 'Я' => 'ja');
    return str_replace(array_keys($transliterationTable), array_values($transliterationTable), $txt);
}

function getCalculatedPrices($fromB2BPriceList,$offerB2BPriceList,$fromB2CPriceList,$offerB2CPriceList,$isB2C,$customerID,$itemID,$qty){

    $prevPrice = 0;
    $price = 0;

    if (isset($fromB2BPriceList) && $fromB2BPriceList > 0 && !$isB2C) {
        $b2bPrice = getDefaultPriceFromPriceType($itemID, $customerID, $fromB2BPriceList, $isB2C, $qty);
    }

    if (isset($offerB2BPriceList) && $offerB2BPriceList > 0 && !$isB2C) {
        $offerB2bPrice = getDefaultPriceFromPriceType($itemID, $customerID, $offerB2BPriceList, $isB2C, $qty);
    }

    if (isset($fromB2CPriceList) && $fromB2CPriceList > 0 && $isB2C) {
        $b2cPrice = getDefaultPriceFromPriceType($itemID, $customerID, $fromB2CPriceList, $isB2C, $qty);
    }

    if (isset($offerB2CPriceList) && $offerB2CPriceList > 0 && $isB2C) {
        $offerB2cPrice = getDefaultPriceFromPriceType($itemID, $customerID, $offerB2CPriceList, $isB2C, $qty);
    }

    if (isset($b2bPrice) && $b2bPrice > 0) {
        $price = $b2bPrice;
    } else if (isset($b2cPrice) && $b2cPrice > 0) {
        $price = $b2cPrice;
    } else {
        $price = getDefaultPrice($itemID, $customerID, '', $qty);
    }

    if (isset($offerB2BPriceList) && $offerB2BPriceList > 0 && !$isB2C) {
        $offerPrice = $offerB2bPrice;
    } else if (isset($offerB2CPriceList) && $offerB2CPriceList > 0 && $isB2C) {
        $offerPrice = $offerB2cPrice;
    } else {
        $offerPrice = $price;
    }

    if ($offerPrice < $price && $offerPrice > 0) {
        $prevPrice = $price;
        $price = $offerPrice;
    } else {
        $defaultPrice = getDefaultPriceFromDefaultPriceType($itemID);
        if ($defaultPrice > $price && $defaultPrice > 0 && !$isB2C) {
            $prevPrice = $defaultPrice;
        }
    }

    $pricingObject = new stdClass();
    $pricingObject->price = $price;
    $pricingObject->prevPrice = $prevPrice;
    return $pricingObject;
}

function getVatPercentageByItemID($db2,$itemID){
    $vatPercent = 0;
    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT Vats.percentage FROM Vats,Items WHERE Vats.vat_id=Items.vat_id AND Items.item_id='$itemID' LIMIT 1");
    $stm2->execute();
    $stm2->bind_result($vatPercent);
    while ($stm2->fetch()) {}
    $stm2->close();

    return intval($vatPercent);
}

function getCustomerActiveContractPriceInfo($db2,$customerID,$itemID,$qty){
    $contractPriceTimestamp = $contractPrice = '';

    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT price,timestamp FROM ContractPrices WHERE item_id= '$itemID' AND customer_id='$customerID' AND DATE(valid_from) <= DATE(NOW()) AND DATE(valid_until) >= DATE(NOW()) GROUP BY customer_id,item_id,min_qty HAVING MIN(min_qty) <= $qty ORDER BY min_qty DESC LIMIT 1");
    $stm2->execute();
    $stm2->bind_result($contractPrice, $contractPriceTimestamp);
    while ($stm2->fetch()) {
        $contractPriceTimestamp = "<div style='color:black;font-weight:normal;font-size:12px;'>Revised: " . date_format(date_create_from_format('Y-m-d H:i:s', $contractPriceTimestamp), 'd/m/Y') . "</div>";
    }
    $stm2->close();

    $contractPriceObj = new stdClass();
    $contractPriceObj->price = $contractPrice;
    $contractPriceObj->timestamp = $contractPriceTimestamp;

    return $contractPriceObj;
}
?>