<?php
session_start();
include_once("../../param.php");
require_once("dbhelper.php");
require_once("../assets/mobiledetect/Mobile_Detect.php");

if(!isset($_SESSION['lang'])) {$_SESSION['lang'] = 'en';}
include_once('../langs/'.$_SESSION['lang'].'.php');

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$db2 = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db2->set_charset("utf8");

$currencySign = getCurrencySign();
$userID = $_SESSION['userID'] ;
$orderID = $_SESSION['orderID'];
$customerID = $_SESSION['customerID'];
$subunitsForce = $_SESSION['subunitsForce'];

$pageNumber = $_POST['pageNumber'];
$numOfItemsInPage = $_POST['numItemsInPage'];
$offset = ($pageNumber-1)*$numOfItemsInPage;

if(!isset($pageNumber) || strcmp("$pageNumber","")==0) {
    $pageNumber = $numOfItemsInPage = 100;
    $offset=0;
}

$extraCredit = false;

$stm = $db->prepare("SELECT product_code_to_show,use_packing,primary_language,show_prices,use_max_stock_on_item,allow_order_over_stock,max_stock_limit,show_prices_with_vat,show_prices_anonymous,b2b_price_list,b2c_price_list,b2b_offer_price_list,b2c_offer_price_list,anonymous_order,use_as_b2c,theme,css_theme,logo_link,show_discount_bubble FROM B2B_Configuration LIMIT 1");
$stm-> execute();
$stm-> bind_result($productShow,$usePacking,$primaryLanguage,$showPrices,$useMaxStock,$allowOrderOverStock,$maxStockLimit,$showPricesIncludingVAT,$showB2BAnonymousPrices,$fromB2BPriceList,$fromB2CPriceList,$offerB2BPriceList,$offerB2CPriceList,$anonymousOrder,$useAsB2C,$themeColor,$cssTheme,$logoLink,$show_discount_bubble);
while ($stm->fetch()) {}
$stm-> close();

$stm = $db->prepare("SELECT recommended_retail_price,numeric_stock,promotion_everywhere,sub_categories_with_items,stock_warning_qty,show_add_to_cart_button,sort_items_by,include_subcategory_products,popular_products_from,show_non_stock_items,category_id_to_load,category_id_to_load_anonymous FROM B2B_Page_Catalogue LIMIT 1");
$stm-> execute();
$stm-> bind_result($recommendedRetailPrice,$numericStock,$promotionsEveryWhere,$sub_categories_with_items,$stockWarningQty,$showAddToCartButton,$orderBySelection,$includeSubcategoryProducts,$popularItemsSelection,$show_non_stock_items,$categoryIDToLoad,$categoryIDToLoadAnonymous);
while ($stm->fetch()) {}
$stm-> close();

$detect = new Mobile_Detect;
if($detect->isMobile()) {
    $gridPreference = "mobile";
    $isMobile = true;
} else if($detect->isTablet()) {
    $gridPreference = "tablet";
    $isMobile = false;
} else {
    $isMobile = false;
}

if(isset($_SESSION['app']) && strcmp($_SESSION['app'],'yes')==0 ) {
    $gridPreference = "app";
}

if(strcmp($sub_categories_with_items,'yes')==0){
    $splitSubcategories = true;
} else {
    $splitSubcategories = false;
}

if(strcmp($showAddToCartButton,'yes')==0){
    $enableAddToCartButton = true;
} else {
    $enableAddToCartButton = false;
}

if(strcmp($useAsB2C,"yes")==0){
    $isB2C = true;
} else {
    $isB2C = false;
}

if(strcmp($anonymousOrder,'yes')==0){
    $allowAnonymousOrder = true;
} else {
    $allowAnonymousOrder = false;
}

if(strcmp($showB2BAnonymousPrices,'yes')==0){
    $showAnonymousPrices = true;
} else {
    $showAnonymousPrices = false;
}

if(strcmp($allowOrderOverStock,"yes")==0) {
    $maxStockAlert=false;
} else {
    $maxStockAlert=true;
}

if(strcmp($useMaxStock,"yes")==0) {
    $useMaxStockOnItems=true;
} else {
    $useMaxStockOnItems=false;
}

if($customerID == 0) {
    if ($showAnonymousPrices) {
        $_SESSION['showPrices'] = true;
    } else {
        $_SESSION['showPrices'] = false;
    }
}

if(strcmp($showPrices,"no")==0) {
    $showPrices=false;
} else if($_SESSION['showPrices']==false) {
    $showPrices=false;
} else {
    $showPrices=true;
}

switch ($showPricesIncludingVAT){
    case 'yes':
        $showPricesWithVAT = true;
        $includeVatOnPrice = true;
        break;
    case 'both':
        $showPricesWithVAT = true;
        $includeVatOnPrice = false;
        break;
    default:
        $showPricesWithVAT = false;
        $includeVatOnPrice = false;
}

switch ("$show_discount_bubble") {
    case "no":
        $showDiscountBubble = false;
        $showPrevPrice = false;
        break;
    case 'bubble':
        $showDiscountBubble = true;
        $showPrevPrice = false;
        break;
    case 'price':
        $showDiscountBubble = false;
        $showPrevPrice = true;
        break;
    default:
        $showDiscountBubble = true;
        $showPrevPrice = true;
}

switch ("$show_non_stock_items") {
    case "no":
        $hideNonStockItems = true;
        $notAvailableNonStockItems = false;
        break;
    case 'notavailable':
        $hideNonStockItems = false;
        $notAvailableNonStockItems = true;
        break;
    default:
        $hideNonStockItems = false;
        $notAvailableNonStockItems = false;
}

switch (strtolower("$themeColor")){
    case '':
        $themeColor = "#6796d3";
        break;
    case 'red':
        $themeColor = "firebrick";
        break;
    case 'darkslateblue':
        $themeColor = "#1d4f9c";
        break;
    case 'navyblue':
        $themeColor = "#000080";
        break;
    case 'black':
        $themeColor="black";
        break;
    case 'gold':
        $themeColor = "goldenrod";
        break;
    case 'yellow':
        $themeColor = "yellow";
        break;
    default:
        if(strpos($themeColor,'#')===false) {
            $themeColor = str_replace('darkdark','dark',"dark$themeColor");
        } else {
            $themeColor = strtolower($themeColor);
        }
}

if(isset( $_POST['gridPreference']) && strcmp($_POST['gridPreference'],"")!=0) {
    $gridPreference = $_POST['gridPreference'];
    $_SESSION['gridPreference'] = $gridPreference;
} else {
    $gridPreference = $_SESSION['gridPreference'];
}

$orderBy = "sellable DESC,item_code";
$orderBy2= "sellable DESC,item_code";
if(isset($_POST['sorting']) && strcmp($_POST['sorting'],"")!=0) {
    $orderBy = 'sellable DESC,'.$_POST['sorting'];
    $orderBy2= 'sellable DESC,'.$_POST['sorting'];
} else if(strcmp($orderBySelection,'Category_Item.position')==0){
    $orderBy2 = "sellable DESC,$orderBySelection";
} else {
    $orderBy = "sellable DESC,$orderBySelection";
    $orderBy2= "sellable DESC,$orderBySelection";
}


$selectedFilters = '';
$filteredItemsQueryFilter = '';
if(isset($_POST['optionFilters']) && count(array_filter($_POST['optionFilters'])) > 0){

    $selectedFilters = implode(',',array_filter($_POST['optionFilters']));

    $filterOptionsArray = implode(',',$_POST['optionFilters']);
    $filterOptionsArray = explode(',',trim($filterOptionsArray));

    $filterRadioArray    = array_filter($filterOptionsArray, function($v) {return strpos($v, 'S-') !== false;});
    $filterCheckboxArray = array_filter($filterOptionsArray, function($v) {return strpos($v, 'M-') !== false;});
    $filterRangesArray   = array_filter($filterOptionsArray, function($v) {return strpos($v, 'R-') !== false;});
    $filterPriceArray    = array_filter($filterOptionsArray, function($v) {return strpos($v, 'P-') !== false;});

    $filteredItemsArray = array();

    if(is_array($filterRadioArray) && count($filterRadioArray) > 0) {

        $filterRadioPerFilterIDArray = array();
        foreach ($filterRadioArray as $filter) {
            $filterElements = explode('-', $filter);
            $filterID = $filterElements[1];
            $filterOptionID = $filterElements[2];
            $filterRadioPerFilterIDArray[$filterID][$filterOptionID] = $filterOptionID;
        }

        foreach ($filterRadioPerFilterIDArray as $filterArray) {

            $filterRadioImplode = implode(',',$filterArray);

            if (count($filteredItemsArray) > 0) {
                $extraFilterImplode = implode(',', $filteredItemsArray);
                $extraFilter = "AND item_id IN ($extraFilterImplode)";
                $filteredItemsArray = array();
            } else {
                $extraFilter = '';
            }

            $stm = $db->prepare("SELECT item_id FROM Filter_Item WHERE filter_option_id IN ($filterRadioImplode) $extraFilter");
            $stm->execute();
            $stm->bind_result($filteredItemID);
            while ($stm->fetch()) {array_push($filteredItemsArray, $filteredItemID);}
            $stm->close();

        }

    }

    if(is_array($filterCheckboxArray) && count($filterCheckboxArray) > 0) {

        $filterCheckboxPerFilterIDArray = array();
        foreach ($filterCheckboxArray as $filter) {
            $filterElements = explode('-', $filter);
            $filterID = $filterElements[1];
            $filterOptionID = $filterElements[2];
            $filterCheckboxPerFilterIDArray[$filterID][$filterOptionID] = $filterOptionID;
        }


        foreach ($filterCheckboxPerFilterIDArray as $filterArray) {

            $filterOptionsImplode = implode(',', $filterArray);

            if (count($filteredItemsArray) > 0) {
                $extraFilterImplode = implode(',', $filteredItemsArray);
                $extraFilter = "AND item_id IN ($extraFilterImplode)";
                $filteredItemsArray = array();
            } else {
                $extraFilter = '';
            }

            $stm = $db->prepare("SELECT item_id FROM Filter_Item WHERE filter_option_id IN ($filterOptionsImplode) $extraFilter");
            $stm->execute();
            $stm->bind_result($filteredItemID);
            while ($stm->fetch()) {array_push($filteredItemsArray, $filteredItemID);}
            $stm->close();

        }
    }

    if(is_array($filterPriceArray) && count($filterPriceArray) > 0){

        $filterPriceElement = reset($filterPriceArray);
        $filterPriceElement = explode('-',$filterPriceElement);

        $filterPriceCategoryID  = $filterPriceElement[1];
        $filterPricePriceTypeID = $filterPriceElement[2];
        $filterPriceFilterID    = $filterPriceElement[3];
        $filterPriceMinPrice    = $filterPriceElement[4];
        $filterPriceMaxPrice    = $filterPriceElement[5];

        if(count($filteredItemsArray) > 0){
            $extraFilter = implode(',',$filteredItemsArray);
            $extraFilter = "AND Category_Item.item_id IN ($extraFilter)";
            $filteredItemsArray = array();
        } else {
            $extraFilter = '';
        }

        $stm = $db->prepare("SELECT Category_Item.item_id FROM Category_Item,Prices WHERE Category_Item.item_id=Prices.item_id AND category_id='$filterPriceCategoryID' AND pricetype_id='$filterPricePriceTypeID' AND price >='$filterPriceMinPrice' AND price <= '$filterPriceMaxPrice' $extraFilter GROUP BY Category_Item.item_id");
        $stm-> execute();
        $stm-> bind_result($filteredItemID);
        while ($stm->fetch()) {array_push($filteredItemsArray,$filteredItemID);}
        $stm->close();


    }

    $filteredItemsImplode = implode(',',$filteredItemsArray);

    if(strcmp($filteredItemsImplode,'')!=0) {
        $filteredItemsQueryFilter = " AND Items.item_id IN ($filteredItemsImplode) ";
    } else {
        $filteredItemsQueryFilter = " AND 0=1 ";
    }
}

if($hideNonStockItems){
    $stm = $db->prepare("SELECT get_stock_from,stock_from_warehouse FROM B2B_Page_Catalogue LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($getStockFrom,$fromWarehouses);
    while ($stm->fetch()) {}
    $stm-> close();

    if(strcmp($getStockFrom,'both')==0){$getStockFrom = "available+reserved";}
    else if(strcmp($getStockFrom,'ignoreReserved')==0){$getStockFrom = "available";}
    else {$getStockFrom = 'available-reserved';}

    if(strcmp($fromWarehouses,'all')==0){$whFilter = "1=1";}
    else if(strcmp($fromWarehouses,'')==0){$whFilter = "1=1";}
    else {$whFilter = " warehouse_id IN($fromWarehouses) ";}

    $filteredItemsQueryFilter .= " AND Items.item_id IN (SELECT item_id FROM Stock WHERE $whFilter GROUP BY item_id HAVING SUM($getStockFrom) > 0 ) ";

}


//$statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items WHERE NOT status='inactive' AND NOT sellable='no' $filteredItemsQueryFilter LIMIT 50";
////$statement = "SELECT Items.item_id,item_code,item_sku,name FROM Items,Item_Images WHERE NOT status='inactive' AND Items.item_id=Item_Images.item_id LIMIT 50";
//$statementCount ="SELECT COUNT(DISTINCT(Items.item_id)) FROM Items LIMIT 50";

if(isset($_POST['category'])) {

    $categoryID = $_POST['category'];

    if(strcmp($categoryID,"1")==0) {

        $categoriesArray = getB2BCategories($db);
        $categoriesStringFilter = implode(',',$categoriesArray);

        if(strcmp("$categoriesStringFilter","")!=0){
            $b2bItemsFilter = " AND Category_id IN ($categoriesStringFilter)";
        } else {
            $b2bItemsFilter = " AND 0=1";
        }

        $statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Category_Item WHERE Items.item_id = Category_Item.item_id AND NOT status='inactive' AND NOT sellable='no' $b2bItemsFilter $filteredItemsQueryFilter ORDER BY $orderBy2 LIMIT $numOfItemsInPage OFFSET $offset";
        $statementCount="SELECT COUNT(*) FROM Category_Item,Items  WHERE NOT status='inactive' AND NOT sellable='no' AND Items.item_id = Category_Item.item_id $b2bItemsFilter $filteredItemsQueryFilter";
    }
    else if(strcmp($categoryID,"2")==0) {

        // ---------------- DELIVERY METHOD ITEMS ----------------
        $deliveryMethodItemsArray = array();
        $stm = $db->prepare("SELECT Category_Item.item_id FROM B2C_Configuration,Category_Item WHERE Category_Item.category_id=B2C_Configuration.delivery_method_category_id");
        $stm-> execute();
        $stm-> bind_result($deliveryMethodItemID);
        while ($stm->fetch()) {array_push($deliveryMethodItemsArray,$deliveryMethodItemID);}
        $stm->close();

        $deliveryMethodItemsImplode = implode(',',$deliveryMethodItemsArray);
        if(strcmp($deliveryMethodItemsImplode,'')!=0){
            $deliveryMethodFilter = " AND Items.item_id NOT IN ($deliveryMethodItemsImplode)";
        }
        // ---------------- DELIVERY METHOD ITEMS/----------------


        $categoriesArray = getB2BCategories($db);
        $allowedCategories = implode(',',$categoriesArray);

        if(strcmp(trim("$allowedCategories"),'')!=0){
            $allowedItemsFilters = " AND Items.item_id IN (SELECT item_id AS item_id FROM Category_Item WHERE category_id IN ($allowedCategories))";
        } else {
            $allowedItemsFilters = " AND 0=1";
        }

        switch($popularItemsSelection) {
            case 1:
                $statement = "SELECT ERP_Popular_Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,ERP_Popular_Items WHERE ERP_Popular_Items.item_id = Items.item_id AND NOT status='inactive' AND NOT sellable='no' AND customer_id='$customerID' $allowedItemsFilters $deliveryMethodFilter $filteredItemsQueryFilter GROUP BY ERP_Popular_Items.item_id ORDER BY COUNT(ERP_Popular_Items.item_id) DESC  LIMIT $numOfItemsInPage OFFSET $offset ";
                $statementCount = "SELECT COUNT(DISTINCT ERP_Popular_Items.item_id) FROM Items,ERP_Popular_Items WHERE ERP_Popular_Items.item_id = Items.item_id AND NOT status='inactive' AND NOT sellable='no' AND customer_id='$customerID' $allowedItemsFilters $deliveryMethodFilter $filteredItemsQueryFilter";
                break;
            case 2:
                $statement = "SELECT Invoice_Item.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Invoice_Item,Invoices WHERE Invoice_Item.item_id = Items.item_id AND Invoices.invoice_id=Invoice_Item.invoice_id AND NOT Items.status='inactive' AND NOT Items.sellable='no' AND customer_id='$customerID' $allowedItemsFilters $deliveryMethodFilter $filteredItemsQueryFilter GROUP BY Invoice_Item.item_id ORDER BY COUNT(Invoice_Item.item_id) DESC  LIMIT $numOfItemsInPage OFFSET $offset ";
                $statementCount = "SELECT COUNT(DISTINCT Invoice_Item.item_id) FROM Items,Invoice_Item,Invoices WHERE Invoice_Item.item_id = Items.item_id AND Invoices.invoice_id=Invoice_Item.invoice_id AND NOT Items.status='inactive' AND NOT Items.sellable='no' AND customer_id='$customerID' $allowedItemsFilters $deliveryMethodFilter $filteredItemsQueryFilter";
                break;
            default:
                $statement = "SELECT Order_Item.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Order_Item,Orders WHERE Order_Item.item_id = Items.item_id AND Orders.order_id=Order_Item.order_id AND NOT Items.status='inactive' AND NOT Items.sellable='no' AND customer_id='$customerID' $allowedItemsFilters $deliveryMethodFilter $filteredItemsQueryFilter GROUP BY Order_Item.item_id ORDER BY COUNT(Order_Item.item_id) DESC  LIMIT $numOfItemsInPage OFFSET $offset ";
                $statementCount = "SELECT COUNT(DISTINCT Order_Item.item_id) FROM Items,Order_Item,Orders WHERE Order_Item.item_id = Items.item_id AND Orders.order_id=Order_Item.order_id AND NOT Items.status='inactive' AND NOT Items.sellable='no' AND customer_id='$customerID' $allowedItemsFilters $deliveryMethodFilter $filteredItemsQueryFilter";

        }


    }
    else if(strcmp($categoryID,"3")==0) {
        $categoryID=5;
        $statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Category_Item WHERE Items.item_id = Category_Item.item_id AND NOT status='inactive' AND NOT sellable='no' AND category_id='$categoryID' $filteredItemsQueryFilter ORDER BY $orderBy2 LIMIT $numOfItemsInPage OFFSET $offset";
        $statementCount="SELECT COUNT(DISTINCT(Items.item_id)) FROM Category_Item,Items  WHERE category_id='$categoryID' AND NOT status='inactive' AND NOT sellable='no' AND Items.item_id = Category_Item.item_id";
    }
    else if(strcmp($categoryID,"5")==0) {
        $categoriesArray = getB2BCategories($db);
        $categoriesStringFilter = implode(',',$categoriesArray);
        $categoryID=5;
        $statement = "SELECT DISTINCT(Items.item_id),item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Category_Item,ContractPrices WHERE Items.item_id = Category_Item.item_id AND Items.item_id=ContractPrices.item_id AND ContractPrices.customer_id='$customerID' AND ContractPrices.valid_from <= CURDATE() AND ContractPrices.valid_until >= CURDATE() AND NOT status='inactive' AND NOT sellable='no' AND category_id IN ($categoriesStringFilter) $filteredItemsQueryFilter ORDER BY $orderBy2 LIMIT $numOfItemsInPage OFFSET $offset";
        $statementCount="SELECT COUNT(DISTINCT(Items.item_id)) FROM Category_Item,Items,ContractPrices  WHERE Items.item_id = Category_Item.item_id AND Items.item_id=ContractPrices.item_id AND ContractPrices.customer_id='$customerID' AND ContractPrices.valid_from <= CURDATE() AND ContractPrices.valid_until >= CURDATE() AND category_id IN ($categoriesStringFilter) AND NOT status='inactive' AND NOT sellable='no'";
    }
    else if(strcmp($categoryID,"12")==0) {

        // ---------------- DELIVERY METHOD ITEMS ----------------
        $deliveryMethodItemsArray = array();
        $stm = $db->prepare("SELECT Category_Item.item_id FROM B2C_Configuration,Category_Item WHERE Category_Item.category_id=B2C_Configuration.delivery_method_category_id");
        $stm-> execute();
        $stm-> bind_result($deliveryMethodItemID);
        while ($stm->fetch()) {array_push($deliveryMethodItemsArray,$deliveryMethodItemID);}
        $stm->close();

        $deliveryMethodItemsImplode = implode(',',$deliveryMethodItemsArray);
        if(strcmp($deliveryMethodItemsImplode,'')!=0){
            $deliveryMethodFilter = " AND Items.item_id NOT IN ($deliveryMethodItemsImplode)";
        }
        // ---------------- DELIVERY METHOD ITEMS/----------------

        $categoryID=12;
        $statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items WHERE timestamp BETWEEN CURDATE() - INTERVAL 30 DAY AND CURDATE() AND NOT status='inactive' AND NOT sellable='no' $deliveryMethodFilter $filteredItemsQueryFilter ORDER BY $orderBy LIMIT $numOfItemsInPage OFFSET $offset";
        $statementCount="SELECT COUNT(DISTINCT(Items.item_id)) FROM Items  WHERE Items.timestamp BETWEEN CURDATE() - INTERVAL 30 DAY AND CURDATE() AND NOT status='inactive' AND NOT sellable='no' $deliveryMethodFilter $filteredItemsQueryFilter";
    }
    else if(strcmp($categoryID,"-12")==0) {
        $categoryID=-12;
        $statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Item_Back_In_Stock WHERE Items.item_id = Item_Back_In_Stock.item_id AND NOT status='inactive' AND NOT sellable='no' AND (back_in_stock_date BETWEEN DATE_SUB(NOW(), INTERVAL 10 DAY) AND NOW()) $filteredItemsQueryFilter ORDER BY $orderBy LIMIT $numOfItemsInPage OFFSET $offset";
        $statementCount="SELECT COUNT(DISTINCT(Items.item_id)) FROM Item_Back_In_Stock,Items  WHERE NOT status='inactive' AND NOT sellable='no' AND Items.item_id = Item_Back_In_Stock.item_id AND (back_in_stock_date BETWEEN DATE_SUB(NOW(), INTERVAL 10 DAY) AND NOW()) $filteredItemsQueryFilter";
    }
    else if(strcmp($categoryID,"-10")==0) {
        $categoryID=-10;
        $statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items WHERE  NOT status='inactive' AND NOT sellable='no' AND category_id='$categoryID' $filteredItemsQueryFilter ORDER BY item_code LIMIT $numOfItemsInPage OFFSET $offset";
        $statementCount="SELECT COUNT(DISTINCT(Items.item_id)) FROM Category_Item,Items  WHERE category_id='$categoryID' AND NOT status='inactive' AND NOT sellable='no' AND Items.item_id = Category_Item.item_id $filteredItemsQueryFilter";
    }
    else if(strcmp($categoryID,"28")==0) {
        $userID=  $_SESSION['userID'] ;
        $statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items INNER JOIN Customer_Favorite_Items ON Items.item_id = Customer_Favorite_Items.item_id AND Customer_Favorite_Items.customer_id = '$customerID' AND Customer_Favorite_Items.user_id = '$userID' WHERE NOT status='inactive' AND NOT sellable='no'  $filteredItemsQueryFilter ORDER BY item_code LIMIT $numOfItemsInPage OFFSET $offset";
        $statementCount = "SELECT COUNT(DISTINCT(Items.item_id)) FROM Items INNER JOIN Customer_Favorite_Items ON Items.item_id = Customer_Favorite_Items.item_id AND Customer_Favorite_Items.customer_id = '$customerID' AND Customer_Favorite_Items.user_id = '$userID' WHERE NOT status='inactive' AND NOT sellable='no' $filteredItemsQueryFilter";
    }
    else {

        if (strcmp($includeSubcategoryProducts, 'yes') == 0) {
            $categories = $categoryID.getSubCategoriesID($categoryID);
            $statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Category_Item WHERE Items.item_id = Category_Item.item_id AND NOT status='inactive' AND NOT sellable='no' AND category_id IN ($categories) $filteredItemsQueryFilter GROUP BY Items.item_id ORDER BY $orderBy2  LIMIT $numOfItemsInPage OFFSET $offset";
            $statementCount="SELECT COUNT(DISTINCT(Items.item_id)) FROM Category_Item,Items  WHERE category_id IN ($categories) AND NOT status='inactive' AND NOT sellable='no' AND Items.item_id = Category_Item.item_id $filteredItemsQueryFilter";
        } else {
            $statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Category_Item WHERE Items.item_id = Category_Item.item_id AND NOT status='inactive' AND NOT sellable='no' AND category_id='$categoryID' $filteredItemsQueryFilter ORDER BY $orderBy2 LIMIT $numOfItemsInPage OFFSET $offset";
            $statementCount = "SELECT COUNT(DISTINCT(Items.item_id)) FROM Category_Item,Items  WHERE category_id='$categoryID' AND NOT status='inactive' AND NOT sellable='no' AND Items.item_id = Category_Item.item_id $filteredItemsQueryFilter";

        }
    }
}
else if(isset($_POST['search'])) {

    if(strcmp(trim(str_replace(' ','',$_POST['text'])),'')==0){return;}

    $text =$_POST['text'];
    $keyword_tokens = trim($_POST['text']);

    //------- Customer Synonyms ----------------
    if($customerID>0){
        $keyword = "%$keyword_tokens%";
        $customerSynonymItems = array();

        $stm = $db->prepare("SELECT DISTINCT(item_id) FROM Customer_Item_Synonyms WHERE customer_id=? AND (code_synonym LIKE ? OR name_synonym LIKE ? )");
        $stm->bind_param('iss', $customerID,$keyword, $keyword);
        $stm->execute();
        $stm->bind_result($customerSynonymItem);
        while ($stm->fetch()) {array_push($customerSynonymItems,$customerSynonymItem);}
        $stm->close();

        $customerSynonymItemsFilter = implode(',',$customerSynonymItems);
        if(strcmp($customerSynonymItemsFilter,'')!=0){$customerSynonymItemsQueryFilter = " Items.item_id IN ($customerSynonymItemsFilter) OR ";}
    }
    //-----------------/Customer Synonyms/--------------------

    $text = str_replace("'","%",$text);
    $keyword_tokens = str_replace("'","%",$keyword_tokens);

    $categorySelect = $_POST['categorySelect'];
    $categoriesArray = getB2BCategories($db);
    $allowedCategories = implode(',',$categoriesArray);

    if(strcmp(trim("$allowedCategories"),'')!=0 && strcmp(trim("$categorySelect"),"")==0){
        $whereCategory = " item_id IN (SELECT item_id AS item_id FROM Category_Item WHERE category_id IN($allowedCategories)) $filteredItemsQueryFilter AND ";
    } else if(strcmp(trim("$categorySelect"),"")!=0 && intval($categorySelect) > 0) {
        $whereCategory=" item_id IN (SELECT item_id AS item_id FROM Category_Item WHERE category_id=\"$categorySelect\") $filteredItemsQueryFilter AND ";
    } else {
        $whereCategory = " 0=1 $filteredItemsQueryFilter AND";
    }

    $keyword_tokens = explode(' ', $keyword_tokens);
    $final_text = implode(' ',$keyword_tokens);

    $statement  = "SELECT item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items WHERE $whereCategory NOT status =\"inactive\" AND NOT sellable=\"no\" $filteredItemsQueryFilter AND( $customerSynonymItemsQueryFilter item_code LIKE '%";
    $statement .= implode("%' AND item_code LIKE '%", $keyword_tokens)    ."%' OR name LIKE '%";
    $statement .= implode("%' AND name LIKE '%", $keyword_tokens) ."%' OR item_sku LIKE '%";
    $statement .= implode("%' AND item_sku LIKE '%", $keyword_tokens) ."%'  OR long_description LIKE '%";
    $statement .= implode("%' AND long_description LIKE '%", $keyword_tokens) ."%'  OR short_description LIKE '%";
    $statement .= implode("%' AND short_description LIKE '%", $keyword_tokens) ."%'";
    $statement .=") ORDER BY CASE";
    $statement.=" WHEN item_code = '$final_text' THEN 1";
    $statement.=" WHEN name = '$final_text' THEN 1";
    $statement.=" WHEN item_sku = '$final_text' THEN 1";
    $statement.=" WHEN item_code LIKE '$final_text%' THEN 2";
    $statement.=" WHEN name LIKE '$final_text%' THEN 2";
    $statement.=" WHEN name LIKE '%$final_text%' THEN 3";
    $statement.=" WHEN short_description LIKE '$final_text%' THEN 2";
    $statement.=" WHEN short_description LIKE '%$final_text%' THEN 3";
    $statement.=" WHEN item_code LIKE '%$final_text%' THEN 3  WHEN item_code LIKE '%";
    $statement .= implode("%'THEN 4 WHEN item_code LIKE '%", $keyword_tokens)."%' THEN 4 ";
    $statement.=" WHEN name LIKE '$final_text%' THEN 2";
    $statement.=" WHEN name LIKE '%$final_text%' THEN 3  WHEN name LIKE '%";
    $statement .= implode("%'THEN 4 WHEN name LIKE '%", $keyword_tokens)."%' THEN 4 ";
    $statement.="  ELSE 6 END,$orderBy LIMIT $numOfItemsInPage OFFSET $offset";

    $statementCount  = "SELECT COUNT(item_id) FROM Items WHERE $whereCategory NOT status =\"inactive\" AND NOT sellable=\"no\" $filteredItemsQueryFilter AND( item_code LIKE '%";
    $statementCount .= implode("%' AND item_code LIKE '%", $keyword_tokens)    ."%' OR name LIKE '%";
    $statementCount .= implode("%' AND name LIKE '%", $keyword_tokens) ."%' OR item_sku LIKE '%";
    $statementCount .= implode("%' AND item_sku LIKE '%", $keyword_tokens) ."%'  OR long_description LIKE '%";
    $statementCount .= implode("%' AND long_description LIKE '%", $keyword_tokens) ."%'  OR short_description LIKE '%";
    $statementCount .= implode("%' AND short_description LIKE '%", $keyword_tokens) ."%'";
    $statementCount .= ") ORDER BY CASE";
    $statementCount .= " WHEN item_code = '$final_text' THEN 1";
    $statementCount .= " WHEN name = '$final_text' THEN 1";
    $statementCount .= " WHEN item_sku = '$final_text' THEN 1";
    $statementCount .= " WHEN item_code LIKE '$final_text%' THEN 2";
    $statementCount .= " WHEN name LIKE '$final_text%' THEN 2";
    $statementCount .= " WHEN name LIKE '%$final_text%' THEN 3";
    $statementCount .= " WHEN item_code LIKE '%$final_text%' THEN 3  WHEN item_code LIKE '%";
    $statementCount .=  implode("%'THEN 4 WHEN item_code LIKE '%", $keyword_tokens)."%' THEN 4 ";
    $statementCount .= " WHEN name LIKE '$final_text%' THEN 2";
    $statementCount .= " WHEN name LIKE '%$final_text%' THEN 3  WHEN name LIKE '%";
    $statementCount .= implode("%'THEN 4 WHEN name LIKE '%", $keyword_tokens)."%' THEN 4 ";
    $statementCount .= "  ELSE 6 END";


}
else if(isset($_POST['advancedSearch'])) {

    $customTableName = $_POST['custTable'];
    $customTable = " INNER JOIN $customTableName ON (Items.item_id=$customTableName.id) ";

    require_once(ROOT . "backend/core/model/CustomTable.php");
    $custTable = new CustomTable('Items');
    $custTableFields = $custTable->getCustomTableB2BFields($_POST['ctid']);

    $categorySelect = $_POST['categorySelect'];
    $categoriesArray = getB2BCategories($db);
    $allowedCategories = implode(',',$categoriesArray);

    if(strcmp("$allowedCategories","")!=0 && strcmp(trim("$categorySelect"),"")==0) {
        $whereCategory = " item_id IN (SELECT item_id AS item_id FROM Category_Item WHERE category_id IN($allowedCategories)) AND ";
    } else if(strcmp(trim("$categorySelect"),"")!=0 && intval($categorySelect) > 0){
        $categoryID = $categorySelect;
        $whereCategory = " item_id IN (SELECT item_id AS item_id FROM Category_Item WHERE category_id=\"$categorySelect\") AND ";
    } else {
        $whereCategory = " 0=1 AND ";
    }

    $statement  = "SELECT item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items $customTable WHERE $whereCategory NOT status =\"inactive\" AND NOT sellable=\"no\" $filteredItemsQueryFilter ";
    $statementCount  = "SELECT COUNT(item_id) FROM Items $customTable WHERE $whereCategory NOT status =\"inactive\" AND NOT sellable=\"no\" ";

    foreach ($custTableFields as $custTableField) {
        if(strcmp($_POST["$custTableField->customTableField"],'')!=0) {
            $statement .= " AND $customTableName.$custTableField->customTableField='" . $_POST["$custTableField->customTableField"] . "' ";
            $statementCount .= " AND $customTableName.$custTableField->customTableField='" . $_POST["$custTableField->customTableField"] . "' ";
        }
    }

    $statement .= " LIMIT $numOfItemsInPage OFFSET $offset";


}
else {
    if(isset($userID) && $userID > 0) {
        $categoryID=$categoryIDToLoad;
    } else {
        $categoryID=$categoryIDToLoadAnonymous;
    }

    $statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Category_Item WHERE Items.item_id = Category_Item.item_id AND NOT status='inactive' AND NOT sellable='no' AND category_id='$categoryID' $filteredItemsQueryFilter ORDER BY Items.sellable DESC,item_code LIMIT $numOfItemsInPage OFFSET $offset";
    $statementCount="SELECT COUNT(DISTINCT(Items.item_id)) FROM Category_Item,Items  WHERE category_id='$categoryID' AND NOT status='inactive' AND NOT sellable='no' AND Items.item_id = Category_Item.item_id $filteredItemsQueryFilter";
}



$stm = $db->prepare("SELECT brand_id,brand_code,brand_name,brand_image_url,brand_link_url,popup_text,slider_position FROM B2B_Brands WHERE (slider_position='grid' OR slider_position='variants')  AND category_id='$categoryID' ORDER BY position ASC");
$stm->execute();
$stm->bind_result($brandID, $brandCode, $brandName, $brandImageUrl, $brandLinkUrl, $popupText,$brandType);
while ($stm->fetch()) {
    $gridSideImage = "<img src='assets/brandslider/$brandImageUrl' alt='' style='height: auto;width: 100%;'/>";
}
$stm->close();

$result= new stdClass();

$stm = $db->prepare($statementCount);
$stm-> execute();
$stm-> bind_result($count);

while ($stm->fetch()) {
    $result->counter=$count;
}
$stm-> close();

if(!isset($count))
{

    $stm2 = $db->prepare("SELECT category_id FROM B2B_Categories WHERE category_id>1000 ORDER BY position LIMIT 1");
    $stm2-> execute();
    $stm2-> bind_result($categoryID);
    while ($stm2->fetch()) {}
    $stm2-> close();

    $statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Category_Item WHERE Items.item_id = Category_Item.item_id AND category_id='$categoryID' LIMIT $numOfItemsInPage OFFSET $offset";
    $statementCount="SELECT COUNT(DISTINCT(Items.item_id)) FROM Category_Item  WHERE category_id='$categoryID'";

    $stm2 = $db->prepare($statementCount);
    $stm2-> execute();
    $stm2-> bind_result($count);

    while ($stm2->fetch()) {
        $result->counter=$count;
    }
    $stm2-> close();

    $result->counter=$count;
}



$testFile=fopen('getItemsStatement.txr', 'w');
fwrite($testFile,"$statement");
fclose($testFile);

$userID=$_SESSION['userID'];
if($userID > 0) {
    $stm = $db->prepare("SELECT B2C_User FROM B2B_User WHERE b2b_user_id='$userID'");
    $stm->execute();
    $stm->bind_result($isB2CUser);
    while ($stm->fetch()) {
    }
    $stm->close();

    if (strcmp("$isB2CUser", "yes") == 0 && $isB2C) {
        $isB2C = true;
    } else {
        $isB2C = false;
    }
}

$addWatermark = false;
$stm = $db->prepare("SELECT watermark_id,file_url,position,opacity FROM B2B_Image_Watermark WHERE watermark_id=1 AND active='yes'");
$stm-> execute();
$stm-> bind_result($watermarkID,$watermarkURL,$watermarkPosition,$watermarkOpacity);
while ($stm->fetch()) {
    if($watermarkID > 0){$addWatermark = true;}
}
$stm->close();

$statementRows = array();
$userFavoriteItems = getUserFavoriteItems($userID,$customerID);
$stm = $db->prepare("$statement");
$stm-> execute();
$stm-> bind_result($itemID,$itemCode,$itemSKU,$name,$shortDescription,$longDescription,$thumbnail_url,$b2bAvailable);
while ($stm->fetch()) {

    $qty = getQtyFromCart($orderID, $itemID);

    $stock = getStock($itemID);

    $subUnits = getSubUnits($itemID);

    $itemPrices = getCalculatedPrices($fromB2BPriceList,$offerB2BPriceList,$fromB2CPriceList,$offerB2CPriceList,$isB2C,$customerID,$itemID,$qty);

    $vatPercent = getVatPercentageByItemID($db2,$itemID);

    $contractPriceTimestamp = $contractPrice = '';
    if ($customerID > 0 && $categoryID == 5) {
        $customerActiveContractPrice = getCustomerActiveContractPriceInfo($db2,$customerID,$itemID,$qty);
        $contractPriceTimestamp = $customerActiveContractPrice->contractPriceTimestamp;
        $contractPrice = $customerActiveContractPrice->contractPrice;
    }

    if(strcmp($usePacking,'yes')==0) {
        $packing = getPacking($itemID);
    } else {
        $packing = 1;
    }


    $itemUOMs = getItemUOMs($orderID,$itemID);
    $uomQty   = 0;
    foreach ($itemUOMs as $uom) {$uomQty = $uom->qty;}
    if($uomQty > 0){$qty = $uomQty;}


    switch ($productShow){
        case 'barcode':$itemCode = $longDescription;break;
        case 'sku':$itemCode = $itemSKU;break;
        case 'none':$itemCode = '';break;
    }

    if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 && isset($shortDescription) && strcmp($shortDescription,'')!=0 ) {
        $name=$shortDescription;
    }

    if($customerID > 0) {
        $itemCode = getCustomerSynonym($customerID,$itemID,'code',$itemCode);
        $name = getCustomerSynonym($customerID,$itemID,'name',$name);
    }

    if(file_exists(ROOT."/media/productImages/$thumbnail_url.jpg")){
        $imageUrl = "//" . HTML_PATH . "/cop/media/productImages/" . $thumbnail_url . ".jpg";
    } else if(file_exists(ROOT."/media/productImages/$thumbnail_url.png")){
        $imageUrl = "//" . HTML_PATH . "/cop/media/productImages/" . $thumbnail_url . ".png";
    } else if(file_exists(ROOT."/media/productImages/$thumbnail_url.gif")){
        $imageUrl = "//" . HTML_PATH . "/cop/media/productImages/" . $thumbnail_url . ".gif";
    } else if(file_exists(".$logoLink")){
        $imageUrl = "$logoLink";
    } else {
        $imageUrl = "./assets/img/noimage.jpg";
    }

    if($notAvailableNonStockItems && $stock <= 0){
        $b2bAvailable = 'notavailable';
    }

    if(strcmp($b2bAvailable,'')==0){
        $b2bAvailable = 'yes';
    }

    $isFavorite = false;
    if (in_array($itemID, $userFavoriteItems)) {
        $isFavorite = true;
    }

    $statementRow = new stdClass();
    $statementRow->itemID = $itemID;
    $statementRow->itemCode = $itemCode;
    $statementRow->itemSKU = $itemSKU;
    $statementRow->name = $name;
    $statementRow->shortDescription = $shortDescription;
    $statementRow->longDescription = $longDescription;
    $statementRow->imageUrl = $imageUrl;
    $statementRow->b2bAvailable = $b2bAvailable;
    $statementRow->price = $itemPrices->price;
    $statementRow->prevPrice = $itemPrices->prevPrice;
    $statementRow->qty = $qty;
    $statementRow->subUnits = $subUnits;
    $statementRow->packing = $packing;
    $statementRow->itemUOMs = $itemUOMs;
    $statementRow->contractPrice = $contractPrice;
    $statementRow->contractPriceTimestamp = $contractPriceTimestamp;
    $statementRow->vatPercent = intval($vatPercent);
    $statementRow->stock = $stock;
    $statementRow->isFavorite = $isFavorite;
    array_push($statementRows,$statementRow);

}
$stm-> close();

if(strcmp(''.$_POST['sortingFilter'],'')==0 && strcmp(''.$_SESSION['sortingFilter'],'')!=0){
    $_POST['sortingFilter'] = $_SESSION['sortingFilter'];
}

if(isset($_POST['sortingFilter']) && strcmp(''.$_POST['sortingFilter'],'')!=0) {
    $_SESSION['sortingFilter'] = $_POST['sortingFilter'];
    switch ($_POST['sortingFilter']){
        case 'priceAsc':
            usort($statementRows, function($a, $b) {
                if($a->b2bAvailable != $b->b2bAvailable){
                    if($a->b2bAvailable > $b->b2bAvailable){return -1;} else {return 1;}
                }
                if(floatval($b->price) < floatval($a->price)){return -1;} else {return 1;}
            });
            break;
        case 'priceDesc':
            usort($statementRows, function($a, $b) {
                if($a->b2bAvailable != $b->b2bAvailable){
                    if($a->b2bAvailable > $b->b2bAvailable){return -1;} else {return 1;}
                }
                if(floatval($a->price) < floatval($b->price)){return -1;} else {return 1;}
            });
            break;
        case 'newest':
            usort($statementRows, function($a, $b) {
                if($a->b2bAvailable != $b->b2bAvailable){
                    if($a->b2bAvailable > $b->b2bAvailable){return -1;} else {return 1;}
                }
                if(floatval($a->itemID) < floatval($b->itemID)){return -1;} else {return 1;}
            });
            break;
        default:
            usort($statementRows, function($a, $b) {
                if($a->b2bAvailable != $b->b2bAvailable){
                    if($a->b2bAvailable > $b->b2bAvailable){return -1;} else {return 1;}
                }
            });
            break;
    }
}




$i = 0;

$result->items= array();
foreach($statementRows as $statementRow) {
    $i++;
    $itemID = $statementRow->itemID;
    $itemCode = $statementRow->itemCode;
    $itemSKU = $statementRow->itemSKU;
    $name = $statementRow->name;
    $shortDescription = $statementRow->shortDescription;
    $longDescription = $statementRow->longDescription;
    $imageUrl = $statementRow->imageUrl;
    $b2bAvailable = $statementRow->b2bAvailable;
    $qty = $statementRow->qty;
    $vatPercent = $statementRow->vatPercent;
    $price = $statementRow->price;
    $prevPrice = $statementRow->prevPrice;
    $packing = $statementRow->packing;
    $itemUOMs = $statementRow->itemUOMs;
    $subUnits = $statementRow->subUnits;
    $stock = $statementRow->stock;
    $isFavorite= $statementRow->isFavorite;



    $notAvalableFlag=false;
    $nonstockFlag=false;
    if(strcmp($b2bAvailable,'notavailable')==0){
        $stock = 0;
        $notAvalableFlag = true;
    } else if(strcmp($b2bAvailable,'nonstock')==0){
        $stock = 0;
        $nonstockFlag=true;
    }

    if($prevPrice > $price && $price > 0 && $showDiscountBubble){
        $percentDiscount = round((1 - ($price/$prevPrice))*100);
    } else {
        $percentDiscount = 0;
    }

    if($showPricesWithVAT) {
        $vat = floatval($price) * ($vatPercent / 100);
        $priceWithVAT =  number_format(floatval($price + $vat),2);
        $prevVat = floatval($prevPrice) * ($vatPercent / 100);
        $prevPriceWithVAT =  number_format(floatval(floatval($prevPrice) + $prevVat),2);
    }

    $price = number_format(floatval($price),2);
    $prevPrice = number_format(floatval($prevPrice),2);

    $showRecommendedRetailPrice = false;
    if(isset($recommendedRetailPrice)&& $recommendedRetailPrice>0) {
        $recommendedRetailPriceDouble=getPriceFromPriceType($itemID,$recommendedRetailPrice);

        if($includeVatOnPrice) {
            $vat = floatval($recommendedRetailPriceDouble) * ($vatPercent / 100);
            $recommendedRetailPriceDouble = floatval($recommendedRetailPriceDouble) + $vat;
        }

        $showRecommendedRetailPrice = true;
        $recommendedRetailPriceFormatted = number_format($recommendedRetailPriceDouble,2);

    } else {
        $recommendedRetailPriceFormatted = number_format(0,2);
    }

    if($useMaxStockOnItems) {
        $itemMaxStock = 0;
        $db2->set_charset("utf8");
        $stm2 = $db2->prepare("SELECT max_stock,vat_id FROM Items WHERE item_id='$itemID' LIMIT 1");
        $stm2->execute();
        $stm2->bind_result($itemMaxStock, $vatID);
        while ($stm2->fetch()) {}
        $stm2->close();
    }

    $maxStock = $stock;
    if($maxStockAlert) {
        if($maxStockLimit > 0 && $maxStockLimit < $stock){
            $maxStock = $maxStockLimit;
        }

        if($useMaxStockOnItems && $maxStock > $itemMaxStock && $itemMaxStock > 0){
            $maxStock = $itemMaxStock;
        }
    }

    if(($customerID!=0 || $allowAnonymousOrder)&&onAfterCartPromotion($itemID,$customerID)&&(strcmp($extraCredit,"yes")==0||strcmp($promotionsEveryWhere,"yes")==0)) {

        $afterCartPromotions = getAvailableAfterCartPromotions($itemID,$customerID);

    } else if(($customerID!=0 || $allowAnonymousOrder)&&onPromotion($itemID,$customerID)&&(strcmp($extraCredit,"yes")==0||strcmp($promotionsEveryWhere,"yes")==0)) {

        $promotions = getAvailablePromotions($itemID,$customerID);

    }



    $stockFlag = false;
    $stockDot = '';
    if($_SESSION['showStock'] == true) {
        if ($customerID > 0 || $allowAnonymousOrder) {
            if (strcmp($numericStock, "yes") == 0) {
                $stockFlag = true;
                if ($stock < $stockWarningQty && $stock > 0) {
                    $stockDot='orange';
                } else if ($stock > 0) {
                    $stockDot='green';
                } else {
                    $stockDot='red';
                }
            } else if (strcmp($numericStock, "dot") == 0) {
                if ($stock < $stockWarningQty && $stock > 0) {
                    $stockDot='orange';
                } else if ($stock > 0) {
                    $stockDot='green';
                } else {
                    $stockDot='red';
                }
            }
        }
    }

    $extraFields = array();
    $extraFields['Packing'] = '';

    $itemForApp=new stdClass();
    $itemForApp->imageUrl=$imageUrl;
    $itemForApp->stock=$stock;
    $itemForApp->notAvalableFlag=$notAvalableFlag;
    $itemForApp->nonstockFlag=$nonstockFlag;
    $itemForApp->percentDiscount=intval($percentDiscount);
    $itemForApp->qty=$qty;
    $itemForApp->subUnits=$subUnits;
    $itemForApp->packing=$packing;
    $itemForApp->name=$name;
    $itemForApp->afterCartPromotions=$afterCartPromotions;
    $itemForApp->promotions=$promotions;
    $itemForApp->itemID=$itemID;
    $itemForApp->itemCode=$itemCode;
    $itemForApp->showStock=$stockFlag;
    $itemForApp->stock=$stock;
    $itemForApp->stockDot=$stockDot;
    $itemForApp->showPrices=$showPrices;
    $itemForApp->maxStockAlert = $maxStockAlert;
    $itemForApp->maxStock = $maxStock;
    $itemForApp->showRecommendedRetailPrice = $showRecommendedRetailPrice;
    $itemForApp->RecommendedRetailPrice = $recommendedRetailPriceFormatted;
    $itemForApp->uoms = $itemUOMs;
    if($showPricesWithVAT && $includeVatOnPrice) {
        $itemForApp->oldPrice=$prevPriceWithVAT;
        $itemForApp->price=$priceWithVAT;
        $itemForApp->priceInclVATLabel = "";
    } else if($showPricesWithVAT && !$includeVatOnPrice) {
        $itemForApp->oldPrice=$prevPrice;
        $itemForApp->price=$price;
        $itemForApp->priceInclVATLabel = "$priceWithVAT";
    } else {
        $itemForApp->oldPrice=$prevPrice;
        $itemForApp->price=$price;
        $itemForApp->priceInclVATLabel = "";
    }
    $itemForApp->contractPricing = getContractPricesPerQty($itemID,$customerID, $userID, $vatPercent, $includeVatOnPrice);
    $itemForApp->isFavorite=$isFavorite;
    $itemForApp->extraFields=$extraFields;


    array_push($result->items,$itemForApp);
}

$result = json_encode($result);
echo $result;



function getSubCategoriesID($categoryID){

    global $username,$password,$database;
    $db2 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT Categories.category_id FROM Categories,Subcategories WHERE  Subcategories.category_id =\"$categoryID\" AND Categories.category_id=Subcategories.subcategory_id ORDER BY name");
    $stm2-> execute();
    $stm2-> bind_result($subCategoryID);
    while ($stm2->fetch()) {

        global $username,$password,$database;
        $db3 = new mysqli('localhost',$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $stm3 = $db3->prepare("SELECT COUNT(Categories.category_id) FROM Categories,Subcategories WHERE  Subcategories.category_id =\"$subCategoryID\" AND Categories.category_id=Subcategories.subcategory_id");
        $stm3-> execute();
        $stm3-> bind_result($subCounter);
        while ($stm3->fetch()) {}
        $stm3-> close();

        if(strcmp($subCategoryID,'')!=0){

            $subCategoriesSt.=",$subCategoryID";

            if($subCounter > 0){
                $subCategoriesSt.= getSubCategoriesID($subCategoryID);
            }
        }

    }
    $stm2-> close();

    return $subCategoriesSt;

}

function getNextLevelCategories($categoryID,$cssTheme,$themeColor,$primaryLanguage,$subcategoriesLabel){
    $result = '';
    $resultPrev = '';
    global $username,$password,$database;
    $db2 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT name,description FROM Categories WHERE  Categories.category_id =\"$categoryID\" LIMIT 1");
    $stm2-> execute();
    $stm2-> bind_result($name,$description);
    while ($stm2->fetch()) {
        if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 && isset($description) && strcmp($description,'')!=0 )
        {
            $name=$description;
        }
    }
    $stm2-> close();

    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT Categories.category_id,name,description FROM Categories,Subcategories WHERE  Subcategories.category_id =\"$categoryID\" AND Categories.category_id=Subcategories.subcategory_id ORDER BY name");
    $stm2-> execute();
    $stm2-> bind_result($subCategoryID,$subName,$subDescription);
    while ($stm2->fetch()) {
        if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 && isset($subDescription) && strcmp($subDescription,'')!=0 )
        {
            $subName=$subDescription;
        }
        $result .= "<li class='cop-category' style='padding: 3px 5px 3px 12px;text-transform:capitalize;'>
                        <a style='padding-top:3px;padding-bottom:3px;font-weight:bold;font-size:13px;' class='selectCategoryStandard pointer' data-index='$subCategoryID'><i class='fa' style='background-color:$themeColor;border: 4.7px solid $themeColor; border-radius: 2px;transform: rotate(45deg); '></i class='fa fa-circle-o-notch'>&nbsp;&nbsp;&nbsp;&nbsp;$subName</a>
                    </li>";
    }
    $stm2-> close();

    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT Categories.category_id,name,description FROM Categories,Subcategories WHERE  Subcategories.subcategory_id =\"$categoryID\" AND Categories.category_id=Subcategories.category_id ORDER BY name");
    $stm2-> execute();
    $stm2-> bind_result($prevCategoryID,$prevName,$prevDescription);
    while ($stm2->fetch()) {
        if (strcmp($_SESSION['lang'], $primaryLanguage) != 0 && isset($prevDescription) && strcmp($prevDescription, '') != 0) {
            $prevName = $prevDescription;
        }
        if($prevCategoryID != $categoryID){
            $resultPrev .= "<li class='cop-category' style='padding: 3px 5px 3px 14px;text-transform:capitalize;background-color: $themeColor;color: white;'>
                            <a style='padding-top:3px;padding-bottom:3px;font-weight:bold;font-size:13px;background-color: $themeColor;color: white;' class='selectCategoryStandard pointer' data-index='$prevCategoryID'><i class='fa fa-arrow-left'></i>&nbsp; $prevName</a>
                        </li>";
        }
    }
    $stm2-> close();

    if($cssTheme == 3){
        $themeBorderStyle = 'border-left:0;border-right:0;';
    }

    if(strcmp($resultPrev,'')!=0){
        $resultPrev = "<div class=\"widget shop-categories category-container-outer\" style='border-bottom: 0;$themeBorderStyle' >
                       <div class=\"widget-content\"  >
                       <ul style='text-transform:capitalize;'>".$resultPrev."</ul>
                       </div>
                       </div>
                       <script>
                         $('.selectCategoryStandard').unbind(\"click\").click(function () {
                            var valueCategry = $(this).data(\"index\");
                            var categoryName = $(this).text();
        
                            $('.mainslidersection').css('display','none');
                            if( screen.width <= 480 ) {
                                $('.content-area').css('margin-top', '5px');
                                document.getElementById('productGrid').scrollIntoView();
                            }
                            else
                            {
                                $('.content-area').css('margin-top', '75px');
                            }
        
                            $('#categoryPath').html(\"<i class='fa-fw fa fa-info'></i><b>Catalogue / \" + categoryName + \"</b>\");
                            $('#categoryPath').show();
        
                            $.cookie(\"currentCategoryName\", categoryName);
        
                            $.cookie(\"currentCategory\", valueCategry);
                            $.cookie(\"pageNumber\", 1);
                            getItemsInCategory(valueCategry,1,recordsPerPage);
                            $('#promoCategoriesContainer').show();
                            $(this).parent().find('.arrow').click();
                        });
                        </script>";

    }
    if(strcmp($result,'')!=0){


        $result="
                <div class=\"widget shop-categories category-container-outer\" style='margin-top: 0;$themeBorderStyle' >
                 <h4 class=\"widget-title category-title-custom\" style='background-color: $themeColor;color: white;text-transform: none' >$name $subcategoriesLabel</h4>
                 <div class=\"widget-content\"  >
                 <ul style='text-transform:capitalize;'>".$result."</ul>
                 </div>
                 </div>
                 <script>
                 $('.selectCategoryStandard').unbind(\"click\").click(function () {
                    var valueCategry = $(this).data(\"index\");
                    var categoryName = $(this).text();

                    $('.mainslidersection').css('display','none');
                    if( screen.width <= 480 ) {
                        $('.content-area').css('margin-top', '5px');
                        document.getElementById('productGrid').scrollIntoView();
                    }
                    else
                    {
                        $('.content-area').css('margin-top', '75px');
                    }

                    $('#categoryPath').html(\"<i class='fa-fw fa fa-info'></i><b>Catalogue / \" + categoryName + \"</b>\");
                    $('#categoryPath').show();

                    $.cookie(\"currentCategoryName\", categoryName);

                    $.cookie(\"currentCategory\", valueCategry);
                    $.cookie(\"pageNumber\", 1);
                    getItemsInCategory(valueCategry,1,recordsPerPage);
                    $('#promoCategoriesContainer').show();
                    $(this).parent().find('.arrow').click();
                });
                </script>
                 ";
    }

    return $resultPrev.$result;

}

function getB2BCategories($db){

    $categoriesArray = array();
    $counterOfCategories = 0;
    $categoryID = 0;

    if(isset($_SESSION['userID'])) {
        $user=$_SESSION['userID'];
        $stm = $db->prepare("SELECT COUNT(*) FROM B2B_Allow_Categories_User WHERE b2b_user_id='$user'");
        $stm-> execute();
        $stm-> bind_result($counterOfCategories);
        while ($stm->fetch()) {}
        $stm-> close();
        if($counterOfCategories>0)
        {
            $query="SELECT Categories.category_id FROM Categories INNER JOIN B2B_Allow_Categories_User ON(Categories.category_id=B2B_Allow_Categories_User.category_id) LEFT JOIN B2B_Categories ON (Categories.category_id=B2B_Categories.category_id) WHERE b2b_user_id='$user' ORDER BY B2B_Categories.position,category_code";
        } else {
            $query="SELECT Categories.category_id FROM Categories,B2B_Categories WHERE Categories.category_id=B2B_Categories.category_id ORDER BY B2B_Categories.position,category_code";
        }
    } else {
        $query="SELECT Categories.category_id FROM Categories,B2B_Categories WHERE Categories.category_id=B2B_Categories.category_id AND Categories.category_id > 100 ORDER BY B2B_Categories.position,category_code";
    }

    $stm = $db->prepare($query);
    $stm-> execute();
    $stm-> bind_result($categoryID);
    while ($stm->fetch()) {
        $categoriesArray = array_unique(array_merge($categoriesArray,getSubCategories($categoryID,$categoriesArray)));
    }
    $stm->close();

    return $categoriesArray;
}

function getSubCategories($categoryID,$categoriesArray){

    if(!in_array($categoryID,$categoriesArray)){
        array_push($categoriesArray,$categoryID);
    }

    global $username,$password,$database;
    $db2 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT Categories.category_id FROM Categories,Subcategories WHERE  Subcategories.category_id =\"$categoryID\" AND Categories.category_id=Subcategories.subcategory_id ");
    $stm2-> execute();
    $stm2-> bind_result($subCategoryID);
    while ($stm2->fetch()) {
        if(!in_array($subCategoryID,$categoriesArray)){
            array_push($categoriesArray,$subCategoryID);
            $categoriesArray = array_unique(array_merge($categoriesArray,getSubCategories($subCategoryID,$categoriesArray)));
        }
    }
    $stm2-> close();

    return $categoriesArray;

}

function make_greeklish($text) {
    $expressions = array(
        '/[αΑ][ιίΙΊ]/u' => 'e',
        '/[οΟΕε][ιίΙΊ]/u' => 'i',
        '/[αΑ][υύΥΎ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/u' => 'af$1',
        '/[αΑ][υύΥΎ]/u' => 'av',
        '/[εΕ][υύΥΎ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/u' => 'ef$1',
        '/[εΕ][υύΥΎ]/u' => 'ev',
        '/[οΟ][υύΥΎ]/u' => 'ou',
        '/(^|\s)[μΜ][πΠ]/u' => '$1b',
        '/[μΜ][πΠ](\s|$)/u' => 'b$1',
        '/[μΜ][πΠ]/u' => 'mp',
        '/[νΝ][τΤ]/u' => 'nt',
        '/[τΤ][σΣ]/u' => 'ts',
        '/[τΤ][ζΖ]/u' => 'tz',
        '/[γΓ][γΓ]/u' => 'ng',
        '/[γΓ][κΚ]/u' => 'gk',
        '/[ηΗ][υΥ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/u' => 'if$1',
        '/[ηΗ][υΥ]/u' => 'iu',
        '/[θΘ]/u' => 'th',
        '/[χΧ]/u' => 'ch',
        '/[ψΨ]/u' => 'ps',
        '/[αά]/u' => 'a',
        '/[βΒ]/u' => 'v',
        '/[γΓ]/u' => 'g',
        '/[δΔ]/u' => 'd',
        '/[εέΕΈ]/u' => 'e',
        '/[ζΖ]/u' => 'z',
        '/[ηήΗΉ]/u' => 'i',
        '/[ιίϊΙΊΪ]/u' => 'i',
        '/[κΚ]/u' => 'k',
        '/[λΛ]/u' => 'l',
        '/[μΜ]/u' => 'm',
        '/[νΝ]/u' => 'n',
        '/[ξΞ]/u' => 'x',
        '/[οόΟΌ]/u' => 'o',
        '/[πΠ]/u' => 'p',
        '/[ρΡ]/u' => 'r',
        '/[σςΣ]/u' => 's',
        '/[τΤ]/u' => 't',
        '/[υύϋΥΎΫ]/u' => 'i',
        '/[φΦ]/iu' => 'f',
        '/[ωώ]/iu' => 'o',
    );

    $text = preg_replace( array_keys($expressions), array_values($expressions), $text);
    return $text;
}

function transliterateString($txt) {
    $transliterationTable = array('á' => 'a', 'Á' => 'A', 'à' => 'a', 'À' => 'A', 'ă' => 'a', 'Ă' => 'A', 'â' => 'a', 'Â' => 'A', 'å' => 'a', 'Å' => 'A', 'ã' => 'a', 'Ã' => 'A', 'ą' => 'a', 'Ą' => 'A', 'ā' => 'a', 'Ā' => 'A', 'ä' => 'ae', 'Ä' => 'AE', 'æ' => 'ae', 'Æ' => 'AE', 'ḃ' => 'b', 'Ḃ' => 'B', 'ć' => 'c', 'Ć' => 'C', 'ĉ' => 'c', 'Ĉ' => 'C', 'č' => 'c', 'Č' => 'C', 'ċ' => 'c', 'Ċ' => 'C', 'ç' => 'c', 'Ç' => 'C', 'ď' => 'd', 'Ď' => 'D', 'ḋ' => 'd', 'Ḋ' => 'D', 'đ' => 'd', 'Đ' => 'D', 'ð' => 'dh', 'Ð' => 'Dh', 'é' => 'e', 'É' => 'E', 'è' => 'e', 'È' => 'E', 'ĕ' => 'e', 'Ĕ' => 'E', 'ê' => 'e', 'Ê' => 'E', 'ě' => 'e', 'Ě' => 'E', 'ë' => 'e', 'Ë' => 'E', 'ė' => 'e', 'Ė' => 'E', 'ę' => 'e', 'Ę' => 'E', 'ē' => 'e', 'Ē' => 'E', 'ḟ' => 'f', 'Ḟ' => 'F', 'ƒ' => 'f', 'Ƒ' => 'F', 'ğ' => 'g', 'Ğ' => 'G', 'ĝ' => 'g', 'Ĝ' => 'G', 'ġ' => 'g', 'Ġ' => 'G', 'ģ' => 'g', 'Ģ' => 'G', 'ĥ' => 'h', 'Ĥ' => 'H', 'ħ' => 'h', 'Ħ' => 'H', 'í' => 'i', 'Í' => 'I', 'ì' => 'i', 'Ì' => 'I', 'î' => 'i', 'Î' => 'I', 'ï' => 'i', 'Ï' => 'I', 'ĩ' => 'i', 'Ĩ' => 'I', 'į' => 'i', 'Į' => 'I', 'ī' => 'i', 'Ī' => 'I', 'ĵ' => 'j', 'Ĵ' => 'J', 'ķ' => 'k', 'Ķ' => 'K', 'ĺ' => 'l', 'Ĺ' => 'L', 'ľ' => 'l', 'Ľ' => 'L', 'ļ' => 'l', 'Ļ' => 'L', 'ł' => 'l', 'Ł' => 'L', 'ṁ' => 'm', 'Ṁ' => 'M', 'ń' => 'n', 'Ń' => 'N', 'ň' => 'n', 'Ň' => 'N', 'ñ' => 'n', 'Ñ' => 'N', 'ņ' => 'n', 'Ņ' => 'N', 'ó' => 'o', 'Ó' => 'O', 'ò' => 'o', 'Ò' => 'O', 'ô' => 'o', 'Ô' => 'O', 'ő' => 'o', 'Ő' => 'O', 'õ' => 'o', 'Õ' => 'O', 'ø' => 'oe', 'Ø' => 'OE', 'ō' => 'o', 'Ō' => 'O', 'ơ' => 'o', 'Ơ' => 'O', 'ö' => 'oe', 'Ö' => 'OE', 'ṗ' => 'p', 'Ṗ' => 'P', 'ŕ' => 'r', 'Ŕ' => 'R', 'ř' => 'r', 'Ř' => 'R', 'ŗ' => 'r', 'Ŗ' => 'R', 'ś' => 's', 'Ś' => 'S', 'ŝ' => 's', 'Ŝ' => 'S', 'š' => 's', 'Š' => 'S', 'ṡ' => 's', 'Ṡ' => 'S', 'ş' => 's', 'Ş' => 'S', 'ș' => 's', 'Ș' => 'S', 'ß' => 'SS', 'ť' => 't', 'Ť' => 'T', 'ṫ' => 't', 'Ṫ' => 'T', 'ţ' => 't', 'Ţ' => 'T', 'ț' => 't', 'Ț' => 'T', 'ŧ' => 't', 'Ŧ' => 'T', 'ú' => 'u', 'Ú' => 'U', 'ù' => 'u', 'Ù' => 'U', 'ŭ' => 'u', 'Ŭ' => 'U', 'û' => 'u', 'Û' => 'U', 'ů' => 'u', 'Ů' => 'U', 'ű' => 'u', 'Ű' => 'U', 'ũ' => 'u', 'Ũ' => 'U', 'ų' => 'u', 'Ų' => 'U', 'ū' => 'u', 'Ū' => 'U', 'ư' => 'u', 'Ư' => 'U', 'ü' => 'ue', 'Ü' => 'UE', 'ẃ' => 'w', 'Ẃ' => 'W', 'ẁ' => 'w', 'Ẁ' => 'W', 'ŵ' => 'w', 'Ŵ' => 'W', 'ẅ' => 'w', 'Ẅ' => 'W', 'ý' => 'y', 'Ý' => 'Y', 'ỳ' => 'y', 'Ỳ' => 'Y', 'ŷ' => 'y', 'Ŷ' => 'Y', 'ÿ' => 'y', 'Ÿ' => 'Y', 'ź' => 'z', 'Ź' => 'Z', 'ž' => 'z', 'Ž' => 'Z', 'ż' => 'z', 'Ż' => 'Z', 'þ' => 'th', 'Þ' => 'Th', 'µ' => 'u', 'а' => 'a', 'А' => 'a', 'б' => 'b', 'Б' => 'b', 'в' => 'v', 'В' => 'v', 'г' => 'g', 'Г' => 'g', 'д' => 'd', 'Д' => 'd', 'е' => 'e', 'Е' => 'E', 'ё' => 'e', 'Ё' => 'E', 'ж' => 'zh', 'Ж' => 'zh', 'з' => 'z', 'З' => 'z', 'и' => 'i', 'И' => 'i', 'й' => 'j', 'Й' => 'j', 'к' => 'k', 'К' => 'k', 'л' => 'l', 'Л' => 'l', 'м' => 'm', 'М' => 'm', 'н' => 'n', 'Н' => 'n', 'о' => 'o', 'О' => 'o', 'п' => 'p', 'П' => 'p', 'р' => 'r', 'Р' => 'r', 'с' => 's', 'С' => 's', 'т' => 't', 'Т' => 't', 'у' => 'u', 'У' => 'u', 'ф' => 'f', 'Ф' => 'f', 'х' => 'h', 'Х' => 'h', 'ц' => 'c', 'Ц' => 'c', 'ч' => 'ch', 'Ч' => 'ch', 'ш' => 'sh', 'Ш' => 'sh', 'щ' => 'sch', 'Щ' => 'sch', 'ъ' => '', 'Ъ' => '', 'ы' => 'y', 'Ы' => 'y', 'ь' => '', 'Ь' => '', 'э' => 'e', 'Э' => 'e', 'ю' => 'ju', 'Ю' => 'ju', 'я' => 'ja', 'Я' => 'ja');
    return str_replace(array_keys($transliterationTable), array_values($transliterationTable), $txt);
}

function getCalculatedPrices($fromB2BPriceList,$offerB2BPriceList,$fromB2CPriceList,$offerB2CPriceList,$isB2C,$customerID,$itemID,$qty){

    $prevPrice = 0;
    $price = 0;

    if (isset($fromB2BPriceList) && $fromB2BPriceList > 0 && !$isB2C) {
        $b2bPrice = getDefaultPriceFromPriceType($itemID, $customerID, $fromB2BPriceList, $isB2C, $qty);
    }

    if (isset($offerB2BPriceList) && $offerB2BPriceList > 0 && !$isB2C) {
        $offerB2bPrice = getDefaultPriceFromPriceType($itemID, $customerID, $offerB2BPriceList, $isB2C, $qty);
    }

    if (isset($fromB2CPriceList) && $fromB2CPriceList > 0 && $isB2C) {
        $b2cPrice = getDefaultPriceFromPriceType($itemID, $customerID, $fromB2CPriceList, $isB2C, $qty);
    }

    if (isset($offerB2CPriceList) && $offerB2CPriceList > 0 && $isB2C) {
        $offerB2cPrice = getDefaultPriceFromPriceType($itemID, $customerID, $offerB2CPriceList, $isB2C, $qty);
    }

    if (isset($b2bPrice) && $b2bPrice > 0) {
        $price = $b2bPrice;
    } else if (isset($b2cPrice) && $b2cPrice > 0) {
        $price = $b2cPrice;
    } else {
        $price = getDefaultPrice($itemID, $customerID, '', $qty);
    }

    if (isset($offerB2BPriceList) && $offerB2BPriceList > 0 && !$isB2C) {
        $offerPrice = $offerB2bPrice;
    } else if (isset($offerB2CPriceList) && $offerB2CPriceList > 0 && $isB2C) {
        $offerPrice = $offerB2cPrice;
    } else {
        $offerPrice = $price;
    }

    if ($offerPrice < $price && $offerPrice > 0) {
        $prevPrice = $price;
        $price = $offerPrice;
    } else {
        $defaultPrice = getDefaultPriceFromDefaultPriceType($itemID);
        if ($defaultPrice > $price && $defaultPrice > 0 && !$isB2C) {
            $prevPrice = $defaultPrice;
        }
    }

    $pricingObject = new stdClass();
    $pricingObject->price = $price;
    $pricingObject->prevPrice = $prevPrice;
    return $pricingObject;
}

function getVatPercentageByItemID($db2,$itemID){
    $vatPercent = 0;
    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT Vats.percentage FROM Vats,Items WHERE Vats.vat_id=Items.vat_id AND Items.item_id='$itemID' LIMIT 1");
    $stm2->execute();
    $stm2->bind_result($vatPercent);
    while ($stm2->fetch()) {}
    $stm2->close();

    return intval($vatPercent);
}

function getCustomerActiveContractPriceInfo($db2,$customerID,$itemID,$qty){
    $contractPriceTimestamp = $contractPrice = '';

    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT price,timestamp FROM ContractPrices WHERE item_id= '$itemID' AND customer_id='$customerID' AND DATE(valid_from) <= DATE(NOW()) AND DATE(valid_until) >= DATE(NOW()) GROUP BY customer_id,item_id,min_qty HAVING MIN(min_qty) <= $qty ORDER BY min_qty DESC LIMIT 1");
    $stm2->execute();
    $stm2->bind_result($contractPrice, $contractPriceTimestamp);
    while ($stm2->fetch()) {
        $contractPriceTimestamp = "<div style='color:black;font-weight:normal;font-size:12px;'>Revised: " . date_format(date_create_from_format('Y-m-d H:i:s', $contractPriceTimestamp), 'd/m/Y') . "</div>";
    }
    $stm2->close();

    $contractPriceObj = new stdClass();
    $contractPriceObj->price = $contractPrice;
    $contractPriceObj->timestamp = $contractPriceTimestamp;

    return $contractPriceObj;
}

function getContractPricesPerQty($itemID,$customerID, $userID, $vatPercentage, $includeVatOnPrice){
    $pricingArray = array();

    if(isset($userID) && $userID > 0){
        $singlePrice = getDefaultPriceInclPriceTypes($itemID,$customerID,false,1);
    } else {
        $singlePrice = getDefaultPriceInclPriceTypes($itemID,$customerID,true,1);
    }

    if($includeVatOnPrice){
        $singlePrice = floatval($singlePrice) + floatval($singlePrice*($vatPercentage/100));
    }

    $singlePrice = number_format(floatval($singlePrice), 2);

    global $username,$password,$database;
    $db2 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");


    $stm2 = $db2->prepare("SELECT min_qty,price FROM ContractPrices WHERE item_id = ? AND (customer_id = ? OR customer_id = 1) AND DATE(valid_from) <= DATE(NOW()) AND DATE(valid_until) >= DATE(NOW()) AND min_qty > 1 ORDER BY min_qty ASC");
    $stm2->bind_param('ii', $itemID,$customerID);
    $stm2-> execute();
    $stm2-> bind_result($minQty,$price);
    while ($stm2->fetch()) {

        if($price > 0) {
            $price = $price / getPriceRate();

            if($includeVatOnPrice){
                $price = floatval($price) + floatval($price*($vatPercentage/100));
            }

            $price = number_format(floatval($price), 2);

            $pricingObject = new stdClass();
            $pricingObject->qty = $minQty;
            $pricingObject->price = $price;
            array_push($pricingArray,$pricingObject);
        }
    }
    $stm2-> close();

    if(count($pricingArray)>0){

        $pricingObject = new stdClass();
        $pricingObject->qty = 1;
        $pricingObject->price = $singlePrice;
        array_push($pricingArray,$pricingObject);

        usort($pricingArray, function($a, $b) {
            return $a->qty - $b->qty;
        });

    }
    return $pricingArray;
}
?>