<?php
session_start();
include_once("../../param.php");
require("dbhelper.php");
$orderID=$_SESSION['orderID'];
$customerID=$_SESSION['customerID'];
$currencySign = getCurrencySign();

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$nonStockItemsQueryFilter = "";
$stm = $db->prepare("SELECT show_non_stock_items,get_stock_from,stock_from_warehouse FROM B2B_Page_Catalogue LIMIT 1");
$stm-> execute();
$stm-> bind_result($show_non_stock_items,$getStockFrom,$fromWarehouses);
while ($stm->fetch()) {
    if(strcmp("$show_non_stock_items","no")==0){
        if(strcmp($getStockFrom,'both')==0){$getStockFrom = "available+reserved";}
        else if(strcmp($getStockFrom,'ignoreReserved')==0){$getStockFrom = "available";}
        else {$getStockFrom = 'available-reserved';}

        if(strcmp($fromWarehouses,'all')==0){$whFilter = "1=1";}
        else if(strcmp($fromWarehouses,'')==0){$whFilter = "1=1";}
        else {$whFilter = " warehouse_id IN($fromWarehouses) ";}

        $nonStockItemsQueryFilter .= " AND Items.item_id IN (SELECT item_id FROM Stock WHERE $whFilter GROUP BY item_id HAVING SUM($getStockFrom) > 0 ) ";
    }
}
$stm-> close();


$statement = "SELECT Items.item_id,item_code,item_sku,Items.name,Items.short_description,long_description,numeric_stock FROM Items,Category_Item,Categories, B2B_Page_Catalogue WHERE NOT status='inactive'
AND Items.item_id=Category_Item.item_id AND Categories.category_id = Category_Item.category_id AND Categories.category_id = popular_products_category $nonStockItemsQueryFilter LIMIT 10";


$result="";

$showPrices=true;

$addWatermark = false;
$stm = $db->prepare("SELECT watermark_id,file_url,position,opacity FROM B2B_Image_Watermark WHERE watermark_id=1 AND active='yes'");
$stm-> execute();
$stm-> bind_result($watermarkID,$watermarkURL,$watermarkPosition,$watermarkOpacity);
while ($stm->fetch()) {
    if($watermarkID > 0){$addWatermark = true;}
}
$stm->close();

$stm = $db->prepare("SELECT logo_link FROM B2B_Configuration LIMIT 1");
$stm-> execute();
$stm-> bind_result($logoLink);
while ($stm->fetch()) {}
$stm->close();

$stm = $db->prepare("SELECT product_code_to_show,use_packing,primary_language,show_prices,use_max_stock_on_item,allow_order_over_stock,max_stock_limit,show_prices_with_vat,show_prices_anonymous,b2b_price_list,b2c_price_list,b2b_offer_price_list,b2c_offer_price_list,anonymous_order,use_as_b2c FROM B2B_Configuration LIMIT 1");
$stm-> execute();
$stm-> bind_result($productShow,$usePacking,$primaryLanguage,$showPrices,$useMaxStock,$allowOrderOverStock,$maxStockLimit,$showPricesIncludingVAT,$showB2BAnonymousPrices,$fromB2BPriceList,$fromB2CPriceList,$offerB2BPriceList,$offerB2CPriceList,$anonymousOrder,$useAsB2C);
while ($stm->fetch()) {

    if(!isset($_SESSION['lang']))
    {
        $_SESSION['lang'] = 'en';
    }

    include('../langs/'.$_SESSION['lang'].'.php');

    if(strcmp($showPrices,"no")==0)
    {
        $showPrices=false;
    }
    if(strcmp($anonymousOrder,'yes')==0){
        $allowAnonymousOrder = true;
        if(strcmp($showB2BAnonymousPrices,'yes')==0 && $customerID == 0) {
            $showPrices = true;
        } else if(strcmp($showB2BAnonymousPrices,'yes')!=0 && $customerID == 0){
            $showPrices = false;
        }
    }

    if(!$allowAnonymousOrder && $customerID == 0 && $showPrices == true && strcmp($showB2BAnonymousPrices,'yes')!=0 ){
        $showPrices = false;
    }

    if(strcmp($useAsB2C,"yes")==0){$isB2C = true;}

    if(strcmp($showB2BAnonymousPrices,'yes')==0){
        $showAnonymousPrices = true;
        $showPrices = true;
    }

    if(strcmp($showPrices,"no")==0 || $showPrices==false)
    {
        $showPrices=false;
    }
    if(strcmp($allowOrderOverStock,"yes")==0)
    {
        $maxStockAlert=false;
    }
    if(strcmp($useMaxStock,"yes")==0)
    {
        $useMaxStockOnItems=true;
    }
    if(strcmp($showPricesIncludingVAT,"yes")==0 || strcmp($showPricesIncludingVAT,"both")==0)
    {
        $showPricesWithVAT=true;
        if(strcmp($showPricesIncludingVAT,"yes")==0){
            $includeVatOnPrice = true;
        }
    }

}
$stm-> close();

$stm = $db->prepare("$statement");
$stm-> execute();
$stm-> bind_result($itemID,$itemCode,$itemSKU,$name,$shortDescription,$longDescription,$numericStock);

$i = 0;

while ($stm->fetch()) {
    $i++;
    $itemCodeUrl = urlencode(str_replace('/','--CP2F--',$itemCode));
    $imageUrl = getDefaultImage($itemID);
//    $price = number_format( getDefaultPrice($itemID,$customerID),2);
    $qty = getQtyFromCart($orderID, $itemID);
    $stock = getStock($itemID);

    if(isset($fromB2BPriceList) && $fromB2BPriceList > 0 && !$isB2C) {
        $b2bPrice = getDefaultPriceFromPriceType($itemID,$customerID, $fromB2BPriceList,$isB2C,$qty);
    }

    if(isset($offerB2BPriceList) && $offerB2BPriceList > 0 && !$isB2C) {
        $offerB2bPrice = getDefaultPriceFromPriceType($itemID,$customerID, $offerB2BPriceList,$isB2C,$qty);
    }

    if(isset($fromB2CPriceList) && $fromB2CPriceList > 0 && $isB2C) {
        $b2cPrice = getDefaultPriceFromPriceType($itemID,$customerID, $fromB2CPriceList,$isB2C,$qty);
    }

    if(isset($offerB2CPriceList) && $offerB2CPriceList > 0 && $isB2C) {
        $offerB2cPrice = getDefaultPriceFromPriceType($itemID,$customerID, $offerB2CPriceList,$isB2C,$qty);
    }

    if(isset($b2bPrice) && $b2bPrice > 0){
        $price =  $b2bPrice;
    } else if(isset($b2cPrice) && $b2cPrice > 0){
        $price =  $b2cPrice;
    } else {
        $price = getDefaultPrice($itemID,$customerID,'',$qty);
    }

    if(isset($offerB2BPriceList) && $offerB2BPriceList > 0 && !$isB2C){
        $offerPrice =  $offerB2bPrice;
    } else if(isset($offerB2CPriceList) && $offerB2CPriceList > 0 && $isB2C){
        $offerPrice =  $offerB2cPrice;
    } else {
        $offerPrice = $price;
    }

    if($offerPrice < $price && $offerPrice > 0){
        $hasOffer = true;
    } else {
        $hasOffer = false;
    }




    if($hasOffer){
        $prevPrice = $price;
        $price = $offerPrice;

    } else {
        $defaultPrice = getDefaultPriceFromDefaultPriceType($itemID);
        if($defaultPrice > $price && $defaultPrice > 0 && !$isB2C){
            $prevPrice = $defaultPrice;
        } else {
            $prevPrice = '';
        }

    }

    if($prevPrice > $price && $price > 0){
        $percentDiscount = round((1 - ($price/$prevPrice))*100);
        $discountLabel = "<span style='height: 24px;vertical-align: top;margin-bottom: 0px;font-size: 17px;padding-top: 1px;border-radius: 10%;' class='pull-right btn-theme'><center>-$percentDiscount%</center></span>";
    } else {
        $discountLabel = "";
    }

    if($showPricesWithVAT) {
        $db2 = new mysqli('localhost',$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        $db2->set_charset("utf8");
        $stm2 = $db2->prepare("SELECT Vats.percentage FROM Vats,Items WHERE Vats.vat_id=Items.vat_id AND Items.item_id='$itemID' LIMIT 1");
        $stm2->execute();
        $stm2->bind_result($vatPercent);
        while ($stm2->fetch()) {
            $vat = (float)$price * ($vatPercent / 100);
            $priceWithVAT =  number_format((float)$price + $vat,2);
            $prevPriceWithVAT =  number_format((float)$prevPrice + $vat,2);
            $inc = $langu['incl_label'];
            $vat = $langu['vat_label'];
            $PriceWithVatText = "<span  style='font-size: 11px;color: #0aa66e '>$currencySign$priceWithVAT &nbsp;$inc $vat</span>";

        }
        $stm2->close();
        if(strcmp($prevPrice,'')!=0 && $prevPrice > 0) {
            if ($includeVatOnPrice) {
                $prevPrice = "<del style='color: gray;'>$currencySign$prevPriceWithVAT</del><br>";
            } else {
                $prevPrice = number_format(floatval($prevPrice),2);
                $prevPrice = "<del style='color: gray;'>$currencySign$prevPrice</del><br>";
            }
        } else {
            $prevPrice = "<del></del><br>";
        }

    } else {
        if(strcmp($prevPrice,'')!=0 && $prevPrice > 0) {
            $prevPrice = number_format(floatval($prevPrice),2);
            $prevPrice = "<del style='color: gray;'>$currencySign$prevPrice</del><br>";
        } else {
            $prevPrice = "<del></del><br>";
        }
    }

    if($showAnonymousPrices){
        if($price > 0) {
            $priceAnonymous = number_format(floatval($price),2);
            $pricing = "$currencySign$priceAnonymous<br>$PriceWithVatText";
            if ($includeVatOnPrice) {
                $pricing = "$currencySign$priceWithVAT";
            }

            $anonymousPricesText = " <div class='price'><ins>$prevPrice$pricing</ins></div>";
        } else {
            if(strcmp($PriceWithVatText,'')!=0){$PriceWithVatText="<br>";}
            $anonymousPricesText = " <div class='price'><ins><br><br>$PriceWithVatText</ins></div>";
        }
    } else {
        $anonymousPricesText = '';
    }

    if($showPrices)
    {
        $price = number_format(floatval($price),2);
        $pricing="$currencySign$price<br>$PriceWithVatText";
        if($includeVatOnPrice){
            $pricing="$currencySign$priceWithVAT";
        }
    }
    else
    {
        $pricing="";
    }


    if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 && isset($shortDescription) && strcmp($shortDescription,'')!=0 )
    {
        $name=$shortDescription;
    }
    if(strcmp($productShow,'barcode')==0)
    {
        $itemCode = $longDescription;
    }
    if(strcmp($productShow,'sku')==0)
    {
        $itemCode = $itemSKU;
    }
    if(strcmp($productShow,'none')==0){
        $itemCode = '<br>';
    }

    if($customerID > 0) {
        $name = getCustomerSynonym($customerID,$itemID,'name',$name);
        $itemCode = getCustomerSynonym($customerID,$itemID,'code',$itemCode);
    }

    if($addWatermark) {


        if(strcmp($watermarkURL,'')==0){$watermarkURL = $logoLink;};
        if(strcmp($watermarkPosition,'')==0){$watermarkPosition = 'center';}
        if(strcmp($watermarkOpacity,'')==0){$watermarkOpacity = '0.5';}
        if(strcmp($imageUrl,'./assets/img/noimage.jpg')!=0) {
            $watermarks .= "
            watermark(['$imageUrl','$watermarkURL'])
            .image(watermark.image.$watermarkPosition($watermarkOpacity))
            .then(function (img) {
                img.id = 'watermark-img-$itemID';
                img.style.cssText = document.getElementById('media-link-img-h-$itemID').style.cssText;
                document.getElementById('media-link-img-h-$itemID').remove();
                document.getElementById('media-link-h-$itemID').appendChild(img);
                document.getElementById('media-link-h-$itemID').href = './products/$itemCodeUrl';
                delete document.getElementById('media-link-h-$itemID').dataset.featherlight;
    
            });
    
            ";
        }

        $imageUrl = './assets/img/noimage.jpg';
    }


        $result = $result . "
                                        <div class='thumbnail no-border no-padding'>
                                            <div class='media'>
                                                <a class='media-link media-link-h-$itemID' href='#' id='media-link-h-$itemID' data-featherlight='$imageUrl'>
                                                        <img src='$imageUrl' alt='' class='media-link-img-h-$itemID' id='media-link-img-h-$itemID' style='width:auto;height:150px;'/>
                                                    <span class='icon-view'>
                                                        <strong><i class='fa fa-eye'></i></strong>
                                                    </span>
                                                </a>
                                            </div>


                                            <div class='caption text-center'>
                                                <input type='hidden' value='$itemID'/>
                                          <h4 style='white-space:nowrap;font-size:14px;color:#000;font-weight:400;' class='pointer productCode caption-title' data-value='$itemID' data-product='$itemCodeUrl' data-category='$categoryPathURL'>$name</h4>
                                                <h6 style='white-space:nowrap;font-size:14px;' class='productCode caption-title pointer' data-value='$itemID' data-product='$itemCodeUrl' data-category='$categoryPathURL'>$itemCode</h6>";

                                               if(!$_SESSION['showStock'] ) {
                                                   $stockText=   "";

                                               }
                                               else
                                               {
                                                   if(strcmp($numericStock,"yes")==0)
                                                   {
                                                       $stockText=   "<h6 style='white-space:nowrap;font-size:14px;color:#008080;font-weight:400;' class='productCode caption-title pointer' data-value='$itemID' data-product='$itemCodeUrl' data-category='$categoryPathURL'>Stock: $stock</h6>";

                                                   }
                                                   else
                                                   {
                                                       if(strcmp($numericStock,"dot")==0) {
                                                           if ($stock > 0) {
                                                               $stockText = "<h6 style='height: 8px;width: 8px;background-color: #008080;border-radius: 50%;display:inline-block;' class='dot'></h6>";
                                                           } else {
                                                               $stockText = "<h6 style='height: 8px;width: 8px;background-color: #b22222;border-radius: 50%;display:inline-block;' class='dot'></h6>";
                                                           }
                                                       }
                                                   }

                                               }


    if($customerID!=0&&$showPrices)
    {
        $priceText = "<div class='price'><ins>$pricing</ins></div>";
    }
    else{
        $priceText = "";
    }

    $result = $result. $stockText.$priceText."

                                                <div class='buttons'>

                                                 <a class='btn btn-theme' style='' href='products/".$itemCodeUrl."' id='placeOrderButton'>View More</a>

                                               </div>
                                            </div>
                                        </div>
                                    ";



}
$stm-> close();
if($i == 1)
{
    $result.= $result;
}

if($addWatermark) {
    $result .= "<!--watermarks-->
    <script type='text/javascript'>
        $watermarks
    </script>

    ";
}
echo $result;
?>