<?php
session_start();
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once("../../param.php");
// DB table to use
$table = 'Tenders';
 
// Table's primary key
$primaryKey = "tender_code";
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`o`.`tender_code`', 'dt' =>  'code', 'field' =>'tender_code' ),
    array( 'db' => '`o`.`tender_date`', 'dt' => 'date' , 'formatter' => function( $d, $row ) {
        return date('d-m-Y',strtotime($d));},'field' => 'tender_date' ),

    array( 'db' => '`o`.`grand_total`', 'dt' => 'grand', 'formatter' => function( $d, $row ) {
        return "&euro;" . strval(number_format(floatval($d),2));},
        'field' => 'grand_total' ),

    array( 'db' => '`o`.`status`', 'dt' =>  'status', 'field' =>'status' ),
    array( 'db' => '`o`.`tender_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {
        return '<form id="'.$d.'"action="viewsingletender.php" method="post">
           		<input type="hidden" name="orderID" value="'.$d.'"><center>
			<button style="font-size:13px;" type="submit" class="btn btn-primary" style="width:60px"><i class="fa fa-edit"></i></button>
			</form>';},
        'field' => 'tender_id' )
);
 
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */

$db2 = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$stm2 = $db2->prepare("SELECT anonymous_checkout_customer_id FROM B2B_Configuration");
$stm2-> execute();
$stm2-> bind_result($anonymousCustomerForCheckoutID);
while ($stm2->fetch()) {}
$stm2-> close();
if(strcmp($anonymousCustomerForCheckoutID,'')==0){$anonymousCustomerForCheckoutID = 0;}


$customerID =$_SESSION['customerID'];
$joinQuery = "FROM `Tenders` AS `o` LEFT JOIN `Customers` AS `c` ON (`o`.`customer_id` = `c`.`customer_id`) LEFT JOIN `SalesPersons` AS `s` ON (`o`.`salesperson_id` = `s`.`salesperson_id`)";
$where = "`o`.`customer_id`='$customerID' AND NOT `o`.`customer_id`='$anonymousCustomerForCheckoutID'";
require( 'ssp2.class.php' );

echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
     );
     
     ?>