<?php
session_start();
include_once("../../param.php");

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */

// DB table to use
$table = 'Service_Call';

// Table's primary key
$primaryKey = "service_call_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`sc`.`service_call_code`', 'dt' =>  'code','formatter' => function( $d, $row ) {
        return "<div align='center'>$d</div>";
    }, 'field' =>'service_call_code' ),
    array( 'db' => '`sc`.`schedule_start_date`', 'dt' =>  'startdate','formatter' => function( $d, $row ) {
        if(strcmp($d,'0000-00-00 00:00:00')!=0){
            $d = date('d-m-Y',strtotime($d));
        } else {$d='';}
        return "<div align='center'>$d</div>";
    }, 'field' =>'schedule_start_date' ),
    array( 'db' => '`sc`.`schedule_end_date`', 'dt' =>  'enddate','formatter' => function( $d, $row ) {
        if(strcmp($d,'0000-00-00 00:00:00')!=0){
            $d = date('d-m-Y',strtotime($d));
        } else {$d='';}
        return "<div align='center'>$d</div>";
    }, 'field' =>'schedule_end_date' ),
    array( 'db' => '`scs`.`status_name`', 'dt' =>  'status','formatter' => function( $d, $row ) {
        return "<div align='center'>$d</div>";
    }, 'field' =>'status_name' ),

    array( 'db' => '`sc`.`topic`', 'dt' => 'projects','formatter' => function( $d, $row ) {
        return "<div align='left'>$d</div>";
    }, 'field' => 'topic' ),

    array( 'db' => '`sc`.`service_call_id`', 'dt' => 'activities', 'formatter' => function( $d, $row ) {

        global $db;

        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT COUNT( DISTINCT service_call_reply_id) FROM Service_Call_Reply WHERE service_call_id = $d ");
        $stm-> execute();
        $stm-> bind_result($projects);
        while ($stm->fetch()) {}
        $stm-> close();
        return "<div align='center'>$projects</div>";
    }, 'field' => 'service_call_id' ),


    array( 'db' => '`sc`.`timestamp`', 'dt' => 'date' , 'formatter' => function( $d, $row ) {
        return "<div align='center'>".date('d-m-Y',strtotime($d));
        },'field' => 'timestamp' ),

    array( 'db' => '`sc`.`service_call_id`', 'dt' => 'form' , 'formatter' => function( $d, $row ) {
        return '<div align="center"><form id="'.$d.'"action="viewsingleservicecall.php" method="post">
                    <input type="hidden" name="serviceCallID" value="'.$d.'">	           			                   
                    <input style="font-size:13px;" type="submit" class="btn btn-primary" value="View" style="width:60px">
                </form></div>';
            },'field' => 'service_call_id' )
);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */


$customerID =$_SESSION['customerID'];
$salesPersonID = $_SESSION['userID'];
$joinQuery = "FROM `Service_Call` AS `sc` LEFT JOIN `SC_Status` AS `scs` ON(`sc`.`status_id`=`scs`.`status_id`) ";
$where = "`sc`.`customer_id`='$customerID' AND NOT `scs`.`status_name`='Closed' AND NOT `scs`.`status_name`='Canceled'";
require( 'ssp2.class.php' );

echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
     );

     ?>