<?php
session_start();
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

//require '../emailer/PHPMailer/Exception.php';
//require '../emailer/PHPMailer/PHPMailer.php';
//require '../emailer/PHPMailer/SMTP.php';

require_once '../emailer/PHPMailer8/vendor/autoload.php';


include_once("../../concc/dbinfo.php");
include_once("dbhelper.php");


$orderID= $_POST["orderID"];
$showPrices = $_POST["showPrices"];

if(isset($showPrices) && strcmp($showPrices,'yes')==0){
    $showPrices = true;
} else {
    $showPrices = false;
}

if(isset($_SESSION['customerID']) && isset($_POST["orderID"]) && $orderID>0) {
    sendEmail($orderID,0,$showPrices);
}


function sendEmail($orderID,$receiptID=0,$showPrices=true)
{
    $myfile = fopen("tttttttt.txt", "w") or die("Unable to open file!");

    global $username;
    global $password;
    global $database;
    $userID        = $_SESSION['userID'];


    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $stm = $db->prepare("SELECT CONCAT(last_name,' ',first_name),email FROM B2B_User WHERE b2b_user_id='$userID' AND b2b_user_id > 0");
    $stm-> execute();
    $stm-> bind_result($userName,$email);
    while ($stm->fetch()) {}
    $stm-> close();

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT email_host, email_from, email_username, email_password, company_name FROM B2B_Configuration");
    $stm-> execute();
    $stm-> bind_result($emailHost,$fromEmail,$emailUsername,$emailPassword,$fromName);
    while ($stm->fetch()) {}
    $stm-> close();

    $stm = $db->prepare("SELECT email_template_id, email_text, cc_emails,email_type FROM B2B_Email_Templates WHERE email_type = 'Quotation Confirmation' AND default_template = 'yes' AND active = 'yes' LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($emailTemplateID, $body, $emailCC, $subject);
    while ($stm->fetch()) {}
    $stm-> close();


    $stm = $db->prepare("SELECT tender_id,tender_code,company_id,customer_id,salesperson_id,tender_date,subtotal,grand_total,vat_amount,discount_amount,print_count,details,status,timestamp FROM Tenders WHERE tender_id='$orderID'");
    $stm-> execute();
    $stm-> bind_result($orderID,$orderCode,$companyID,$customerID,$salespersonID,$orderDate,$subtotal,$grandTotal,$vatAmount,$discountAmount,$printCount,$details,$status,$timestamp);
    while ($stm->fetch()) {
        $db3 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db3->set_charset("utf8");

        $anonymousCheckout = false;
        $stmt3 = $db3->prepare("SELECT anonymous_quotation,anonymous_checkout_customer_id FROM B2B_Configuration");
        $stmt3-> execute();
        $stmt3-> bind_result($anonymousCheckoutCheck,$anonymousCheckoutCustomerID);
        while ($stmt3->fetch()) {
            if(strcmp($anonymousCheckoutCheck,'yes')==0 && $anonymousCheckoutCustomerID == $customerID){
                $anonymousCheckout = true;
            }
        }
        $stmt3->close();


        $customerCode = getCustomerCode1($customerID);
        $customerName = getCustomerName3($customerID);
        $customerAddress =getCustomerAddress1($customerID);
        $date = DateTime::createFromFormat('Y-m-d', $orderDate);
        $orderDate= $date->format('d/m/Y');
        $clientEmail = getCustomerEmail($customerID);


        $subtotal =number_format(floatval($subtotal),2);
        $discountAmount=number_format(floatval($discountAmount),2);
        $vatAmount=number_format(floatval($vatAmount),2);
        $grandTotal=number_format(floatval($grandTotal),2);

        $anonymousCustomerInfo = '';

        if($anonymousCheckout){
            $testFile = fopen('anonymousDetailsTest.txt','w');
            fwrite($testFile,"$details \n ");

            $detailsAndCustomerInfo = explode("\nCustomer: ",$details);
            $details = $detailsAndCustomerInfo[0];

            $customerNameAndCustomerInfo = explode("\nAddress: ",$detailsAndCustomerInfo[1]);
            $customerName = $customerNameAndCustomerInfo[0];
            $userName = $customerNameAndCustomerInfo[0];

            $customerAddressAndCustomerInfo = explode("\nPhone: ",$customerNameAndCustomerInfo[1]);
            $customerAddress = $customerAddressAndCustomerInfo[0];

            $customerPhoneAndCustomerEmail = explode("\nEmail: ",$customerAddressAndCustomerInfo[1]);
            $customerPhone = $customerPhoneAndCustomerEmail[0];
            $email = rtrim($customerPhoneAndCustomerEmail[1],' ');

            $anonymousCustomerInfo = "$customerName<br>$customerAddress<br>Phone: $customerPhone<br>Email: $email";
            fwrite($testFile,"$customerName ($userName) - $customerAddress - $customerPhone - ||$email||");
            fclose($testFile);

            $customerCode = '';
        }

        if($showPrices) {
            $actionDetails = getTender($orderID,$anonymousCheckout,$anonymousCustomerInfo);
        } else {
            $actionDetails = getTenderNoPrices($orderID,$anonymousCheckout,$anonymousCustomerInfo);
        }


        if($emailTemplateID > 0){

        } else {
            $subject = 'Quotation Confirmation';
            $body = $actionDetails;
        }

        $mail = new PHPMailer(true);                              // Passing `true` enables exceptions
        try {

            $mail->SMTPDebug = 0;                                 // Enable verbose debug output
            $mail->isSMTP();                                      // Set mailer to use SMTP
            $mail->Host = $emailHost;                             // Specify main and backup SMTP servers
            $mail->SMTPAuth = true;                               // Enable SMTP authentication
            $mail->Username = $emailUsername;                     // SMTP username
            $mail->Password = $emailPassword;                     // SMTP password
            $mail->SMTPSecure = 'tls';                            // Enable TLS encryption, `ssl` also accepted
            $mail->Port = 587;                                    // TCP port to connect to

            //Recipients
            $mail->setFrom($fromEmail, $fromName);

            if(strcmp($email,'')!=0) {
                $mail->addAddress($email, $customerName);
                $clientEmail = $email;
            } else {
                $mail->addAddress($clientEmail, $customerName);
            }
            $ccArray = explode(';',$emailCC);
            foreach ($ccArray as $cc){
                if(strcmp($cc,'') != 0) {
                    $mail->addCC($cc);
                }
            }


            $body = str_replace("{action_details}"       ,"$actionDetails"      ,"$body");
            $body = str_replace("{action_date}"          ,"$orderDate"          ,"$body");
            $body = str_replace("{grand_total}"          ,"$grandTotal"         ,"$body");
            $body = str_replace("{b2b_user_name}"        ,"$userName"           ,"$body");
            $body = str_replace("{b2b_username}"         ,"$b2bUsername"        ,"$body");
            $body = str_replace("{b2b_user_password}"    ,"$b2bPass"            ,"$body");
            $body = str_replace("{reset_password_link}"  ,"$passwordLink"       ,"$body");
            $body = str_replace("{customer_company_name}","$customerName"       ,"$body");
            $body = str_replace("{customer_code}"        ,"$customerCode"       ,"$body");
            $body = str_replace("{action_code}"          ,"$orderCode"          ,"$body");
            $body = str_replace("{delivery_date}"        ,"$deliveryDate"       ,"$body");

            if (strpos($body, "{company_logo}") !== false) {
                $Companylogo = "<img src='http://".$_SERVER['HTTP_HOST']."/cop/media/pdfimage/logo.png' width='20%' height='20%'>";
                $body = str_replace("{company_logo}","$Companylogo","$body");
            }

            //If Company Name variable exists replace variable
            if (strpos($body, "{company_name}") !== false) {
                $body = str_replace("{company_name}","$fromName","$body");
            }

            $mail->CharSet = 'UTF-8';
            $mail->Encoding = "base64";
            $mail->isHTML(true);                                  // Set email format to HTML
            $mail->Subject = $subject;
            $mail->Body = $body;
            $mail->AltBody = $body;

            $mail->send();



            $docType='Tenders';


            $stmt3 = $db3->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
            $stmt3->bind_param('isss', $orderID,$orderCode,$docType,$clientEmail);
            $stmt3->execute();
            $stmt3->close();

        } catch (Exception $e) {
//        echo 'Message could not be sent.';
//          echo 'Mailer Error: ' . $mail->ErrorInfo;
            fwrite($myfile, $mail->ErrorInfo);
        }







    }
    $stm-> close();


    if($receiptID > 0 && strcmp($receiptID,'')!=0){
        sendReceiptEmail($receiptID);
    }
}

function sendReceiptEmail($receiptID)
{
    $myfile = fopen("ssssss.txt", "w") or die("Unable to open file!");

    global $username;
    global $password;
    global $database;
    $userID        = $_SESSION['userID'];
    $actionDetails = generateReceipt($receiptID);

    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $stm = $db->prepare("SELECT CONCAT(last_name,' ',first_name),email FROM B2B_User WHERE b2b_user_id='$userID'");
    $stm-> execute();
    $stm-> bind_result($userName,$email);
    while ($stm->fetch()) {}
    $stm-> close();

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT email_host, email_from, email_username, email_password, company_name FROM B2B_Configuration");
    $stm-> execute();
    $stm-> bind_result($emailHost,$fromEmail,$emailUsername,$emailPassword,$fromName);
    while ($stm->fetch()) {}
    $stm-> close();

    $stm = $db->prepare("SELECT email_template_id, email_text, cc_emails,email_type FROM B2B_Email_Templates WHERE email_type = 'Receipt Confirmation' AND default_template = 'yes' AND active = 'yes' LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($emailTemplateID, $body, $emailCC, $subject);
    while ($stm->fetch()) {}
    $stm-> close();





    $stm = $db->prepare("SELECT receipt_id,receipt_code,customer_id,company_id,salesperson_id,order_id,invoice_id,address_id,amount,payment_method,cash_discount,bank,branch,cheque_number,cheque_date,receipt_date,notes,status,timestamp FROM Receipts  WHERE receipt_id='$receiptID'");
    $stm-> execute();
    $stm-> bind_result($receiptID,$receiptCode,$customerID,$companyID,$salespersonID,$orderID,$invoiceID,$addressID,$amount,$paymentMethod,$cashDiscount,$bank,$branch,$chequeNumber,$chequeDate,$receiptDate,$notes,$status,$timestamp);
    while ($stm->fetch()) {
        //$docCounter++;
        $headers="";

        $customerCode = getCustomerCode1($customerID);
        $customerName = getCustomerName3($customerID);
        $customerAddress =getCustomerAddress1($customerID);
        $date = DateTime::createFromFormat('Y-m-d', $receiptDate);
        $orderDate= $date->format('d/m/Y');
        $clientEmail = getCustomerEmail($customerID);


        $amount = number_format(floatval($amount),'2','.',',');
        $cashDiscount = number_format(floatval($cashDiscount),'2','.',',');


        $mail = new PHPMailer(true);                              // Passing `true` enables exceptions
        try {

            $mail->SMTPDebug = 0;                                 // Enable verbose debug output
            $mail->isSMTP();                                      // Set mailer to use SMTP
            $mail->Host = $emailHost;  // Specify main and backup SMTP servers
            $mail->SMTPAuth = true;                               // Enable SMTP authentication
            $mail->Username = $emailUsername;                 // SMTP username
            $mail->Password = $emailPassword;                           // SMTP password
            $mail->SMTPSecure = 'tls';                            // Enable TLS encryption, `ssl` also accepted
            $mail->Port = 587;                                    // TCP port to connect to

            //Recipients
            $mail->setFrom($fromEmail, $fromName);

            if(strcmp($email,'')!=0) {
                $mail->addAddress($email, $customerName);
            } else {
                $mail->addAddress($clientEmail, $customerName);
            }
            $ccArray = explode(';',$emailCC);
            foreach ($ccArray as $cc){
                if(strcmp($cc,'') != 0) {
                    $mail->addCC($cc);
                }
            }


            $body = str_replace("{action_details}"       ,"$actionDetails"      ,"$body");
            $body = str_replace("{action_date}"          ,"$receiptDate"        ,"$body");
            $body = str_replace("{grand_total}"          ,"$amount"             ,"$body");
            $body = str_replace("{b2b_user_name}"        ,"$userName"           ,"$body");
            $body = str_replace("{b2b_username}"         ,"$b2bUsername"        ,"$body");
            $body = str_replace("{b2b_user_password}"    ,"$b2bPass"            ,"$body");
            $body = str_replace("{reset_password_link}"  ,"$passwordLink"       ,"$body");
            $body = str_replace("{customer_company_name}","$customerName"       ,"$body");
            $body = str_replace("{customer_code}"        ,"$customerCode"       ,"$body");
            $body = str_replace("{action_code}"          ,"$receiptCode"        ,"$body");

            if (strpos($body, "{company_logo}") !== false) {
                $Companylogo = "<img src='http://".$_SERVER['HTTP_HOST']."/cop/media/pdfimage/logo.png' width='20%' height='20%'>";
                $body = str_replace("{company_logo}","$Companylogo","$body");
            }

            //If Company Name variable exists replace variable
            if (strpos($body, "{company_name}") !== false) {
                $body = str_replace("{company_name}","$fromName","$body");
            }

            $mail->CharSet = 'UTF-8';
            $mail->Encoding = "base64";
            $mail->isHTML(true);                                  // Set email format to HTML
            $mail->Subject = $subject;
            $mail->Body = $body;
            $mail->AltBody = $body;

            $mail->send();



            $docType='Receipts';

            $db3 = new mysqli(localhost, $username, $password, $database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $db3->set_charset("utf8");
            $stmt3 = $db3->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
            $stmt3->bind_param('isss', $orderID,$orderCode,$docType,$clientEmail);
            $stmt3->execute();
            $stmt3->close();
            // }
        } catch (Exception $e) {
//        echo 'Message could not be sent.';
//          echo 'Mailer Error: ' . $mail->ErrorInfo;
            fwrite($myfile, $mail->ErrorInfo);
        }







    }
    $stm-> close();

}

function getCustomerCode1($customerID) {
    global $username;
    global $password;
    global $database;

    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT customer_code FROM Customers WHERE customer_id ='$customerID'");
    $stm1-> execute();
    $stm1-> bind_result($customerCode);
    while ($stm1->fetch()) {
        return $customerCode;
    }
    $stm1->close();
    return $customerCode;


}

function getCustomerName3($customerID) {
    global $username;
    global $password;
    global $database;

    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT customer_company_name FROM Customers WHERE customer_id ='$customerID'");
    $stm1-> execute();
    $stm1-> bind_result($customerCode);
    while ($stm1->fetch()) {
        return $customerCode;
    }
    $stm1->close();
    return $customerCode;


}

function getItemCode1($itemID) {
    global $username;
    global $password;
    global $database;

    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT item_code FROM Items WHERE item_id='$itemID'");
    $stm1-> execute();
    $stm1-> bind_result($code);
    while ($stm1->fetch()) {
        return $code;
    }
    $stm1->close();
    return $code;


}
function getItemName($itemID) {
    global $username;
    global $password;
    global $database;

    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT name FROM Items WHERE item_id='$itemID'");
    $stm1-> execute();
    $stm1-> bind_result($code);
    while ($stm1->fetch()) {
        return $code;
    }
    $stm1->close();
    return $code;


}

function getItemLong($itemID) {
    global $username;
    global $password;
    global $database;

    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT long_description FROM Items WHERE item_id='$itemID'");
    $stm1-> execute();
    $stm1-> bind_result($code);
    while ($stm1->fetch()) {
        return $code;
    }
    $stm1->close();
    return $code;


}


function getCustomerAddress1($customerID) {
    global $username;
    global $password;
    global $database;

    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT address_line_1,address_line_2,city FROM CustomerAddress WHERE customer_id='$customerID'");
    $stm1-> execute();
    $stm1-> bind_result($addressLine1,$addressLine2,$city);
    while ($stm1->fetch()) {
        return $addressLine1."  ".$addressLine2."  ".$city;
    }
    $stm1->close();
    return $code;


}

function getCustomerEmail($customerID) {
    global $username;
    global $password;
    global $database;

    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT email FROM Customers WHERE customer_id ='$customerID'");
    $stm1-> execute();
    $stm1-> bind_result($customerCode);
    while ($stm1->fetch()) {
        return $customerCode;
    }
    $stm1->close();
    return $customerCode;


}

function getTender($tenderID,$anonymous,$anonymousInfo)
{
    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $addItemByUnits = true;
    $stm = $db->prepare("SELECT order_qty_by_subunits FROM B2B_Configuration");
    $stm->execute();
    $stm->bind_result($orderQtyBySubunits);
    while ($stm->fetch()) {
        if(strcmp($orderQtyBySubunits,'yes')==0){
            $addItemByUnits = false;
        }
    }
    $stm->close();

    $stm = $db->prepare("SELECT tender_code,tender_date,valid_until,subtotal,grand_total,vat_amount,customer_id,company_id FROM Tenders WHERE tender_id='$tenderID'");
    $stm->execute();
    $stm->bind_result($orderCode, $orderDate,$validUntil, $subtotal, $grandTotal, $vatAmount,$customerID,$companyID);

    while ($stm->fetch()) {


    }
    $stm->close();

    $orderDate = date_format( date_create_from_format('Y-m-d', $orderDate), 'd-m-Y');
    $validUntil = date_format( date_create_from_format('Y-m-d', $validUntil), 'd-m-Y');

    $subtotal = number_format(floatval($subtotal),2);
    $grandTotal = number_format(floatval($grandTotal),2);
    $vatAmount = number_format(floatval($vatAmount),2);


//    $stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies WHERE company_id='$companyID'");
//    $stm->execute();
//    $stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);
//
//    while ($stm->fetch()) {
//        if(strcmp($line1,'')!=0){$line1 .="<br>";}
//        if(strcmp($line2,'')!=0){$line2 .="<br>";}
//        if(strcmp($line3,'')!=0){$line3 .="<br>";}
//        if(strcmp($line4,'')!=0){$line4 .="<br>";}
//        if(strcmp($line5,'')!=0){$line5 .="<br>";}
//        if(strcmp($line6,'')!=0){$line6 .="<br>";}
//
//    }
//    $stm->close();


    $stm = $db->prepare("SELECT customer_code,customer_company_name FROM Customers WHERE customer_id='$customerID'");
    $stm->execute();
    $stm->bind_result($customerCode, $customerName);

    while ($stm->fetch()) {


    }
    $stm->close();

    if($anonymous){
        $customerName = 'Customer';
        $customerCode =$anonymousInfo;
    } else {
        $stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,city,landline FROM CustomerAddress WHERE customer_id='$customerID' AND primary_address='yes'");
        $stm->execute();
        $stm->bind_result($addressLine1, $addressLine2, $postcode, $city, $landline);

        while ($stm->fetch()) {
            if (strcmp($addressLine2, '') != 0 && strcmp($city, '') != 0) {
                $addressLine2 .= ",";
            }
            if (strcmp($postcode, '') != 0 && strcmp($city, '') != 0) {
                $postcode .= ",";
            }
            if (strcmp($landline, '') != 0) {
                $landline = "Tel.: " . $landline;
            }

        }
        $stm->close();

    }

    $displayDate = $orderDate;
    $displayDeliveryDate = $deliveryDate;


    $result= "
<div class='row'>
<div  class='col-sm-10 col-sm-offset-1' style='border: #888 1px solid'>

<style>




        *
        {
            margin:0;
            padding:0;
            font-family:Arial;
            font-size:10pt;
            color:#000;
        }
        body
        {
            width:100%;
            font-family:Arial;
            font-size:10pt;
            margin:0;
            padding:0;
        }

        p
        {
            margin:0;
            padding:0;
        }

        #wrapper
        {
            width:180mm;
            margin:0 15mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {
            height:50mm;
        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_bodyr
        {
            height: 149mm;
        }

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;

            border-spacing:0;
            border-collapse: collapse;


        }

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size:9pt;
  border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family:monospace;
            text-align:right;
            padding-right:3mm;
            font-size:14pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


       @page {
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }

        .customer {
           font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
           font-weight: 400;
        }

    </style>


<div style='width:100%;padding:3px;' name='myHTMLHeader1'>
    <table  style='width:100%'>
          <tr>
              <td valign='top' style='width:30%'>
                  <!--<img style='display:block;max-width: 200px;' src='//" . HTML_PATH . "/cop/media/pdfimage/logo.png'/>-->
              </td>
              <td  valign='top' style='width:40%' align='center'>
                 <p style='display:block;font-weight:bold; font-size:24px; width:100%'>Online Quotation Request</p>
              </td>
              <td valign='top' style='width:30%' align='right'>
                 <h1 class='heading' style='display:block;padding-top:2px;padding-bottom:2px;'>$line1</h1>
                            <h2 class='heading'>
                                $line2
                                $line3
                                $line4
                                $line5
                                $line6
                                $line7
                            </h2>
              </td>
           </tr>
      </table>
    
    <table  style='width:100%;'>
        <tr>

            <td  valign='top' align='left' style='padding:1mm;'>
                <table>
                    <tr><td style='font-weight:bold' colspan='2'><h3>Quotation Details</h3></td></tr>
                    <tr><td >Quotation No.: </td><td>$orderCode</td></tr>
                    <tr><td >Quotation Type: </td><td>Online Quotation</td></tr>
                    <tr><td >Quotation Date: </td><td>$displayDate</td></tr>
                    <tr><td >&nbsp;</td><td>&nbsp;</td></tr>
                </table>
            </td>
            <td ></td>
            <td class='customer' align='right'>
                <table >
                    <tr><td style='font-weight:bold'  align='right'><h3>Customer Details</h3></td></tr>
                    <tr><td align='right'>$customerName - $customerCode</td></tr>
                    <tr><td align='right'>$addressLine1</td></tr>
                    <tr><td align='right'>$postcode $addressLine2 $city</td></tr>
                    <tr><td align='right'>$landline</td></tr>

                </table>
            </td>
        </tr>
    </table>
    </div>
<div id='invoice_body' style='min-height: 500px;'>
    
     <table id='tableHeader' style='margin-top:10px;'>
            <tr style='background:#eee;'>
                <td style='width:8%' ><b>No.</b></td>
                <td style='width:17%'><b>Code</b></td>
                 <td style='width:30%'><b>Description</b></td>
                <td style='width:15%'><b>Quantity</b></td>
                <td style='width:15%' ><b>Unit Price</b></td>
                <td style='width:15%'><b>Total</b></td>
            </tr>
            </table>


            <table style='overflow:hidden;'>

            ";

    $vatsArray = Array();
    $stm = $db->prepare("SELECT vat_id,vat_code,percentage FROM Vats");
    $stm->execute();
    $stm->bind_result($vatID,$vatCode,$percentage);
    while ($stm->fetch()) {
        $vatObject="";
        $vatObject->id=$vatID;
        $vatObject->code=$vatCode;
        $vatObject->percentage=$percentage;
        $vatObject->vatAmount=0;
        $vatObject->goods=0;
        array_push($vatsArray,$vatObject);
    }
    $stm->close();

    $counter = 0;
    $stm = $db->prepare("SELECT Tender_Item.item_id,qty,unit_price,Items.vat_id,item_code,name FROM Tender_Item,Items WHERE Tender_Item.item_id=Items.item_id AND Tender_Item.tender_id='$tenderID'");
    $stm->execute();
    $stm->bind_result($itemID, $qty, $unitPrice, $vatID, $itemCode, $name);
    while ($stm->fetch()) {
        $counter++;


        if($addItemByUnits) {
            $qty = $qty / floatval(getSubUnits($itemID));
            $lineTotal = $unitPrice*$qty;
        } else {
            $lineTotal = $unitPrice*$qty / floatval(getSubUnits($itemID));
        }


        $lineTotal = number_format(floatval($lineTotal),2);
        $lineTotalDisplay = number_format(floatval($lineTotal),2);
        $unitPrice = number_format(floatval($unitPrice),2);
        $unitPriceDisplay = number_format(floatval($unitPrice),2);

        if($customerID > 0) {
            $name = getCustomerSynonym($customerID,$itemID,'name',$name);
            $itemCode = getCustomerSynonym($customerID,$itemID,'code',$itemCode);
        }

        $result.= "<tr>
                <td style='width:8%'> $counter</td >
                <td style='width:17%;' > $itemCode  </td >
                <td style='width:30%'> $name </td >
                <td style='width:15%;text-align:center;padding-right:5px;'  > $qty</td >
                <td style='width:15%;text-align:right;padding-right:5px;' > $unitPriceDisplay</td >
                <td style='width:15%;text-align:right;padding-right:5px;'  > $lineTotalDisplay</td >
            </tr >";

        foreach($vatsArray as $vatObject)
        {
            if($vatObject->id==$vatID)
            {
                $vatLineAmount = $vatObject->percentage * $lineTotal / 100;
                $vatObject->vatAmount+=$vatLineAmount;
                $vatObject->goods+=$lineTotal;
            }
        }

    }
    $stm->close();


    $result.=
        "

        </table>
        </div>

    <div><br></div>
    <div id='invoice_total' style='margin-top:20px;border-top: 1px solid #222;border-bottom: 1px solid #222;'>
            <table style='width: 100%'>
             <tr>
               <td style='width:50%;'>

               <table>
                  <tr>
                    <td style='text-align:center'>
                     <p style='display: inline;text-align:center;'><b> VAT Summary</b></p>
                    </td>
                 </tr>
                 </table>
                 <table>
                 <tr>

                   <td style='width:33%;text-align:center;font-weight: bold;'>
                     <p > Percent:</p>
                   </td>
                   <td style='width:33%;text-align:center;font-weight: bold;'>
                     <p > Goods:</p>
                   </td>
                   <td style='width:33%;text-align:center;font-weight: bold;'>
                     <p> VAT</p>
                   </td>
                 </tr>";


    foreach($vatsArray as $vatObject) {

        if($vatObject->goods>0) {

            $vatObject->goods = number_format(floatval($vatObject->goods),2);
            $vatObject->vatAmount = number_format(floatval($vatObject->vatAmount),2);
            $result .= "<tr>
                <td style='width:33%;font-size:12px;text-align:center;' > $vatObject->percentage%  </td >
                <td style='width:33%;font-size:12px;text-align:center;'>  $vatObject->goods </td >
                 <td style='width:33%;text-align:center;font-size:12px;'> $vatObject->vatAmount</td >
            </tr >";
        }

    }


    $result.="
               </table>

              </td>
              <td style='width:20%'></td>
              <td  style='width:30%;'>
               <table>
                <tr>
                    <td style='text-align:right;font-weight:bold;'> Subtotal</td>
                    <td style='text-align:right;' >$subtotal</td>
                </tr>
                <tr>
                    <td style='text-align:right;font-weight:bold'> Vat Total</td>
                    <td style='text-align:right;' >$vatAmount</td>
                </tr>
                <tr>
                    <td style='text-align:right;font-weight:bold'> Grand Total</td>
                    <td style='text-align:right;' >$grandTotal</td>
                </tr>
            </table>
              </td>
            </tr>
          </table>
        </div>
<div><br></div>

    </div>



   

</div>

";


    return $result;
}

function getTenderNoPrices($tenderID,$anonymous,$anonymousInfo)
{
    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $addItemByUnits = true;
    $stm = $db->prepare("SELECT order_qty_by_subunits FROM B2B_Configuration");
    $stm->execute();
    $stm->bind_result($orderQtyBySubunits);
    while ($stm->fetch()) {
        if(strcmp($orderQtyBySubunits,'yes')==0){
            $addItemByUnits = false;
        }
    }
    $stm->close();

    $stm = $db->prepare("SELECT tender_code,tender_date,valid_until,subtotal,grand_total,vat_amount,customer_id,company_id FROM Tenders WHERE tender_id='$tenderID'");
    $stm->execute();
    $stm->bind_result($orderCode, $orderDate,$validUntil, $subtotal, $grandTotal, $vatAmount,$customerID,$companyID);

    while ($stm->fetch()) {


    }
    $stm->close();

    $orderDate = date_format( date_create_from_format('Y-m-d', $orderDate), 'd-m-Y');
    $validUntil = date_format( date_create_from_format('Y-m-d', $validUntil), 'd-m-Y');

    $subtotal = number_format(floatval($subtotal),2);
    $grandTotal = number_format(floatval($grandTotal),2);
    $vatAmount = number_format(floatval($vatAmount),2);


//    $stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies WHERE company_id='$companyID'");
//    $stm->execute();
//    $stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);
//
//    while ($stm->fetch()) {
//        if(strcmp($line1,'')!=0){$line1 .="<br>";}
//        if(strcmp($line2,'')!=0){$line2 .="<br>";}
//        if(strcmp($line3,'')!=0){$line3 .="<br>";}
//        if(strcmp($line4,'')!=0){$line4 .="<br>";}
//        if(strcmp($line5,'')!=0){$line5 .="<br>";}
//        if(strcmp($line6,'')!=0){$line6 .="<br>";}
//
//    }
//    $stm->close();


    $stm = $db->prepare("SELECT customer_code,customer_company_name FROM Customers WHERE customer_id='$customerID'");
    $stm->execute();
    $stm->bind_result($customerCode, $customerName);

    while ($stm->fetch()) {


    }
    $stm->close();

    if($anonymous){
        $customerName = 'Customer';
        $customerCode =$anonymousInfo;
    } else {
        $stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,city,landline FROM CustomerAddress WHERE customer_id='$customerID' AND primary_address='yes'");
        $stm->execute();
        $stm->bind_result($addressLine1, $addressLine2, $postcode, $city, $landline);

        while ($stm->fetch()) {
            if (strcmp($addressLine2, '') != 0 && strcmp($city, '') != 0) {
                $addressLine2 .= ",";
            }
            if (strcmp($postcode, '') != 0 && strcmp($city, '') != 0) {
                $postcode .= ",";
            }
            if (strcmp($landline, '') != 0) {
                $landline = "Tel.: " . $landline;
            }

        }
        $stm->close();

    }

    $displayDate = $orderDate;
    $displayDeliveryDate = $deliveryDate;

    $result= "
<div class='row'>
<div  class='col-sm-10 col-sm-offset-1' style='border: #888 1px solid'>

<style>




        *
        {
            margin:0;
            padding:0;
            font-family:Arial;
            font-size:10pt;
            color:#000;
        }
        body
        {
            width:100%;
            font-family:Arial;
            font-size:10pt;
            margin:0;
            padding:0;
        }

        p
        {
            margin:0;
            padding:0;
        }

        #wrapper
        {
            width:180mm;
            margin:0 15mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {
            height:50mm;
        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_bodyr
        {
            height: 149mm;
        }

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;

            border-spacing:0;
            border-collapse: collapse;


        }

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size:9pt;
  border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family:monospace;
            text-align:right;
            padding-right:3mm;
            font-size:14pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


       @page {
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }

        .customer {
           font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
           font-weight: 400;
        }

    </style>


<div style='width:100%;padding:3px;' name='myHTMLHeader1'>
    <table  style='width:100%'>
          <tr>
              <td valign='top' style='width:30%'>
                  <!--<img style='display:block;max-width: 200px;' src='//" . HTML_PATH . "/cop/media/pdfimage/logo.png'/>-->
              </td>
              <td  valign='top' style='width:40%' align='center'>
                 <p style='display:block;font-weight:bold; font-size:24px; width:100%'>Online Quotation Request</p>
              </td>
              <td valign='top' style='width:30%' align='right'>
                 <h1 class='heading' style='display:block;padding-top:2px;padding-bottom:2px;'>$line1</h1>
                            <h2 class='heading'>
                                $line2
                                $line3
                                $line4
                                $line5
                                $line6
                                $line7
                            </h2>
              </td>
           </tr>
      </table>
    
    <table  style='width:100%;'>
        <tr>

            <td  valign='top' align='left' style='padding:1mm;'>
                <table>
                    <tr><td style='font-weight:bold' colspan='2'><h3>Quotation Details</h3></td></tr>
                    <tr><td >Quotation No.: </td><td>$orderCode</td></tr>
                    <tr><td >Quotation Type: </td><td>Online Quotation</td></tr>
                    <tr><td >Quotation Date: </td><td>$displayDate</td></tr>
                    <tr><td >&nbsp;</td><td>&nbsp;</td></tr>
                </table>
            </td>
            <td ></td>
            <td class='customer' align='right'>
                <table >
                    <tr><td style='font-weight:bold'  align='right'><h3>Customer Details</h3></td></tr>
                    <tr><td align='right'>$customerName - $customerCode</td></tr>
                    <tr><td align='right'>$addressLine1</td></tr>
                    <tr><td align='right'>$postcode $addressLine2 $city</td></tr>
                    <tr><td align='right'>$landline</td></tr>

                </table>
            </td>
        </tr>
    </table>
    </div>
<div id='invoice_body' style='min-height: 500px;'>
    
     <table id='tableHeader' style='margin-top:10px;'>
            <tr style='background:#eee;'>
                <td style='width:8%' ><b>No.</b></td>
                <td style='width:17%'><b>Code</b></td>
                 <td style='width:60%'><b>Description</b></td>
                <td style='width:15%'><b>Quantity</b></td>
            </tr>
            </table>


            <table style='overflow:hidden;'>

            ";

    $vatsArray = Array();
    $stm = $db->prepare("SELECT vat_id,vat_code,percentage FROM Vats");
    $stm->execute();
    $stm->bind_result($vatID,$vatCode,$percentage);
    while ($stm->fetch()) {
        $vatObject="";
        $vatObject->id=$vatID;
        $vatObject->code=$vatCode;
        $vatObject->percentage=$percentage;
        $vatObject->vatAmount=0;
        $vatObject->goods=0;
        array_push($vatsArray,$vatObject);
    }
    $stm->close();

    $counter = 0;
    $stm = $db->prepare("SELECT Tender_Item.item_id,qty,unit_price,Items.vat_id,item_code,name FROM Tender_Item,Items WHERE Tender_Item.item_id=Items.item_id AND Tender_Item.tender_id='$tenderID'");
    $stm->execute();
    $stm->bind_result($itemID, $qty, $unitPrice, $vatID, $itemCode, $name);
    while ($stm->fetch()) {

        $counter++;

        if($addItemByUnits) {
            $qty = $qty / floatval(getSubUnits($itemID));
            $lineTotal = $unitPrice*$qty;
        } else {
            $lineTotal = $unitPrice*$qty / floatval(getSubUnits($itemID));
        }

        $lineTotal = number_format(floatval($lineTotal),2);
        $lineTotalDisplay = number_format(floatval($lineTotal),2);
        $unitPrice = number_format(floatval($unitPrice),2);
        $unitPriceDisplay = number_format(floatval($unitPrice),2);

        $result.= "<tr>
                <td style='width:8%'> $counter</td >
                <td style='width:17%;' > $itemCode  </td >
                <td style='width:60%'> $name </td >
                <td style='width:15%;text-align:center;padding-right:5px;'  > $qty</td >
                
            </tr >";

        foreach($vatsArray as $vatObject)
        {
            if($vatObject->id==$vatID)
            {
                $vatLineAmount = $vatObject->percentage * $lineTotal / 100;
                $vatObject->vatAmount+=$vatLineAmount;
                $vatObject->goods+=$lineTotal;
            }
        }

    }
    $stm->close();


    $result.=
        "

        </table>
        </div>

    <div><br></div>

    <div><br></div>

    </div>



   

</div>

";


    return $result;
}

function generateReceipt($receiptID){
    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }


    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT receipt_code, customer_id, company_id, salesperson_id, order_id, invoice_id, address_id, amount, payment_method, cash_discount, bank, branch, cheque_number, cheque_date, receipt_date, notes, status FROM Receipts WHERE receipt_id=$receiptID");
    $stm->execute();
    $stm->bind_result($receiptCode, $customerID,$companyID,$salespersonID,$orderID,$invoiceID,$receiptAddressID,$amount,$paymentMethod,$cashDiscount,$bank, $branch, $chequeNumber, $chequeDate,$receiptDate, $notes, $status);
    while ($stm->fetch()) {}
    $stm->close();

    $invoiceReference = array();
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT invoice_code, grand_total FROM Invoices,Invoice_Receipt WHERE Invoices.invoice_id = Invoice_Receipt.invoice_id AND receipt_id=$receiptID");
    $stm->execute();
    $stm->bind_result($invoiceCode, $invoiceTotal);
    while ($stm->fetch()) {

        $invoice ='';
        $invoice->code  = $invoiceCode;
        $invoice->total = $invoiceTotal;

        array_push($invoiceReference, $invoice);
    }
    $stm->close();

    $amount       = number_format(floatval($amount),2);
    $cashDiscount = number_format(floatval($cashDiscount),2);
    $receiptDate  = date_format( date_create_from_format('Y-m-d', $receiptDate), 'd-m-Y');
    $chequeDate   = date_format( date_create_from_format('Y-m-d',  $chequeDate), 'd-m-Y');


    $stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies WHERE company_id='$companyID'");
    $stm->execute();
    $stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);
    while ($stm->fetch()) {}
    $stm->close();


    $stm = $db->prepare("SELECT customer_code,customer_company_name FROM Customers WHERE customer_id='$customerID'");
    $stm->execute();
    $stm->bind_result($customerCode, $customerName);
    while ($stm->fetch()) {}
    $stm->close();


    $stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,city,landline FROM CustomerAddress WHERE customer_address_id='$receiptAddressID'");
    $stm->execute();
    $stm->bind_result($addressLine1, $addressLine2,$postcode,$city,$landline);
    while ($stm->fetch()) {}
    $stm->close();


    $stm = $db->prepare("SELECT CONCAT(salesperson_code,' - ',first_name,' ',last_name) FROM SalesPersons WHERE salesperson_id='$salespersonID'");
    $stm->execute();
    $stm->bind_result($salespersonDisplayName);
    while ($stm->fetch()) {}
    $stm->close();


    $whole = floor($amount);      // 1
    $decimal = round(($amount - $whole)*100); // .25

    $money = convertNumber($whole);
    $cents = convertNumber($decimal);

    $stringAmount = strtoupper("$money and $cents cents ");

    $result= "



<style>


        body
        {


        }

        p
        {

        }

        #wrapper
        {
            width:190mm;
            margin:0 10mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {

        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_body
        {

        }

        td {
          font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
        }

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;
        }

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size: 11px;
            border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
            text-align:right;
            padding-right:3mm;
            font-size:10pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


        @page
        {
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }

        .customer {
           font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
           font-weight: 400;
        }

        #table_info td {
           font-size: 12px;
           padding:0;

        }

    </style>

<table id='table_info' style='width:100%;margin-top:0;padding-top:0;'>
        <tr>
            <td rowspan='1' valign='top' align='left' style='width:33%'>
                <h4 >Receipt Details</h4>
                <table>
                  <tr><td >Receipt Number: </td><td>$receiptCode  </td></tr>
                  <tr><td >Receipt Date:   </td><td>$receiptDate  </td></tr>
                  <tr><td >Payment Method: </td><td>$paymentMethod</td></tr>
                </table>
            </td>
            <td rowspan='1' valign='top' align='center' style='width:33%'>
                <h4 >Online Receipt</h4>
                <table>
                  <tr><td ></td></tr>
                  <tr><td colspan='2'></td></tr>

                </table>
            </td>
            <td rowspan='2' valign='top' align='right' style='width:33%'>
                <h4>Customer Details</h4>
                <table>

                    <tr><td align='right'>$customerName</td></tr>
                    <tr><td align='right'>$addressLine1</td></tr>
                    <tr><td align='right'>$addressLine2, $city, $postcode</td></tr>
                </table>
            </td>
            
        </tr>

    </table>
    <br/>
    <table repeat_header='1' id='tableHeader' style='width:100%;border-top: 1px solid #222222;border-bottom: 1px solid #222222;background:#f5f8ff;padding-top:3px;padding-bottom:3px;'>
        <tr>
            <td style='font-size:13px;width:5%;text-align:center;' ><b>Receipt Amount</b></td>
        </tr>
        <tr>
            <td style='font-size:13px;width:5%;text-align:center;' ><h1 style='color: #0a6ebd'> &euro;$amount</h1></td>
        </tr>
        <tr>
            <td style='font-size:13px;width:5%;text-align:center;' >$stringAmount</td>
        </tr>
    </table>
    <br/>
    <table id='table_info' style='width:100%;margin-top:0;padding-top:0;'>
        <tr>
             <td rowspan='2' valign='top' align='left' style='width:33%'>";

    if(!empty($invoiceReference)) {
        $result .= "<h4 >Invoice Reference</h4>
                <br/>
                <table>";

        foreach ($invoiceReference as $invoice){
            $result .= " <tr><td>$invoice->code : &euro;$invoice->total</td></tr>";
        }

        $result .= " </table>";
    }

    $result.="</td>
            <td rowspan='1' valign='top' align='center' style='width:33%'>";

    if(strcmp($notes,'') != 0){
        $result .= "<h4 >Receipt Notes</h4>
                <br/>
                 <table>
                  <tr><td >$notes</td></tr>
                 </table>";
    }
    $result.="</td>
            <td rowspan='1' valign='top' align='right' style='width:33%'>";

    if($cashDiscount > 0) {
        $result .= "    <h4 >Cash Discount: &euro;$cashDiscount</h4><br/>";
    }
    if(strcmp($paymentMethod,'Cheque') == 0) {
        $result .= " <table>
                  <tr><td colspan='2'> <h4 >Cheque Details</h4> </td></tr>
                  <tr><td >Bank:         </td><td >$bank        </td></tr>
                  <tr><td >Branch:       </td><td >$branch      </td></tr>
                  <tr><td >Cheque Number:</td><td >$chequeNumber</td></tr>
                  <tr><td >Cheque Date:  </td><td >$chequeDate  </td></tr>
                 </table>";
    }
    $result.=" </td>

        </tr>

    </table>
        <div style='margin-top:80px;width:100%;'>
           <table style='width:100%;'>
               <tr>
                 <td style='width:50%;'>
                    <table style='width:100%;'>
                       <tr>
                       <td style='width:40%'>

                       </td>
                        <td style='width:20%;text-align:center'>
                            
                       </td>
                        <td style='width:40%'>

                       </td>
                       </tr>
                    </table>
                  </td>
              </tr>
           </table>

        </div>
        <htmlpagefooter name='myFooter1'>
        <div>
          <p style='margin-top:5px;font-size:10px;font-family: Helvetica Neue, Helvetica, Arial, sans-serif'> Powered by Coprime Mobile Commerce: 25-311504 </p>
        </div>

            <table width='100%' style='vertical-align: bottom; font-family: Helvetica Neue, Helvetica, Arial, sans-serif; font-size: 8pt;
                color: #000000;  '><tr>
                <td width='33%'><span style=''></span></td>
                <td width='33%' align='center' style=''></td>
                <td width='33%' style='text-align: right; '></td>
                </tr></table>
            </htmlpagefooter>



";


    return $result;
}

function convertNumber($number)
{
    list($integer, $fraction) = explode(".", (string) $number);

    $output = "";

    if ($integer{0} == "-")
    {
        $output = "negative ";
        $integer    = ltrim($integer, "-");
    }
    else if ($integer{0} == "+")
    {
        $output = "positive ";
        $integer    = ltrim($integer, "+");
    }

    if ($integer{0} == "0")
    {
        $output .= "zero";
    }
    else
    {
        $integer = str_pad($integer, 36, "0", STR_PAD_LEFT);
        $group   = rtrim(chunk_split($integer, 3, " "), " ");
        $groups  = explode(" ", $group);

        $groups2 = array();
        foreach ($groups as $g)
        {
            $groups2[] = convertThreeDigit($g{0}, $g{1}, $g{2});
        }

        for ($z = 0; $z < count($groups2); $z++)
        {
            if ($groups2[$z] != "")
            {
                $output .= $groups2[$z] . convertGroup(11 - $z) . (
                    $z < 11
                    && !array_search('', array_slice($groups2, $z + 1, -1))
                    && $groups2[11] != ''
                    && $groups[11]{0} == '0'
                        ? " and "
                        : ", "
                    );
            }
        }

        $output = rtrim($output, ", ");
    }

    if ($fraction > 0)
    {
        $output .= " point";
        for ($i = 0; $i < strlen($fraction); $i++)
        {
            $output .= " " . convertDigit($fraction{$i});
        }
    }

    return $output;
}

function convertGroup($index)
{
    switch ($index)
    {
        case 11:
            return " decillion";
        case 10:
            return " nonillion";
        case 9:
            return " octillion";
        case 8:
            return " septillion";
        case 7:
            return " sextillion";
        case 6:
            return " quintrillion";
        case 5:
            return " quadrillion";
        case 4:
            return " trillion";
        case 3:
            return " billion";
        case 2:
            return " million";
        case 1:
            return " thousand";
        case 0:
            return "";
    }
}

function convertThreeDigit($digit1, $digit2, $digit3)
{
    $buffer = "";

    if ($digit1 == "0" && $digit2 == "0" && $digit3 == "0")
    {
        return "";
    }

    if ($digit1 != "0")
    {
        $buffer .= convertDigit($digit1) . " hundred";
        if ($digit2 != "0" || $digit3 != "0")
        {
            $buffer .= " ";
        }
    }

    if ($digit2 != "0")
    {
        $buffer .= convertTwoDigit($digit2, $digit3);
    }
    else if ($digit3 != "0")
    {
        $buffer .= convertDigit($digit3);
    }

    return $buffer;
}

function convertTwoDigit($digit1, $digit2)
{
    if ($digit2 == "0")
    {
        switch ($digit1)
        {
            case "1":
                return "ten";
            case "2":
                return "twenty";
            case "3":
                return "thirty";
            case "4":
                return "forty";
            case "5":
                return "fifty";
            case "6":
                return "sixty";
            case "7":
                return "seventy";
            case "8":
                return "eighty";
            case "9":
                return "ninety";
        }
    } else if ($digit1 == "1")
    {
        switch ($digit2)
        {
            case "1":
                return "eleven";
            case "2":
                return "twelve";
            case "3":
                return "thirteen";
            case "4":
                return "fourteen";
            case "5":
                return "fifteen";
            case "6":
                return "sixteen";
            case "7":
                return "seventeen";
            case "8":
                return "eighteen";
            case "9":
                return "nineteen";
        }
    } else
    {
        $temp = convertDigit($digit2);
        switch ($digit1)
        {
            case "2":
                return "twenty $temp";
            case "3":
                return "thirty $temp";
            case "4":
                return "forty $temp";
            case "5":
                return "fifty $temp";
            case "6":
                return "sixty $temp";
            case "7":
                return "seventy $temp";
            case "8":
                return "eighty $temp";
            case "9":
                return "ninety $temp";
        }
    }
}

function convertDigit($digit)
{
    switch ($digit)
    {
        case "0":
            return "zero";
        case "1":
            return "one";
        case "2":
            return "two";
        case "3":
            return "three";
        case "4":
            return "four";
        case "5":
            return "five";
        case "6":
            return "six";
        case "7":
            return "seven";
        case "8":
            return "eight";
        case "9":
            return "nine";
    }
}

?>