<?php
if (file_exists('../../param.php')) {
    include_once("../../param.php");
}

function getNextCustomerCodeB2C()
{
    global $username, $password, $database;
    $customerCode=0;

    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT b2c_customer_code_suffix,b2c_customer_code_number FROM B2C_Configuration LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($customerCodeSuffix,$customerCode);
    while ($stm1->fetch()) {}
    $stm1->close();
    if(strcmp($customerCodeSuffix,'')==0){$customerCodeSuffix = "B2C00";}

    $customerCode = $customerCodeSuffix.$customerCode;


    $stmt = $db1->prepare("UPDATE B2C_Configuration SET b2c_customer_code_number=b2c_customer_code_number+1 ");
    $stmt->execute();
    $stmt->close();

    return $customerCode;

}

function setNextServiceCallCode($activationCode)
{
    global $username, $password, $database;

    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stmt = $db->prepare("UPDATE Devices SET begin_service_call_number=begin_service_call_number+1 WHERE activation_code='$activationCode'");
    $stmt->execute();
    $stmt->close();



}

function getNextServiceCallCode($activationCode)
{
    global $username, $password, $database;
    $beginOrderNumber="";

    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT begin_service_call_number FROM Devices WHERE activation_code='$activationCode' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($beginOrderNumber);
    while ($stm1->fetch()) {

    }
    $stm1->close();
    return $beginOrderNumber;
}

function getNextKey($tableName,$idName)
{
 global $username, $password, $database;
 $z=0;
 $db1 = new mysqli('localhost',$username,$password,$database);
 if (mysqli_connect_errno()) {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db1->set_charset("utf8");
 $prefix = "1000";
 $likeVar = $prefix."%";
 $stm1 = $db1->prepare("SELECT $idName FROM $tableName WHERE $idName LIKE '$likeVar' ORDER BY $idName DESC LIMIT 1");
 $stm1-> execute();
 $stm1-> bind_result($nextID);
 while ($stm1->fetch()) {

  $z = substr($nextID,4,strlen($nextID));
  $z+=1;


 }
 $stm1->close();


 return $prefix.$z;
}

function getNextKeySingleTransaction($tableName,$idName,$db)
{
    $z=0;
    $prefix=1210;


    $likeVar = $prefix."%";
    $stm1 = $db->prepare("SELECT $idName FROM $tableName WHERE $idName LIKE '$likeVar' ORDER BY $idName DESC LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($nextID);
    while ($stm1->fetch()) {

        $z = substr($nextID,4,strlen($nextID));
        $z+=1;


    }
    $stm1->close();


    return $prefix.$z;




}
function getDefaultPriceInclPriceTypesNoOffer($itemID,$customerID,$anonymous=false,$qty=1){
    $isB2C = false;
    global $username, $password, $database;
    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $stm1 = $db1->prepare("SELECT b2b_price_list,b2c_price_list,b2b_offer_price_list,b2c_offer_price_list,use_as_b2c FROM B2B_Configuration LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($fromB2BPriceList,$fromB2CPriceList,$offerB2BPriceList,$offerB2CPriceList,$useAsB2C);
    while ($stm1->fetch()) {if(strcmp($useAsB2C,"yes")==0){$isB2C = true;}}
    $stm1->close();

    if(!$anonymous && isset($_SESSION['userID']) && $_SESSION['userID'] != 0) {
        $userID = $_SESSION['userID'];
        $stm1 = $db1->prepare("SELECT B2C_User FROM B2B_User WHERE b2b_user_id='$userID'");
        $stm1->execute();
        $stm1->bind_result($isB2CUser);
        while ($stm1->fetch()) {
        }
        $stm1->close();


        if (strcmp($isB2CUser, "yes") == 0 && $isB2C) {
            $isB2C = true;
        } else {
            $isB2C = false;
        }
    }

    if(isset($fromB2BPriceList) && $fromB2BPriceList > 0 && !$isB2C) {
        $b2bPrice = getDefaultPriceFromPriceType($itemID,$customerID, $fromB2BPriceList,$isB2C,$qty);
    }
    if(isset($fromB2CPriceList) && $fromB2CPriceList > 0 && $isB2C) {
        $b2cPrice = getDefaultPriceFromPriceType($itemID,$customerID, $fromB2CPriceList,$isB2C,$qty);
    }


    if(isset($b2bPrice) && $b2bPrice > 0){
        $price =  $b2bPrice;
    } else if(isset($b2cPrice) && $b2cPrice > 0){
        $price =  $b2cPrice;
    } else {
        $price = getDefaultPrice($itemID,$customerID);
    }


    return $price;
}
function getDefaultPriceInclPriceTypes($itemID,$customerID,$anonymous=false,$qty=1){
    $isB2C = false;
    global $username, $password, $database;
    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $stm1 = $db1->prepare("SELECT b2b_price_list,b2c_price_list,b2b_offer_price_list,b2c_offer_price_list,use_as_b2c FROM B2B_Configuration LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($fromB2BPriceList,$fromB2CPriceList,$offerB2BPriceList,$offerB2CPriceList,$useAsB2C);
    while ($stm1->fetch()) {if(strcmp($useAsB2C,"yes")==0){$isB2C = true;}}
    $stm1->close();

    if(!$anonymous && isset($_SESSION['userID']) && $_SESSION['userID'] != 0) {
        $userID = $_SESSION['userID'];
        $stm1 = $db1->prepare("SELECT B2C_User FROM B2B_User WHERE b2b_user_id='$userID'");
        $stm1->execute();
        $stm1->bind_result($isB2CUser);
        while ($stm1->fetch()) {
        }
        $stm1->close();

        if (strcmp($isB2CUser, "yes") == 0 && $isB2C) {
            $isB2C = true;
        } else {
            $isB2C = false;
        }
    }
    if(isset($fromB2BPriceList) && $fromB2BPriceList > 0 && !$isB2C) {
        $b2bPrice = getDefaultPriceFromPriceType($itemID,$customerID, $fromB2BPriceList,$isB2C,$qty);
    }
    if(isset($fromB2CPriceList) && $fromB2CPriceList > 0 && $isB2C) {
        $b2cPrice = getDefaultPriceFromPriceType($itemID,$customerID, $fromB2CPriceList,$isB2C,$qty);
    }
    if(isset($offerB2BPriceList) && $offerB2BPriceList > 0 && !$isB2C) {
        $offerB2bPrice = getDefaultPriceFromPriceType($itemID,$customerID, $offerB2BPriceList,$isB2C,$qty);
    }
    if(isset($offerB2CPriceList) && $offerB2CPriceList > 0 && $isB2C) {
        $offerB2cPrice = getDefaultPriceFromPriceType($itemID,$customerID, $offerB2CPriceList,$isB2C,$qty);
    }

    if(isset($b2bPrice) && $b2bPrice > 0){
        $price =  $b2bPrice;
    } else if(isset($b2cPrice) && $b2cPrice > 0){
        $price =  $b2cPrice;
    } else {
        $price = getDefaultPrice($itemID,$customerID,'',$qty);
    }

    if(isset($offerB2BPriceList) && $offerB2BPriceList > 0 && !$isB2C){
        $offerPrice =  $offerB2bPrice;
    } else if(isset($offerB2CPriceList) && $offerB2CPriceList > 0 && $isB2C){
        $offerPrice =  $offerB2cPrice;
    } else {
        $offerPrice = $price;
    }

    if($offerPrice < $price && $offerPrice > 0){
        $price = $offerPrice;
    }

    return $price;
}

function getPriceType($itemID,$customerID,$finalPrice,$db1='')
{
    global $username, $password, $database;
    $z=0;
    if(is_string($db1) && strcmp($db1,'')==0) {
        global $username, $password, $database;
        $db1 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db1->set_charset("utf8");
    }
    $stm1 = $db1->prepare("SELECT COUNT(pricetype_id) FROM ContractPrices WHERE item_id= '$itemID' AND customer_id='$customerID' AND price='$finalPrice' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {$z = $counter;}
    $stm1->close();

    if($z>0) {return 97;}

    $stm1 = $db1->prepare("SELECT pricetype_id FROM Prices WHERE item_id= '$itemID' AND price='$finalPrice' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($priceTypeID);
    while ($stm1->fetch()) {}
    $stm1->close();

    if($priceTypeID > 0){return $priceTypeID;}
    else {return 0;}

}

function getDefaultPrice($itemID,$customerID,$db1='',$qty=1)
{
 global $username, $password, $database;
    $z=0;
    if(is_string($db1) && strcmp($db1,'')==0) {
        global $username, $password, $database;
        $db1 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db1->set_charset("utf8");
    }
    if($customerID > 0) {
        $db1->set_charset("utf8");
        $stm1 = $db1->prepare("SELECT price FROM ContractPrices WHERE item_id= '$itemID' AND customer_id='$customerID' AND DATE(valid_from) <= DATE(NOW()) AND DATE(valid_until) >= DATE(NOW()) GROUP BY customer_id,item_id,min_qty HAVING MIN(min_qty) <= $qty ORDER BY min_qty DESC LIMIT 1");
        $stm1->execute();
        $stm1->bind_result($price);
        while ($stm1->fetch()) {

            $z = $price;


        }
        $stm1->close();

        if ($z > 0) {
            return $z*getPriceRate();
        }

        $db1->set_charset("utf8");
        $stm1 = $db1->prepare("SELECT price FROM ContractPrices WHERE item_id= '$itemID' AND customer_id='1' AND DATE(valid_from) <= DATE(NOW()) AND DATE(valid_until) >= DATE(NOW()) GROUP BY customer_id,item_id,min_qty HAVING MIN(min_qty) <= $qty ORDER BY min_qty DESC LIMIT 1");
        $stm1->execute();
        $stm1->bind_result($price);
        while ($stm1->fetch()) {

            $z = $price;


        }
        $stm1->close();

        if ($z > 0) {
            return $z*getPriceRate();
        }


        $stm1 = $db1->prepare("SELECT price_group_definition_id FROM Price_Group_Customer WHERE customer_id='$customerID'");
        $stm1->execute();
        $stm1->bind_result($priceGroupDefinitionID);
        while ($stm1->fetch()) {

            $categories = array();
            $categories = getItemCategories($itemID);

            foreach ($categories as $category) {
                $db = new mysqli('localhost', $username, $password, $database);
                if (mysqli_connect_errno()) {
                    printf("Connect failed: %s\n", mysqli_connect_error());
                    exit();
                }
                $db->set_charset("utf8");
                $stm = $db->prepare("SELECT discount_percent,price_type_id FROM Price_Group_Rules WHERE  price_group_definition_id ='$priceGroupDefinitionID' AND category_id='$category'");
                $stm->execute();
                $stm->bind_result($discountPercent, $priceGroupPriceTypeID);
                while ($stm->fetch()) {

                    $price = getPriceFromPriceType($itemID, $priceGroupPriceTypeID) - getPriceFromPriceType($itemID, $priceGroupPriceTypeID) * $discountPercent / 100;
                    $z = $price;
                    if ($z > 0) {
                        break;
                    }


                }
                $stm->close();
                if ($z > 0) {
                    break;
                }

            }
            if ($z > 0) {
                break;
            }
        }
        $stm1->close();


        if ($z > 0) {
            return $z*getPriceRate();
        }


        $stm1 = $db1->prepare("SELECT price_group_definition_id FROM Price_Group_Customer_Group WHERE customer_group_id IN(SELECT group_id AS customer_group_id FROM Customer_CustomersGroup WHERE customer_id='$customerID')");
        $stm1->execute();
        $stm1->bind_result($priceGroupDefinitionID);
        while ($stm1->fetch()) {

            $categories = array();
            $categories = getItemCategories($itemID);

            foreach ($categories as $category) {
                $db = new mysqli('localhost', $username, $password, $database);
                if (mysqli_connect_errno()) {
                    printf("Connect failed: %s\n", mysqli_connect_error());
                    exit();
                }
                $db->set_charset("utf8");
                $stm = $db->prepare("SELECT discount_percent,price_type_id FROM Price_Group_Rules WHERE  price_group_definition_id ='$priceGroupDefinitionID' AND category_id='$category'");
                $stm->execute();
                $stm->bind_result($discountPercent, $priceGroupPriceTypeID);
                while ($stm->fetch()) {

                    $price = getPriceFromPriceType($itemID, $priceGroupPriceTypeID) - getPriceFromPriceType($itemID, $priceGroupPriceTypeID) * $discountPercent / 100;
                    $z = $price;
                    if ($z > 0) {
                        break;
                    }


                }
                $stm->close();
                if ($z > 0) {
                    break;
                }

            }
            if ($z > 0) {
                break;
            }
        }
        $stm1->close();


        if ($z > 0) {
            return $z*getPriceRate();
        }


        $stm1 = $db1->prepare("SELECT pricetype_id,discount_percentage FROM Customer_Pricelist WHERE customer_id ='$customerID' AND (NOT allow_discount='onlydisc' OR allow_discount IS NULL)");
        $stm1->execute();
        $stm1->bind_result($customerPriceTypeID,$discountPercent);
        while ($stm1->fetch()) {
            if(strcmp($discountPercent,'')==0){$discountPercent = 0;}
            $z = getPriceFromPriceType($itemID, $customerPriceTypeID);
            $z = $z - $z*$discountPercent/100;
        }
        $stm1->close();

        if ($z > 0) {
            return $z*getPriceRate();
        }

    }
    $stm1 = $db1->prepare("SELECT price FROM Prices,PriceTypes WHERE item_id= '$itemID' AND default_type=\"yes\" AND Prices.pricetype_id=PriceTypes.pricetype_id  LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($price);
    while ($stm1->fetch()) {
    $z = $price;
    }
    $stm1->close();

    return $z*getPriceRate();
}

function getDefaultPriceFromDefaultPriceType($itemID,$qty=1)
{
 global $username, $password, $database;
    $z=0;
    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $userID=  $_SESSION['userID'] ;
    $customerID=  $_SESSION['customerID'] ;
    $stm1 = $db1->prepare("SELECT b2b_price_list,b2c_price_list,use_as_b2c FROM B2B_Configuration LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($b2bPriceList,$B2CPricelist,$isB2C);
    while ($stm1->fetch()) {}
    $stm1->close();

    if(strcmp($isB2C,'yes')==0){
        $stm1 = $db1->prepare("SELECT B2C_User FROM B2B_User WHERE b2b_user_id='$userID'");
        $stm1->execute();
        $stm1->bind_result($isB2CUser);
        while ($stm1->fetch()) {}
        $stm1->close();
        if(strcmp($isB2CUser,'yes')==0){$b2bPriceList = $B2CPricelist;}
    }

    if($b2bPriceList > 0){
        $stm1 = $db1->prepare("SELECT price FROM Prices WHERE item_id= '$itemID' AND pricetype_id='$b2bPriceList'  LIMIT 1");
        $stm1-> execute();
        $stm1-> bind_result($price);
        while ($stm1->fetch()) {

            if($price > 0){
                return $price*getPriceRate();
            }

        }
        $stm1->close();
    }

    $stm1 = $db1->prepare("SELECT price FROM Prices,PriceTypes WHERE item_id= '$itemID' AND default_type=\"yes\" AND Prices.pricetype_id=PriceTypes.pricetype_id  LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($price);
    while ($stm1->fetch()) {

        $z = $price;



    }
    $stm1->close();

    $stm1 = $db1->prepare("SELECT price,percentage FROM ContractPrices WHERE item_id= '$itemID' AND customer_id='$customerID' AND DATE(valid_from) <= DATE(NOW()) AND DATE(valid_until) >= DATE(NOW()) GROUP BY customer_id,item_id,min_qty HAVING MIN(min_qty) <= $qty ORDER BY min_qty DESC LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($price,$percentage);
    while ($stm1->fetch()) {
        $price=($price*100)/(100-$percentage);
        $z = $price;



    }
    $stm1->close();

    $stm1 = $db1->prepare("SELECT pricetype_id,discount_percentage FROM Customer_Pricelist WHERE customer_id ='$customerID' AND (NOT allow_discount='onlydisc' OR allow_discount IS NULL)");
    $stm1->execute();
    $stm1->bind_result($customerPriceTypeID,$discountPercent);
    while ($stm1->fetch()) {
        if(strcmp($discountPercent,'')==0){$discountPercent = 0;}
        $z = getPriceFromPriceType($itemID, $customerPriceTypeID);
        $z = $z - $z*$discountPercent/100;
    }
    $stm1->close();


 return $z*getPriceRate();
}


function getDefaultPriceFromPriceType($itemID,$customerID,$priceTypeID,$isB2C,$qty=1)
{
    global $username, $password, $database;
    $z=0;
    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");
    $stm1 = $db1->prepare("SELECT price FROM ContractPrices WHERE item_id= '$itemID' AND customer_id='$customerID' AND DATE(valid_from) <= DATE(NOW()) AND DATE(valid_until) >= DATE(NOW()) GROUP BY customer_id,item_id,min_qty HAVING MIN(min_qty) <= $qty ORDER BY min_qty DESC LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($price);
    while ($stm1->fetch()) {

        $z = $price;



    }
    $stm1->close();

    if($z>0)
    {
        return $z*getPriceRate();
    }

    $db1->set_charset("utf8");
    $stm1 = $db1->prepare("SELECT price FROM ContractPrices WHERE item_id= '$itemID' AND customer_id='1' AND DATE(valid_from) <= DATE(NOW()) AND DATE(valid_until) >= DATE(NOW()) GROUP BY customer_id,item_id,min_qty HAVING MIN(min_qty) <= $qty ORDER BY min_qty DESC LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($price);
    while ($stm1->fetch()) {

        $z = $price;



    }
    $stm1->close();

    if($z>0)
    {
        return $z*getPriceRate();
    }


    $stm1 = $db1->prepare("SELECT price_group_definition_id FROM Price_Group_Customer WHERE customer_id='$customerID'");
    $stm1-> execute();
    $stm1-> bind_result($priceGroupDefinitionID);
    while ($stm1->fetch()) {

        $categories = array();
        $categories = getItemCategories($itemID);

        foreach($categories as $category)
        {
            $db = new mysqli('localhost',$username,$password,$database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $db->set_charset("utf8");
            $stm = $db->prepare("SELECT discount_percent,price_type_id FROM Price_Group_Rules WHERE  price_group_definition_id ='$priceGroupDefinitionID' AND category_id='$category'");
            $stm-> execute();
            $stm-> bind_result($discountPercent,$priceGroupPriceTypeID);
            while ($stm->fetch()) {

                $price = getPriceFromPriceType($itemID,$priceGroupPriceTypeID) - getPriceFromPriceType($itemID,$priceGroupPriceTypeID)*$discountPercent/100;
                $z = $price;
                if($z>0)
                {
                    break;
                }



            }
            $stm->close();
            if($z>0)
            {
                break;
            }

        }
        if($z>0)
        {
            break;
        }
    }
    $stm1->close();


    if($z>0)
    {
        return $z;
    }



    $stm1 = $db1->prepare("SELECT price_group_definition_id FROM Price_Group_Customer_Group WHERE customer_group_id IN(SELECT group_id AS customer_group_id FROM Customer_CustomersGroup WHERE customer_id='$customerID')");
    $stm1-> execute();
    $stm1-> bind_result($priceGroupDefinitionID);
    while ($stm1->fetch()) {

        $categories = array();
        $categories = getItemCategories($itemID);

        foreach($categories as $category)
        {
            $db = new mysqli('localhost',$username,$password,$database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $db->set_charset("utf8");
            $stm = $db->prepare("SELECT discount_percent,price_type_id FROM Price_Group_Rules WHERE  price_group_definition_id ='$priceGroupDefinitionID' AND category_id='$category'");
            $stm-> execute();
            $stm-> bind_result($discountPercent,$priceGroupPriceTypeID);
            while ($stm->fetch()) {

                $price = getPriceFromPriceType($itemID,$priceGroupPriceTypeID) - getPriceFromPriceType($itemID,$priceGroupPriceTypeID)*$discountPercent/100;
                $z = $price;
                if($z>0)
                {
                    break;
                }



            }
            $stm->close();
            if($z>0)
            {
                break;
            }

        }
        if($z>0)
        {
            break;
        }
    }
    $stm1->close();


    if($z>0)
    {
        return $z*getPriceRate();
    }


    $stm1 = $db1->prepare("SELECT pricetype_id,discount_percentage FROM Customer_Pricelist WHERE customer_id ='$customerID' AND (NOT allow_discount='onlydisc' OR allow_discount IS NULL)");
    $stm1->execute();
    $stm1->bind_result($customerPriceTypeID,$discountPercent);
    while ($stm1->fetch()) {
        if(strcmp($discountPercent,'')==0){$discountPercent = 0;}
        $z = getPriceFromPriceType($itemID, $customerPriceTypeID);
        $z = $z - $z*$discountPercent/100;
    }
    $stm1->close();

    if($z > 0) {
        return $z*getPriceRate();
    }



    $stm1 = $db1->prepare("SELECT price FROM Prices WHERE item_id='$itemID' AND pricetype_id='$priceTypeID'");
    $stm1->execute();
    $stm1->bind_result($price);

    while ($stm1->fetch()) {
        $z=$price;
    }
    $stm1->close();

    if($z>0)
    {
        return $z*getPriceRate();
    }


    $stm1 = $db1->prepare("SELECT price FROM Prices,PriceTypes WHERE item_id= '$itemID' AND default_type=\"yes\" AND Prices.pricetype_id=PriceTypes.pricetype_id  LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($price);
    while ($stm1->fetch()) {

        $z = $price;



    }
    $stm1->close();


    return $z*getPriceRate();
}

function getDefaultImage($itemID)
{
 global $username, $password, $database;
 $z=0;
 $db1 = new mysqli('localhost',$username,$password,$database);
 if (mysqli_connect_errno()) {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db1->set_charset("utf8");

 $stm1 = $db1->prepare("SELECT image_url FROM Item_Images WHERE item_id= '$itemID' ORDER BY image_order ASC, timestamp DESC");
 $stm1-> execute();
 $stm1-> bind_result($image);
 while ($stm1->fetch()) {

  $z = "//" . HTML_PATH . "/cop/media/productImages/$image.jpg";
  $rz = ROOT."/media/productImages/$image.jpg";
  if(!file_exists("../".$rz) && !file_exists($rz))
  {
	  $z = "//" . HTML_PATH . "/cop/media/productImages/$image.png";
      $rz = ROOT."/media/productImages/$image.png";
  }

  if(file_exists($rz)){break;}

 }
 $stm1->close();

 if(!file_exists($rz))
 {
  $z = "./assets/img/noimage.jpg";
 }

 return $z;
}

function getVatPercentage($vatID,$db1='') {
    if(is_string($db1) && strcmp($db1,'')==0) {
        global $username, $password, $database;
        $db1 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
    }

    $customerID = intval($_SESSION['customerID']);
    if($customerID > 0) {
        $stm1 = $db1->prepare("SELECT vat_id FROM Customer_Vat WHERE customer_id='$customerID' LIMIT 1");
        $stm1->execute();
        $stm1->bind_result($customerVatID);
        while ($stm1->fetch()) {
            if ($customerVatID > 0) {$vatID = $customerVatID;}
        }
        $stm1->close();
    }

    $stm1 = $db1->prepare("SELECT percentage FROM Vats WHERE vat_id='$vatID' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($percentage);
    while ($stm1->fetch()) {
        return $percentage;
    }
    $stm1->close();

    return $percentage;


}


function getQtyFromCart($orderID,$itemID) {
 global $username, $password, $database;
 $qty=0;
 $db1 = new mysqli('localhost',$username,$password,$database);
 if (mysqli_connect_errno()) {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db1->set_charset("utf8");

 $stm1 = $db1->prepare("SELECT qty FROM Online_Order_Item WHERE order_id='$orderID' AND item_id='$itemID' AND promotion_id=0 LIMIT 1");
 $stm1-> execute();
 $stm1-> bind_result($qty);
 while ($stm1->fetch()) {}
 $stm1->close();
 if(!isset($qty)) {
     $qty=0;
 }

 $addItemByUnits = true;
 $stm1 = $db1->prepare("SELECT order_qty_by_subunits FROM B2B_Configuration LIMIT 1");
 $stm1-> execute();
 $stm1-> bind_result($orderQtyBySubunits);
 while ($stm1->fetch()) {
     if(strcmp($orderQtyBySubunits,'yes')==0){
         $addItemByUnits = false;
     }
 }
 $stm1-> close();

 if($addItemByUnits) {
     $qty = $qty / floatval(getSubUnits($itemID));
 }

 return $qty;


}


function itemInCart($itemID,$orderID) {
 global $username, $password, $database;
 $z=false;

 $db1 = new mysqli('localhost',$username,$password,$database);
 if (mysqli_connect_errno()) {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db1->set_charset("utf8");

 $stm1 = $db1->prepare("SELECT COUNT(*)FROM Online_Order_Item WHERE order_id='$orderID' AND item_id='$itemID' AND promotion_id=0");
 $stm1-> execute();
 $stm1-> bind_result($counter);
 while ($stm1->fetch()) {

  if($counter>0)
  {
   $z=true;
  }
 }
 $stm1->close();
 return $z;


}


function updateItemInCart($itemID,$orderID,$qty,$customerID){
 global $username, $password, $database;
 if($customerID == 0 || strcmp($customerID,'')==0){$anonymous = true;} else {$anonymous = false;}
 $unitPrice = getDefaultPriceInclPriceTypes($itemID,$customerID,$anonymous,$qty) / getPriceRate();
 $db = new mysqli('localhost',$username,$password,$database);
 if (mysqli_connect_errno())
 {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db->set_charset("utf8");
 $stmt = $db->prepare("UPDATE Online_Order_Item SET qty=?,unit_price=? WHERE order_id=? AND item_id=? AND promotion_id=0");
 $stmt->bind_param('ddii',$qty,$unitPrice,$orderID,$itemID);
 $stmt->execute();
 $stmt->close();


}


function  insertItemInCart($itemID,$orderID,$qty,$customerID)
{
 global $username, $password, $database;
 if($customerID == 0 || strcmp($customerID,'')==0){$anonymous = true;} else {$anonymous = false;}
 $unitPrice = getDefaultPriceInclPriceTypes($itemID,$customerID,$anonymous,$qty) / getPriceRate();
 //$onlineOrderItemID=getNextKey("Online_Order_Item","order_item_id");
 $db = new mysqli('localhost', $username, $password, $database);
 if (mysqli_connect_errno()) {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db->set_charset("utf8");


 $stmt = $db->prepare("INSERT INTO Online_Order_Item (order_id,item_id,qty,unit_price,timestamp) VALUES(?,?,?,?,NOW())");
 $stmt->bind_param('iidd', $orderID, $itemID, $qty, $unitPrice);
 $stmt->execute();
 $stmt->close();
}






function  removeItemFromCart($itemID,$orderID)
{
 global $username, $password, $database;
 $db = new mysqli('localhost', $username, $password, $database);
 if (mysqli_connect_errno()) {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db->set_charset("utf8");


 $stmt = $db->prepare("DELETE FROM Online_Order_Item WHERE item_id=? AND order_id=? AND promotion_id=0");
 $stmt->bind_param('ii',$itemID,$orderID);
 $stmt->execute();
 $stmt->close();
}

function  removeItemFromDropShip($itemID,$orderID)
{
    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");


    $stmt = $db->prepare("DELETE FROM Online_Order_Item WHERE order_item_id=? AND order_id=? AND promotion_id=0");
    $stmt->bind_param('ii',$itemID,$orderID);
    $stmt->execute();
    $stmt->close();
}

function  removeItemFromPromotionFromCart($promotionID,$orderID,$promotionNumber)
{
    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");


    $stmt = $db->prepare("DELETE FROM Online_Order_Item WHERE  promotion_id=? AND promotion_number=? AND order_id=? ");
    $stmt->bind_param('iii',$promotionID,$promotionNumber,$orderID);
    $stmt->execute();
    $stmt->close();
}
function clearCart($orderID)
{
    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");


    $stmt = $db->prepare("DELETE FROM Online_Order_Item WHERE  order_id=?");
    $stmt->bind_param('i',$orderID);
    $stmt->execute();
    $stmt->close();
}


function  getAvailableOrderID($customerID,$userID,$status="draft")
{
 global $username, $password, $database;
 $z=false;

 $db1 = new mysqli('localhost',$username,$password,$database);
 if (mysqli_connect_errno()) {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db1->set_charset("utf8");

 $stm1 = $db1->prepare("SELECT order_id FROM Online_Orders WHERE customer_id='$customerID' AND salesperson_id='$userID' AND status='$status' LIMIT 1");
 $stm1-> execute();
 $stm1-> bind_result($orderID);
 while ($stm1->fetch()) {

 }
 $stm1->close();
 if(strcmp("$orderID","0")!=0 &&strcmp("$orderID","")!=0 &&strcmp("$orderID"," ")!=0)
 {
   return $orderID;
 }
 else{

  //$orderID=getNextKey("Online_Orders","order_id");

  $db = new mysqli('localhost', $username, $password, $database);
  if (mysqli_connect_errno()) {
   printf("Connect failed: %s\n", mysqli_connect_error());
   exit();
  }
  $db->set_charset("utf8");


  $stmt = $db->prepare("INSERT INTO Online_Orders (customer_id,salesperson_id,status,timestamp) VALUES(?,?,?,NOW())");
  $stmt->bind_param('iis', $customerID, $userID, $status);
  $stmt->execute();
  $orderID = $stmt->insert_id;
  $stmt->close();

  return $orderID;
 }

}

function getPrefix($activationCode,$db1='')
{
    if(is_string($db1) && strcmp($db1,'')==0) {
        global $username, $password, $database;
        $displayPrefix="";

        $db1 = new mysqli('localhost',$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db1->set_charset("utf8");
    }


 $stm1 = $db1->prepare("SELECT display_prefix FROM Devices WHERE activation_code='$activationCode' LIMIT 1");
 $stm1-> execute();
 $stm1-> bind_result($displayPrefix);
 while ($stm1->fetch()) {

 }
 $stm1->close();
 return "O".$displayPrefix;
}

function getReceiptPrefix($activationCode)
{
    global $username, $password, $database;
    $displayPrefix="";

    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT display_prefix FROM Devices WHERE activation_code='$activationCode' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($displayPrefix);
    while ($stm1->fetch()) {

    }
    $stm1->close();
    return "R".$displayPrefix;
}

function getPrefixForTimesheet($activationCode)
{
    global $username, $password, $database;
    $displayPrefix="";

    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT display_prefix FROM Devices WHERE activation_code='$activationCode' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($displayPrefix);
    while ($stm1->fetch()) {

    }
    $stm1->close();
    return "W".$displayPrefix;
}


function getNextCode($table,$field,$tablePrefix,$activationCode,$db,$devicesTable = 'Devices')
{


    $result   = 0;
    $prefix   = '';
    $nextCode = '';

    $stm1 = $db->prepare("SELECT display_prefix FROM Devices WHERE activation_code='$activationCode' LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($prefix);
    while ($stm1->fetch()) {}
    $stm1->close();

    if(strcmp($prefix,'')!=0) {
        $prefix = $tablePrefix.$prefix;
        $stm = $db->prepare("SELECT REPLACE($field, '$prefix', '')+1 AS counter FROM $table WHERE $field LIKE'$prefix%' AND REPLACE($field, '$prefix', '') REGEXP '^-?[0-9]+$' ORDER BY counter DESC LIMIT 1");
        $stm->execute();
        $stm->bind_result($nextCode);
        while ($stm->fetch()) {
            if(is_numeric($nextCode) && $nextCode > 0){
                $result=$nextCode;
            }
        }
        $stm->close();
    }

    if($result > 0){
        while (canceledActionExists($table,$prefix,$result)){
            $result++;
        }
        return $prefix.$result;
    } else {
        return $prefix.'10000';
    }


}

function canceledActionExists($table,$prefix,$code){
    $z=false;

    $actionType = rtrim($table,'s');
    $actionCode = $prefix.$code;

    global $username,$password,$database;
    $db9 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $stm1 = $db9->prepare("SELECT cancelled_id FROM Cancelled_Actions WHERE type = '$actionType' AND code = '$actionCode' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($key);
    while ($stm1->fetch()) {
        if(strcmp($key,'')!=0 && $key > 0){
            $z = true;
        }
    }
    $stm1->close();

    return $z;
}

function getNextReceiptCode($activationCode)
{
    global $username, $password, $database;
    $beginOrderNumber="";

    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT begin_receipt_number FROM Devices WHERE activation_code='$activationCode' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($beginOrderNumber);
    while ($stm1->fetch()) {

    }
    $stm1->close();
    return $beginOrderNumber;
}

function getNextWaybillCode($activationCode)
{
    global $username, $password, $database;
    $beginWaybillNumber="";

    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT begin_waybill_number FROM Devices WHERE activation_code='$activationCode' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($beginWaybillNumber);
    while ($stm1->fetch()) {

    }
    $stm1->close();
    return $beginWaybillNumber;
}


function setNextOrderCode($activationCode)
{
 global $username, $password, $database;

 $db = new mysqli('localhost',$username,$password,$database);
 if (mysqli_connect_errno())
 {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db->set_charset("utf8");
 $stmt = $db->prepare("UPDATE Devices SET begin_order_number=begin_order_number+1 WHERE activation_code='$activationCode'");
 $stmt->execute();
 $stmt->close();



}

function setNextWaybillCode($activationCode)
{
    global $username, $password, $database;

    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stmt = $db->prepare("UPDATE Devices SET begin_waybill_number=begin_waybill_number+1 WHERE activation_code='$activationCode'");
    $stmt->execute();
    $stmt->close();



}

function setNextReceiptCode($activationCode)
{
    global $username, $password, $database;

    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stmt = $db->prepare("UPDATE Devices SET begin_receipt_number=begin_receipt_number+1 WHERE activation_code='$activationCode'");
    $stmt->execute();
    $stmt->close();
}


function getOrderPDFForPrinting($orderID)
{
    global $username, $password, $database;
 $db = new mysqli('localhost', $username, $password, $database);
 if (mysqli_connect_errno()) {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db->set_charset("utf8");

 $stm = $db->prepare("SELECT order_code,order_date,subtotal,grand_total,vat_amount,customer_id,company_id,order_address_id,discount_amount FROM Orders WHERE order_id='$orderID' LIMIT 1");
 $stm->execute();
 $stm->bind_result($orderCode, $orderDate, $subtotal, $grandTotal, $vatAmount,$customerID,$companyID,$orderAddressID,$discountAmount);

 while ($stm->fetch()) {


 }
 $stm->close();

    $orderDate = date_format( date_create_from_format('Y-m-d', $orderDate), 'd-m-Y');

    $subtotal = number_format(floatval($subtotal),2);
    $grandTotal = number_format(floatval($grandTotal),2);
    $vatAmount = number_format(floatval($vatAmount),2);


 $stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies WHERE company_id='$companyID' LIMIT 1");
 $stm->execute();
 $stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);

 while ($stm->fetch()) {


 }
 $stm->close();


 $stm = $db->prepare("SELECT customer_code,customer_company_name FROM Customers WHERE customer_id='$customerID' LIMIT 1");
 $stm->execute();
 $stm->bind_result($customerCode, $customerName);

 while ($stm->fetch()) {


 }
 $stm->close();


 $stm = $db->prepare("SELECT address_line_1,address_line_2 FROM CustomerAddress WHERE customer_address_id='$orderAddressID' LIMIT 1");
 $stm->execute();
 $stm->bind_result($addressLine1, $addressLine2);

 while ($stm->fetch()) {


 }
 $stm->close();
 $displayDate =$orderDate;



 $result= "
<div class='row'>
<div  class='col-sm-8 col-sm-offset-2'>

<style>




        *
        {
            margin:0;
            padding:0;
            font-family:Arial;
            font-size:10pt;
            color:#000;
        }
        body
        {
            width:100%;
            font-family:Arial;
            font-size:10pt;
            margin:0;
            padding:0;
        }

        p
        {
            margin:0;
            padding:0;
        }

        #wrapper
        {
            width:180mm;
            margin:0 15mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {
            height:50mm;
        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_bodyr
        {
            height: 149mm;
        }

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;

            border-spacing:0;
            border-collapse: collapse;


        }

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size:9pt;
  border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family:monospace;
            text-align:right;
            padding-right:3mm;
            font-size:10pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


       @page {
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }

        .customer {
           font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
           font-weight: 400;
        }

    </style>


<htmlpageheader name='myHTMLHeader1'>
    <p style='text-align:center; font-weight:bold; font-size:22px;padding-top:10px;'>Online Order</p>
    <br/>
    <table class='heading' style='width:100%;'>
        <tr>
            <td style='width:100mm;'>
                <h1 class='heading' style='padding-top:2px;padding-bottom:2px;'>$line1</h1>
                <h2 class='heading'>
                    $line2<br/>
                    $line3<br/>
                    $line4<br/>
                    $line5<br/>
                    $line6<br/>
                    $line7
                </h2>
            </td>
            <td rowspan='2' valign='top' align='right' style='padding:3mm;'>
                <table>
                    <tr><td style='font-weight:bold'>Order No: </td><td>$orderCode</td></tr>
                    <tr><td style='font-weight:bold'>Date: </td><td>$displayDate</td></tr>
                    <tr><td style='font-weight:bold'>Type : </td><td>Online Order</td></tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class='customer'>
                <b>Customer</b> :<br />
                $customerCode -  $customerName<br />
               $addressLine1
                <br />
               $addressLine2<br />
            </td>
        </tr>
    </table>
<div id='invoice_body'>
     <table id='tableHeader' style='margin-top:10px;'>
            <tr style='background:#eee;'>
                <td style='width:8%' ><b>No.</b></td>
                <td style='width:17%'><b>Code</b></td>
                 <td style='width:30%'><b>Description</b></td>
                <td style='width:15%'><b>Quantity</b></td>
                <td style='width:15%' ><b>Unit Price</b></td>
                <td style='width:15%'><b>Total</b></td>
            </tr>
            </table>
</div>
</htmlpageheader>

    <div id='content' >

        <div id='invoice_body' >

            <table style='overflow:hidden;'>

            ";

    $addItemByUnits = true;
    $stm = $db->prepare("SELECT order_qty_by_subunits FROM B2B_Configuration LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($orderQtyBySubunits);
    while ($stm->fetch()) {
        if(strcmp($orderQtyBySubunits,'yes')==0){
            $addItemByUnits = false;
        }
    }
    $stm-> close();

 $counter = 0;
 $stm = $db->prepare("SELECT Order_Item.item_id,qty,unit_price,Items.vat_id,item_code,name,Order_Item.description FROM Order_Item,Items WHERE Order_Item.item_id=Items.item_id AND Order_Item.order_id='$orderID'");
 $stm->execute();
 $stm->bind_result($itemID, $qty, $unitPrice, $vatID, $itemCode, $name,$description);
 while ($stm->fetch()) {
     $counter++;

     if($addItemByUnits) {
         $qty = $qty / floatval(getSubUnits($itemID));
         $lineTotal = $unitPrice*$qty;
     } else {
         $lineTotal = $unitPrice*$qty / floatval(getSubUnits($itemID));
     }

     $name .= " $description";

     $lineTotal = number_format(floatval($lineTotal),2);

     if($customerID > 0) {
         $name = getCustomerSynonym($customerID,$itemID,'name',$name);
         $itemCode = getCustomerSynonym($customerID,$itemID,'code',$itemCode);
     }

  $result.= "<tr>
                <td style='width:8%'> $counter</td >
                <td style='width:17%;' > $itemCode  </td >
                <td style='width:30%'> $name </td >
                <td style='width:15%;text-align:right;padding-right:5px;'  > $qty</td >
                <td style='width:15%;text-align:right;padding-right:5px;' > $unitPrice</td >
                <td style='width:15%;text-align:right;padding-right:5px;'  > $lineTotal</td >
            </tr >";

 }
 $stm->close();

    if($discountAmount > 0){
        $discountAmountDisplay = number_format(floatval($discountAmount),2);
        $discountAmountLabel = "<tr>
                    <td style='text-align:left; padding-left:10px;'></td>
                    <td style='width:15%;text-align:right;font-weight:bold'> Discount</td>
                    <td style='width:15%;text-align:right;' >$discountAmountDisplay</td>
                </tr>";
    }
 $result.=
     "

        </table>
        </div>


        <div id='invoice_total' style='margin-top:20px;'>
            <table>
                <tr>
                    <td style='text-align:left; padding-left:10px;'></td>
                    <td style='width:15%;text-align:right;font-weight:bold'> Subtotal</td>
                    <td style='width:15%;text-align:right;' >$subtotal</td>
                </tr>
                $discountAmountLabel
                <tr>
                    <td style='text-align:left; padding-left:10px;'></td>
                    <td style='width:15%;text-align:right;font-weight:bold'> Vat</td>
                    <td style='width:15%;text-align:right;' >$vatAmount</td>
                </tr>
                <tr>
                    <td style='text-align:left; padding-left:10px;'></td>
                    <td style='width:15%;text-align:right;font-weight:bold'> Grand Total</td>
                    <td style='width:15%;text-align:right;' >$grandTotal</td>
                </tr>
            </table>
        </div>


    </div>



    </div>

</div>
<htmlpagefooter name='myFooter1'>
            <table width='100%' style='vertical-align: bottom; font-family: Helvetica Neue, Helvetica, Arial, sans-serif; font-size: 8pt;
                color: #000000;  '><tr>
                <td width='33%'><span style=''>{DATE d-m-Y}</span></td>
                <td width='33%' align='center' style=''>{PAGENO} of {nbpg}</td>
                <td width='33%' style='text-align: right; '>$orderCode</td>
                </tr></table>
            </htmlpagefooter>

<sethtmlpagefooter name='myHTMLHeader1' value='on'' />
<sethtmlpagefooter name='myFooter1' value='on'' />
";


 return $result;
}


function getItemCategories($itemID)
{
    global $username, $password, $database;
    $categories=array();

    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT category_id FROM Category_Item WHERE item_id='$itemID'");
    $stm->execute();
    $stm->bind_result($categoryID);

    while ($stm->fetch()) {
        array_push($categories,$categoryID);
    }
    $stm->close();

    return $categories;
}

function getPriceFromPriceType($itemID,$priceTypeID)
{
    global $username, $password, $database;
    $z=0;

    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT price FROM Prices WHERE item_id='$itemID' AND pricetype_id='$priceTypeID'");
    $stm->execute();
    $stm->bind_result($price);

    while ($stm->fetch()) {
        $z=$price;
    }
    $stm->close();

    return $z;
}

function round_up($number, $precision = 2)
{
    $fig = (int) str_pad('1', $precision, '0');
    return (ceil($number * $fig) / $fig);
}

function getOrderPDF($orderID)
{
    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT order_code,order_date,delivery_date,subtotal,grand_total,vat_amount,customer_id,company_id,order_address_id,delivery_address_id,delivery_method,details,discount_amount FROM Orders WHERE order_id='$orderID'");
    $stm->execute();
    $stm->bind_result($orderCode, $orderDate,$deliveryDate, $subtotal, $grandTotal, $vatAmount,$customerID,$companyID,$orderAddressID,$deliveryAddressID,$deliveryMethod,$details,$discountAmount);
    while ($stm->fetch()) {}
    $stm->close();

    $anonymousCheckout = false;
    $addItemByUnits = true;
    $stm = $db->prepare("SELECT anonymous_checkout,anonymous_checkout_customer_id,show_prices_with_vat,order_qty_by_subunits FROM B2B_Configuration");
    $stm-> execute();
    $stm-> bind_result($anonymousCheckoutCheck,$anonymousCheckoutCustomerID,$showPricesIncludingVAT,$orderQtyBySubunits);
    while ($stm->fetch()) {
        if(strcmp($anonymousCheckoutCheck,'yes')==0 && $anonymousCheckoutCustomerID == $customerID){
            $anonymousCheckout = true;
        }
        if(strcmp($orderQtyBySubunits,'yes')==0){
            $addItemByUnits = false;
        }
    }
    $stm->close();



    $orderDate = date_format( date_create_from_format('Y-m-d', $orderDate), 'd-m-Y');
    $deliveryDate = date_format( date_create_from_format('Y-m-d', $deliveryDate), 'd-m-Y');

    $subtotal = B2B_CURRENCY_SYMBOL.' '.number_format(floatval($subtotal),2);
    $grandTotal = B2B_CURRENCY_SYMBOL.' '.number_format(floatval($grandTotal),2);
    $vatAmount = B2B_CURRENCY_SYMBOL.' '.number_format(floatval($vatAmount),2);

    $stm = $db->prepare("SELECT  subtotal_currency, grand_total_currency, vat_amount_currency, currency_id, currency_rate, currency_sign FROM Multi_Currency_Orders WHERE Multi_Currency_Orders.order_id='$orderID' LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($subtotalCurrency,$grandTotalCurrency,$vatAmountCurrency,$currencyID,$currencyRate,$currencySign);
    while ($stm->fetch()) {

        if($subtotalCurrency >  0){$subtotal = "$currencySign ".number_format(floatval($subtotalCurrency),2);}
        if($vatAmountCurrency >  0){$vatAmount = "$currencySign ".number_format(floatval($vatAmountCurrency),2);}
        if($grandTotalCurrency >  0){$grandTotal = "$currencySign ".number_format(floatval($grandTotalCurrency),2);}

    }

    if(strcmp($currencyRate,'')==0){$currencyRate = 1;}
    if(strcmp($currencySign,'')==0){$currencySign = B2B_CURRENCY_SYMBOL;}


    $stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies WHERE company_id='$companyID'");
    $stm->execute();
    $stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);

    while ($stm->fetch()) {
    if(strcmp($line1,'')!=0){$line1 .="<br>";}
    if(strcmp($line2,'')!=0){$line2 .="<br>";}
    if(strcmp($line3,'')!=0){$line3 .="<br>";}
    if(strcmp($line4,'')!=0){$line4 .="<br>";}
    if(strcmp($line5,'')!=0){$line5 .="<br>";}
    if(strcmp($line6,'')!=0){$line6 .="<br>";}

    }
    $stm->close();

    if($anonymousCheckout){
        $detailsAndCustomerInfo = explode('Customer:',$details);
        $details = $detailsAndCustomerInfo[0];
        $customerCode = str_replace("\n","<br>",$detailsAndCustomerInfo[1]);
        $customerCode = str_replace("Address: ","",$customerCode);
        $customerCode = str_replace("Phone: ","",$customerCode);
        $customerCode = str_replace("Email: ","",$customerCode);
    } else {
        $stm = $db->prepare("SELECT customer_code,customer_company_name FROM Customers WHERE customer_id='$customerID'");
        $stm->execute();
        $stm->bind_result($customerCode, $customerName);
        while ($stm->fetch()) {
            $customerCode = " - ".$customerCode;
        }
        $stm->close();


        $stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,city,landline FROM CustomerAddress WHERE customer_address_id='$orderAddressID' LIMIT 1");
        $stm->execute();
        $stm->bind_result($addressLine1, $addressLine2,$postcode,$city,$landline);
        while ($stm->fetch()) {
            if(strcmp($addressLine2,'')!=0 && strcmp($city,'')!=0){$addressLine2 .= ",";}
            if(strcmp($postcode,'')!=0 && strcmp($city,'')!=0){$postcode .= ",";}
            if(strcmp($landline,'')!=0 ){$landline = "Tel.: ".$landline;}
            $deliveryAddress = "<b>Address:&nbsp;</b></td><td align='left'>$addressLine1 $postcode $addressLine2 $city";
        }
        $stm->close();

        if($deliveryAddressID != 0 &&  $deliveryAddressID != $orderAddressID){


            $stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,city,landline FROM CustomerAddress WHERE customer_address_id='$deliveryAddressID' LIMIT 1");
            $stm->execute();
            $stm->bind_result($addressLine1D, $addressLine2D,$postcodeD,$cityD,$landlineD);
            while ($stm->fetch()) {
                if(strcmp($addressLine2D,'')!=0 && strcmp($cityD,'')!=0){$addressLine2D .= ",";}
                if(strcmp($postcodeD,'')!=0 && strcmp($cityD,'')!=0){$postcodeD .= ",";}
                if(strcmp($landlineD,'')!=0 ){$landlineD = "Tel.: ".$landlineD;}
                $deliveryAddress = "<b>Address:&nbsp;</b></td><td align='left'>$addressLine1D $postcodeD $addressLine2D $cityD";
            }
            $stm->close();


        }
    }


    $displayDate =$orderDate;
    $displayDeliveryDate =$deliveryDate;

//    $details = str_replace("\n","<br>","$details");
    $detailsPayment = explode("\nPayment Method:","$details");
    $details = $detailsPayment[0];
    $paymentMethod = $detailsPayment[1];

    $paymentMethodTimeSlots = explode("\nTime Slot:","$paymentMethod");
    $paymentMethod = $paymentMethodTimeSlots[0];
    $timeSlot = $paymentMethodTimeSlots[1];

    if(strcmp($timeSlot,'')!=0){
        $timeslotLabel = "<b>Time Slot:&nbsp;</b></td><td align='left'>$timeSlot";
    }

    if(strcmp($details,'')!=0 && strcmp($details,' ')!=0) {
        $details = "<tr><td colspan='3' align='left' style='padding:0mm;padding-left: 2mm;padding-right: 2mm;'>Notes: $details</td></tr>";
    }


    if(strcmp(trim($deliveryMethod),'')!=0){
        $deliveryMethod = "<b>Method:&nbsp;</b></td><td align='left'>$deliveryMethod";
    }
    if(strcmp(trim($paymentMethod),'')!=0){
        $paymentMethod = "<b>Payment:&nbsp;</b></td><td align='left'>$paymentMethod";
    }


    $result= "
<div class='row'>
<div  class='col-sm-10 col-sm-offset-1' style='border: #888 1px solid'>

<style>




        *
        {
            margin:0;
            padding:0;
            font-family:Arial;
            font-size:10pt;
            color:#000;
        }
        body
        {
            width:100%;
            font-family:Arial;
            font-size:10pt;
            margin:0;
            padding:0;
        }

        p
        {
            margin:0;
            padding:0;
        }

        #wrapper
        {
            width:180mm;
            margin:0 15mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {
            height:50mm;
        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_bodyr
        {
            height: 149mm;
        }

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;

            border-spacing:0;
            border-collapse: collapse;


        }

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size:9pt;
  border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family:monospace;
            text-align:right;
            padding-right:3mm;
            font-size:14pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


       @page {
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }

        .customer {
           font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
           font-weight: 400;
        }

    </style>


<htmlpageheader name='myHTMLHeader1'><br>
    <table  style='width:100%'>
          <tr>
              <td valign='top' style='width:30%'>
                  <img style='display:block;max-width: 200px;' src='//" . HTML_PATH . "/cop/media/pdfimage/logo.png'/>
              </td>
              <td  valign='top' style='width:40%' align='center'>
                 <p style='display:block;font-weight:bold; font-size:24px; width:100%'>Online Order</p>
              </td>
              <td valign='top' style='width:30%' align='right'>
                 <h1 class='heading' style='display:block;padding-top:2px;padding-bottom:2px;'>$line1</h1>
                            <h2 class='heading'>
                                $line2
                                $line3
                                $line4
                                $line5
                                $line6
                                $line7
                            </h2>
              </td>
           </tr>
      </table>
    
    <table  style='width:100%;'>
        <tr>

            <td  valign='top' align='left' style='padding:1mm;width: 30%'>
                <table>
                    <tr><td style='font-weight:bold' colspan='2'><h3>Order Details</h3></td></tr>
                    <tr><td >Order No.: </td><td>$orderCode</td></tr>
                    <tr><td >Order Type: </td><td>Online Order</td></tr>
                    <tr><td >Order Date: </td><td>$displayDate</td></tr>
                    <tr><td >Delivery Date: </td><td>$displayDeliveryDate</td></tr>
                </table>
            </td>
            <td valign='top' align='center' style='padding:1mm;width: 40%'>
                <table style='width: 70%;'>
                    <tr><td style='font-weight:bold' colspan='2' align='Center'><h3>Delivery Details</h3></td></tr>                    
                    <tr><td style='vertical-align:top;'>$deliveryAddress</td></tr>
                    <tr><td style='vertical-align:top;'>$deliveryMethod</td></tr>
                    <tr><td style='vertical-align:top;'>$paymentMethod</td></tr>
                    <tr><td style='vertical-align:top;'>$timeslotLabel</td></tr>

                </table>
            </td>
            <td class='customer' align='right' style='padding:1mm;width: 30%'>
                <table >
                    <tr><td style='font-weight:bold'  align='right'><h3>Customer Details</h3></td></tr>
                    <tr><td align='right'>$customerName $customerCode</td></tr>
                    <tr><td align='right'>$addressLine1</td></tr>
                    <tr><td align='right'>$postcode $addressLine2 $city</td></tr>
                    <tr><td align='right'>$landline</td></tr>

                </table>
            </td>
        </tr>
        $details
    </table>
    </htmlpageheader>
<div id='invoice_body' style='min-height: 500px;'>
    
     <table id='tableHeader' style='margin-top:10px;'>
            <tr style='background:#eee;'>
                <td style='width:8%' ><b>No.</b></td>
                <td style='width:17%'><b>Code</b></td>
                 <td style='width:30%'><b>Description</b></td>
                <td style='width:15%'><b>Quantity</b></td>
                <td style='width:15%' ><b>Unit Price</b></td>
                <td style='width:15%'><b>Total</b></td>
            </tr>
            </table>


            <table style='overflow:hidden;'>

            ";

    $vatsArray = Array();
    $stm = $db->prepare("SELECT vat_id,vat_code,percentage FROM Vats");
    $stm->execute();
    $stm->bind_result($vatID,$vatCode,$percentage);
    while ($stm->fetch()) {
        $vatObject= new stdClass();
        $vatObject->id=$vatID;
        $vatObject->code=$vatCode;
        $vatObject->percentage=$percentage;
        $vatObject->vatAmount=0;
        $vatObject->goods=0;
        array_push($vatsArray,$vatObject);
    }
    $stm->close();

    $counter = 0;
    $stm = $db->prepare("SELECT Order_Item.item_id,qty,unit_price,Items.vat_id,item_code,name,Order_Item.description FROM Order_Item,Items WHERE Order_Item.item_id=Items.item_id AND Order_Item.order_id='$orderID'");
    $stm->execute();
    $stm->bind_result($itemID, $qty, $unitPrice, $vatID, $itemCode, $name,$description);



    while ($stm->fetch()) {
        $counter++;
        $unitPrice *= $currencyRate;
        if($addItemByUnits) {
            $qty = $qty / floatval(getSubUnits($itemID));
            $lineTotal = $unitPrice*$qty;
        } else {
            $lineTotal = $unitPrice*$qty / floatval(getSubUnits($itemID));
        }
        $defaultPrice = getDefaultPriceInclPriceTypesNoOffer($itemID,$customerID,false,$qty)/getPriceRate()*$currencyRate;

        $name .= " $description";

        if($defaultPrice > $unitPrice && $unitPrice > 0){
            $percentDiscount = round((1 - ($unitPrice/$defaultPrice))*100);
            $discountLabel = "<span class='pull-right' style='color: firebrick !important;' ><center>&nbsp; (-$percentDiscount%)</center></span>";
        } else {
            $discountLabel = "";
        }

        $vatOnUnitPrice = 0;
        $vatLineAmount = 0;

        foreach($vatsArray as $vatObject)
        {
            if($vatObject->id==$vatID)
            {
                $vatOnUnitPrice = $vatObject->percentage * $unitPrice / 100;
                $vatLineAmount = $vatObject->percentage * $lineTotal / 100;
                $vatObject->vatAmount+=$vatLineAmount;
                $vatObject->goods+=$lineTotal;
            }
        }

        if(strcmp($showPricesIncludingVAT,"yes")==0){
            $lineTotalDisplay = $currencySign.' '.number_format(floatval($lineTotal+$vatLineAmount),2);
            $unitPriceDisplay = $currencySign.' '.number_format(floatval($unitPrice+$vatOnUnitPrice),2);
        } else {
            $lineTotalDisplay = $currencySign.' '.number_format(floatval($lineTotal),2);
            $unitPriceDisplay = $currencySign.' '.number_format(floatval($unitPrice),2);
        }

        if($customerID > 0) {
            $name = getCustomerSynonym($customerID,$itemID,'name',$name);
            $itemCode = getCustomerSynonym($customerID,$itemID,'code',$itemCode);
        }

        $result.= "<tr>
                <td style='width:8%'> $counter</td >
                <td style='width:17%;' > $itemCode  </td >
                <td style='width:30%'> $name </td >
                <td style='width:15%;text-align:center;padding-right:5px;'  > $qty</td >
                <td style='width:15%;text-align:right;padding-right:5px;' > $unitPriceDisplay $discountLabel</td >
                <td style='width:15%;text-align:right;padding-right:5px;'  > $lineTotalDisplay</td >
            </tr >";



    }
    $stm->close();


    $result.=
        "

        </table>
        </div>


    <div id='invoice_total' style='margin-top:20px;border-top: 1px solid #222;border-bottom: 1px solid #222;'>
            <table style='width: 100%'>
             <tr>
               <td style='width:50%;'>

               <table>
                  <tr>
                    <td style='text-align:center'>
                     <p style='display: inline;text-align:center;'><b> VAT Summary</b></p>
                    </td>
                 </tr>
                 </table>
                 <table>
                 <tr>

                   <td style='width:33%;text-align:center;font-weight: bold;'>
                     <p > Percent:</p>
                   </td>
                   <td style='width:33%;text-align:center;font-weight: bold;'>
                     <p > Goods:</p>
                   </td>
                   <td style='width:33%;text-align:center;font-weight: bold;'>
                     <p> VAT</p>
                   </td>
                 </tr>";


    foreach($vatsArray as $vatObject) {

        if($vatObject->goods>0) {

            $vatObject->goods = number_format(floatval($vatObject->goods),2);
            $vatObject->vatAmount = number_format(floatval($vatObject->vatAmount),2);
            $result .= "<tr>
                <td style='width:33%;font-size:12px;text-align:center;' > $vatObject->percentage%  </td >
                <td style='width:33%;font-size:12px;text-align:center;'>  $currencySign $vatObject->goods </td >
                 <td style='width:33%;text-align:center;font-size:12px;'> $currencySign $vatObject->vatAmount</td >
            </tr >";
        }

    }

    if($discountAmount > 0){
        $discountAmountDisplay = number_format(floatval($discountAmount),2);
        $discountAmountLabel = "<tr>
                    <td style='text-align:right;font-weight:bold;'> Discount</td>
                    <td style='text-align:right;' >$currencySign $discountAmountDisplay</td>
                </tr>";
    }
    $result.="
               </table>

              </td>
              <td style='width:20%'></td>
              <td  style='width:30%;'>
               <table>
                <tr>
                    <td style='text-align:right;font-weight:bold;'> Subtotal</td>
                    <td style='text-align:right;' >$subtotal</td>
                </tr>
                $discountAmountLabel
                <tr>
                    <td style='text-align:right;font-weight:bold'> Vat Total</td>
                    <td style='text-align:right;' >$vatAmount</td>
                </tr>
                <tr>
                    <td style='text-align:right;font-weight:bold'> Grand Total</td>
                    <td style='text-align:right;' >$grandTotal</td>
                </tr>
            </table>
              </td>
            </tr>
          </table>
        </div>
  <br>


    </div>



   

</div>

";


    return $result;
}

function getTenderPDF($tenderID)
{
    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT tender_code,tender_date,valid_until,subtotal,grand_total,vat_amount,customer_id,company_id,name,address_line_1,address_line_2 FROM Tenders WHERE tender_id='$tenderID'");
    $stm->execute();
    $stm->bind_result($orderCode, $orderDate,$validUntil, $subtotal, $grandTotal, $vatAmount,$customerID,$companyID,$anonymousCustomerName,$anonymousAddressLine1,$anonymousAddressLine2);

    while ($stm->fetch()) {


    }
    $stm->close();

    $orderDate = date_format( date_create_from_format('Y-m-d', $orderDate), 'd-m-Y');
    $validUntil = date_format( date_create_from_format('Y-m-d', $validUntil), 'd-m-Y');

    $subtotal = number_format(floatval($subtotal),2);
    $grandTotal = number_format(floatval($grandTotal),2);
    $vatAmount = number_format(floatval($vatAmount),2);


//    $stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies WHERE company_id='$companyID'");
//    $stm->execute();
//    $stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);
//
//    while ($stm->fetch()) {
//        if(strcmp($line1,'')!=0){$line1 .="<br>";}
//        if(strcmp($line2,'')!=0){$line2 .="<br>";}
//        if(strcmp($line3,'')!=0){$line3 .="<br>";}
//        if(strcmp($line4,'')!=0){$line4 .="<br>";}
//        if(strcmp($line5,'')!=0){$line5 .="<br>";}
//        if(strcmp($line6,'')!=0){$line6 .="<br>";}
//
//    }
//    $stm->close();


    $stm = $db->prepare("SELECT customer_code,customer_company_name FROM Customers WHERE customer_id='$customerID'");
    $stm->execute();
    $stm->bind_result($customerCode, $customerName);

    while ($stm->fetch()) {


    }
    $stm->close();

    $stm = $db->prepare("SELECT anonymous_checkout_customer_id FROM B2B_Configuration");
    $stm-> execute();
    $stm-> bind_result($anonymousCheckoutCustomerID);
    while ($stm->fetch()) {}
    $stm->close();

    if($customerID == $anonymousCheckoutCustomerID){
        $customerName = "Customer";
        $customerCode = $anonymousCustomerName;
        $addressLine1 = str_replace(",","<br>",$anonymousAddressLine1);
        $addressLine2 = str_replace(",","<br>",$anonymousAddressLine2);
    } else {

        $stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,city,landline FROM CustomerAddress WHERE customer_id='$customerID' AND primary_address='yes'");
        $stm->execute();
        $stm->bind_result($addressLine1, $addressLine2, $postcode, $city, $landline);

        while ($stm->fetch()) {
            if (strcmp($addressLine2, '') != 0 && strcmp($city, '') != 0) {
                $addressLine2 .= ",";
            }
            if (strcmp($postcode, '') != 0 && strcmp($city, '') != 0) {
                $postcode .= ",";
            }
            if (strcmp($landline, '') != 0) {
                $landline = "Tel.: " . $landline;
            }

        }
        $stm->close();
    }
    $displayDate =$orderDate;
    $displayDeliveryDate =$deliveryDate;



    $result= "
<div class='row'>
<div  class='col-sm-10 col-sm-offset-1' style='border: #888 1px solid'>

<style>




        *
        {
            margin:0;
            padding:0;
            font-family:Arial;
            font-size:10pt;
            color:#000;
        }
        body
        {
            width:100%;
            font-family:Arial;
            font-size:10pt;
            margin:0;
            padding:0;
        }

        p
        {
            margin:0;
            padding:0;
        }

        #wrapper
        {
            width:180mm;
            margin:0 15mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {
            height:50mm;
        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_bodyr
        {
            height: 149mm;
        }

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;

            border-spacing:0;
            border-collapse: collapse;


        }

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size:9pt;
  border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family:monospace;
            text-align:right;
            padding-right:3mm;
            font-size:14pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


       @page {
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }

        .customer {
           font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
           font-weight: 400;
        }

    </style>


<htmlpageheader name='myHTMLHeader1'><br>
    <table  style='width:100%'>
          <tr>
              <td valign='top' style='width:30%'>
                  <img style='display:block;max-width: 200px;' src='//" . HTML_PATH . "/cop/media/pdfimage/logo.png'/>
              </td>
              <td  valign='top' style='width:40%' align='center'>
                 <p style='display:block;font-weight:bold; font-size:24px; width:100%'>Online Quotation Request</p>
              </td>
              <td valign='top' style='width:30%' align='right'>
                 <h1 class='heading' style='display:block;padding-top:2px;padding-bottom:2px;'>$line1</h1>
                            <h2 class='heading'>
                                $line2
                                $line3
                                $line4
                                $line5
                                $line6
                                $line7
                            </h2>
              </td>
           </tr>
      </table>
    
    <table  style='width:100%;'>
        <tr>

            <td  valign='top' align='left' style='padding:1mm;'>
                <table>
                    <tr><td style='font-weight:bold' colspan='2'><h3>Quotation Details</h3></td></tr>
                    <tr><td >Quotation No.: </td><td>$orderCode</td></tr>
                    <tr><td >Quotation Type: </td><td>Online Quotation</td></tr>
                    <tr><td >Quotation Date: </td><td>$displayDate</td></tr>
                    <tr><td >&nbsp;</td><td>&nbsp;</td></tr>
                </table>
            </td>
            <td ></td>
            <td class='customer' align='right'>
                <table >
                    <tr><td style='font-weight:bold'  align='right'><h3>Customer Details</h3></td></tr>
                    <tr><td align='right'>$customerName - $customerCode</td></tr>
                    <tr><td align='right'>$addressLine1</td></tr>
                    <tr><td align='right'>$postcode $addressLine2 $city</td></tr>
                    <tr><td align='right'>$landline</td></tr>

                </table>
            </td>
        </tr>
    </table>
    </htmlpageheader>
<div id='invoice_body' style='min-height: 500px;'>
    
     <table id='tableHeader' style='margin-top:10px;'>
            <tr style='background:#eee;'>
                <td style='width:8%' ><b>No.</b></td>
                <td style='width:17%'><b>Code</b></td>
                 <td style='width:30%'><b>Description</b></td>
                <td style='width:15%'><b>Quantity</b></td>
                <td style='width:15%' ><b>Unit Price</b></td>
                <td style='width:15%'><b>Total</b></td>
            </tr>
            </table>


            <table style='overflow:hidden;'>

            ";

    $vatsArray = Array();
    $stm = $db->prepare("SELECT vat_id,vat_code,percentage FROM Vats");
    $stm->execute();
    $stm->bind_result($vatID,$vatCode,$percentage);
    while ($stm->fetch()) {
        $vatObject= new stdClass();
        $vatObject->id=$vatID;
        $vatObject->code=$vatCode;
        $vatObject->percentage=$percentage;
        $vatObject->vatAmount=0;
        $vatObject->goods=0;
        array_push($vatsArray,$vatObject);
    }
    $stm->close();

    $addItemByUnits = true;
    $stm = $db->prepare("SELECT order_qty_by_subunits FROM B2B_Configuration LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($orderQtyBySubunits);
    while ($stm->fetch()) {
        if(strcmp($orderQtyBySubunits,'yes')==0){
            $addItemByUnits = false;
        }
    }
    $stm-> close();

    $counter = 0;
    $stm = $db->prepare("SELECT Tender_Item.item_id,qty,unit_price,Items.vat_id,item_code,name FROM Tender_Item,Items WHERE Tender_Item.item_id=Items.item_id AND Tender_Item.tender_id='$tenderID'");
    $stm->execute();
    $stm->bind_result($itemID, $qty, $unitPrice, $vatID, $itemCode, $name);



    while ($stm->fetch()) {
        $counter++;

        if($addItemByUnits) {
            $qty = $qty / floatval(getSubUnits($itemID));
            $lineTotal = $unitPrice*$qty;
        } else {
            $lineTotal = $unitPrice*$qty / floatval(getSubUnits($itemID));
        }

        $lineTotalDisplay = number_format(floatval($lineTotal),2);
        $unitPriceDisplay = number_format(floatval($unitPrice),2);

        if($customerID > 0) {
            $name = getCustomerSynonym($customerID,$itemID,'name',$name);
            $itemCode = getCustomerSynonym($customerID,$itemID,'code',$itemCode);
        }

        $result.= "<tr>
                <td style='width:8%'> $counter</td >
                <td style='width:17%;' > $itemCode  </td >
                <td style='width:30%'> $name </td >
                <td style='width:15%;text-align:center;padding-right:5px;'  > $qty</td >
                <td style='width:15%;text-align:right;padding-right:5px;' > $unitPriceDisplay</td >
                <td style='width:15%;text-align:right;padding-right:5px;'  > $lineTotalDisplay</td >
            </tr >";

        foreach($vatsArray as $vatObject)
        {
            if($vatObject->id==$vatID)
            {
                $vatLineAmount = $vatObject->percentage * $lineTotal / 100;
                $vatObject->vatAmount+=$vatLineAmount;
                $vatObject->goods+=$lineTotal;
            }
        }

    }
    $stm->close();


    $result.=
        "

        </table>
        </div>


    <div id='invoice_total' style='margin-top:20px;border-top: 1px solid #222;border-bottom: 1px solid #222;'>
            <table style='width: 100%'>
             <tr>
               <td style='width:50%;'>

               <table>
                  <tr>
                    <td style='text-align:center'>
                     <p style='display: inline;text-align:center;'><b> VAT Summary</b></p>
                    </td>
                 </tr>
                 </table>
                 <table>
                 <tr>

                   <td style='width:33%;text-align:center;font-weight: bold;'>
                     <p > Percent:</p>
                   </td>
                   <td style='width:33%;text-align:center;font-weight: bold;'>
                     <p > Goods:</p>
                   </td>
                   <td style='width:33%;text-align:center;font-weight: bold;'>
                     <p> VAT</p>
                   </td>
                 </tr>";


    foreach($vatsArray as $vatObject) {

        if($vatObject->goods>0) {

            $vatObject->goods = number_format(floatval($vatObject->goods),2);
            $vatObject->vatAmount = number_format(floatval($vatObject->vatAmount),2);
            $result .= "<tr>
                <td style='width:33%;font-size:12px;text-align:center;' > $vatObject->percentage%  </td >
                <td style='width:33%;font-size:12px;text-align:center;'>  $vatObject->goods </td >
                 <td style='width:33%;text-align:center;font-size:12px;'> $vatObject->vatAmount</td >
            </tr >";
        }

    }


    $result.="
               </table>

              </td>
              <td style='width:20%'></td>
              <td  style='width:30%;'>
               <table>
                <tr>
                    <td style='text-align:right;font-weight:bold;'> Subtotal</td>
                    <td style='text-align:right;' >$subtotal</td>
                </tr>
                <tr>
                    <td style='text-align:right;font-weight:bold'> Vat Total</td>
                    <td style='text-align:right;' >$vatAmount</td>
                </tr>
                <tr>
                    <td style='text-align:right;font-weight:bold'> Grand Total</td>
                    <td style='text-align:right;' >$grandTotal</td>
                </tr>
            </table>
              </td>
            </tr>
          </table>
        </div>
  <br>


    </div>



   

</div>

";


    return $result;
}

function getSubUnits($itemID) {

    global $username, $password, $database;

    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT subunits FROM Items WHERE item_id='$itemID' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($sub);
    while ($stm1->fetch()) {
        return $sub;
    }
    $stm1->close();
    return $sub;


}


function getPacking($itemID) {

    global $username, $password, $database;

    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT packing FROM Items WHERE item_id='$itemID' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($packing);
    while ($stm1->fetch()) {

    }
    $stm1->close();
    if($packing==0)
    {
        $packing=1;
    }

    return $packing;


}

function getStock($itemID)
{
 global $username, $password, $database;

        $stock = 0;
        $db1 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db1->set_charset("utf8");

        $stm = $db1->prepare("SELECT get_stock_from,stock_from_warehouse FROM B2B_Page_Catalogue LIMIT 1");
        $stm-> execute();
        $stm-> bind_result($getStockFrom,$fromWarehouses);
        while ($stm->fetch()) {}
        $stm-> close();


        if(strcmp($getStockFrom,'both')==0){$getStockFrom = "available+reserved";}
        else if(strcmp($getStockFrom,'ignoreReserved')==0){$getStockFrom = "available";}
        else {$getStockFrom = 'available-reserved';}

        if(strcmp($fromWarehouses,'all')==0){$whFilter = "";}
        else if(strcmp($fromWarehouses,'')==0){$whFilter = "";}
        else {$whFilter = " AND warehouse_id IN($fromWarehouses) ";}


        $stm1 = $db1->prepare("SELECT SUM($getStockFrom) FROM Stock WHERE item_id= '$itemID' $whFilter LIMIT 1");
        $stm1->execute();
        $stm1->bind_result($stock);
        while ($stm1->fetch()) {}
        $stm1->close();

 return $stock;
	
}

function showStock($customerID){
//USE SESSION VARIABLE SHOW STOCK $_SESSION['showStock']
    return true;

}


function getPrefixQ($activationCode)
{
 global $username, $password, $database;
 $displayPrefix="";

 $db1 = new mysqli('localhost',$username,$password,$database);
 if (mysqli_connect_errno()) {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db1->set_charset("utf8");

 $stm1 = $db1->prepare("SELECT display_prefix FROM Devices WHERE activation_code='$activationCode' LIMIT 1");
 $stm1-> execute();
 $stm1-> bind_result($displayPrefix);
 while ($stm1->fetch()) {

 }
 $stm1->close();
 return "Q".$displayPrefix;
}

function getNextTenderCode($activationCode)
{
 global $username, $password, $database;
 $beginOrderNumber="";

 $db1 = new mysqli('localhost',$username,$password,$database);
 if (mysqli_connect_errno()) {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db1->set_charset("utf8");

 $stm1 = $db1->prepare("SELECT begin_tender_number FROM Devices WHERE activation_code='$activationCode' LIMIT 1");
 $stm1-> execute();
 $stm1-> bind_result($beginOrderNumber);
 while ($stm1->fetch()) {

 }
 $stm1->close();
 return $beginOrderNumber;
}


function setNextTenderCode($activationCode)
{
 global $username, $password, $database;

 $db = new mysqli('localhost',$username,$password,$database);
 if (mysqli_connect_errno())
 {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db->set_charset("utf8");
 $stmt = $db->prepare("UPDATE Devices SET begin_tender_number=begin_tender_number+1 WHERE activation_code='$activationCode'");
 $stmt->execute();
 $stmt->close();



}


function getDeliveryVatAmount($deliveryFee,$db='')
{
    return $deliveryFee*getItemVatPercent(getItemVatID(getDeliveryItemID(),$db),$db)/100;
}

function getDeliveryCost($subtotal,$sumOFQties,$customer,$db1="")
{
    $deliveryfee = 0;
    $itemID = 0;

    if(is_string($db1) && strcmp($db1,'')==0) {
        global $username, $password, $database;
        $db1 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db1->set_charset("utf8");
    }

//    $stm1 = $db1->prepare("SELECT description FROM Customers WHERE customer_id=\"$customer\" LIMIT 1");
//    $stm1-> execute();
//    $stm1-> bind_result($factor);
//    while ($stm1->fetch()) {}
//    $stm1->close();
//
//    if(strcmp($factor,"0")!=0) {
//        $deliveryfee= $factor*$sumOFQties;
//        return $deliveryfee;
//    }



    $stm1 = $db1->prepare("SELECT delivery_price,notes,item_id FROM Delivery_Cost WHERE min_value < '$subtotal'  ORDER BY min_value DESC LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($deliveryfee,$notes,$itemID);
    while ($stm1->fetch()) {}
    $stm1->close();



    return array($deliveryfee,"$notes",$itemID);
}


function getDeliveryItemID($db1='')
{
    if(is_string($db1) && strcmp($db1,'')==0) {
        global $username, $password, $database;
        $db1 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db1->set_charset("utf8");
    }

    $stm1 = $db1->prepare("SELECT item_id FROM Items WHERE cbm=1 LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($itemID);
    while ($stm1->fetch()) {


    }
    $stm1->close();



    return $itemID;
}


function getItemVatID($itemID,$db1='')
{
    $deliveryfee=0;
    if(is_string($db1) && strcmp($db1,'')==0) {
        global $username, $password, $database;
        $db1 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db1->set_charset("utf8");
    }

    $stm1 = $db1->prepare("SELECT vat_id FROM Items WHERE item_id='$itemID' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($itemID);
    while ($stm1->fetch()) {


    }
    $stm1->close();



    return $itemID;
}


function getItemVatPercent($vatID,$db1='')
{
    $percentage=0;
    if(is_string($db1) && strcmp($db1,'')==0) {
        global $username, $password, $database;
        $db1 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db1->set_charset("utf8");
    }

    $stm1 = $db1->prepare("SELECT percentage FROM Vats WHERE vat_id='$vatID' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($percentage);
    while ($stm1->fetch()) {


    }
    $stm1->close();



    return $percentage;
}


function onPromotion($itemID,$customerID)
{
    global $username, $password, $database;
    $z = 0;
    $db1 = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");
    $stm1 = $db1->prepare("SELECT COUNT(Promotions.promotion_id) FROM Promotions,Promotion_Customer WHERE Promotions.promotion_id=Promotion_Customer.promotion_id AND item_id= '$itemID' AND (Promotion_Customer.customer_id='$customerID' OR Promotion_Customer.customer_id=0) AND type=1 ");
    $stm1->execute();
    $stm1->bind_result($z);
    while ($stm1->fetch()) {



    }
    $stm1->close();

    if ($z > 0) {
        return true;
    }
    else
    {
        return false;
    }
}

function onAfterCartPromotion($itemID,$customerID)
{
    global $username, $password, $database;
    $z = 0;
    $db1 = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");
    $stm1 = $db1->prepare("SELECT COUNT(Promotions.promotion_id) FROM Promotions,Promotion_Customer,Items WHERE Promotions.promotion_id=Promotion_Customer.promotion_id AND Items.item_id= '$itemID' AND Promotions.item_id=Items.long_description AND (Promotion_Customer.customer_id='$customerID' OR Promotion_Customer.customer_id=0) AND type=2 AND NOT Promotions.item_id=0");
    $stm1->execute();
    $stm1->bind_result($z);
    while ($stm1->fetch()) {



    }
    $stm1->close();

    if ($z > 0) {
        return true;
    }
    else
    {
        return false;
    }
}

function getAvailableAfterCartPromotions($itemID,$customerID)
{
    global $username, $password, $database;
    $promotions=array();
    $db1 = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");
    $stm1 = $db1->prepare("SELECT Promotions.promotion_id,promotion_code,promotion_name,Promotions.item_id,Promotions.qty,Promotions.fixed_discount_percent FROM Promotions,Promotion_Customer,Items WHERE Promotions.promotion_id=Promotion_Customer.promotion_id AND Items.item_id= '$itemID' AND Promotions.item_id=Items.long_description AND (Promotion_Customer.customer_id='$customerID' OR Promotion_Customer.customer_id=0) AND NOT Promotions.item_id=0 AND type=2 AND CURDATE() >= valid_from AND CURDATE()<=valid_until GROUP BY qty ORDER BY qty ");
    $stm1->execute();
    $stm1->bind_result($id,$code,$name,$categoryID,$qty,$discount);
    while ($stm1->fetch()){
        $promotion= new stdClass();
        $promotion->id=$id;
        $promotion->code=$code;
        $promotion->name=$name;
        $promotion->categoryID=$categoryID;
        $promotion->qty=$qty;
        $promotion->discount=$discount;
        array_push($promotions,$promotion);



    }
    $stm1->close();

    return $promotions;
}

function getAvailablePromotions($itemID,$customerID)
{
    global $username, $password, $database;
    $promotions=array();
    $db1 = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");
    $stm1 = $db1->prepare("SELECT Promotions.promotion_id,promotion_code,promotion_name FROM Promotions,Promotion_Customer WHERE Promotions.promotion_id=Promotion_Customer.promotion_id AND item_id= '$itemID' AND (Promotion_Customer.customer_id='$customerID' OR Promotion_Customer.customer_id=0) AND type=1 AND CURDATE() >= valid_from AND CURDATE()<=valid_until ");
    $stm1->execute();
    $stm1->bind_result($id,$code,$name);
    while ($stm1->fetch()){
        $promotion= new stdClass();
        $promotion->id=$id;
        $promotion->code=$code;
        $promotion->name=$name;
        array_push($promotions,$promotion);



    }
    $stm1->close();

    return $promotions;
}


function getNextPromotionNumber($orderID)
{
    global $username, $password, $database;
    $promotionOrderNumber=0;
    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT MAX(promotion_number) FROM Online_Order_Item WHERE order_id='$orderID' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($promotionOrderNumber);
    while ($stm1->fetch()) {


    }
    $stm1->close();

    $promotionOrderNumber=  $promotionOrderNumber+1;

    return $promotionOrderNumber;
}


function applyMixAndMatchDiscount($categoryID,$customerID,$totalQty,$orderID)
{
    global $username, $password, $database;
    $discount=0;
    $matchedPromotion= new stdClass();
    $matchedPromotion->id=0;
    $matchedPromotion->code="";
    $matchedPromotion->name="";
    $matchedPromotion->discount=$discount;
    $db1 = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");
    $stm1 = $db1->prepare("SELECT Promotions.promotion_id,promotion_code,promotion_name,qty,fixed_discount_percent FROM Promotions,Promotion_Customer WHERE Promotions.promotion_id=Promotion_Customer.promotion_id AND item_id= '$categoryID' AND (customer_id='0' OR customer_id='$customerID') AND CURDATE()>= valid_from AND CURDATE()<=valid_until  AND type=2 ORDER BY qty ");
    $stm1->execute();
    $stm1->bind_result($id,$code,$name,$minQty,$promotionDiscountPercent);
    while ($stm1->fetch()){
        $promotion= new stdClass();
        $promotion->id=$id;
        $promotion->code=$code;
        $promotion->name=$name;
        $promotion->discount=$promotionDiscountPercent;
        $promotion->number=getNextPromotionNumber($orderID);
        if($minQty<=$totalQty)
        {
            $matchedPromotion=$promotion;
        }



    }
    $stm1->close();


    $stm2 = $db1->prepare("SELECT Online_Order_Item.order_item_id,Online_Order_Item.item_id,Online_Order_Item.qty FROM Online_Order_Item,Items,Category_Item WHERE Category_Item.category_id='$categoryID' AND Items.item_id=Category_Item.item_id AND  Online_Order_Item.item_id=Items.item_id AND Online_Order_Item.order_id='$orderID' AND Online_Order_Item.promotion_number=0");
    $stm2->execute();
    $stm2->bind_result($orderItemID,$itemID,$qty);

    while ($stm2->fetch()) {
       $dPrice= getDefaultPrice($itemID,$customerID,'',$qty) / getPriceRate();
        $unitPrice=$dPrice-$dPrice *$matchedPromotion->discount/100;
        $lineDiscountPercentage=$matchedPromotion->discount;
        $promotionID=$matchedPromotion->id;

        $db2 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("utf8");
        $stmt = $db2->prepare("UPDATE Online_Order_Item SET unit_price=?,line_discount_percentage=? WHERE order_item_id=? AND item_id=?");
        $stmt->bind_param('ddii',$unitPrice,$lineDiscountPercentage,$orderItemID,$itemID);
        $stmt->execute();
        $stmt->close();



    }
    $stm2->close();



}


function backInStock()
{
    global $username, $password, $database;
    $result=0;
    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT COUNT(*) FROM Stock WHERE MONTH(timestamp) = MONTH(NOW() - INTERVAL 1 MONTH) ");
    $stm1-> execute();
    $stm1-> bind_result($result);
    while ($stm1->fetch()) {


    }
    $stm1->close();
    return $result;
}

function getLastValueOfCustomForm($customFormID,$customFieldID,$tableName,$tableID)
{

    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");


    $value = "";
    $stm = $db->prepare("SELECT value FROM ZA_Custom_Field_Object,ZA_Custom_Form_Object,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Object.custom_form_id='$customFormID' AND ZA_Custom_Form_Object.custom_form_id =ZA_Custom_Form_Usage.custom_form_id AND ZA_Custom_Form_Usage.linked_table='$tableName' AND  ZA_Custom_Form_Object.linked_table_id='$tableID' AND ZA_Custom_Form_Object.custom_form_object_id=ZA_Custom_Field_Object.custom_form_object_id AND ZA_Custom_Field_Object.custom_field_id='$customFieldID' LIMIT 1");
    $stm->execute();
    $stm->bind_result($value);
    while ($stm->fetch()) {


    }
    $stm->close();

    return $value;
}

function getItemAttributes($orderID,$itemID,$qty,$db1='')
{
    if(is_string($db1) && strcmp($db1,'')==0) {
        global $username, $password, $database;
        $db1 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
    }

    $db1->set_charset("utf8");
    $stm1 = $db1->prepare("SELECT line_discount,global_discount,line_discount_percentage,master_item FROM Online_Order_Item WHERE order_id='$orderID' AND item_id='$itemID' AND qty='$qty' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($lineDiscount,$globalDiscount,$lineDiscountPercentage,$masterItem);
    while ($stm1->fetch()) {}
    $stm1->close();

    $item = new stdClass();
    $item->masterItem = $masterItem;
    $item->lineDiscountPercentage = $lineDiscountPercentage;
    $item->lineDiscount = $lineDiscount;
    $item->globalDiscount = $globalDiscount;

    return $item;
}

function getItemUOMs($orderID,$itemID)
{
    global $username, $password, $database;
    $uoms=array();
    $qty = 0;

    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT qty_picked,qty_delivered,qty FROM Online_Order_Item WHERE order_id=? AND item_id=? AND promotion_id=0 LIMIT 1");
    $stm-> bind_param('ii',$orderID,$itemID);
    $stm-> execute();
    $stm-> bind_result($oldMultiplier,$oldUomID,$oldQty);
    while ($stm->fetch()) {}
    $stm->close();

    $stm = $db->prepare("SELECT UOMs.description,UOMs.uom_id,UOM_Item.multiplier FROM UOM_Item,UOMs,Items WHERE UOM_Item.uom_id=UOMs.uom_id AND Items.item_id=UOM_Item.item_id AND UOMs.active='yes' AND UOM_Item.item_id='$itemID' AND Items.sales_units='multiple' ORDER BY UOM_Item.position ASC");
    $stm->execute();
    $stm->bind_result($uomName,$uomID,$uomMultiplier);

    while ($stm->fetch()) {

        if($oldUomID > 0 && $oldUomID == $uomID){
            $selected = 'selected';
            $qty = $oldQty/$uomMultiplier;
        } else {
            $selected = '';
        }

        $uom = new stdClass();
        $uom->id = $uomID;
        $uom->name = $uomName;
        $uom->multiplier = $uomMultiplier;
        $uom->selected = $selected;
        $uom->qty = $qty;
        array_push($uoms,$uom);
    }
    $stm->close();

    return $uoms;
}

function getUomName($uomID)
{
    global $username, $password, $database;

    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT UOMs.description FROM UOMs WHERE uom_id='$uomID' LIMIT 1");
    $stm->execute();
    $stm->bind_result($uomName);
    while ($stm->fetch()) {
    }
    $stm->close();

    return $uomName;
}

function updateItemUomInCart($itemID,$orderID,$uomID,$multiplier,$customerID){
    global $username, $password, $database;
    if($customerID == 0 || strcmp($customerID,'')==0){$anonymous = true;} else {$anonymous = false;}
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT qty_picked,qty FROM Online_Order_Item WHERE order_id=? AND item_id=? AND promotion_id=0 LIMIT 1");
    $stm-> bind_param('ii',$orderID,$itemID);
    $stm-> execute();
    $stm-> bind_result($oldMultiplier,$oldQty);
    while ($stm->fetch()) {}
    $stm->close();

    if((int)$oldMultiplier < 1){
        $oldMultiplier = 1;
    }

    if((int)$oldQty == 0){
        $oldQty = 0;
    }

    $unitQty = $oldQty/$oldMultiplier;
    $qty = $unitQty*$multiplier;


    $stmt = $db->prepare("UPDATE Online_Order_Item SET qty_picked=?,qty_delivered=? WHERE order_id=? AND item_id=? AND promotion_id=0");
    $stmt->bind_param('ddii',$multiplier,$uomID,$orderID,$itemID);
    $stmt->execute();
    $stmt->close();


    echo "UPDATE Online_Order_Item SET qty_picked=$multiplier,qty_delivered=$uomID WHERE order_id=$orderID AND item_id=$itemID AND promotion_id=0";
}

function getPriceRate(){
    $currencyID = getOrderCurrency();
    global $username, $password, $database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT rate_on_default FROM Display_Currency WHERE currency_id=$currencyID LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($rate);
    while ($stm->fetch()) {}
    $stm->close();


    if(strcmp($rate,'')==0 || (float)$rate == 0){
        return 1;
    } else {
        return $rate;
    }
}

function getCurrencySign(){
    $currencyID = getOrderCurrency();
    $currencySign = B2B_CURRENCY_SYMBOL;
    global $username, $password, $database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT currency_sign FROM Display_Currency WHERE currency_id=$currencyID LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($selectedSign);
    while ($stm->fetch()) {
        if(strcmp($selectedSign,'')!=0){
            $currencySign = $selectedSign;
        }
    }
    $stm->close();

    return $currencySign;
}

function getCurrencyCode(){
    $currencyID = getOrderCurrency();
    $currencySign = B2B_CURRENCY_SYMBOL;
    global $username, $password, $database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT currency_code FROM Display_Currency WHERE currency_id=$currencyID LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($selectedSign);
    while ($stm->fetch()) {
        if(strcmp($selectedSign,'')!=0){
            $currencySign = $selectedSign;
        }
    }
    $stm->close();

    return $currencySign;
}
function getCurrencyIso(){
    $currencyID = getOrderCurrency();
    $currencySign = B2B_CURRENCY_SYMBOL;
    global $username, $password, $database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT iso_code FROM Display_Currency WHERE currency_id=$currencyID LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($selectedSign);
    while ($stm->fetch()) {
        if(strcmp($selectedSign,'')!=0){
            $currencySign = $selectedSign;
        }
    }
    $stm->close();

    return $currencySign;
}

function getOrderCurrency(){
    $orderID=$_SESSION['orderID'];
    $sessionCurrencyID = $_SESSION['currency'];
    $currencyID = 0;

    global $username, $password, $database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    if(isset($sessionCurrencyID) && $sessionCurrencyID > 0){
        $stm = $db->prepare("SELECT currency_id FROM Display_Currency WHERE currency_id=$sessionCurrencyID LIMIT 1");
        $stm-> execute();
        $stm-> bind_result($currentCurrencyID);
        while ($stm->fetch()) {
            if(strcmp($currentCurrencyID,'')!=0){
                $currencyID = $currentCurrencyID;
            }
        }
        $stm->close();
    }
    else if(isset($orderID) && $orderID > 0) {

        $stm = $db->prepare("SELECT Online_Orders.currency_id FROM Online_Orders,Display_Currency WHERE Online_Orders.currency_id=Display_Currency.currency_id AND order_id='$orderID' AND order_id > 0 LIMIT 1");
        $stm->execute();
        $stm->bind_result($orderCurrencyID);
        while ($stm->fetch()) {}
        $stm->close();

        if (strcmp($orderCurrencyID, '') != 0) {
            $currencyID = $orderCurrencyID;
        }

    }

    if($currencyID == 0){
        $stm = $db->prepare("SELECT currency_id FROM Display_Currency WHERE default_currency='yes' LIMIT 1");
        $stm-> execute();
        $stm-> bind_result($defaultCurrencyID);
        while ($stm->fetch()) {
            if(strcmp($defaultCurrencyID,'')!=0){
                $currencyID = $defaultCurrencyID;
            }
        }
        $stm->close();
    }

    $_SESSION['currency'] = $currencyID;
    return $currencyID;
}

function getDefaultCurrency(){

    $currencyRate = 1;
    $currencySign = B2B_CURRENCY_SYMBOL;

    global $username, $password, $database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT rate_on_default,currency_sign,currency_code,currency_name,iso_code FROM Display_Currency WHERE default_currency='yes' LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($currencyOnDefailtRate,$currencyDefailtSign,$currencyDefailtCode,$currencyDefailtName,$currencyIsoCOde);
    while ($stm->fetch()) {
        if(strcmp($currencyOnDefailtRate,'')!=0){
            $currencyRate = $currencyOnDefailtRate;
        }
        if(strcmp($currencyDefailtSign,'')!=0){
            $currencySign = $currencyDefailtSign;
        }
    }
    $stm->close();

    $baseCurrency = new stdClass();
    $baseCurrency->rate = getPriceRate();
    $baseCurrency->sign = $currencySign;
    $baseCurrency->code = $currencyDefailtCode;
    $baseCurrency->name = $currencyDefailtName;
    $baseCurrency->iso  = $currencyIsoCOde;

    return $baseCurrency;
}

function getCurrencyNameBySign($sign){
    $currency = '';
    global $username, $password, $database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT currency_name FROM Display_Currency WHERE currency_sign='$sign' LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($currencyName);
    while ($stm->fetch()) {
        if(strcmp($currencyName,'')!=0){
            $currency = $currencyName;
        }
    }
    $stm->close();
    return $currency;
}

function getCurrencyIsoByID($currencyID = 0){
    if($currencyID == 0) {
        $currencyID = getOrderCurrency();
    }
    $currencySign = B2B_CURRENCY_SYMBOL;
    global $username, $password, $database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT iso_code FROM Display_Currency WHERE currency_id=$currencyID LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($selectedSign);
    while ($stm->fetch()) {
        if(strcmp($selectedSign,'')!=0){
            $currencySign = $selectedSign;
        }
    }
    $stm->close();

    return $currencySign;
}

function getRangeOfNumber($number,$rangeGap=0){

    if((int)$number <= 0){$number = 1;}


    $length = (int)(log($number, 10) + 1) - 2;

    if((int)$rangeGap == 0){
        $rangeGap = 100;
        for($i = 1;$i < $length;$i++){$rangeGap *= 10;}
    }



    if($number % $rangeGap == 0){$number -= 1;}

    $numberEnd = ceil($number / $rangeGap) * $rangeGap;
    $numberStart = floor($number / $rangeGap) * $rangeGap;

    $numberEnd = number_format(floatval($numberEnd),0);
    $numberStart = number_format(floatval($numberStart),0);

    return "$numberStart-$numberEnd";

}

function getNextCodeSingleTransaction($table,$field,$tablePrefix,$activationCode,$db,$devicesTable = 'Devices')
{
    $result   = 0;
    $prefix   = '';
    $nextCode = '';

    $stm1 = $db->prepare("SELECT display_prefix FROM $devicesTable WHERE activation_code='$activationCode' LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($prefix);
    while ($stm1->fetch()) {}
    $stm1->close();

    if(strcmp($prefix,'')!=0) {
        $prefix = $tablePrefix.$prefix;
        $stm = $db->prepare("SELECT REPLACE($field, '$prefix', '')+1 AS counter FROM $table WHERE $field LIKE'$prefix%' AND REPLACE($field, '$prefix', '') REGEXP '^-?[0-9]+$' ORDER BY counter DESC LIMIT 1");
        $stm->execute();
        $stm->bind_result($nextCode);
        while ($stm->fetch()) {
            if(is_numeric($nextCode) && $nextCode > 0){
                $result=$nextCode;
            }
        }
        $stm->close();
    }

    if($result > 0){
        while (canceledActionExists($table,$prefix,$result)){
            $result++;
        }
        return $prefix.$result;
    } else {
        return $prefix.'100000';
    }


}

function getCustomerSynonym($customerID,$itemID,$type,$value){

    $field = $type.'_synonym';

    global $username, $password, $database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT $field FROM Customer_Item_Synonyms WHERE item_id=? AND customer_id=? LIMIT 1");
    $stm->bind_param('ii',$itemID,$customerID);
    $stm-> execute();
    $stm-> bind_result($synonym);
    while ($stm->fetch()) {
        if(strcmp($synonym,'')!=0){
            $value = $synonym;
        }
    }
    $stm->close();

    return $value;
}

function confirmOrderAsPlaced($db,$orderID,$instantDelivery = false){

    $deliveryApprovalDeviceID = 0;
    $deliveryApprovalDeviceToken = '';
    $deliveryApprovalCheck = '';

    $stmt = $db->prepare("SELECT has_delivery_approval FROM B2B_Configuration LIMIT 1");
    $stmt-> execute();
    $stmt-> bind_result($deliveryApprovalCheck);
    while ($stmt->fetch()) {}
    $stmt->close();

    if(strcmp("$deliveryApprovalCheck",'yes')==0 && $instantDelivery) {

        $stmt = $db->prepare("SELECT device_id FROM B2B_Delivery_Approval_Devices LIMIT 1");
        $stmt->execute();
        $stmt->bind_result($deliveryApprovalDeviceID);
        while ($stmt->fetch()) {}
        $stmt->close();
        $deliveryApprovalDeviceID = intval($deliveryApprovalDeviceID);

        if ($deliveryApprovalDeviceID > 0) {
            $gcmID = '';
            $stmt = $db->prepare("SELECT gcm_id FROM Devices_Pop WHERE device_pop_id=? LIMIT 1");
            $stmt->bind_param('i', $deliveryApprovalDeviceID);
            $stmt->execute();
            $stmt->bind_result($gcmID);
            while ($stmt->fetch()) {$deliveryApprovalDeviceToken = "$gcmID";}
            $stmt->close();
        }

        if($deliveryApprovalDeviceID > 0 && strcmp("$deliveryApprovalDeviceToken",'')!=0){

            include_once("../../libs/gcm/FirebasePushNotification.php");

            $orderCode = '';
            $stmt = $db->prepare("SELECT order_code FROM Orders WHERE order_id = ? LIMIT 1");
            $stmt->bind_param('i', $orderID);
            $stmt-> execute();
            $stmt-> bind_result($orderCode);
            while ($stmt->fetch()) {}
            $stmt->close();

            $push = new FirebasePushNotification($db);
            $push->senderID(0);
            $push->selectDeviceByID("Devices_Pop","device_pop_id",$deliveryApprovalDeviceID);
            $push->notificationType('DeliveryApproval');
            $push->title('New Order!');
            $push->body("Order Code: $orderCode");
            $push->send();


        }

        $status = "Awaiting Approval";
        $stmt = $db->prepare("UPDATE Orders SET status=? WHERE order_id=? AND order_id > 0");
        $stmt->bind_param('si', $status, $orderID);
        $stmt->execute();
        $error = $stmt->error;
        $stmt->close();

        if(strcmp("$error", '')==0){return true;}
        else {return false;}

    } else {

        $stm = $db->prepare("SELECT status FROM Orders WHERE order_id='$orderID' LIMIT 1");
        $stm->execute();
        $stm->bind_result($checkStatus);
        while ($stm->fetch()) {}
        $stm->close();

        if(strcmp("$checkStatus","Payment Pending")!=0){
            $status = "Placed";
            $stmt = $db->prepare("UPDATE Orders SET status=? WHERE order_id=? AND order_id > 0");
            $stmt->bind_param('si', $status, $orderID);
            $stmt->execute();
            $error = $stmt->error;
            $stmt->close();
        }

        if(strcmp("$error", '')==0){return true;}
        else {return false;}
    }



}

function getUserFavoriteItems($userID,$customerID){

    global $username, $password, $database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT item_id FROM Customer_Favorite_Items WHERE customer_id = ? AND user_id = ?");
    $stm->bind_param('ii', $customerID, $userID);
    $stm-> execute();
    $stm->bind_result($itemID);
    $favoriteItems = [];
    while ($stm->fetch()) {
        $favoriteItems[] = $itemID;
    }
    $stm->close();

    return $favoriteItems;
}

function isItemFavorite($itemID,$userID,$customerID){
    global $username, $password, $database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT i.item_id FROM Customer_Favorite_Items as fi INNER JOIN Items as i ON i.item_id=fi.item_id WHERE i.item_id = ?  and fi.user_id = ? AND fi.customer_id=? LIMIT 1");
    $stm->bind_param('iii', $itemID,$userID,$customerID);
    $stm->execute();
    $stm->bind_result($isFavorite);
    if ($stm->fetch()) {}
    $stm->close();

    if(intval($isFavorite)>0){return true;}
    else {return false;}

}


?>