<?php
include_once("../../param.php");
session_start();
// Example json : '{"invoiceCode":"OHB100885","datescan":"2022-03-17 13:12:12","customerCode":"C10065","grandTotal":4491.8,"userID":1}';
// useExternalDocument = true : use to check loyalty transaction from documents not in Coprime.
// useExternalDocument = false : use to check loyalty transaction from documents in Coprime.



$actionType = 'Invoice';
$useExternalDocument = false;

$json   = $_POST['scan'];
$userID = $_SESSION['userID'];

$logFile = fopen("loyaltyLog.txt", "w") or die("Unable to open file!");
fwrite($logFile, "USER: $userID "."\n");
fclose($logFile);

$obj = json_decode($json);
$invoiceCode  = $obj->invoiceCode;
$customerCode = $obj->customerCode;
$grandTotal   = $obj->grandTotal;
$dateScan     = date("Y-m-d",strtotime($obj->datescan));

$loyaltyTypeID = 0;
$multiplier    = 0;
global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stmt = $db->prepare("SELECT loyalty_type_id,name,acquiring_points_multiplier,qr_code_valid_days FROM Loyalty_Types WHERE type = '2' AND status='yes' AND DATE(valid_from)<=DATE(NOW()) AND DATE(valid_until)>=DATE(NOW()) ORDER BY valid_from DESC,valid_until ASC");
$stmt->execute();
$stmt->bind_result($loyaltyTypeID,$loyaltyTypeName,$multiplier,$qrCodeValidDays);
while ($stmt->fetch()) {}
$stmt->close();

$qrCodeValidDays = (int)$qrCodeValidDays;
$dateValid   = date('Y-m-d', strtotime("-$qrCodeValidDays days", strtotime("NOW")));

$response    = checkLoyaltyTransaction($invoiceCode,$dateScan,$customerCode,$userID,$dateValid,$grandTotal,$actionType,$loyaltyTypeID,$useExternalDocument);
$objResponse = json_decode($response,true);

$check       = $objResponse['success'];
$message     = $objResponse['message'];


if ($check){
    $success = insertLoyaltyTransaction($invoiceCode,$dateScan,$customerCode,$userID,$grandTotal,$actionType,$loyaltyTypeID,$loyaltyTypeName,$multiplier,$useExternalDocument);
    echo $success;
}else{
    echo json_encode($objResponse);
}










function getPoints($grandTotal,$multiplier){
        return round($grandTotal*$multiplier);
}
function insertLoyaltyTransaction($invoiceCode,$dateScan,$customerCode,$userID,$grandTotal,$actionType,$typeID,$typeName,$multiplier,$useExternalDocument){
    global $username,$password,$database;
    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    try {
        $db->begin_transaction();

        $stm = $db->prepare("SELECT customer_id FROM Customers WHERE customer_code='$customerCode' LIMIT 1");
        $stm-> execute();
        if(strcmp($stm->error,"")!=0) {throw new Exception($stm->error);}
        $stm-> bind_result($customerID);
        while ($stm->fetch()) {}
        $stm-> close();

        $documentID = 0;
        if(!$useExternalDocument) {
            $actionElement = str_replace('Esoft_', '', $actionType);
            $actionTable = $actionElement . 's';
            $actionColumnID = strtolower($actionElement) . '_id';
            $actionColumnCode = strtolower($actionElement) . '_code';

            $actionsArray = array('Orders', 'Invoices', 'Returns');

            // check if document is in Coprime
            if (in_array($actionTable, $actionsArray)) {

                $stm = $db->prepare("SELECT $actionColumnID FROM $actionTable WHERE $actionColumnCode='$invoiceCode' LIMIT 1");
                $stm->execute();
                if(strcmp($stm->error,"")!=0) {throw new Exception($stm->error);}
                $stm->bind_result($actionID);
                while ($stm->fetch()) {if($actionID > 0){$documentID = $actionID;}}
                $stm->close();
            }
        }


        $documentCode  = $invoiceCode;
        $documentTotal = $grandTotal;
        $entryDate     = $dateScan;
        $details       = "$typeName";
        $points        = getPoints($grandTotal,$multiplier);
        $sign          = 1;
        $companyID     = 1;

    //    insert customer in Loyalty Transaction
        $stm = $db->prepare("INSERT INTO Loyalty_Transactions (type_id,action_type,document_id,document_code,document_total,entry_date,sign,points,customer_id,user_id,company_id,details,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stm->bind_param('isisdsidiiis',  $typeID,$actionType,$documentID,$documentCode,$documentTotal,$entryDate,$sign,$points,$customerID,$userID,$companyID,$details);
        $stm->execute();
        if(strcmp($stm->error,"")!=0) {throw new Exception($stm->error);}
        $stm->close();

        $stm = $db->prepare("INSERT INTO Loyalty_Balances (customer_id,user_id,type_id,balance,timestamp) VALUES(?,?,?,?,NOW()) ON DUPLICATE KEY UPDATE balance=balance+?");
        $stm->bind_param('iiidd',  $customerID,$userID,$typeID,$points,$points);
        $stm->execute();
        if(strcmp($stm->error,"")!=0) {throw new Exception($stm->error);}
        $stm->close();

        $stm = $db->prepare("SELECT balance FROM Loyalty_Balances WHERE customer_id='$customerID' AND user_id = '$userID' AND type_id='$typeID' LIMIT 1");
        $stm-> execute();
        if(strcmp($stm->error,"")!=0) {throw new Exception($stm->error);}
        $stm-> bind_result($loyaltyBalance);
        while ($stm->fetch()) {}
        $stm-> close();

        $db->commit(true);

        $data = array(
            'success' => true,
            'docCode' => $documentCode,
            'points' => $points,
            'totalPoints' =>$loyaltyBalance,
            'error' => ''
        );

        $jsonRes = json_encode($data);

        return $jsonRes;

    } catch (Exception  $e) {

        $db->rollback();

        $data = array(
            'success' => false,
            'docCode' => "$documentCode",
            'points' => 0,
            'totalPoints' =>0,
            'error' => $e->getMessage()." ".$e->getLine()." "
        );

        $jsonRes = json_encode($data);

        return $jsonRes;
    }





}

function checkLoyaltyTransaction($invoiceCode,$dateScan,$customerCode,$userID,$validDate,$grandTotal,$actionType,$loyaltyTypeID,$useExternalDocument){

    $message='';
    $check = true;

    global $username,$password,$database;
    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    if($loyaltyTypeID == 0) {
        $check = false;
        $code = "002";
        $message = "No Loyalty Scheme Found.";
    }

    if(!$useExternalDocument) {
        $actionElement = str_replace('Esoft_', '', $actionType);
        $actionTable = $actionElement . 's';
        $actionColumnID = strtolower($actionElement) . '_id';
        $actionColumnCode = strtolower($actionElement) . '_code';
        $actionColumnDate = strtolower($actionElement) . '_date';
        $actionColumnTotal = 'grand_total';

        $actionsArray = array('Orders', 'Invoices', 'Returns');

        // check if document is in Coprime
        if (in_array($actionTable, $actionsArray)) {

            $stm = $db->prepare("SELECT $actionColumnID,$actionColumnDate,$actionColumnTotal FROM $actionTable WHERE $actionColumnCode='$invoiceCode' LIMIT 1");
            $stm->execute();
            $stm->bind_result($actionID,$actionDate, $actionTotal);
            while ($stm->fetch()) {}
            $stm->close();

            // check if document amount matches.
            if (abs(round($actionTotal, 2) - round($grandTotal, 2)) > 0.05) {
                $check = false;
                $code = "005";
                $message = "Error $actionElement $invoiceCode Total Amount Does Not Match.";
            }
            if ($dateScan != $actionDate) {
                $check = false;
                $code = "005";
                $message = "Error $actionElement $invoiceCode Date Does Not Match.";
            }

        } else {
            $check = false;
            $code = "004";
            $message = "Error $actionElement $invoiceCode Does Not Exist.";
        }
    }

//    check if invoice code already exists
    $stm = $db->prepare("SELECT transaction_id FROM Loyalty_Transactions WHERE type_id='$loyaltyTypeID' AND document_code='$invoiceCode' AND action_type='$actionType' LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($countTransactionID);
    while ($stm->fetch()) {}
    $stm-> close();
    if ($countTransactionID>0){
        $check = false;
        $code = "001";
        $message = "Document Already exists.";
    }


//    check valid date
    if ($dateScan<$validDate){
        $check = false;
        $code = "002";
        $message = "Document Expired.";
    }


//    check user with customer
    $stm = $db->prepare("SELECT customer_id FROM Customers WHERE customer_code='$customerCode' LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($customerID);
    while ($stm->fetch()) {}
    $stm-> close();

    $stm = $db->prepare("SELECT b2b_user_id FROM B2B_User WHERE b2b_user_id='$userID' AND customer_id='$customerID' LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($b2bUserID);
    while ($stm->fetch()) {}
    $stm-> close();

    if ($b2bUserID <= 0){
        $check = false;
        $code = "003";
        $message = "Not a Valid User.";
    }

    $data = array(
        'success' => $check,
        'code' => $code,
        'message' => $message
    );

    $jsonRes = json_encode($data);

    $logFile = fopen("loyaltyLog.txt", "a") or die("Unable to open file!");
    fwrite($logFile, $jsonRes."\n");
    fclose($logFile);
    return $jsonRes;
}

?>