<?php
session_start();
if(!isset($_SESSION['customerID']) ) {
    redirect("login.php");
}
function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}
include_once("../param.php");
require("./dbaccess/dbhelper.php");
include_once("headerImports.php");

$customerID = $_SESSION['customerID'];
$userID     = $_SESSION['userID'];
$today      = date('Y-m-d');
$time       = '00:00';

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stm = $db->prepare("SELECT css_theme FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($cssTheme);

while ($stm->fetch()) {
    if($cssTheme <= 1){
        $cssTheme = '';
    }
}

?>

<body id="home" class="wide" >
<!-- PRELOADER -->
<div id="preloader">
    <div id="preloader-status">
        <div class="spinner">
            <div class="rect1"></div>
            <div class="rect2"></div>
            <div class="rect3"></div>
            <div class="rect4"></div>
            <div class="rect5"></div>
        </div>
        <div id="preloader-title">Loading</div>
    </div>
</div>
<!-- /PRELOADER -->

<!-- WRAPPER -->
<div class="wrapper">

    <!-- Popup: Shopping cart items -->
    <div class="modal fade popup-cart" id="popup-cart" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog">
            <div class="container">
                <div class="cart-items">

                </div>
            </div>
        </div>
    </div>
    <!-- /Popup: Shopping cart items -->

    <!-- HEADER -->
        <?php
        $topmenu = "topMenu$cssTheme.php";

        if(strcmp($topmenu,"topMenu2.php")==0){
            echo '<header class="header fixed" style="border: 0px;">';
        } else {
            echo '<header class="header fixed" >';
        }

        include_once("$topmenu");
        if(strcmp($topmenu,"topMenu.php")==0) {
            include_once("navigationMenu.php");
        }
        ?>
    </header>

    <!-- /HEADER -->

    <!-- CONTENT AREA -->
    <div class="content-area">

        <!-- PAGE -->
        <section class="page-section color">
            <div class="container" id="checkoutContainer">
                <h3 class="block-title alt"><i class="fa fa-angle-down"></i><?php echo "Service Call"?></h3>
                <div class="row">
                    <div class="col-md-2"></div>
                    <div class="col-md-8">

                        <form class="smart-form" name="SCForm" id="SCForm" method="post" action="add_b2b_service_call.php" enctype="multipart/form-data">

                            <label>Service Call Type</label>
                            <select class="form-control" name="SCType" id="SCType">
                                <?php

                                $db->set_charset("utf8");
                                $stm = $db->prepare("SELECT type_id, type_code, type_name FROM SC_Types");
                                $stm->execute();
                                $stm->bind_result($SCTypeID, $SCTypeCode, $SCTypeName);
                                while ($stm->fetch()) {

                                    echo "<option value='$SCTypeID'>$SCTypeCode - $SCTypeName</option>";

                                }
                                $stm->close();
                                ?>
                            </select>

                             <?php
                             $serialNumbers = '';
                             $db->set_charset("utf8");
                             $stm = $db->prepare("SELECT Contracts.serial_number_id, serial_number FROM Contracts, Serial_Numbers WHERE Serial_Numbers.serial_number_id = Contracts.serial_number_id AND customer_id = '$customerID'");
                             $stm->execute();
                             $stm->bind_result($serialNumberID,$serialNumber);
                             while ($stm->fetch()) {
                                 $serialNumbers .= "<option value='$serialNumberID'>$serialNumber</option>";
                             }
                             $stm->close();

                             if(strcmp($serialNumbers,'') !=0){
                                 echo "<label>Serial Number</label>
                                       <select class='form-control' name='serialNumber' id='serialNumber'>$serialNumbers</select>";
                             }

                             ?>

                            <label>Title</label>
                            <input class="form-control" type="text" name="SCTitle" id="SCTitle" required/>

                            <label>Details</label>
                            <textarea rows="4" class="form-control" name="SCDetails" id="SCDetails"></textarea>


                            <label>Attachments</label>
                            <label class="form-control" style="height: 100%">
                                <div class="btn btn-primary"><input name="attachment" id="attachment" onchange="this.parentNode.nextSibling.value = this.value" type="file" style="display: none;">Browse</div><input placeholder="No Attachment" readonly="" type="text" class="form-control" style="width: 87%;height:110%; margin-left: 5px; display: inline-block;">
                            </label>

                            <input type="hidden" name="customerID" id="customerID" value="<?php echo $customerID?>">

                            <input type="submit" class="btn btn-primary pull-right" id="submitButton" style="margin-top: 20px;" value="Submit Service Call">
                        </form>

                    </div>

                </div>
        </section>
        <!-- /PAGE -->

    </div>
    <!-- /CONTENT AREA -->



    <!-- FOOTER -->
    <footer class="footer">
        <div class="footer-meta">
            <div class="container">
                <div class="row">
                    <div class="col-sm-6" style="font-size:16px;">
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <!-- /FOOTER -->

    <div id="to-top" class="to-top"><i class="fa fa-angle-up"></i></div>

</div>
<!-- /WRAPPER -->

<!-- Modal -->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="appInfoLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
                    &times;
                </button>
                <h4 class="modal-title" style="margin-left:10px;"><i class="fa fa-lg fa-fw fa-gears"></i><strong style="padding-left:5px;">Service Call Sent</strong></h4>
            </div>

            <footer class="modal-footer" >
                <button onclick="$('#myModal').modal('toggle');window.location.replace('index.php');" class="btn btn-default" type="button" style="margin-right:10px;" >
                    Close
                </button>



            </footer>

        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<!-- JS Global -->
<script src="assets/plugins/jquery/jquery-1.11.1.min.js"></script>
<script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
<script src="assets/plugins/bootstrap-select/js/bootstrap-select.min.js"></script>
<script src="assets/plugins/superfish/js/superfish.min.js"></script>
<script src="assets/plugins/prettyphoto/js/jquery.prettyPhoto.js"></script>
<script src="assets/plugins/jquery.sticky.min.js"></script>
<script src="assets/plugins/jquery.easing.min.js"></script>
<script src="assets/plugins/jquery.easing.min.js"></script>
<script src="assets/plugins/jquery.smoothscroll.min.js"></script>
<script src="assets/plugins/smooth-scrollbar.min.js"></script>
<script src="assets/js/jquery-scrolltofixed-min.js"></script>

<link href="assets/popover/bootstrap-popover-x.min.css" media="all" rel="stylesheet" type="text/css" />
<script src="assets/popover/bootstrap-popover-x.min.js" type="text/javascript"></script>
<!-- JS Page Level -->
<script src="assets/js/theme.js"></script>
<!--[if (gte IE 9)|!(IE)]><!-->
<script src="assets/plugins/jquery.cookie.js"></script>
<script src="assets/js/waitMe.min.js"></script>








<script>



    $(document).ready(function() {

        $("#SCForm").submit(function (e) {

            $("#submitButton").attr("disabled", true);

        });

        var sent = '<?php echo $_GET["sent"]?>';

        if(sent > 0){
            $('#myModal').modal('show');
            $("#submitButton").attr("disabled", true);
        }
    });


</script>

</body>
</html>