<?php
session_start();
include_once("../param.php");
require("./dbaccess/dbhelper.php");

$fromApp= trim($_POST['fromApp']);

$customerID          = trim($_SESSION['customerID']);
$serialNumberID      = trim($_POST['serialNumber']);
$salespersonID       = 0;

$sourceDetails       = "";
$sourceName          = "b2b";

$serviceCallPriority = "Normal";
$serviceCallType     = trim($_POST['SCType']);
$serviceCallTitle    = trim($_POST['SCTitle']);
$serviceCallDetails  = trim($_POST['SCDetails']);

$assignTo            = 0;
$serviceCallStatus   = 1;

$config =  new stdClass();
$config->success = false;

global $username, $password, $database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}

$db->set_charset("utf8");

try {
    $db->begin_transaction();

    $stm = $db->prepare("SELECT customer_address_id FROM CustomerAddress WHERE customer_id = '$customerID'");
    $stm->execute();
    $stm->bind_result($customerAddressID);
    while ($stm->fetch()) {}
    if(strcmp("$stm->error","")!=0) {throw new Exception("$stm->error");}
    $stm->close();


    $stm = $db->prepare("SELECT source_id FROM SC_Sources WHERE source_name LIKE '$sourceName'");
    $stm->execute();
    $stm->bind_result($sourceID);
    while ($stm->fetch()) {}
    if(strcmp("$stm->error","")!=0) {throw new Exception("$stm->error");}
    $stm->close();


    $stm = $db->prepare("SELECT priority_id FROM SC_Priorities WHERE priority_name LIKE '$serviceCallPriority'");
    $stm->execute();
    $stm->bind_result($priority);
    while ($stm->fetch()) {}
    if(strcmp("$stm->error","")!=0) {throw new Exception("$stm->error");}
    $stm->close();


    $serviceCallID  = getNextKeySingleTransaction("Service_Call","service_call_id",$db);
    //$serviceCallCode = getNextServiceCallCode("CLOUD");
    $serviceCallCode = getNextCode("Service_Call","service_call_code",'CC','CLOUD',$db,$devicesTable = 'Devices');

    $stm = $db->prepare("INSERT INTO Service_Call (service_call_id,service_call_code,salesperson_id,assign_to,customer_id,customer_address_id,serial_number_id,source_id,type_id,status_id,priority_id,topic,details,source_name,source_details,date,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW(),NOW())");
    $stm->bind_param('isiiiiiiiiissss',$serviceCallID,$serviceCallCode,$salespersonID,$assignTo,$customerID,$customerAddressID,$serialNumberID,$sourceID,$serviceCallType,$serviceCallStatus,$priority,$serviceCallTitle,$serviceCallDetails,$sourceName,$sourceDetails);
    $stm->execute();
    if(strcmp("$stm->error","")!=0) {throw new Exception("$stm->error");}
    $stm->close();

    //setNextServiceCallCode("CLOUD");

    if (isset($_FILES['attachment']) && !empty($_FILES['attachment'])) {

        $fileName         = str_replace(' ', '_', basename($_FILES['attachment']['name']));
        $fileName         = $serviceCallCode."_".$fileName;
        $file_path        = ROOT . "media/serviceCallAttachments/" . $fileName;
        move_uploaded_file($_FILES['attachment']['tmp_name'], $file_path);

        $statusID = 1;
        $replyTypeID = 2;
        $attachmentOrder = 1;

        $serviceCallReplyID  = getNextKey("Service_Call_Reply","service_call_reply_id");
        $stm = $db->prepare("INSERT INTO Service_Call_Reply (service_call_reply_id, service_call_id, salesperson_id, status_id, reply_type_id, details, date, timestamp) VALUES(?,?,?,?,?,?,NOW(),NOW())");
        $stm->bind_param('iiiiis',$serviceCallReplyID,$serviceCallID,$salespersonID,$statusID,$replyTypeID,$fileName);
        $stm->execute();
        if(strcmp("$stm->error","")!=0) {throw new Exception("$stm->error");}
        $stm->close();

        $scAttachmentID  = getNextKey("Service_Call_Reply_Attachments","sc_attachment_id");
        $stm = $db->prepare("INSERT INTO Service_Call_Reply_Attachments (sc_attachment_id, service_call_reply_id, attachment_name, attachment_url, attachment_order, timestamp) VALUES(?,?,?,?,?, NOW())");
        $stm->bind_param('iissi',$scAttachmentID,$serviceCallReplyID,$fileName,$file_path,$attachmentOrder);
        $stm->execute();
        if(strcmp("$stm->error","")!=0) {throw new Exception("$stm->error");}
        $stm->close();

    }
    $config->success = true;
    $db->commit(true);
    echo json_encode($config);
    redirect("b2bServiceCall.php?sent=1");
} catch (Exception $e) {
    $db->rollback();
    $config->success = false;
    echo json_encode($config);
    redirect("b2bServiceCall.php?sent=0&error=".urlencode($e->getMessage()));

}

function redirect($url)
{
    global $fromApp;
    if (strcmp($fromApp, 'yes') == 0) {

//        $rawParamArray = explode('&', explode('?', $url)[1]);
//        $parameters = array();
//
//        foreach ($rawParamArray as $parameter) {
//            $parameter = explode('=', $parameter);
//            $parameters[$parameter[0]] = $parameter[1];
//        }
//
//        $response = new stdClass();
//        $response->redirectUrl = basename($url);
//        $response->function = str_replace('.php', '', explode('?', basename($url))[0]);
//        $response->parameters = $parameters;
//        $response->sessionID = session_id();
//
//        echo json_encode($response);
    } else {

        if (headers_sent()) {
            die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
        } else {
            header('Location: ' . $url);
            die();
        }
    }
}
?>