<?php
session_start();
require("../concc/dbinfo.php");

$devID = $_POST['deviceID'];
$appURL = $_POST['url'];
$currURL = $_SERVER["HTTP_HOST"].$_SERVER['REQUEST_URI'];
$androidID = $_POST['androidID'];
$companyCode = $_POST['companyCode'];
$displayPrefix = $_POST['displayPrefix'];
$databasePrefix = $_POST['databasePrefix'];
$activationCode = $_POST['activationCode'];
$isActivation   = $_POST['activation'];



$appURL = str_replace('https://','',$appURL);
$appURL = str_replace('http://' ,'',$appURL);

$authError = new stdClass();

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");


$stm = $db->prepare("SELECT app_activation_window FROM Cloud_Configuration LIMIT 1");
$stm->execute();
$stm->bind_result($activationWindowNumber);
while($stm->fetch()) {
    $activationWindow = " AND timestamp >= DATE_SUB(NOW(), INTERVAL {$activationWindowNumber} MONTH)";
}
$stm->close();

if(strcmp($appURL,$currURL)!=0){
    $authError->code = '1';
    $authError->name = 'Domain Mismatch';
    $authError->details = "App URL Call [$appURL] - Server URL Call [$currURL]";
    echo json_encode($authError);
    exit();
} else {

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT count(company_id) FROM Companies WHERE company_code = '$companyCode' LIMIT 1");
    $stm->execute();
    $stm->bind_result($companiesCount);
    while ($stm->fetch()) {}
    $stm->close();

    if($companiesCount > 0){

        $stm = $db->prepare("SELECT count(device_id) FROM Devices WHERE display_prefix = '$displayPrefix' AND device_id = '$devID' LIMIT 1");
        $stm->execute();
        $stm->bind_result($devicesCount);
        while ($stm->fetch()) {}
        $stm->close();

        if($devicesCount == 0){
            $authError->code = '2';
            $authError->name = 'Device Mismatch';
            $authError->details = "Device [ID:$devID][PREFIX:$displayPrefix] does not exist in Database";
            echo json_encode($authError);
            exit();
        }

    } else if(strcmp($isActivation,'CopYes')==0){

        $stm = $db->prepare("SELECT count(device_id) FROM Devices WHERE activation_code = '$activationCode' AND device_id = '$devID' LIMIT 1");
        $stm->execute();
        $stm->bind_result($devicesCount);
        while ($stm->fetch()) {}
        $stm->close();

        if($devicesCount == 0){
            $authError->code = '3';
            $authError->name = 'Activation Device Mismatch';
            $authError->details = "Activation Device [ID:$devID][PREFIX:$displayPrefix] does not exist in Database";
            echo json_encode($authError);
            exit();
        }

    } else {
        $authError->code = '4';
        $authError->name = 'Company Mismatch';
        $authError->details = "Company [CODE:$companyCode] does not exist in Database";
        echo json_encode($authError);
        exit();
    }


}

$counter=0;

$myfile = fopen("update.txt", "w") or die("Unable to open file!");
$lastUpdate = $_POST['lastUpdate'];
$devID = $_POST['deviceID'];
$isFile=false;
if(isset($_POST['file']))
{
   $isFile=true;
}
$date = new DateTime();

fwrite($myfile,"Start Time : ".$date->getTimestamp()."\n");


$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$xml = new SimpleXMLElement('<?xml version="1.0" encoding="UTF-8"?>'.'<xml/>');

//timestamp
$stm = $db->prepare("SELECT CURRENT_TIMESTAMP() FROM Companies");
$stm-> execute();
$stm-> bind_result($time);
while ($stm->fetch()) {
    $s = $xml->addChild('t');



    $s->addAttribute('time',$time);

}
$stm-> close();

$validID=false;
// STATUS CHECK
$stm = $db->prepare("SELECT expiry_date,status FROM Devices WHERE device_id='$devID'");
$stm-> execute();
$stm-> bind_result($expiryDate,$status);
while ($stm->fetch()) {
    $s = $xml->addChild('e');
$validID=true;
    if($expiryDate < $time)
    {
        $s->addAttribute('status','disabled');
    }
    else
        if($status =='disabled')
        {
            $s->addAttribute('status','disabled');
        }
        else
        {
            $s->addAttribute('status','enabled');
        }
        

}
$stm-> close();

if(!$validID)
{
    return;
}


$file = fopen("sync".$devID.".txt","w");


//Deletes
if(!strcmp($isActivation,'CopYes')==0) {
    $stm = $db->prepare("SELECT statement FROM Deletes WHERE timestamp >='$lastUpdate'");
    $stm->execute();
    $stm->bind_result($statement);
    while ($stm->fetch()) {

        $s = $xml->addChild('s');

        $s->addAttribute('c', $statement);
    }
    $stm->close();
}

//ZA_Custom_Tables_App_Sync
$stm = $db->prepare("SELECT command FROM ZA_Custom_Tables_App_Sync WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($command);
while ($stm->fetch()) {
    $s = $xml->addChild('s');

    $s->addAttribute('c', $command);
}
$stm->close();



//CustomerGroups

$stm = $db->prepare("SELECT group_id,group_code,name,description,creation_date,timestamp FROM CustomerGroups WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($groupID,$groupCode,$name,$description,$creationDate,$timestamp);
while ($stm->fetch()) {



$groupCode= prepareString($groupCode);
$name= prepareString($name);
$description= prepareString($description);
$creationDate= prepareString($creationDate);

    
    
    
    
    $txt="INSERT OR REPLACE INTO  'CustomerGroups' VALUES ('$groupID', '$groupCode', '$name', '$description', '$creationDate','$timestamp')";
    if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
  $counter++;
}
$stm-> close();


//Customers

$stm = $db->prepare("SELECT customer_id,customer_code,customer_company_name,customer_report_name,logo,registration_code,mobile,website,email,description,type_of_business,tic_code,vat_code,credit_limit,customer_type,balance,timestamp FROM Customers WHERE timestamp >='$lastUpdate' ");
$stm-> execute();
$stm-> bind_result($customerID,$customerCode,$name,$reportName,$logo,$registrationCode,$mobile,$website,$email,$description,$typeOfBusiness,$ticCode,$vatCode,$creditLimit,$typeOfCustomer,$balance,$timestamp);
while ($stm->fetch()) {
  

$customerCode= prepareString($customerCode);
$name= prepareString($name);
$reportName= prepareString($reportName);
$logo= prepareString($logo);
$registrationCode= prepareString($registrationCode);
$mobile= prepareString($mobile);
$website= prepareString($website);
$email= prepareString($email);
$description= prepareString($description);
$typeOfBusiness= prepareString($typeOfBusiness);
$ticCode= prepareString($ticCode);
$vatCode= prepareString($vatCode);
$typeOfCustomer= prepareString($typeOfCustomer);


  
  
  
  
    $txt="INSERT OR REPLACE INTO  'Customers' VALUES ('$customerID', '$customerCode', '$name', '$reportName', '$logo', '$registrationCode', '$mobile', '$website', '$email', '$description', '$typeOfBusiness', '$ticCode', '$vatCode', '$creditLimit','$typeOfCustomer','$balance','$timestamp')";
    if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;

}
$stm-> close();

//Customer_CustomersGroup
$stm = $db->prepare("SELECT group_id,customer_id,added_date,salesperson_id,timestamp FROM Customer_CustomersGroup WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($groupID,$customerID,$addedDate,$salepersonID,$timestamp);
while ($stm->fetch()) {


$addedDate= prepareString($addedDate);

   
    $txt="INSERT OR REPLACE INTO  'Customer_CustomersGroup' VALUES ('$groupID', '$customerID', '$addedDate', '$salepersonID','$timestamp')";
   if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//CustomerAddress

$stm = $db->prepare("SELECT customer_address_id,address_code,customer_id,country,city,address_line_1,address_line_2,postcode,region,lat,lng,pobox,landline,fax,primary_address,timestamp FROM CustomerAddress WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($customerAddressID,$addressCode,$customerID,$country,$city,$addressLine1,$addressLine2,$postcode,$region,$lat,$lng,$pobox,$landline,$fax,$primaryAddress,$timestamp);
while ($stm->fetch()) {
    
    
    

 
$addressCode= prepareString($addressCode);

$country= prepareString($country);
$city= prepareString($city);
$addressLine1= prepareString($addressLine1);
$addressLine2= prepareString($addressLine2);
$postcode= prepareString($postcode);
$region= prepareString($region);
$pobox= prepareString($pobox);
$landline= prepareString($landline);
$fax= prepareString($fax);
$primaryAddress= prepareString($primaryAddress);

    
    
    
    
    
    
    
    $txt="INSERT OR REPLACE INTO  'CustomerAddress' VALUES ('$customerAddressID', '$addressCode', '$customerID', '$country', '$city', '$addressLine1', '$addressLine2', '$postcode', '$region', '$lat', '$lng', '$pobox', '$landline', '$fax','$primaryAddress', '$timestamp')";
      if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }

$counter++;
}
$stm-> close();

//Contact_Person

$stm = $db->prepare("SELECT contact_person_id,first_name,last_name,position,landline,mobile,fax,email,customer_id,notes,timestamp FROM Contact_Person WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($contactPersonID,$firstName,$lastName,$position,$landline,$mobile,$fax,$email,$customerID,$notes,$timestamp);
while ($stm->fetch()) {


$firstName= prepareString($firstName);
$lastName= prepareString($lastName);
$position= prepareString($position);
$landline= prepareString($landline);
$mobile= prepareString($mobile);
$fax= prepareString($fax);
$email= prepareString($email);

$notes= prepareString($notes);

    
    $txt="INSERT OR REPLACE INTO  'Contact_Person' VALUES ('$contactPersonID', '$firstName', '$lastName', '$position', '$landline', '$mobile', '$fax', '$email', '$customerID', '$notes','$timestamp')";
      if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//Categories

$stm = $db->prepare("SELECT category_id,category_code,name,description,creation_date,allow_subcategories,allow_items,level,custom_order,timestamp FROM Categories WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($categoryID,$categoryCode,$name,$description,$creationDate,$allowSubcategories,$allowItems,$level,$customOrder,$timestamp);
while ($stm->fetch()) {
   


$categoryCode= prepareString($categoryCode);
$name= prepareString($name);
$description= prepareString($description);
$creationDate= prepareString($creationDate);
$allowSubcategories= prepareString($allowSubcategories);
$allowItems= prepareString($allowItems);

    $txt="INSERT OR REPLACE INTO  'Categories' VALUES ('$categoryID', '$categoryCode', '$name', '$description', '$creationDate', '$allowSubcategories', '$allowItems','$level','$customOrder','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//Subcategories

$stm = $db->prepare("SELECT category_id,subcategory_id,date_added,timestamp FROM Subcategories WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($categoryID,$subCategoryID,$dateAdded,$timestamp);
while ($stm->fetch()) {
    

$dateAdded= prepareString($dateAdded);


    $txt="INSERT OR REPLACE INTO  'Subcategories' VALUES ('$categoryID','$subCategoryID','$dateAdded','$timestamp')";
      if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//Vats
$stm = $db->prepare("SELECT vat_id,vat_code,vat_display_name,percentage,timestamp FROM Vats WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($vatID,$vatCode,$displayName,$percentage,$timestamp);
while ($stm->fetch()) {
    
    
    
$vatCode= prepareString($vatCode);
$displayName= prepareString($displayName);

    
    
    $txt="INSERT OR REPLACE INTO  'Vats' VALUES ('$vatID', '$vatCode', '$displayName', '$percentage','$timestamp')";
      if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//Items
$stm = $db->prepare("SELECT item_id,item_code,item_sku,company_id,vat_id,subunits,sales_units,manufacturer_id,name,short_description,long_description,thumbnail_url,reorder_level,target_qty,bundled,max_stock,min_stock,packing,stock_control,sellable,weight,cbm,status,timestamp FROM Items WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($itemID,$itemCode,$itemSku,$companyID,$vatID,$subunits,$salesUnits,$manufacturerID,$name,$shortDescription,$longDescription,$thumb,$reorderLevel,$targetQTY,$bundled,$maxStock,$minStock,$packing,$stockControl,$sellable,$weight,$cbm,$status,$timestamp);
while ($stm->fetch()) {
    
    
    

$itemCode= prepareString($itemCode);
$itemSku= prepareString($itemSku);
$salesUnits= prepareString($salesUnits);
$name= prepareString($name);
$shortDescription= prepareString($shortDescription);
$longDescription= prepareString($longDescription);
$thumb= prepareString($thumb);
$bundled= prepareString($bundled);
$stockControl= prepareString($stockControl);
$sellable= prepareString($sellable);
$status= prepareString($status);

    
    $txt="INSERT OR REPLACE INTO  'Items' VALUES ('$itemID', '$itemCode', '$itemSku','$companyID','$vatID', $subunits, '$salesUnits', '$manufacturerID', '$name', '$shortDescription', '$longDescription', '$thumb', '$reorderLevel', '$targetQTY', '$bundled', '$maxStock', '$minStock', '$packing','$stockControl', '$sellable','$weight','$cbm','$status','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;

}
$stm-> close();

//Item_Barcode
$stm = $db->prepare("SELECT item_id,barcode,multiplier,default_barcode,timestamp FROM Item_Barcode WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($itemID,$barcode,$multiplier,$default,$timestamp);
while ($stm->fetch()) {


    $barcode= prepareString($barcode);






    $txt="INSERT OR REPLACE INTO  'Item_Barcode' VALUES ('$itemID', '$barcode','$multiplier','$default','$timestamp')";
    if($isFile)
    {
        fwrite($file,$txt."\n");
    }
    else
    {
        $s = $xml->addChild('s');
        $s->addAttribute('c',$txt);
    }
    $counter++;
}
$stm-> close();


//PriceTypes
$stm = $db->prepare("SELECT pricetype_id,price_code,name,allow_discount,default_type,timestamp FROM PriceTypes WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($priceTypeID,$priceCode,$name,$allowDiscount,$defaultType,$timestamp);
while ($stm->fetch()) {
    
    

$priceCode= prepareString($priceCode);
$name= prepareString($name);
$allowDiscount= prepareString($allowDiscount);
$defaultType= prepareString($defaultType);

    
  
    $txt="INSERT OR REPLACE INTO  'PriceTypes' VALUES ('$priceTypeID', '$priceCode', '$name', '$allowDiscount','$defaultType','$timestamp')";
      if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//Prices
$stm = $db->prepare("SELECT item_id,pricetype_id,price,allow_discount,inc_vat,timestamp FROM Prices WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($itemID,$pricetypeID,$price,$allowDiscount,$incVat,$timestamp);
while ($stm->fetch()) {
    

$allowDiscount= prepareString($allowDiscount);
$incVat= prepareString($incVat);

    
    
    
    
    
    $txt="INSERT OR REPLACE INTO  'Prices' VALUES ('$itemID', '$pricetypeID', '$price', '$allowDiscount','$incVat','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//Category_Item
$stm = $db->prepare("SELECT category_id,item_id,position,timestamp FROM Category_Item WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($categoryID,$itemID,$position,$timestamp);
while ($stm->fetch()) {
    
    
   
    
    
    
    $txt="INSERT OR REPLACE INTO  'Category_Item' VALUES ('$categoryID', '$itemID','$position','$timestamp')";
      if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//ContractPrices
$stm = $db->prepare("SELECT customer_id,item_id,price,pricetype_id,percentage,min_qty,valid_from,valid_until,timestamp FROM ContractPrices WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($customerID,$itemID,$price,$priceTypeID,$percentage,$minQty,$validFrom,$validUntil,$timestamp);
while ($stm->fetch()) {
    
   
$validFrom= prepareString($validFrom);
$validUntil= prepareString($validUntil);

    
    
    
    
    
    
    $txt="INSERT OR REPLACE INTO  'ContractPrices' VALUES ('$customerID', '$itemID', '$price','$priceTypeID', '$percentage', '$minQty', '$validFrom', '$validUntil','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//Warehouses
$stm = $db->prepare("SELECT warehouse_id,warehouse_code,company_id,name,type,landline,fax,email,country,city,address_line_1,address_line_2,postcode,region,lat,lng,pobox,salesperson_id,timestamp FROM Warehouses WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($warehouseID,$warehouseCode,$companyID,$name,$type,$landline,$fax,$email,$country,$city,$addressLine1,$addressLine2,$postcode,$region,$lat,$lng,$pobox,$salespersonID,$timestamp);
while ($stm->fetch()) {
 

$warehouseCode= prepareString($warehouseCode);

$name= prepareString($name);
$type= prepareString($type);
$landline= prepareString($landline);
$fax= prepareString($fax);
$email= prepareString($email);
$country= prepareString($country);
$city= prepareString($city);
$addressLine1= prepareString($addressLine1);
$addressLine2= prepareString($addressLine2);
$postcode= prepareString($postcode);
$region= prepareString($region);
$pobox= prepareString($pobox);




    $txt="INSERT OR REPLACE INTO  'Warehouses' VALUES ('$warehouseID', '$warehouseCode', '$companyID','$name','$type', '$landline', '$fax', '$email', '$country', '$city', '$addressLine1', '$addressLine2', '$postcode', '$region', '$lat', '$lng', '$pobox', '$salespersonID', '$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }

$counter++;

}
$stm-> close();

//Stock
$stm = $db->prepare("SELECT warehouse_id,item_id,batch_number,available,reserved,delivered,on_order,requested,sold,expiry_date,timestamp FROM Stock WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($warehouseID,$itemID,$batchnumber,$available,$reserved,$delivered,$onOrder,$requested,$sold,$expiryDate,$timestamp);
while ($stm->fetch()) {
    
    
    

$batchnumber= prepareString($batchnumber);
$expiryDate= prepareString($expiryDate);

    
    
    
    
    
    $txt="INSERT OR REPLACE INTO  'Stock' VALUES ('$warehouseID', '$itemID', '$batchnumber','$available','$reserved','$delivered', '$onOrder', '$requested','$sold','$expiryDate','$timestamp')";
      if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;

}
$stm-> close();



//PaymentTypes
$stm = $db->prepare("SELECT paymenttype_id,paymenttype_code,name,timestamp FROM PaymentTypes WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($paymentTypeID,$pamentTypeCode,$name,$timestamp);
while ($stm->fetch()) {
    

$pamentTypeCode= prepareString($pamentTypeCode);
$name= prepareString($name);

    
    
    
    
    $txt="INSERT OR REPLACE INTO  'PaymentTypes' VALUES ('$paymentTypeID', '$pamentTypeCode', '$name','$timestamp')";
      if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;

}
$stm-> close();


//Orders
$stm = $db->prepare("SELECT order_id,order_code,company_id,customer_id,salesperson_id,paymenttype_id,order_date,subtotal,grand_total,vat_amount,discount_amount,print_count,order_address_id,delivery_address_id,tender_id,vat_i_or_e,delivery_date,deposit_amount,details,status,currency_id,global_discount_percentage,delivery_method,timestamp FROM Orders WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($orderID,$orderCode,$companyID,$customerID,$salespersonID,$paymentTypeID,$orderDate,$subtotal,$grandTotal,$vatAmount,$discountAmount,$printCount,$orderAddressID,$deliveryAddressID,$tenderID,$vatIE,$deliveryDate,$depositAmount,$details,$status,$currencyID,$globalDiscountPercentage,$deliveryMethod,$timestamp);
while ($stm->fetch()) {
    
    

$orderCode= prepareString($orderCode);
$orderDate= prepareString($orderDate);
$vatIE= prepareString($vatIE);
$deliveryDate= prepareString($deliveryDate);
$details= prepareString($details);
$status= prepareString($status);
$deliveryMethod= prepareString($deliveryMethod);

    
    
    $txt="INSERT OR REPLACE INTO  'Orders' VALUES ('$orderID','$orderCode','$companyID','$customerID','$salespersonID','$paymentTypeID','$orderDate','$subtotal','$grandTotal','$vatAmount','$discountAmount','$printCount','$orderAddressID','$deliveryAddressID','$tenderID','$vatIE','$deliveryDate','$depositAmount','$details','$status','$currencyID','$globalDiscountPercentage','$deliveryMethod','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }

$counter++;
}
$stm-> close();





//OrderItem
$stm = $db->prepare("SELECT order_item_id,order_id,item_id,qty,qty_delivered,qty_invoiced,unit_price,line_discount,global_discount,line_discount_percentage,vat_amount,pricetype_id,vat_id,description,promotion_id,promotion_number,master_item,timestamp FROM Order_Item WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($orderItemID,$orderID,$itemID,$qty,$qtyDelivered,$qtyInvoiced,$unitPrice,$lineDiscount,$globalDiscount,$lineDiscountPercentage,$vatAmount,$pricetypeID,$vatID,$description,$promotionID,$promotionNumber,$masterItem,$timestamp);
while ($stm->fetch()) {


$description= prepareString($description);
$masterItem= prepareString($masterItem);



  
    $txt="INSERT OR REPLACE INTO  'Order_Item' VALUES ('$orderItemID','$orderID','$itemID','$qty','$qtyDelivered','$qtyInvoiced','$unitPrice','$lineDiscount','$globalDiscount','$lineDiscountPercentage','$vatAmount','$pricetypeID','$vatID','$description','$promotionID','$promotionNumber','$masterItem','$timestamp')";
      if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }

$counter++;
}
$stm-> close();



//Invoices

$stm = $db->prepare("SELECT invoice_id,invoice_code,company_id,customer_id,salesperson_id,paymenttype_id,order_id,tender_id,subtotal,grand_total,vat_amount,vat_i_e,discount_amount,invoice_address_id,delivery_address_id,print_count,invoice_date,details,invoice_type,due_date,status,currency_id,global_discount_percentage,timestamp FROM Invoices WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($invoiceID,$invoiceCode,$companyID,$customerID,$salespersonID,$paymentTypeID,$orderID,$tenderID,$subtotal,$grandTotal,$vatAmount,$vatIorE,$discountAmount,$invoiceAddressID,$deliveryAdressID,$printCount,$invoiceDATE,$details,$invoiceType,$dueDate,$status,$currencyID,$globalDiscountPercentage,$timestamp);
while ($stm->fetch()) {


$invoiceCode= prepareString($invoiceCode);
$vatIorE= prepareString($vatIorE);
$invoiceDATE= prepareString($invoiceDATE);
$details= prepareString($details);
$invoiceType= prepareString($invoiceType);
$dueDate= prepareString($dueDate);
$status= prepareString($status);



    $txt="INSERT OR REPLACE INTO  'Invoices' VALUES ('$invoiceID','$invoiceCode','$companyID','$customerID','$salespersonID','$paymentTypeID','$orderID','$tenderID','$subtotal','$grandTotal','$vatAmount','$vatIorE','$discountAmount','$invoiceAddressID','$deliveryAdressID','$printCount','$invoiceDATE','$details','$invoiceType','$dueDate','$status','$currencyID','$globalDiscountPercentage','$timestamp')";
      if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;

}
$stm-> close();


//Invoice_Item

$stm = $db->prepare("SELECT invoice_item_id,invoice_id,item_id,batch_number,warehouse_id,qty,unit_price,line_discount,global_discount,line_discount_percentage,vat_amount,pricetype_id,vat_id,serialnumber,description,cost,promotion_id,promotion_number,master_item,timestamp FROM Invoice_Item WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($invoiceItemID,$invoiceID,$itemID,$batchNumber,$warehouseID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$lineDiscountPercentage,$vatAmount,$priceTypeID,$vatID,$serialnumber,$description,$cost,$promotionID,$promotionNumber,$masterItem,$timestamp);
while ($stm->fetch()) {


$batchNumber= prepareString($batchNumber);
$serialnumber= prepareString($serialnumber);
$description= prepareString($description);
$masterItem= prepareString($masterItem);
$timestamp= prepareString($timestamp);






    $txt="INSERT OR REPLACE INTO  'Invoice_Item' VALUES ('$invoiceItemID','$invoiceID','$itemID','$batchNumber','$warehouseID','$qty','$unitPrice','$lineDiscount','$globalDiscount','$lineDiscountPercentage','$vatAmount','$priceTypeID','$vatID','$serialnumber','$description','$cost','$promotionID','$promotionNumber','$masterItem','$timestamp')";
      if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;

}
$stm-> close();




//Receipts

$stm = $db->prepare("SELECT receipt_id,receipt_code,customer_id,company_id,salesperson_id,order_id,invoice_id,address_id,amount,payment_method,cash_discount,bank,branch,cheque_number,cheque_date,receipt_date,notes,status,print_count,timestamp FROM Receipts WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($receiptID,$recieptCode,$customerID,$companyID,$salepersonID,$orderID,$invoiceID,$addressID,$amount,$paymentMethod,$cashDiscount,$bank,$branch,$chequeNumber,$chequeDate,$receiptDate,$notes,$status,$printCount,$timestamp);
while ($stm->fetch()) {


$recieptCode= prepareString($recieptCode);
$paymentMethod= prepareString($paymentMethod);
$bank= prepareString($bank);
$branch= prepareString($branch);
$chequeNumber= prepareString($chequeNumber);
$chequeDate= prepareString($chequeDate);
$receiptDate= prepareString($receiptDate);
$notes= prepareString($notes);
$status= prepareString($status);

    
    
    
    
    
    $txt="INSERT OR REPLACE INTO  'Receipts' VALUES ('$receiptID','$recieptCode','$customerID','$companyID','$salepersonID','$orderID','$invoiceID','$addressID','$amount','$paymentMethod','$cashDiscount','$bank','$branch','$chequeNumber','$chequeDate','$receiptDate','$notes','$status','$printCount','$timestamp')";
      if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;

}
$stm-> close();





//Returns

$stm = $db->prepare("SELECT return_id,return_code,company_id,customer_id,salesperson_id,paymenttype_id,order_id,subtotal,grand_total,vat_amount,vat_i_e,discount_amount,return_address_id,print_count,return_date,details,status,currency_id,global_discount_percentage,return_type,timestamp FROM Returns WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($returnID,$returnCode,$companyID,$customerID,$salespersonID,$paymentTypeID,$orderID,$subtotal,$grandTotal,$vatAmount,$vatIorE,$discountAmount,$returnAddressID,$printCount,$returnDate,$details,$status,$currencyID,$globalDiscountPercentage,$returnType,$timestamp);
while ($stm->fetch()) {
    
    
    

$returnCode= prepareString($returnCode);
$vatIorE= prepareString($vatIorE);
$returnDate= prepareString($returnDate);
$details= prepareString($details);
$status= prepareString($status);
$returnType= prepareString($returnType);





    $txt="INSERT OR REPLACE INTO  'Returns' VALUES ('$returnID','$returnCode','$companyID','$customerID','$salespersonID','$paymentTypeID','$orderID','$subtotal','$grandTotal','$vatAmount','$vatIorE','$discountAmount','$returnAddressID','$printCount','$returnDate','$details','$status','$currencyID','$globalDiscountPercentage','$returnType','$timestamp')";
      if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;

}
$stm-> close();



//Return_Item

$stm = $db->prepare("SELECT return_item_id,return_id,item_id,batch_number,warehouse_id,qty,unit_price,line_discount,global_discount,line_discount_percentage,vat_amount,pricetype_id,vat_id,serialnumber,description,status,cost,timestamp FROM Return_Item WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($returntemID,$returnID,$itemID,$batchNumber,$warehouseID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$lineDiscountPercentage,$vatAmount,$priceTypeID,$vatID,$serialnumber,$description,$status,$cost,$timestamp);
while ($stm->fetch()) {
    

$batchNumber= prepareString($batchNumber);
$serialnumber= prepareString($serialnumber);
$description= prepareString($description);
$status= prepareString($status);
    
    
    


    $txt="INSERT OR REPLACE INTO  'Return_Item' VALUES ('$returntemID','$returnID','$itemID','$batchNumber','$warehouseID','$qty','$unitPrice','$lineDiscount','$globalDiscount','$lineDiscountPercentage','$vatAmount','$priceTypeID','$vatID','$serialnumber','$description','$status','$cost','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;

}
$stm-> close();



//Tenders

$stm = $db->prepare("SELECT tender_id,tender_code,company_id,salesperson_id,customer_id,tender_date,valid_until,name,address_line_1,address_line_2,city,country,region,subtotal,grand_total,vat_amount,discount_amount,status,vat_i_e,print_count,details,currency_id,delivery_method,global_discount_percentage,timestamp FROM Tenders WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm->bind_result($tenderID,$tenderCode,$companyID,$salespersonID,$customerID,$tenderDate,$validUntil,$name,$addressLine1,$addressLine2,$city,$country,$region,$subtotal,$grandTotal,$vatAmount,$discountAmount,$status,$vatIE,$printCount,$details,$currencyID,$deliveryMethod,$globalDiscountPercentage,$timestamp);
while ($stm->fetch()) {

  
  
  

$tenderCode= prepareString($tenderCode);
$tenderDate= prepareString($tenderDate);
$validUntil= prepareString($validUntil);
$name= prepareString($name);
$addressLine1= prepareString($addressLine1);
$addressLine2= prepareString($addressLine2);
$city= prepareString($city);
$country= prepareString($country);
$region= prepareString($region);
$status= prepareString($status);
$vatIE= prepareString($vatIE);
$details= prepareString($details);
$deliveryMethod= prepareString($deliveryMethod);

    
    
    
    $txt="INSERT OR REPLACE INTO  'Tenders' VALUES ('$tenderID','$tenderCode','$companyID','$salespersonID','$customerID','$tenderDate','$validUntil','$name','$addressLine1','$addressLine2','$city','$country','$region','$subtotal','$grandTotal','$vatAmount','$discountAmount','$status','$vatIE','$printCount','$details','$currencyID','$deliveryMethod','$globalDiscountPercentage','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;

}
$stm-> close();


//Tender_Item

$stm = $db->prepare("SELECT tender_item_id,tender_id,item_id,qty,unit_price,line_discount,global_discount,line_discount_percentage,vat_amount,pricetype_id,vat_id,description,promotion_id,promotion_number,master_item,timestamp FROM Tender_Item WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($tenderItemID,$tender_id,$itemID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$lineDiscountPercentage,$vatAmount,$pricetypeID,$vatID,$description,$promotionID,$promotionNumber,$masterItem,$timestamp);
while ($stm->fetch()) {
   
$description= prepareString($description);
$masterItem= prepareString($masterItem);

    
    
    
    $txt="INSERT OR REPLACE INTO  'Tender_Item' VALUES ('$tenderItemID','$tender_id','$itemID','$qty','$unitPrice','$lineDiscount','$globalDiscount','$lineDiscountPercentage','$vatAmount','$pricetypeID','$vatID','$description','$promotionID','$promotionNumber','$masterItem','$timestamp')";
      if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }

$counter++;
}
$stm-> close();


//Waybills

$stm = $db->prepare("SELECT waybill_id,waybill_code,company_id,customer_id,salesperson_id,paymenttype_id,order_id,tender_id,subtotal,grand_total,vat_amount,vat_i_e,discount_amount,waybill_address_id,delivery_address_id,print_count,waybill_date,details,status,currency_id,global_discount_percentage,timestamp FROM Waybills WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($waybillID,$waybillCode,$companyID,$customerID,$salespersonID,$paymentTypeID,$orderID,$tenderID,$subtotal,$grandTotal,$vatAmount,$vatIorE,$discountAmount,$waybillAddressID,$deliveryAdressID,$printCount,$waybillDATE,$details,$status,$currencyID,$globalDiscountPercentage,$timestamp);
while ($stm->fetch()) {


$waybillCode= prepareString($waybillCode);

$vatIorE= prepareString($vatIorE);

$waybillDATE= prepareString($waybillDATE);
$details= prepareString($details);
$status= prepareString($status);

    
    
    
    
    
    
    $txt="INSERT OR REPLACE INTO  'Waybills' VALUES ('$waybillID','$waybillCode','$companyID','$customerID','$salespersonID','$paymentTypeID','$orderID','$tenderID','$subtotal','$grandTotal','$vatAmount','$vatIorE','$discountAmount','$waybillAddressID','$deliveryAdressID','$printCount','$waybillDATE','$details','$status','$currencyID','$globalDiscountPercentage','$timestamp')";
  if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }

$counter++;
}
$stm-> close();


//Waybill_Item

$stm = $db->prepare("SELECT waybill_item_id,waybill_id,item_id,batch_number,warehouse_id,qty,qty_invoiced,unit_price,line_discount,global_discount,line_discount_percentage,vat_amount,pricetype_id,vat_id,serialnumber,description,cost,timestamp FROM Waybill_Item WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($waybillItemID,$waybillID,$itemID,$batchNumber,$warehouseID,$qty,$qtyInvoiced,$unitPrice,$lineDiscount,$globalDiscount,$lineDiscountPercentage,$vatAmount,$priceTypeID,$vatID,$serialnumber,$description,$cost,$timestamp);
while ($stm->fetch()) {


$batchNumber= prepareString($batchNumber);
$serialnumber= prepareString($serialnumber);
$description= prepareString($description);

    
    
    
    $txt="INSERT OR REPLACE INTO  'Waybill_Item' VALUES ('$waybillItemID','$waybillID','$itemID','$batchNumber','$warehouseID','$qty','$qtyInvoiced','$unitPrice','$lineDiscount','$globalDiscount','$lineDiscountPercentage','$vatAmount','$priceTypeID','$vatID','$serialnumber','$description','$cost','$timestamp')";
      if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }

$counter++;
}
$stm-> close();


//Warehouse_Transactions

$stm = $db->prepare("SELECT warehouse_transaction_id,warehouse_transaction_code,warehouse_id_from,warehouse_id_to,company_id,salesperson_id,type,transaction_date,details,timestamp FROM Warehouse_Transactions WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($warehouseTransactionID,$warehouseTransactionCode,$warehouseFrom,$warehouseTo,$companyID,$salespersonID,$type,$transactionDate,$details,$timestamp);
while ($stm->fetch()) {

  
 
$warehouseTransactionCode= prepareString($warehouseTransactionCode);
$type= prepareString($type);
$transactionDate= prepareString($transactionDate);
$details= prepareString($details);

    
    
    
    
    $txt="INSERT OR REPLACE INTO  'Warehouse_Transactions' VALUES ('$warehouseTransactionID','$warehouseTransactionCode','$warehouseFrom','$warehouseTo','$companyID','$salespersonID','$type','$transactionDate','$details','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;

}
$stm-> close();



//Warehouse_Transaction_Item

$stm = $db->prepare("SELECT warehouse_transaction_item_id,warehouse_transaction_id,item_id,batch_number,warehouse_id,qty,serialnumber,item_condition,notes,timestamp FROM Warehouse_Transaction_Item WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($warehouseTransactionItemID,$warehouseTransactionID,$itemID,$batchNumber,$warehouseID,$qty,$serialnumber,$itemCondition,$notes,$timestamp);
while ($stm->fetch()) {


$batchNumber= prepareString($batchNumber);
$serialnumber= prepareString($serialnumber);
$itemCondition= prepareString($itemCondition);
$notes= prepareString($notes);







    $txt="INSERT OR REPLACE INTO  'Warehouse_Transaction_Item' VALUES ('$warehouseTransactionItemID','$warehouseTransactionID','$itemID','$batchNumber','$warehouseID','$qty','$serialnumber','$itemCondition','$notes','$timestamp')";
    if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//ERP_Popular_Items

$stm = $db->prepare("SELECT customer_id,item_id,position,qty_sold,active,timestamp FROM ERP_Popular_Items WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($customerID,$itemID,$position,$qtySold,$active,$timestamp);
while ($stm->fetch()) {
    
$active= prepareString($active);

     
    $txt="INSERT OR REPLACE INTO  'ERP_Popular_Items' VALUES ('$customerID','$itemID','$position','$qtySold','$active','$timestamp')";
    if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }

$counter++;
}
$stm-> close();


//ERP_Last_Prices

$stm = $db->prepare("SELECT erp_last_price_id,customer_id,item_id,price,qty,invoice_id,invoice_code,invoice_date,salesperson_id,timestamp FROM ERP_Last_Prices WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($erpLastPriceID,$customerID,$itemID,$price,$qty,$invoiceID,$invoiceCode,$invoiceDate,$salespersonID,$timestamp);
while ($stm->fetch()) {
    
    

$invoiceCode= prepareString($invoiceCode);
$invoiceDate= prepareString($invoiceDate);

    
    $txt="INSERT OR REPLACE INTO  'ERP_Last_Prices' VALUES ('$erpLastPriceID','$customerID','$itemID','$price','$qty','$invoiceID','$invoiceCode','$invoiceDate','$salespersonID','$timestamp')";
    if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }

$counter++;
}
$stm-> close();


//SalesPersons

$stm = $db->prepare("SELECT salesperson_id,salesperson_code,first_name,last_name,landline,mobile,email,username,password,app_settings_password,default_warehouse_id,discard_warehouse_id,discount_allowance,allow_tenders,allow_invoices,allow_orders,allow_waybills,allow_returns,allow_receipts,allow_visits,allow_load,allow_unload,view_history,allow_anonymous_customer,allow_negative_stock,only_from_truck,order_stock_info,discount_allowance_line,anonymous_group_id,edit_schedule,create_schedule,allow_discount_receipt,gps_track,gps_track_distance,gps_track_time,take_picture,start_end_km_schedules,load_negative_qty,invoice_type_prefer,stock_reserved_calculation,erp_popular_products,default_qty,search_item_in_category,level_navigation,show_last_price,erp_last_price,show_price_after_discount,no_action_before_schedule,visit_all_before_end_schedule,allow_statements,waybill_show_prices_pdf,waybill_to_invoice_include_items,allow_customer_stock_taking,show_customer_stock_taking_info,allow_crm,cheque_mandatory,credit_limit_warning,stock_warning,allow_load_request,round_up_to_box,auto_generate_statement,allow_credit_note,post_dated_cheque_limit,return_only_from_invoice,post_dated_cheque_credit_limit,use_batch_numbers,return_policy,select_promotion_group,type,status,receivables_account,timestamp FROM SalesPersons WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($salespersonID,$salesPersonCode,$firstName,$lastName,$landline,$mobile,$email,$username,$password,$appSettingsPassword,$defaultWarehouseID,$discardWarehouseID,$discountAllowance,$alloTendes,$allowInvoices,$allowOrders,$allowWaybillis,$allowReturns,$allowReceipts,$allowVisits,$allowLoad,$allowUnload,$viewHistory,$allowAnonymousCustomer,$allowNegativeStock,$onlyFromTruck,$orderStockInfo,$discountAllowanceLine,$anonymousGroupID,$editSchelude,$createSchedule,$allowDiscountReceipt,$gpsTrack,$gpsDistance,$gpsTime,$takePicture,$startKm,$loadNegative,$invoiceTypePrefer,$stockReservedCalc,$erpPopularProducts,$defaultQty,$searchItemInCategory,$levelNavigation,$showLastPrice,$erpLastPrice,$showPriceAfrerDiscount,$noActionBeforeSchedule,$visitAllBeforeEndSchedule,$allow_statements,$waybillShowPrices,$waybillToInvoiceIncludeItems,$allowCustomerStockTaking,$showCustomerStockTakinginfo,$allowCrm,$chequeMandatory,$creditLimitWarning,$stockWarning,$allowLoadRequest,$roundUpToBox,$autoGenerateStatement,$allowCreditNote,$postDatedChequeLimit,$returnOnlyFromInvoices,$postDatedCreditLimit,$useBatchNumbers,$returnPolicy,$selectPromotionGroup,$type,$status,$receivablesAccount,$timestamp);
while ($stm->fetch()) {
    
    
$salesPersonCode= prepareString($salesPersonCode);
$firstName= prepareString($firstName);
$lastName= prepareString($lastName);
$landline= prepareString($landline);
$mobile= prepareString($mobile);
$email= prepareString($email);
$username= prepareString($username);
$password= prepareString($password);
$appSettingsPassword= prepareString($appSettingsPassword);
$defaultWarehouseID= prepareString($defaultWarehouseID);
$discardWarehouseID= prepareString($discardWarehouseID);
$discountAllowance= prepareString($discountAllowance);
$alloTendes= prepareString($alloTendes);
$allowInvoices= prepareString($allowInvoices);
$allowOrders= prepareString($allowOrders);
$allowWaybillis= prepareString($allowWaybillis);
$allowReturns= prepareString($allowReturns);
$allowReceipts= prepareString($allowReceipts);
$allowVisits= prepareString($allowVisits);
$allowLoad= prepareString($allowLoad);
$allowUnload= prepareString($allowUnload);
$viewHistory= prepareString($viewHistory);
$allowAnonymousCustomer= prepareString($allowAnonymousCustomer);
$allowNegativeStock= prepareString($allowNegativeStock);
$onlyFromTruck= prepareString($onlyFromTruck);
$orderStockInfo= prepareString($orderStockInfo);
$discountAllowanceLine= prepareString($discountAllowanceLine);
$anonymousGroupID= prepareString($anonymousGroupID);
$editSchelude= prepareString($editSchelude);
$createSchedule= prepareString($createSchedule);
$allowDiscountReceipt= prepareString($allowDiscountReceipt);
$gpsTrack= prepareString($gpsTrack);
$gpsDistance= prepareString($gpsDistance);
$gpsTime= prepareString($gpsTime);
$takePicture= prepareString($takePicture);
$startKm= prepareString($startKm);
$loadNegative= prepareString($loadNegative);
$invoiceTypePrefer= prepareString($invoiceTypePrefer);
$stockReservedCalc= prepareString($stockReservedCalc);
$erpPopularProducts= prepareString($erpPopularProducts);
$defaultQty= prepareString($defaultQty);
$searchItemInCategory= prepareString($searchItemInCategory);
$levelNavigation= prepareString($levelNavigation);
$showLastPrice= prepareString($showLastPrice);
$erpLastPrice= prepareString($erpLastPrice);
$showPriceAfrerDiscount= prepareString($showPriceAfrerDiscount);
$noActionBeforeSchedule= prepareString($noActionBeforeSchedule);
$visitAllBeforeEndSchedule= prepareString($visitAllBeforeEndSchedule);
$allow_statements= prepareString($allow_statements);
$waybillShowPrices= prepareString($waybillShowPrices);
$waybillToInvoiceIncludeItems= prepareString($waybillToInvoiceIncludeItems);
$allowCustomerStockTaking= prepareString($allowCustomerStockTaking);
$showCustomerStockTakinginfo= prepareString($showCustomerStockTakinginfo);
$allowCrm= prepareString($allowCrm);
$chequeMandatory= prepareString($chequeMandatory);
$creditLimitWarning= prepareString($creditLimitWarning);
$stockWarning= prepareString($stockWarning);
$allowLoadRequest= prepareString($allowLoadRequest);
$roundUpToBox= prepareString($roundUpToBox);
$autoGenerateStatement= prepareString($autoGenerateStatement);
$allowCreditNote= prepareString($allowCreditNote);
$postDatedChequeLimit= prepareString($postDatedChequeLimit);
$returnOnlyFromInvoices= prepareString($returnOnlyFromInvoices);
$postDatedCreditLimit= prepareString($postDatedCreditLimit);
$useBatchNumbers= prepareString($useBatchNumbers);
$returnPolicy= prepareString($returnPolicy);
$selectPromotionGroup= prepareString($selectPromotionGroup);
$type= prepareString($type);
$status= prepareString($status);
$receivablesAccount= prepareString($receivablesAccount);

    
    
    
    
   
    $txt="INSERT OR REPLACE INTO  'SalesPersons' VALUES ('$salespersonID','$salesPersonCode','$firstName','$lastName','$landline','$mobile','$email','$username','$password','$appSettingsPassword','$defaultWarehouseID','$discardWarehouseID','$discountAllowance','$alloTendes','$allowInvoices','$allowOrders','$allowWaybillis','$allowReturns','$allowReceipts','$allowVisits','$allowLoad','$allowUnload','$viewHistory','$allowAnonymousCustomer','$allowNegativeStock','$onlyFromTruck','$orderStockInfo','$discountAllowanceLine','$anonymousGroupID','$editSchelude','$createSchedule','$allowDiscountReceipt','$gpsTrack','$gpsDistance','$gpsTime','$takePicture','$startKm','$loadNegative','$invoiceTypePrefer','$stockReservedCalc','$erpPopularProducts','$defaultQty','$searchItemInCategory','$levelNavigation','$showLastPrice','$erpLastPrice','$showPriceAfrerDiscount','$noActionBeforeSchedule','$visitAllBeforeEndSchedule','$allow_statements','$waybillShowPrices','$waybillToInvoiceIncludeItems','$allowCustomerStockTaking','$showCustomerStockTakinginfo','$allowCrm','$chequeMandatory','$creditLimitWarning','$stockWarning','$allowLoadRequest','$roundUpToBox','$autoGenerateStatement','$allowCreditNote','$postDatedChequeLimit','$returnOnlyFromInvoices','$postDatedCreditLimit','$useBatchNumbers','$returnPolicy','$selectPromotionGroup','$type','$status','$receivablesAccount','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//Allow_Prices

$stm = $db->prepare("SELECT salesperson_id,pricetype_id,timestamp FROM Allow_Prices WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($salespersonID,$pricetypeID,$timestamp);
while ($stm->fetch()) {
   
    $txt="INSERT OR REPLACE INTO  'Allow_Prices' VALUES ('$salespersonID','$pricetypeID','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//Allow_Categories

$stm = $db->prepare("SELECT salesperson_id,category_id,timestamp FROM Allow_Categories WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($salespersonID,$categoryID,$timestamp);
while ($stm->fetch()) {
     
    $txt="INSERT OR REPLACE INTO  'Allow_Categories' VALUES ('$salespersonID','$categoryID','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
}
$stm-> close();



//Allow_CustomerGroups

$stm = $db->prepare("SELECT salesperson_id,group_id,timestamp FROM Allow_CustomerGroups WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($salespersonID,$groupID,$timestamp);
while ($stm->fetch()) {
    
    $txt="INSERT OR REPLACE INTO  'Allow_CustomerGroups' VALUES ('$salespersonID','$groupID','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//Tender_Order
$stm = $db->prepare("SELECT tender_id,order_id,timestamp FROM Tender_Order WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($tenderID,$orderID,$timestamp);
while ($stm->fetch()) {
     
    $txt="INSERT OR REPLACE INTO  'Tender_Order' VALUES ('$tenderID','$orderID','$timestamp')";
      if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//Tender_Waybill
$stm = $db->prepare("SELECT tender_id,waybill_id,timestamp FROM Tender_Waybill WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($tenderID,$waybillID,$timestamp);
while ($stm->fetch()) {
    
    $txt="INSERT OR REPLACE INTO  'Tender_Waybill' VALUES ('$tenderID','$waybillID','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//Tender_Invoice
$stm = $db->prepare("SELECT tender_id,invoice_id,timestamp FROM Tender_Invoice WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($tenderID,$invoiceID,$timestamp);
while ($stm->fetch()) {
    
    $txt="INSERT OR REPLACE INTO  'Tender_Invoice' VALUES ('$tenderID','$invoiceID','$timestamp')";
      if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//Order_Waybill
$stm = $db->prepare("SELECT order_id,waybill_id,timestamp FROM Order_Waybill WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($orderID,$waybillID,$timestamp);
while ($stm->fetch()) {
    
    $txt="INSERT OR REPLACE INTO  'Order_Waybill' VALUES ('$orderID','$waybillID','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//Order_Invoice
$stm = $db->prepare("SELECT order_id,invoice_id,timestamp FROM Order_Invoice WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($orderID,$invoiceID,$timestamp);
while ($stm->fetch()) {
    
    $txt="INSERT OR REPLACE INTO  'Order_Invoice' VALUES ('$orderID','$invoiceID','$timestamp')";
  if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//Waybill_Invoice
$stm = $db->prepare("SELECT waybill_id,invoice_id,timestamp FROM Waybill_Invoice WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($waybillID,$invoiceID,$timestamp);
while ($stm->fetch()) {
   
    $txt="INSERT OR REPLACE INTO  'Waybill_Invoice' VALUES ('$waybillID','$invoiceID','$timestamp')";
      if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//Waybill_Return
$stm = $db->prepare("SELECT waybill_id,return_id,timestamp FROM Waybill_Return WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($waybillID,$returnID,$timestamp);
while ($stm->fetch()) {
   
    $txt="INSERT OR REPLACE INTO  'Waybill_Return' VALUES ('$waybillID','$returnID','$timestamp')";
   if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//Invoice_Return
$stm = $db->prepare("SELECT return_id,invoice_id,timestamp FROM Invoice_Return WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($returnID,$invoiceID,$timestamp);
while ($stm->fetch()) {
 
    $txt="INSERT OR REPLACE INTO  'Invoice_Return' VALUES ('$returnID','$invoiceID','$timestamp')";
    if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//Invoice_Receipt
$stm = $db->prepare("SELECT receipt_id,invoice_id,amount,timestamp FROM Invoice_Receipt WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($receiptID,$invoiceID,$amount,$timestamp);
while ($stm->fetch()) {
 
    $txt="INSERT OR REPLACE INTO  'Invoice_Receipt' VALUES ('$receiptID','$invoiceID','$amount','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//Visits
$stm = $db->prepare("SELECT visit_id,visit_code,customer_id,company_id,salesperson_id,notes,visit_date,timestamp FROM Visits WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($visitID,$visitCode,$customerID,$companyID,$salespersonID,$notes,$visitDate,$timestamp);
while ($stm->fetch()) {
    

$visitCode= prepareString($visitCode);
$notes= prepareString($notes);
$visitDate= prepareString($visitDate);

    
    
    
    
    

    $txt="INSERT OR REPLACE INTO  'Visits' VALUES ('$visitID','$visitCode','$customerID','$companyID','$salespersonID','$notes','$visitDate','$timestamp')";
    if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//Item_Images

$stm = $db->prepare("SELECT item_image_id,item_id,image_url,image_name,image_order,timestamp FROM Item_Images WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($imageID,$itemID,$imageUrl,$imageName,$imageOrder,$timestamp);
while ($stm->fetch()) {
    

$imageUrl= prepareString($imageUrl);
$imageName= prepareString($imageName);

    
    
 
    $txt="INSERT OR REPLACE INTO  'Item_Images' VALUES ('$imageID','$itemID','$imageUrl','$imageName','$imageOrder','$timestamp')";
    if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//Schedules

$stm = $db->prepare("SELECT schedule_id,name,creation_date,creator_id,type,date,repeat_period,day,week,month,notes,timestamp FROM Schedules WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($scheduleID,$name,$creationDate,$creatorID,$type,$date,$repeatPeriod,$day,$week,$month,$notes,$timestamp);
while ($stm->fetch()) {
  

$name= prepareString($name);
$creationDate= prepareString($creationDate);

$type= prepareString($type);
$date= prepareString($date);
$notes= prepareString($notes);

    
    
    
    
    
    
    
    
    $txt="INSERT OR REPLACE INTO  'Schedules' VALUES ('$scheduleID','$name','$creationDate','$creatorID','$type','$date','$repeatPeriod','$day','$week','$month','$notes','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();



//Schedule_Customer

$stm = $db->prepare("SELECT schedule_customer_id,schedule_id,customer_id,position,appointment_time,timestamp FROM Schedule_Customer WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($scheduleCustomerID,$scheduleID,$customerID,$position,$appoimentTime,$timestamp);
while ($stm->fetch()) {
    
   
$appoimentTime= prepareString($appoimentTime);

    
    
    
 
    $txt="INSERT OR REPLACE INTO  'Schedule_Customer' VALUES ('$scheduleCustomerID','$scheduleID','$customerID','$position','$appoimentTime','$timestamp')";
    if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//Schedule_Objects

$stm = $db->prepare("SELECT schedule_object_id,schedule_id,date,start_time,end_time,salesperson_id,status,start_km,end_km,timestamp FROM Schedule_Objects WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($scheduleObjectID,$scheduleID,$date,$startTime,$endTime,$salespersonID,$status,$startKm,$endKm,$timestamp);
while ($stm->fetch()) {
    
$date= prepareString($date);
$startTime= prepareString($startTime);
$endTime= prepareString($endTime);
$status= prepareString($status);
$startKm= prepareString($startKm);
$endKm= prepareString($endKm);

    
    
    $txt="INSERT OR REPLACE INTO  'Schedule_Objects' VALUES ('$scheduleObjectID','$scheduleID','$date','$startTime','$endTime','$salespersonID','$status','$startKm','$endKm','$timestamp')";
    if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//Schedule_Object_Actions

$stm = $db->prepare("SELECT schedule_object_action_id,schedule_object_id,customer_id,salesperson_id,action_type,action_id,date,lat,lng,db_id,timestamp FROM Schedule_Object_Actions WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($scheduleObjectActionID,$scheduleObjectID,$customerID,$salespersonID,$actionType,$actionID,$date,$lat,$lng,$dbID,$timestamp);
while ($stm->fetch()) {
    

$actionType= prepareString($actionType);
$date= prepareString($date);

    
    
    
    
    
    
    
    $txt="INSERT OR REPLACE INTO  'Schedule_Object_Actions' VALUES ('$scheduleObjectActionID','$scheduleObjectID','$customerID','$salespersonID','$actionType','$actionID','$date','$lat','$lng','$dbID','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();



//Schedule_Object_Customer

$stm = $db->prepare("SELECT schedule_object_customer_id,schedule_object_id,customer_id,position,visit,appointment_time,timestamp FROM Schedule_Object_Customer WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($scheduleObjectCustomerID,$scheduleObjectID,$customerID,$position,$visit,$appoimentTime,$timestamp);
while ($stm->fetch()) {
  
  
$visit= prepareString($visit);
$appoimentTime= prepareString($appoimentTime);

    
    
    
    
 
    $txt="INSERT OR REPLACE INTO  'Schedule_Object_Customer' VALUES ('$scheduleObjectCustomerID','$scheduleObjectID','$customerID','$position','$visit','$appoimentTime','$timestamp')";
    if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//Schedule_Salesperson

$stm = $db->prepare("SELECT schedule_id,salesperson_id,timestamp FROM Schedule_Salesperson WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($scheduleID,$salespersonID,$timestamp);
while ($stm->fetch()) {
 
    $txt="INSERT OR REPLACE INTO  'Schedule_Salesperson' VALUES ('$scheduleID','$salespersonID','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//GPS_Log

$stm = $db->prepare("SELECT gps_log_id,salesperson_id,device_id,schedule_object_action_id,lat,lng,time,timestamp FROM GPS_Log WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($gpsLogID,$salespersonID,$deviceID,$scheduleObjectActionID,$lat,$lng,$time,$timestamp);
while ($stm->fetch()) {
  

$time= prepareString($time);

 
    $txt="INSERT OR REPLACE INTO  'GPS_Log' VALUES ('$gpsLogID','$salespersonID','$deviceID','$scheduleObjectActionID','$lat','$lng','$time','$timestamp')";
   if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//Allow_Warehouses

$stm = $db->prepare("SELECT salesperson_id,warehouse_id,timestamp FROM Allow_Warehouses WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($salespersonID,$warehouseID,$timestamp);
while ($stm->fetch()) {
 
    $txt="INSERT OR REPLACE INTO  'Allow_Warehouses' VALUES ('$salespersonID','$warehouseID','$timestamp')";
    if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//Synonyms

$stm = $db->prepare("SELECT synonym_id,item_id,synonym,timestamp FROM Synonyms WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($synonymID,$itemID,$synonym,$timestamp);
while ($stm->fetch()) {
    
$synonym= prepareString($synonym);

 

    $txt="INSERT OR REPLACE INTO  'Synonyms' VALUES ('$synonymID','$itemID','$synonym','$timestamp')";
    if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//Sync_Service

$stm = $db->prepare("SELECT id,device_id,type,period,time,active,timestamp FROM Sync_Service WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($id,$deviceID,$type,$period,$time,$active,$timestamp);
while ($stm->fetch()) {
    
$type= prepareString($type);
$period= prepareString($period);
$time= prepareString($time);
$active= prepareString($active);


 
    $txt="INSERT OR REPLACE INTO  'Sync_Service' VALUES ('$id','$deviceID','$type','$period','$time','$active','$timestamp')";
    if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//Bundle

$stm = $db->prepare("SELECT bundle_id,item_id,qty,timestamp FROM Bundle WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($bundleID,$itemID,$qty,$timestamp);
while ($stm->fetch()) {
 
    $txt="INSERT OR REPLACE INTO  'Bundle' VALUES ('$bundleID', '$itemID', '$qty','$timestamp')";
    if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//Customer_Pricelist
$stm = $db->prepare("SELECT customer_id,pricetype_id,discount_percentage,fix_amount,allow_discount,start_date,end_date,periodic,timestamp FROM Customer_Pricelist WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($customerID,$pricetypeID,$discountPercentage,$fixAmount,$allowDiscount,$startDate,$endDate,$periodic,$timestamp);
while ($stm->fetch()) {
    
    

$allowDiscount= prepareString($allowDiscount);
$startDate= prepareString($startDate);
$endDate= prepareString($endDate);
$periodic= prepareString($periodic);

    
    
    
    
     
    $txt="INSERT OR REPLACE INTO  'Customer_Pricelist' VALUES ('$customerID','$pricetypeID','$discountPercentage','$fixAmount','$allowDiscount','$startDate','$endDate','$periodic','$timestamp')";
    if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();



//ChartOfAccounts

$stm = $db->prepare("SELECT account_id,account_code,account_name,type_id,local_currency_id,timestamp FROM ChartOfAccounts WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($accountID,$accountCode,$name,$type,$localCurrencyID,$timestamp);
while ($stm->fetch()) {
   

$accountCode= prepareString($accountCode);
$name= prepareString($name);
$type= prepareString($type);





    $txt="INSERT OR REPLACE INTO  'ChartOfAccounts' VALUES ('$accountID','$accountCode','$name','$type','$localCurrencyID','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//Journals

$stm = $db->prepare("SELECT journal_id,company_id,journal_code,year,period_id,journal_date,action_code,timestamp FROM Journals WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($journalID,$companyID,$journalCode,$year,$period,$journalDate,$actionCode,$timestamp);
while ($stm->fetch()) {
    
    

$journalCode= prepareString($journalCode);
$journalDate= prepareString($journalDate);
$actionCode= prepareString($actionCode);

    
    
    
    
 
    $txt="INSERT OR REPLACE INTO  'Journals' VALUES ('$journalID','$companyID','$journalCode','$year','$period','$journalDate','$actionCode','$timestamp')";
    if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//Transactions

$stm = $db->prepare("SELECT transaction_id,transaction_code,journal_id,company_id,account_id,transaction_type_id,year,period_id,user_id,transaction_date,entry_date,action_code,sign,amount,outstanding_amount,vat_amount,vat_i_o,details,timestamp FROM Transactions WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($transactionID,$tranctionCode,$journalID,$companyId,$accountID,$transactionType,$year,$period,$user,$date,$entryDate,$actionCode,$sign,$amount,$oustantingAmount,$vatAmount,$vatIo,$details,$timestamp);
while ($stm->fetch()) {
 
 
 
$tranctionCode= prepareString($tranctionCode);
$date= prepareString($date);
$entryDate= prepareString($entryDate);
$actionCode= prepareString($actionCode);
$vatIo= prepareString($vatIo);
$details= prepareString($details);

 
 
    $txt="INSERT OR REPLACE INTO  'Transactions' VALUES ('$transactionID','$tranctionCode','$journalID','$companyId','$accountID','$transactionType','$year','$period','$user','$date','$entryDate','$actionCode','$sign','$amount','$oustantingAmount','$vatAmount','$vatIo','$details','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();



//Banks

$stm = $db->prepare("SELECT bank_id,name,status,timestamp FROM Banks WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($bankID,$name,$status,$timestamp);
while ($stm->fetch()) {
    

$name= prepareString($name);
$status= prepareString($status);

    
    

    $txt="INSERT OR REPLACE INTO  'Banks' VALUES ('$bankID', '$name', '$status','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//Customer_Stock_Taking

$stm = $db->prepare("SELECT customer_stock_taking_id,customer_stock_taking_code,company_id,customer_id,salesperson_id,address_id,print_count,date,details,add_override,timestamp FROM Customer_Stock_Taking WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($stockTakingID,$stockTakingCode,$companyID,$customerID,$salespersonID,$addressID,$printCount,$date,$details,$addOverride,$timestamp);
while ($stm->fetch()) {
 
 
$stockTakingCode= prepareString($stockTakingCode);  
$date= prepareString($date);  
$details= prepareString($details);  
$addOverride= prepareString($addOverride);  

 
 
 
 
 

    $txt="INSERT OR REPLACE INTO  'Customer_Stock_Taking' VALUES ('$stockTakingID','$stockTakingCode','$companyID','$customerID','$salespersonID','$addressID','$printCount','$date','$details','$addOverride','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;

}
$stm-> close();

//Customer_Stock_Taking_Item

$stm = $db->prepare("SELECT customer_stock_taking_item_id,customer_stock_taking_id,item_id,batch_number,warehouse_id,qty,serialnumber,description,timestamp FROM Customer_Stock_Taking_Item WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($stockTakingItemID,$stockTakingID,$itemID,$batchNumber,$warehouseID,$qty,$serialnumber,$description,$timestamp);
while ($stm->fetch()) {
    


$batchNumber= prepareString($batchNumber); 
$serialnumber= prepareString($serialnumber);  
$description= prepareString($description);  






    $txt="INSERT OR REPLACE INTO  'Customer_Stock_Taking_Item' VALUES ('$stockTakingItemID','$stockTakingID','$itemID','$batchNumber','$warehouseID','$qty','$serialnumber','$description','$timestamp')";
    if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;

}
$stm-> close();

//Barcode_Schema
$stm = $db->prepare("SELECT barcode_schema_id,barcode_schema_code,barcode_schema_text,prefix,code_start,code_end,qty_start,qty_end,price_start,price_end,qty_factor,price_factor,timestamp FROM Barcode_Schema WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($barcodeSchemaID,$barcodeSchemaCdoe,$barcodeSchemaText,$prefix,$codeStart,$codeEnd,$qtyStart,$qtyEnd,$priceStart,$priceEnd,$qtyFactor,$priceFactor,$timestamp);
while ($stm->fetch()) {
    
    
  
$barcodeSchemaCdoe= prepareString($barcodeSchemaCdoe);
$barcodeSchemaText= prepareString($barcodeSchemaText);
$prefix= prepareString($prefix);

    
    
    
    
    
  
    $txt="INSERT OR REPLACE INTO  'Barcode_Schema' VALUES ('$barcodeSchemaID','$barcodeSchemaCdoe','$barcodeSchemaText','$prefix','$codeStart','$codeEnd','$qtyStart','$qtyEnd','$priceStart','$priceEnd','$qtyFactor','$priceFactor','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//Price_Group_Definitions
$stm = $db->prepare("SELECT price_group_definition_id,price_group_code,name,type,timestamp FROM Price_Group_Definitions WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($priceGroupDefinitionID,$priceGroupCode,$name,$type,$timestamp);
while ($stm->fetch()) {
    
    
    
$priceGroupCode= prepareString($priceGroupCode);
$name= prepareString($name);
$type= prepareString($type);

    
    
    
 
    $txt="INSERT OR REPLACE INTO  'Price_Group_Definitions' VALUES ('$priceGroupDefinitionID','$priceGroupCode','$name','$type','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }

}
$stm-> close();


//Price_Group_Rules
$stm = $db->prepare("SELECT price_group_rule_id,price_group_definition_id,category_id,discount_percent,price_type_id,timestamp FROM Price_Group_Rules WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($priceGroupRuleID,$priceGroupDefinitionID,$categoryID,$discountPercent,$priceTypeID,$timestamp);
while ($stm->fetch()) {
    
    
  
    $txt="INSERT OR REPLACE INTO  'Price_Group_Rules' VALUES ('$priceGroupRuleID','$priceGroupDefinitionID','$categoryID','$discountPercent','$priceTypeID','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();



//Price_Group_Customer
$stm = $db->prepare("SELECT price_group_customer_id,price_group_definition_id,customer_id,timestamp FROM Price_Group_Customer WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($priceGroupCustomerID,$priceGroupDefinitionID,$customerID,$timestamp);
while ($stm->fetch()) {
    

    
    
    
    
    
    
    
    
 
    $txt="INSERT OR REPLACE INTO  'Price_Group_Customer' VALUES ('$priceGroupCustomerID','$priceGroupDefinitionID','$customerID','$timestamp')";
    if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//Price_Group_Customer_Group
$stm = $db->prepare("SELECT price_group_customer_id,price_group_definition_id,customer_group_id,timestamp FROM Price_Group_Customer_Group WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($priceGroupCustomerID,$priceGroupDefinitionID,$customerGroupID,$timestamp);
while ($stm->fetch()) {
    

    
    
    
    
 
    $txt="INSERT OR REPLACE INTO  'Price_Group_Customer_Group' VALUES ('$priceGroupCustomerID','$priceGroupDefinitionID','$customerGroupID','$timestamp')";
    if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
}
$stm-> close();



//Item_Brochures
$stm = $db->prepare("SELECT item_brochure_id,item_id,brochure_name,brochure_url,brochure_order,timestamp FROM Item_Brochures WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($itemBtrochureID,$itemID,$brochureName,$brochureUrl,$brochureOrder,$timestamp);
while ($stm->fetch()) {
    
   
$brochureName= prepareString($brochureName);
$brochureUrl= prepareString($brochureUrl);

    
    
    
 
    $txt="INSERT OR REPLACE INTO  'Item_Brochures' VALUES ('$itemBtrochureID','$itemID','$brochureName','$brochureUrl','$brochureOrder','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//Item_Videos
$stm = $db->prepare("SELECT item_video_id,item_id,vide_name,video_url,player,video_order,timestamp FROM Item_Videos WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($itemVideoID,$itemID,$videoName,$videoUrl,$player,$videoOrder,$timestamp);
while ($stm->fetch()) {
    
    
 
$videoName= prepareString($videoName);
$videoUrl= prepareString($videoUrl);
$player= prepareString($player);

 
 
 
    $txt="INSERT OR REPLACE INTO  'Item_Videos' VALUES ('$itemVideoID','$itemID','$videoName','$videoUrl','$player','$videoOrder','$timestamp')";
    if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//CRM_Types
$stm = $db->prepare("SELECT type_id,type_name,color,icon,visible,position,when_to_show,timestamp FROM CRM_Types WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($typeID,$typeName,$color,$icon,$visible,$position,$whenToShow,$timestamp);
while ($stm->fetch()) {
    
    
$typeName= prepareString($typeName);
$color= prepareString($color);
$icon= prepareString($icon);
$visible= prepareString($visible);
$whenToShow= prepareString($whenToShow);

    
    
    
    
    
    
    
 
    $txt="INSERT OR REPLACE INTO  'CRM_Types' VALUES ('$typeID','$typeName','$color','$icon','$visible','$position','$whenToShow','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//CRM_Posts
$stm = $db->prepare("SELECT post_id,customer_id,salesperson_id,crm_type_id,post_date,post_text,editable,last_edit_time,value,status,timestamp FROM CRM_Posts WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($postID,$customerID,$salespersonID,$crmTypeID,$postDate,$postText,$editable,$lastEditTime,$value,$status,$timestamp);
while ($stm->fetch()) {
  
  
$postDate= prepareString($postDate);
$postText= prepareString($postText);
$editable= prepareString($editable);
$lastEditTime= prepareString($lastEditTime);
$value= prepareString($value);
$status= prepareString($status);
  
  
  
  
  
    $txt="INSERT OR REPLACE INTO  'CRM_Posts' VALUES ('$postID','$customerID','$salespersonID','$crmTypeID','$postDate','$postText','$editable','$lastEditTime','$value','$status','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//CRM_Post_Attachments
$stm = $db->prepare("SELECT post_attachment_id,post_id,type,url,timestamp FROM CRM_Post_Attachments WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($postAttachmentID,$postID,$type,$url,$timestamp);
while ($stm->fetch()) { 
    
  
$type= prepareString($type);
$url= prepareString($url);

    
    
    
    

    $txt="INSERT OR REPLACE INTO  'CRM_Post_Attachments' VALUES ('$postAttachmentID','$postID','$type','$url','$timestamp')";
    if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//Visit_Reasons

$stm = $db->prepare("SELECT reason_id,reason_code,reason,active,timestamp FROM Visit_Reasons WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($reasonID,$reasonCode,$reason,$active,$timestamp);
while ($stm->fetch()) {
   
  
$reasonCode= prepareString($reasonCode);
$reason= prepareString($reason);
$active= prepareString($active);

   
   
   
   
   
   
    $txt="INSERT OR REPLACE INTO  'Visit_Reasons' VALUES ('$reasonID','$reasonCode','$reason','$active','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//Images_To_Delete

$stm = $db->prepare("SELECT image_id,image_name,timestamp FROM Images_To_Delete WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($imageID,$imageName,$timestamp);
while ($stm->fetch()) {
   
  
$imageName= prepareString($imageName);

   
   
   
   
   
    $txt="INSERT OR REPLACE INTO  'Images_To_Delete' VALUES ('$imageID','$imageName','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();




//Promotions

$stm = $db->prepare("SELECT promotion_id,promotion_code,promotion_name,description,type,item_id,qty,fixed_discount_amount,fixed_discount_percent,pricetype_id,price,discount_qty,discount_percent_on_qty,printing_layout,color_in_cart,valid_from,valid_until,loyalty_points,all_customers,all_salespersons,status,timestamp FROM Promotions WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($promotionID,$promotionCode,$promotionName,$description,$type,$itemID,$qty,$fixedDiscountAmount,$fixedDiscountPercent,$pricetypeID,$price,$discountQty,$discountPercentOnQty,$printLayout,$colortInCart,$validFrom,$validUntil,$loyaltyPoints,$allCustomer,$allSalespersons,$status,$timestamp);
while ($stm->fetch()) {
    
    

$promotionCode= prepareString($promotionCode);
$promotionName= prepareString($promotionName);
$description= prepareString($description);
$type= prepareString($type);
$printLayout= prepareString($printLayout);
$colortInCart= prepareString($colortInCart);
$validFrom= prepareString($validFrom);
$validUntil= prepareString($validUntil);
$loyaltyPoints= prepareString($loyaltyPoints);
$allCustomer= prepareString($allCustomer);
$allSalespersons= prepareString($allSalespersons);
$status= prepareString($status);

    
    
    
    
    
    
    
   
    $txt="INSERT OR REPLACE INTO  'Promotions' VALUES ('$promotionID','$promotionCode','$promotionName','$description','$type','$itemID','$qty','$fixedDiscountAmount','$fixedDiscountPercent','$pricetypeID','$price','$discountQty','$discountPercentOnQty','$printLayout','$colortInCart','$validFrom','$validUntil','$loyaltyPoints','$allCustomer','$allSalespersons','$status','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();



//Promotion_Customer

$stm = $db->prepare("SELECT promotion_id,customer_id,timestamp FROM Promotion_Customer WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($promotionID,$customerID,$timestamp);
while ($stm->fetch()) {
   
   
   
   
   
   
   
   
    $txt="INSERT OR REPLACE INTO  'Promotion_Customer' VALUES ('$promotionID','$customerID','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//Promotion_Extra_Item

$stm = $db->prepare("SELECT promotion_id,item_id,pricetype_id,timestamp FROM Promotion_Extra_Item WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($promotionID,$itemID,$priceTypeID,$timestamp);
while ($stm->fetch()) {
   
    $txt="INSERT OR REPLACE INTO  'Promotion_Extra_Item' VALUES ('$promotionID','$itemID','$priceTypeID','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();



//Promotion_Matching_Rule

$stm = $db->prepare("SELECT promotion_matching_rule_id,promotion_id,category_id,item_id,credit_limit,value,timestamp FROM Promotion_Matching_Rule WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($promotionMatchingRuleID,$promotionID,$categoryID,$itemID,$creditLimit,$value,$timestamp);
while ($stm->fetch()) {
    

    
    
    
   
    $txt="INSERT OR REPLACE INTO  'Promotion_Matching_Rule' VALUES ('$promotionMatchingRuleID','$promotionID','$categoryID','$itemID','$creditLimit','$value','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//Promotion_Salesperson

$stm = $db->prepare("SELECT promotion_id,salesperson_id,timestamp FROM Promotion_Salesperson WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($promotionID,$salespersonID,$timestamp);
while ($stm->fetch()) {
   
    $txt="INSERT OR REPLACE INTO  'Promotion_Salesperson' VALUES ('$promotionID','$salespersonID','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//Promotion_Customer_Group

$stm = $db->prepare("SELECT promotion_id,group_id,timestamp FROM Promotion_Customer_Group WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($promotionID,$groupID,$timestamp);
while ($stm->fetch()) {
   
    $txt="INSERT OR REPLACE INTO  'Promotion_Customer_Group' VALUES ('$promotionID','$groupID','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//Payment_Terms

$stm = $db->prepare("SELECT payment_term_id,payment_term_code,payment_term_text,payment_terms_days,timestamp FROM Payment_Terms WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($paymentTermID,$paymenTermCode,$paymentTermText,$paymentTermDays,$timestamp);
while ($stm->fetch()) {

    $paymenTermCode= prepareString($paymenTermCode);
    $paymentTermText= prepareString($paymentTermText);

    $txt="INSERT OR REPLACE INTO  'Payment_Terms' VALUES ('$paymentTermID','$paymenTermCode','$paymentTermText','$paymentTermDays','$timestamp')";
    if($isFile)
    {
        fwrite($file,$txt."\n");
    }
    else
    {
        $s = $xml->addChild('s');
        $s->addAttribute('c',$txt);
    }
    $counter++;
}
$stm-> close();

//Customer_Payment_Terms

$stm = $db->prepare("SELECT customer_id,payment_term_days,payment_term_text,timestamp FROM Customer_Payment_Terms WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($customerID,$paymentTermDays,$paymentTermText,$timestamp);
while ($stm->fetch()) {
    
   
$paymentTermDays= prepareString($paymentTermDays);
$paymentTermText= prepareString($paymentTermText);

    
    
    
    
   
    $txt="INSERT OR REPLACE INTO  'Customer_Payment_Terms' VALUES ('$customerID','$paymentTermDays','$paymentTermText','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//-----------------------------------------Order Notes------------------------------------------------------------

$stm = $db->prepare("SELECT order_note_id,order_note_text,timestamp FROM Order_Notes WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($orderNoteID,$orderNoteText,$timestamp);
while ($stm->fetch()) {
    
    
    
 
$orderNoteText= prepareString($orderNoteText);

    
   
    $txt="INSERT OR REPLACE INTO 'Order_Notes' VALUES ('$orderNoteID','$orderNoteText','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//-----------------------------------------Project------------------------------------------------------------

$stm = $db->prepare("SELECT project_id,project_code,project_name,active,timestamp FROM Projects WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($projectID,$projectCode,$projectName,$active,$timestamp);
while ($stm->fetch()) {
    
    
$projectCode= prepareString($projectCode);
$projectName= prepareString($projectName);
$active= prepareString($active);

    
    
   
    $txt="INSERT OR REPLACE INTO 'Projects' VALUES ('$projectID','$projectCode','$projectName','$active','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//-----------------------------------------Profit_Center------------------------------------------------------------

$stm = $db->prepare("SELECT profit_center_id,profit_center_code,profit_center_name,active,timestamp FROM Profit_Center WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($profitCenterID,$profitCenteCode,$profitCenteName,$active,$timestamp);
while ($stm->fetch()) {
    
    
$profitCenteCode= prepareString($profitCenteCode);
$profitCenteName= prepareString($profitCenteName);
$active= prepareString($active);

    
    
    
    
    
   
    $txt="INSERT OR REPLACE INTO 'Profit_Center' VALUES ('$profitCenterID','$profitCenteCode','$profitCenteName','$active','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();



//-----------------------------------------Customer_Updates------------------------------------------------------------

$stm = $db->prepare("SELECT id,customer_id,amount,timestamp FROM Customer_Updates WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($id,$customerID,$amount,$timestamp);
while ($stm->fetch()) {
   
    $txt="INSERT OR REPLACE INTO 'Customer_Updates' VALUES ('$id','$customerID','$amount','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//-----------------------------------------SC_Priorities------------------------------------------------------------

$stm = $db->prepare("SELECT priority_id,priority_code,priority_name,priority_level,priority_color,timestamp FROM SC_Priorities WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($priorityID,$priorityCode,$priorityName,$priorityLevel,$priorityColor,$timestamp);
while ($stm->fetch()) {
    
    
    
  
$priorityCode= prepareString($priorityCode);
$priorityName= prepareString($priorityName);
$priorityLevel= prepareString($priorityLevel);
$priorityColor= prepareString($priorityColor);

    
   
    $txt="INSERT OR REPLACE INTO 'SC_Priorities' VALUES ('$priorityID','$priorityCode','$priorityName','$priorityLevel','$priorityColor','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();



//-----------------------------------------SC_Reply_Types------------------------------------------------------------

$stm = $db->prepare("SELECT sc_reply_type_id,sc_reply_code,sc_reply_name,timestamp FROM SC_Reply_Types WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($scReplyTypeID,$scReplyCode,$scReplyName,$timestamp);
while ($stm->fetch()) {
   
   

$scReplyCode= prepareString($scReplyCode);
$scReplyName= prepareString($scReplyName);

   
   
   
   
   
    $txt="INSERT OR REPLACE INTO 'SC_Reply_Types' VALUES ('$scReplyTypeID','$scReplyCode','$scReplyName','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//-----------------------------------------SC_Sources------------------------------------------------------------

$stm = $db->prepare("SELECT source_id,source_code,source_name,timestamp FROM SC_Sources WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($sourceID,$sourceCode,$sourceName,$timestamp);
while ($stm->fetch()) {
    
    
    
$sourceCode= prepareString($sourceCode);
$sourceName= prepareString($sourceName);

    
    
    
    
    
    
   
    $txt="INSERT OR REPLACE INTO 'SC_Sources' VALUES ('$sourceID','$sourceCode','$sourceName','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//-----------------------------------------SC_Status------------------------------------------------------------

$stm = $db->prepare("SELECT status_id,status_code,status_name,position,visible,calendar_fixed,status_color,timestamp FROM SC_Status WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($statusID,$statusCode,$statusName,$position,$visible,$calendarFixed,$statusColor,$timestamp);
while ($stm->fetch()) {
    
    
   
$statusCode= prepareString($statusCode);
$statusName= prepareString($statusName);
$visible= prepareString($visible);
$calendarFixed= prepareString($calendarFixed);
$statusColor= prepareString($statusColor);


    
    
   
    $txt="INSERT OR REPLACE INTO 'SC_Status' VALUES ('$statusID','$statusCode','$statusName','$position','$visible','$calendarFixed','$statusColor','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();



//-----------------------------------------SC_Types------------------------------------------------------------

$stm = $db->prepare("SELECT type_id,type_code,type_name,color,timestamp FROM SC_Types WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($typeID,$typeCode,$typeName,$color,$timestamp);
while ($stm->fetch()) {
    
    
    
  
$typeCode= prepareString($typeCode);
$typeName= prepareString($typeName);

    
    
   
    $txt="INSERT OR REPLACE INTO 'SC_Types' VALUES ('$typeID','$typeCode','$typeName','$color','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();



//-----------------------------------------Serial_Numbers------------------------------------------------------------

$stm = $db->prepare("SELECT serial_number_id,serial_number,item_id,desription_1,desription_2,details_1,details_2,details_3,date_1,date_2,notes,status,timestamp FROM Serial_Numbers WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($serialNumberID,$serialNumber,$itemID,$description1,$description2,$details1,$details2,$details3,$date1,$date2,$notes,$status,$timestamp);
while ($stm->fetch()) {
    
    
  
$serialNumber= prepareString($serialNumber);

$description1= prepareString($description1);
$description2= prepareString($description2);
$details1= prepareString($details1);
$details2= prepareString($details2);
$details3= prepareString($details3);
$notes= prepareString($notes);
$status= prepareString($status);

    
    
    
    
   
    $txt="INSERT OR REPLACE INTO 'Serial_Numbers' VALUES ('$serialNumberID','$serialNumber','$itemID','$description1','$description2','$details1','$details2','$details3','$date1','$date2','$notes','$status','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();



//-----------------------------------------Serial_Number_Transaction_Log------------------------------------------------------------

$stm = $db->prepare("SELECT serial_number_transaction_log_id,serial_number_id,customer_id,customer_address_id,warehouse_id,entry_date,start_date,end_date,action_id,action_type,description,notes,serial_number_transaction_type_id,status,timestamp FROM Serial_Number_Transaction_Log WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($serialNumberTransactionLogID,$serialNumberID,$customerID,$customerAddressID,$warehouseID,$entryDate,$startDate,$endDate,$actionID,$actionType,$description,$notes,$serialNumberTransctionTypeID,$status,$timestamp);
while ($stm->fetch()) {
   
 
$entryDate= prepareString($entryDate);
$startDate= prepareString($startDate);
$endDate= prepareString($endDate);

$actionType= prepareString($actionType);
$description= prepareString($description);
$notes= prepareString($notes);

$status= prepareString($status);

   
   
   
    $txt="INSERT OR REPLACE INTO 'Serial_Number_Transaction_Log' VALUES ('$serialNumberTransactionLogID','$serialNumberID','$customerID','$customerAddressID','$warehouseID','$entryDate','$startDate','$endDate','$actionID','$actionType','$description','$notes','$serialNumberTransctionTypeID','$status','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//-----------------------------------------Serial_Number_Transaction_Type------------------------------------------------------------

$stm = $db->prepare("SELECT serial_number_transaction_type_id,serial_number_transaction_type_code,serial_number_transaction_type_name,active,timestamp FROM Serial_Number_Transaction_Type WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($serialNumberTransactionTypeID,$snTraCode,$snTraName,$active,$timestamp);
while ($stm->fetch()) {
   
 
$snTraCode= prepareString($snTraCode);
$snTraName= prepareString($snTraName);
$active= prepareString($active);

   
   
   
   
   
    $txt="INSERT OR REPLACE INTO 'Serial_Number_Transaction_Type' VALUES ('$serialNumberTransactionTypeID','$snTraCode','$snTraName','$active','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//----------------------------------------- Service_Call------------------------------------------------------------

$stm = $db->prepare("SELECT service_call_id,service_call_code,salesperson_id,assign_to,customer_id,customer_address_id,item_id,serial_number_id,source_id,type_id,status_id,priority_id,topic,details,source_name,source_details,date,due_date,schedule_start_date,schedule_end_date,parent_id,progress,assign_to_2,timestamp FROM Service_Call WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($serviceCallID,$serviceCallCode,$salesperonID,$assignTo,$customerID,$customerAddressID,$itemID,$serialNumberID,$sourceID,$typeID,$statusID,$priorityID,$topic,$details,$sourceName,$sourceDetails,$date,$dueDate,$scheduleStartDate,$scheduleEndDate,$parentID,$progress,$assignTo2,$timestamp);
while ($stm->fetch()) {
   
   

$serviceCallCode= prepareString($serviceCallCode);
$topic= prepareString($topic);
$details= prepareString($details);
$sourceName= prepareString($sourceName);
$sourceDetails= prepareString($sourceDetails);
$date= prepareString($date);
$dueDate= prepareString($dueDate);
$scheduleStartDate= prepareString($scheduleStartDate);
$scheduleEndDate= prepareString($scheduleEndDate);
$parentID= prepareString($parentID);
$progress= prepareString($progress);
$assignTo2= prepareString($assignTo2);
   
   
   
   
   
    $txt="INSERT OR REPLACE INTO 'Service_Call' VALUES ('$serviceCallID','$serviceCallCode','$salesperonID','$assignTo','$customerID','$customerAddressID','$itemID','$serialNumberID','$sourceID','$typeID','$statusID','$priorityID','$topic','$details','$sourceName','$sourceDetails','$date','$dueDate','$scheduleStartDate','$scheduleEndDate','$parentID','$progress','$assignTo2','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//----------------------------------------- Service_Call_Reply------------------------------------------------------------

$stm = $db->prepare("SELECT service_call_reply_id,service_call_id,salesperson_id,status_id,date,reply_type_id,details,document_id,document_type,salesperson_to,email_response,priority_id,timestamp FROM Service_Call_Reply WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($serviceCallReplyID,$servicecallID,$salesperonID,$statusID,$date,$replyTypeID,$details,$documentID,$documentType,$salespersonTo,$emailResponse,$priorityID,$timestamp);
while ($stm->fetch()) {
    
  
$date= prepareString($date);
$details= prepareString($details);
$documentType= prepareString($documentType);
$emailResponse= prepareString($emailResponse);
    
   
    $txt="INSERT OR REPLACE INTO 'Service_Call_Reply' VALUES ('$serviceCallReplyID','$servicecallID','$salesperonID','$statusID','$date','$replyTypeID','$details','$documentID','$documentType','$salespersonTo','$emailResponse','$priorityID','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();



//-----------------------------------------Service_Call_Reply_Attachments------------------------------------------------------------

$stm = $db->prepare("SELECT sc_attachment_id,service_call_reply_id,attachment_name,attachment_url,attachment_order,timestamp FROM Service_Call_Reply_Attachments WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($scAttachmentID,$serviceCallReply,$attachmentName,$attachmentUrl,$attachmentOrder,$timestamp);
while ($stm->fetch()) {
    
    
$attachmentName= prepareString($attachmentName);
$attachmentUrl= prepareString($attachmentUrl);

    
    
    
    
    
   
    $txt="INSERT OR REPLACE INTO 'Service_Call_Reply_Attachments' VALUES ('$scAttachmentID','$serviceCallReply','$attachmentName','$attachmentUrl','$attachmentOrder','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//--------------------------------- ZA_Custom_Field_Definition --------------------------------------------------------
$stm = $db->prepare("SELECT custom_field_id,custom_field_name,type,values_range,css_style,class,timestamp FROM ZA_Custom_Field_Definition WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($custom_field_id, $custom_field_name, $type, $values_range, $css_style, $class, $timestamp);
while ($stm->fetch()) {
   
   

 $custom_field_name= prepareString($custom_field_name);
 $type= prepareString($type);
 $values_range= prepareString($values_range);
 $css_style= prepareString($css_style);
 $class= prepareString($class);

   
   
   
   
    $txt="INSERT OR REPLACE INTO 'ZA_Custom_Field_Definition' VALUES ('$custom_field_id','$custom_field_name','$type','$values_range','$css_style','$class','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();



//--------------------------------- ZA_Custom_Field_Object --------------------------------------------------------


$stm = $db->prepare("SELECT custom_field_object_id,custom_field_id,custom_form_object_id,value,timestamp FROM ZA_Custom_Field_Object WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm->bind_result($custom_field_object_id, $custom_field_id, $custom_form_object_id, $value, $timestamp);
while ($stm->fetch()) {
    
 $value= prepareString($value);

    
   
    $txt="INSERT OR REPLACE INTO 'ZA_Custom_Field_Object' VALUES ('$custom_field_object_id','$custom_field_id','$custom_form_object_id','$value','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();



//--------------------------------- ZA_Custom_Form_Custom_Field --------------------------------------------------------


$stm = $db->prepare("SELECT custom_form_id,custom_field_id,position,required,editable,timestamp FROM ZA_Custom_Form_Custom_Field WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($custom_form_id, $custom_field_id, $position, $required,$editable, $timestamp);
while ($stm->fetch()) {
    
    
  
 $required= prepareString($required);
$editable= prepareString($editable);

    
   
    $txt="INSERT OR REPLACE INTO 'ZA_Custom_Form_Custom_Field' VALUES ('$custom_form_id','$custom_field_id','$position','$required','$editable','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//--------------------------------- ZA_Custom_Form_Definition --------------------------------------------------------


$stm = $db->prepare("SELECT custom_form_definition_id,custom_form_code,custom_form_name,prefix,start_number,editiable,required,active,timestamp FROM ZA_Custom_Form_Definition WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($custom_form_definition_id, $custom_form_code, $custom_form_name, $prefix,$start_number,$editiable,$required,$active,$timestamp);
while ($stm->fetch()) {
    
  $custom_form_code= prepareString($custom_form_code);
 $custom_form_name= prepareString($custom_form_name);
 $prefix= prepareString($prefix);
$start_number= prepareString($start_number);
$editiable= prepareString($editiable);
$required= prepareString($required);
$active= prepareString($active);

    
    
   
    $txt="INSERT OR REPLACE INTO 'ZA_Custom_Form_Definition' VALUES ('$custom_form_definition_id','$custom_form_code','$custom_form_name','$prefix','$start_number','$editiable','$required','$active','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();



//--------------------------------- ZA_Custom_Form_Object --------------------------------------------------------


$stm = $db->prepare("SELECT custom_form_object_id,custom_form_id,custom_form_code,linked_table_id,salesperson_id,timestamp FROM ZA_Custom_Form_Object WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm->bind_result($custom_form_object_id, $custom_form_id, $custom_form_code, $linked_table_id,$salesperson_id,$timestamp);
while ($stm->fetch()) {
    
    
 $custom_form_code= prepareString($custom_form_code);
 
    
   
    $txt="INSERT OR REPLACE INTO 'ZA_Custom_Form_Object' VALUES ('$custom_form_object_id','$custom_form_id','$custom_form_code','$linked_table_id','$salesperson_id','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


 
//--------------------------------- ZA_Custom_Form_Usage --------------------------------------------------------


$stm = $db->prepare("SELECT custom_form_usage_id,custom_form_id,linked_table,timestamp FROM ZA_Custom_Form_Usage WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($custom_form_usage_id, $custom_form_id, $linked_table,$timestamp);
while ($stm->fetch()) {
    
    
 $linked_table= prepareString($linked_table);

    
   
    $txt="INSERT OR REPLACE INTO 'ZA_Custom_Form_Usage' VALUES ('$custom_form_usage_id','$custom_form_id','$linked_table','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

 
//--------------------------------- Allow_CRM_Types --------------------------------------------------------


$stm = $db->prepare("SELECT salesperson_id,crm_type_id,timestamp FROM Allow_CRM_Types WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($salespersonID, $crmTypeID,$timestamp);
while ($stm->fetch()) {
    
    
    
    
    
   
    $txt="INSERT OR REPLACE INTO 'Allow_CRM_Types' VALUES ('$salespersonID','$crmTypeID','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();




//--------------------------------- Allow_SC_Assignments --------------------------------------------------------


$stm = $db->prepare("SELECT salesperson_id,assign_to_salesperson_id,timestamp FROM Allow_SC_Assignments WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($salespersonID,$assignToSalespersonID,$timestamp);
while ($stm->fetch()) {
   
    $txt="INSERT OR REPLACE INTO 'Allow_SC_Assignments' VALUES ('$salespersonID','$assignToSalespersonID','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//--------------------------------- Allow_SC_Priorities --------------------------------------------------------

$stm = $db->prepare("SELECT salesperson_id,priority_id,timestamp FROM Allow_SC_Priorities WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($salespersonID,$priorityID,$timestamp);
while ($stm->fetch()) {
   
    $txt="INSERT OR REPLACE INTO 'Allow_SC_Priorities' VALUES ('$salespersonID','$priorityID','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//--------------------------------- Allow_SC_Status --------------------------------------------------------


$stm = $db->prepare("SELECT salesperson_id,status_id,timestamp FROM Allow_SC_Status WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($salespersonID,$statusID,$timestamp);
while ($stm->fetch()) {
   
    $txt="INSERT OR REPLACE INTO 'Allow_SC_Status' VALUES ('$salespersonID','$statusID','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();



//--------------------------------- UOMs --------------------------------------------------------


$stm = $db->prepare("SELECT uom_id,description,active,timestamp FROM UOMs WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($uomID,$description,$active,$timestamp);
while ($stm->fetch()) {
   
   
$description= prepareString($description);
$active= prepareString($active);

   
   
   
    $txt="INSERT OR REPLACE INTO 'UOMs' VALUES ('$uomID','$description','$active','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();



//--------------------------------- UOM_Item --------------------------------------------------------


$stm = $db->prepare("SELECT item_id,uom_id,position,multiplier,timestamp FROM UOM_Item WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($itemID,$uomID,$position,$multiplier,$timestamp);
while ($stm->fetch()) {
    
    
    
    
   
    $txt="INSERT OR REPLACE INTO 'UOM_Item' VALUES ('$itemID','$uomID','$position','$multiplier','$timestamp')";
   if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//--------------------------------- SC_Filters --------------------------------------------------------


$stm = $db->prepare("SELECT filter_id, filter_name, position, salesperson_id, create_date_from, create_date_to, schedule_date_from, schedule_date_to, where_clause, active, default_filter, is_calendar, timestamp FROM SC_Filters WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($filterID,$filterName,$position,$salespersonID,$createDateFrom,$createDateTo,$scheduleDateFrom,$scheduleDateTo,$whereClause,$active,$defaultFilter,$isCalendar,$timestamp);
while ($stm->fetch()) {


    $filterName= prepareString($filterName);
    $whereClause= prepareString($whereClause);
    $active= prepareString($active);
    $defaultFilter= prepareString($defaultFilter);
    $isCalendar= prepareString($isCalendar);

    $txt="INSERT OR REPLACE INTO 'SC_Filters' VALUES ('$filterID','$filterName','$position','$salespersonID','$createDateFrom','$createDateTo','$scheduleDateFrom','$scheduleDateTo','$whereClause','$active','$defaultFilter','$isCalendar','$timestamp')";
   if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//--------------------------------- SC_Filter_Salesperson --------------------------------------------------------

$stm = $db->prepare("SELECT filter_id, salesperson_id, timestamp FROM SC_Filter_Salesperson WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($filterID,$salespersonID,$timestamp);
while ($stm->fetch()) {

    $txt="INSERT OR REPLACE INTO 'SC_Filter_Salesperson' VALUES ('$filterID','$salespersonID','$timestamp')";
   if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//--------------------------------- SC_Filter_Priority --------------------------------------------------------

$stm = $db->prepare("SELECT filter_id, priority_id, timestamp FROM SC_Filter_Priority WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($filterID,$priorityID,$timestamp);
while ($stm->fetch()) {

    $txt="INSERT OR REPLACE INTO 'SC_Filter_Priority' VALUES ('$filterID','$priorityID','$timestamp')";
   if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//--------------------------------- SC_Filter_Status --------------------------------------------------------

$stm = $db->prepare("SELECT filter_id, status_id, timestamp FROM SC_Filter_Status WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($filterID,$statusID,$timestamp);
while ($stm->fetch()) {

    $txt="INSERT OR REPLACE INTO 'SC_Filter_Status' VALUES ('$filterID','$statusID','$timestamp')";
   if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//--------------------------------- SC_Filter_Type --------------------------------------------------------

$stm = $db->prepare("SELECT filter_id, type_id, timestamp FROM SC_Filter_Type WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($filterID,$typeID,$timestamp);
while ($stm->fetch()) {

    $txt="INSERT OR REPLACE INTO 'SC_Filter_Type' VALUES ('$filterID','$typeID','$timestamp')";
   if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//--------------------------------- Stock_Updates --------------------------------------------------------


$stm = $db->prepare("SELECT stock_update_id,warehouse_id,item_id,batch_number,available,reserved,delivered,on_order,requested,sold,expiry_date,action_type,action_id,action_code,reason,from_action_type,from_action_id,from_action_code,from_action_qty,from_action_field,timestamp FROM Stock_Updates WHERE timestamp >='$lastUpdate'  AND stock_update_id LIKE '$databasePrefix%' $activationWindow ");
$stm-> execute();
$stm->bind_result($stockUpdateID,$warehouseID,$itemID,$batchnumber,$available,$reserved,$delivered,$onOrder,$requested,$sold,$expiryDate,$actionType,$actionID,$actionCode,$reason,$fromActionType,$fromActionID,$fromActionCode,$fromActionQty,$fromActionField,$timestamp);
while ($stm->fetch()) {
    


    
    
   
    $txt="INSERT OR REPLACE INTO 'Stock_Updates' VALUES ('$stockUpdateID','$warehouseID','$itemID','$batchnumber','$available','$reserved','$delivered','$onOrder','$requested','$sold','$expiryDate','$actionType','$actionID','$actionCode','$reason','$fromActionType','$fromActionID','$fromActionCode','$fromActionQty','$fromActionField','$timestamp')";
   if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//--------------------------------- ZE_Z_Report --------------------------------------------------------


$stm = $db->prepare("SELECT lock_id,document_id,document_type,lock_number,z_date,start_z_time,salesperson_id,subtotal,discount_amount,vat_amount,grand_total,timestamp FROM ZE_Z_Report WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm->bind_result($lockID,$documentID,$documentType,$lockNumber,$zDate,$startZ,$salespersonID,$subTotal,$discountAmount,$vatAmount,$grandTotal,$timestamp);
while ($stm->fetch()) {
    $documentType= prepareString($documentType);
    $lockNumber= prepareString($lockNumber);
    
    $txt="INSERT OR REPLACE INTO 'ZE_Z_Report' VALUES ('$lockID','$documentID','$documentType','$lockNumber','$zDate','$startZ','$salespersonID','$subTotal','$discountAmount','$vatAmount','$grandTotal','$timestamp')";
   if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();



 

//--------------------------------- Return_Reasons --------------------------------------------------------


$stm = $db->prepare("SELECT return_reason_id,return_reason_code,return_reason_name,timestamp FROM Return_Reasons WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($returnReasonID,$returnReasonCode,$returnReasonName,$timestamp);
while ($stm->fetch()) {
    $returnReasonCode= prepareString($returnReasonCode);
    $returnReasonName= prepareString($returnReasonName);
    
    $txt="INSERT OR REPLACE INTO 'Return_Reasons' VALUES ('$returnReasonID','$returnReasonCode','$returnReasonName','$timestamp')";
   if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//--------------------------------- Action_Initial_Prefs --------------------------------------------------------


$stm = $db->prepare("SELECT salesperson_id,tender_group_id,tender_category_id,order_group_id,order_category_id,waybill_group_id,waybill_category_id,invoice_group_id,invoice_category_id,return_group_id,return_category_id,receipt_group_id,st_group_id,st_category_id,timestamp FROM Action_Initial_Prefs WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($salespersonID,$tenderGroupID,$tenderCategoryID,$orderGroupID,$orderCategoryID,$waybillGroupID,$waybillCategoryID,$invoiceGroupID,$invoiceCategoryID,$returnGroupID,$returnCategoryID,$receiprGroupID,$stGroupID,$stCategoryID,$timestamp);
while ($stm->fetch()) {
  
    $txt="INSERT OR REPLACE INTO 'Action_Initial_Prefs' VALUES ('$salespersonID','$tenderGroupID','$tenderCategoryID','$orderGroupID','$orderCategoryID','$waybillGroupID','$waybillCategoryID','$invoiceGroupID','$invoiceCategoryID','$returnGroupID','$returnCategoryID','$receiprGroupID','$stGroupID','$stCategoryID','$timestamp')";
   if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//Receipt_Item

$stm = $db->prepare("SELECT receipt_item_id,receipt_id,amount,payment_method,cash_discount,bank,branch,cheque_number,cheque_date,notes,timestamp FROM Receipt_Item WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($receiptItemID,$recieptID,$amount,$paymentMethod,$cashDiscount,$bank,$branch,$chequeNumber,$chequeDate,$notes,$timestamp);
while ($stm->fetch()) {


$paymentMethod= prepareString($paymentMethod);
$bank= prepareString($bank);
$branch= prepareString($branch);
$chequeNumber= prepareString($chequeNumber);
$chequeDate= prepareString($chequeDate);
$notes= prepareString($notes);

    
    
    
    
    
    $txt="INSERT OR REPLACE INTO  'Receipt_Item' VALUES ('$receiptItemID','$recieptID','$amount','$paymentMethod','$cashDiscount','$bank','$branch','$chequeNumber','$chequeDate','$notes','$timestamp')";
      if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;

}
$stm-> close();


//Action_Attachments
$stm = $db->prepare("SELECT action_attachment_id, action_type, action_id, attachment_url, name, timestamp FROM Action_Attachments WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($id,$actionType,$actionID,$attachmentURL,$attachmentName,$timestamp);
while ($stm->fetch()) {

    $actionType= prepareString($actionType);
    $attachmentURL= prepareString($attachmentURL);
    $attachmentName= prepareString($attachmentName);


    $txt="INSERT OR REPLACE INTO  'Action_Attachments' VALUES ('$id','$actionType','$actionID','$attachmentURL','$attachmentName','$timestamp')";
    if($isFile)
    {
        fwrite($file,$txt."\n");
    }
    else
    {
        $s = $xml->addChild('s');
        $s->addAttribute('c',$txt);
    }
    $counter++;
}
$stm-> close();

//---------------------------- Item_Serialnumber-------------------------------------------
$stm = $db->prepare("SELECT item_id,serialnumber,warehouse_id,timestamp FROM Item_Serialnumber WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($itemID,$serialNumber,$warehouseID,$timestamp);
while ($stm->fetch()) {
    
    
    
$serialNumber= prepareString($serialNumber);


    
    
    $txt="INSERT OR REPLACE INTO  'Item_Serialnumber' VALUES ('$itemID', '$serialNumber', '$warehouseID','$timestamp')";
      if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//--------------------------------- Receipt_Coupons --------------------------------------------------------


$stm = $db->prepare("SELECT coupon_id,coupon_code,coupon_name,timestamp FROM Receipt_Coupons WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($couponID,$couponCode,$couponName,$timestamp);
while ($stm->fetch()) {
    $couponCode= prepareString($couponCode);
    $couponName= prepareString($couponName);
    
    $txt="INSERT OR REPLACE INTO 'Receipt_Coupons' VALUES ('$couponID','$couponCode','$couponName','$timestamp')";
   if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

//--------------------------------- Contracts --------------------------------------------------------


$stm = $db->prepare("SELECT contract_id, customer_id, customer_address_id, item_id, serial_number_id, salesperson_id, contract_type_id, serial_number_transaction_log_id, start_date, end_date, price, due_date, valid, payment_type_id, payment_date, way_of_payment_id, technician_id, attachment_id, notes, troubleshooting_id, date_of_purchase, price2, price3, total1, total2, timestamp FROM Contracts WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm->bind_result($contractID,$customerID,$addressID,$itemID,$serialNumberID,$salespersonID,$contractTypeID,$serialNumberTransLogID,$startDate,$endDate,$price,$dueDate,$valid,$paymentTypeID,$paymentDate,$wayOfPaymentID,$technitianID,$attachmentID,$notes,$troubleshootingID,$dateOfPurchaseID,$price2,$price3,$total1,$total2,$timestamp);
while ($stm->fetch()) {
    $valid= prepareString($valid);
    $notes= prepareString($notes);

    $txt="INSERT OR REPLACE INTO 'Contracts' VALUES ('$contractID','$customerID','$addressID','$itemID','$serialNumberID','$salespersonID','$contractTypeID','$serialNumberTransLogID','$startDate','$endDate','$price','$dueDate','$valid','$paymentTypeID','$paymentDate','$wayOfPaymentID','$technitianID','$attachmentID','$notes','$troubleshootingID','$dateOfPurchaseID','$price2','$price3','$total1','$total2','$timestamp')";
    if($isFile)
    {
        fwrite($file,$txt."\n");
    }
    else
    {
        $s = $xml->addChild('s');
        $s->addAttribute('c',$txt);
    }
    $counter++;
}
$stm-> close();

//--------------------------------- Contracts_Attachments --------------------------------------------------------


$stm = $db->prepare("SELECT contract_attachment_id, contract_id, type, url, attachment_order, timestamp FROM Contracts_Attachments WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm->bind_result($contractAttachmentID,$contractID, $type, $url, $attachmentOrder ,$timestamp);
while ($stm->fetch()) {
    $type= prepareString($type);
    $url= prepareString($url);

    $txt="INSERT OR REPLACE INTO 'Contracts_Attachments' VALUES ('$contractAttachmentID','$contractID','$type','$url','$attachmentOrder','$timestamp')";
    if($isFile)
    {
        fwrite($file,$txt."\n");
    }
    else
    {
        $s = $xml->addChild('s');
        $s->addAttribute('c',$txt);
    }
    $counter++;
}
$stm-> close();

//--------------------------------- Contract_Types --------------------------------------------------------


$stm = $db->prepare("SELECT contract_type_id, contract_type_code, contract_type_name, days, timestamp FROM Contract_Types WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($contractTypeID,$contractTypeCode,$contractTypeName,$days,$timestamp);
while ($stm->fetch()) {
    $contractTypeCode= prepareString($contractTypeCode);
    $contractTypeName= prepareString($contractTypeName);

    $txt="INSERT OR REPLACE INTO 'Contract_Types' VALUES ('$contractTypeID','$contractTypeCode','$contractTypeName','$days','$timestamp')";
    if($isFile)
    {
        fwrite($file,$txt."\n");
    }
    else
    {
        $s = $xml->addChild('s');
        $s->addAttribute('c',$txt);
    }
    $counter++;
}
$stm-> close();

//--------------------------------- Customer_Vat --------------------------------------------------------


$stm = $db->prepare("SELECT customer_id,customer_address_id,category_id,vat_id,timestamp FROM Customer_Vat WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($customerID,$customerAddressID,$categoryID,$vatID,$timestamp);
while ($stm->fetch()) {

    
    $txt="INSERT OR REPLACE INTO 'Customer_Vat' VALUES ('$customerID','$customerAddressID','$categoryID','$vatID','$timestamp')";
   if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//GroupContractPrices
$stm = $db->prepare("SELECT group_id,item_id,price,pricetype_id,percentage,min_qty,valid_from,valid_until,timestamp FROM GroupContractPrices WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($groupID,$itemID,$price,$priceTypeID,$percentage,$minQty,$validFrom,$validUntil,$timestamp);
while ($stm->fetch()) {
    
   
$validFrom= prepareString($validFrom);
$validUntil= prepareString($validUntil);

    
    
    
    
    
    
    $txt="INSERT OR REPLACE INTO  'GroupContractPrices' VALUES ('$groupID', '$itemID', '$price','$priceTypeID', '$percentage', '$minQty', '$validFrom', '$validUntil','$timestamp')";
     if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();





//--------------------------------- SC_Referred_To --------------------------------------------------------


$stm = $db->prepare("SELECT service_call_id,salesperson_id,added_time,added_by_id,timestamp FROM SC_Referred_To WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm->bind_result($serviceCallID,$salesperson_id,$addedTime,$addedById,$timestamp);
while ($stm->fetch()) {

    
    $txt="INSERT OR REPLACE INTO 'SC_Referred_To' VALUES ('$serviceCallID','$salesperson_id','$addedTime','$addedById','$timestamp')";
   if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();


//--------------------------------- Service_Call_Hierarchy --------------------------------------------------------

try {

    $stm = $db->prepare("SELECT parent_id,child_id,link_type,link_date,active,details,timestamp FROM Service_Call_Hierarchy WHERE timestamp >='$lastUpdate' ");
    $stm->execute();
    $stm->bind_result($parentID, $childID, $linkType, $linkDate, $active, $details,$timestamp);
    while ($stm->fetch()) {
        $details= prepareString($details);
        $txt = "INSERT OR REPLACE INTO 'Service_Call_Hierarchy' VALUES ('$parentID','$childID','$linkType','$linkDate','$active','$details','$timestamp')";
        if ($isFile) {
            fwrite($file, $txt . "\n");
        } else {
            $s = $xml->addChild('s');
            $s->addAttribute('c', $txt);
        }
        $counter++;
    }
    $stm->close();

}
catch (Exception $ex){}



//--------------------------------- Customer_Item --------------------------------------------------------


$stm = $db->prepare("SELECT customer_id,item_id,timestamp FROM Customer_Item WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($customerID,$itemID,$timestamp);
while ($stm->fetch()) {


    $txt="INSERT OR REPLACE INTO 'Customer_Item' VALUES ('$customerID','$itemID','$timestamp')";
    if($isFile)
    {
        fwrite($file,$txt."\n");
    }
    else
    {
        $s = $xml->addChild('s');
        $s->addAttribute('c',$txt);
    }
    $counter++;
}
$stm-> close();

//--------------------------------- Manager_Salesperson --------------------------------------------------------


$stm = $db->prepare("SELECT manager_id,salesperson_id,managing_type,timestamp FROM Manager_Salesperson WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($managerID,$salespersonID,$type,$timestamp);
while ($stm->fetch()) {
    $type= prepareString($type);

    $txt="INSERT OR REPLACE INTO 'Manager_Salesperson' VALUES ('$managerID','$salespersonID','$type','$timestamp')";
    if($isFile)
    {
        fwrite($file,$txt."\n");
    }
    else
    {
        $s = $xml->addChild('s');
        $s->addAttribute('c',$txt);
    }
    $counter++;
}
$stm-> close();

//--------------------------------- Allow_Categories_Customers --------------------------------------------------------


$stm = $db->prepare("SELECT customer_id,category_id,cycle_type,visit_cycle_in_days,last_visit_date,last_action_date,rating,target,notes,timestamp FROM Allow_Categories_Customers WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($customer_id,$category_id,$cycle_type,$visit_cycle_in_days,$last_visit_date,$last_action_date,$rating,$target,$notes,$timestamp);
while ($stm->fetch()) {


    $txt="INSERT OR REPLACE INTO 'Allow_Categories_Customers' VALUES ('$customer_id','$category_id','$cycle_type','$visit_cycle_in_days','$last_visit_date','$last_action_date','$rating','$target','$notes','$timestamp')";
    $txt="INSERT OR REPLACE INTO 'Allow_Categories_Customers' VALUES ('$customer_id','$category_id','$cycle_type','$visit_cycle_in_days','$last_visit_date','$last_action_date','$rating','$target','$notes','$timestamp')";
    if($isFile)
    {
        fwrite($file,$txt."\n");
    }
    else
    {
        $s = $xml->addChild('s');
        $s->addAttribute('c',$txt);
    }
    $counter++;
}
$stm-> close();

//--------------------------------- Customer_GDPR --------------------------------------------------------


$stm = $db->prepare("SELECT customer_gdpr_id,customer_id,gdpr_status,last_action_salesperson_id,status_changed_date,reason,timestamp FROM Customer_GDPR WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($customer_gdpr_id,$customer_id,$gdpr_status,$last_action_salesperson_id,$status_changed_date,$reason,$timestamp);
while ($stm->fetch()) {

    $reason= prepareString($reason);
    $txt="INSERT OR REPLACE INTO 'Customer_GDPR' VALUES ('$customer_gdpr_id','$customer_id','$gdpr_status','$last_action_salesperson_id','$status_changed_date','$reason','$timestamp')";
    if($isFile)
    {
        fwrite($file,$txt."\n");
    }
    else
    {
        $s = $xml->addChild('s');
        $s->addAttribute('c',$txt);
    }
    $counter++;
}
$stm-> close();

//--------------------------------- Serial_Number_Location --------------------------------------------------------


$stm = $db->prepare("SELECT serial_number_id,customer_id,contract_id,service_call_id,lat,lng,location_date,type,reason,notes,salesperson_id,timestamp FROM Serial_Number_Location WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($serialNumberID,$customerID,$contractID,$serviceCallID,$lat,$lng,$locationDate,$type,$reason,$notes,$salespersonID,$timestamp);
while ($stm->fetch()) {
    $reason= prepareString($reason);
    $notes= prepareString($notes);

    $txt="INSERT OR REPLACE INTO 'Serial_Number_Location' VALUES ('$serialNumberID','$customerID','$contractID','$serviceCallID','$lat','$lng','$locationDate','$type','$reason','$notes','$salespersonID','$timestamp')";
    if($isFile)
    {
        fwrite($file,$txt."\n");
    }
    else
    {
        $s = $xml->addChild('s');
        $s->addAttribute('c',$txt);
    }
    $counter++;
}
$stm-> close();

//--------------------------------- SubCustomers --------------------------------------------------------


$stm = $db->prepare("SELECT customer_id,subcustomer_id,date_added,position,user_id,type,notes,timestamp FROM SubCustomers WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($customerID,$subCustomerID,$dateAdded,$position,$userID,$type,$notes,$timestamp);
while ($stm->fetch()) {
    $notes= prepareString($notes);
    $type= prepareString($type);

    $txt="INSERT OR REPLACE INTO 'SubCustomers' VALUES ('$customerID','$subCustomerID','$dateAdded','$position','$userID','$type','$notes','$timestamp')";
    if($isFile)
    {
        fwrite($file,$txt."\n");
    }
    else
    {
        $s = $xml->addChild('s');
        $s->addAttribute('c',$txt);
    }
    $counter++;
}
$stm-> close();

//--------------------------------- SubCustomerGroups --------------------------------------------------------


$stm = $db->prepare("SELECT group_id,subgroup_id,date_added,position,user_id,type,notes,timestamp FROM SubCustomerGroups WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($groupID,$subGroupID,$dateAdded,$position,$userID,$type,$notes,$timestamp);
while ($stm->fetch()) {


    $txt="INSERT OR REPLACE INTO 'SubCustomerGroups' VALUES ('$groupID','$subGroupID','$dateAdded','$position','$userID','$type','$notes','$timestamp')";
    if($isFile)
    {
        fwrite($file,$txt."\n");
    }
    else
    {
        $s = $xml->addChild('s');
        $s->addAttribute('c',$txt);
    }
    $counter++;
}
$stm-> close();

//--------------------------------- SC_Reply_Attachment_Categories --------------------------------------------------------


$stm = $db->prepare("SELECT sc_reply_attachment_category_id,sc_reply_attachment_category_code,sc_reply_attachment_category_name,position,type,timestamp FROM SC_Reply_Attachment_Categories WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($scReplyAttachmentCategoryID,$scReplyAttachmentCategoryCode,$scReplyAttachmentCategoryName,$position,$type,$timestamp);
while ($stm->fetch()) {
    $scReplyAttachmentCategoryCode= prepareString($scReplyAttachmentCategoryCode);
    $scReplyAttachmentCategoryName= prepareString($scReplyAttachmentCategoryName);

    $txt="INSERT OR REPLACE INTO 'SC_Reply_Attachment_Categories' VALUES ('$scReplyAttachmentCategoryID','$scReplyAttachmentCategoryCode','$scReplyAttachmentCategoryName','$position','$type','$timestamp')";
    if($isFile)
    {
        fwrite($file,$txt."\n");
    }
    else
    {
        $s = $xml->addChild('s');
        $s->addAttribute('c',$txt);
    }
    $counter++;
}
$stm-> close();

//--------------------------------- ERP_Customer_Ageing_Header --------------------------------------------------------


$stm = $db->prepare("SELECT company_id,period1_code,period1_name,period2_code,period2_name,period3_code,period3_name,period4_code,period4_name,period5_code,period5_name,period6_code,period6_name,period7_code,period7_name,period8_code,period8_name,period9_code,period9_name,notes,details,timestamp FROM ERP_Customer_Ageing_Header WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($company_id,$period1_code,$period1_name,$period2_code,$period2_name,$period3_code,$period3_name,$period4_code,$period4_name,$period5_code,$period5_name,$period6_code,$period6_name,$period7_code,$period7_name,$period8_code,$period8_name,$period9_code,$period9_name,$notes,$details,$timestamp);
while ($stm->fetch()) {
    $period1_code= prepareString($period1_code);
    $period1_name= prepareString($period1_name);
    $period2_code= prepareString($period2_code);
    $period2_name= prepareString($period2_name);
    $period3_code= prepareString($period3_code);
    $period3_name= prepareString($period3_name);
    $period4_code= prepareString($period4_code);
    $period4_name= prepareString($period4_name);
    $period5_code= prepareString($period5_code);
    $period5_name= prepareString($period5_name);
    $period6_code= prepareString($period6_code);
    $period6_name= prepareString($period6_name);
    $period7_code= prepareString($period7_code);
    $period7_name= prepareString($period7_name);
    $period8_code= prepareString($period8_code);
    $period8_name= prepareString($period8_name);
    $period9_code= prepareString($period9_code);
    $period9_name= prepareString($period9_name);
    $notes= prepareString($notes);
    $details= prepareString($details);

    $txt="INSERT OR REPLACE INTO 'ERP_Customer_Ageing_Header' VALUES ('$company_id','$period1_code','$period1_name','$period2_code','$period2_name','$period3_code','$period3_name','$period4_code','$period4_name','$period5_code','$period5_name','$period6_code','$period6_name','$period7_code','$period7_name','$period8_code','$period8_name','$period9_code','$period9_name','$notes','$details','$timestamp')";
    if($isFile)
    {
        fwrite($file,$txt."\n");
    }
    else
    {
        $s = $xml->addChild('s');
        $s->addAttribute('c',$txt);
    }
    $counter++;
}
$stm-> close();

//--------------------------------- ERP_Customer_Ageing --------------------------------------------------------


$stm = $db->prepare("SELECT customer_id,period1,period2,period3,period4,period5,period6,period7,period8,period9,balance,notes,details,date,timestamp FROM ERP_Customer_Ageing WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($customerID,$period1,$period2,$period3,$period4,$period5,$period6,$period7,$period8,$period9,$balance,$notes,$details,$date,$timestamp);
while ($stm->fetch()) {

    $notes= prepareString($notes);
    $details= prepareString($details);


    $txt="INSERT OR REPLACE INTO 'ERP_Customer_Ageing' VALUES ('$customerID','$period1','$period2','$period3','$period4','$period5','$period6','$period7','$period8','$period9','$balance','$notes','$details','$date','$timestamp')";
    if($isFile)
    {
        fwrite($file,$txt."\n");
    }
    else
    {
        $s = $xml->addChild('s');
        $s->addAttribute('c',$txt);
    }
    $counter++;
}
$stm-> close();


//--------------------------------- Company_Bank_Details --------------------------------------------------------

$stm = $db->prepare("SELECT company_bank_id, company_id, type, bank_name, sort_code, account_number, iban, bic, payment_term_id, position, details, timestamp FROM Company_Bank_Details WHERE timestamp >='$lastUpdate'");
$stm->execute();
$stm->bind_result($companyBankID, $companyID, $type, $bankName, $sortCode, $accountNumber, $iban, $bic, $paymentTermID, $position, $details, $timestamp);
while ($stm->fetch()) {
    $bankName= prepareString($bankName);
    $sortCode= prepareString($sortCode);
    $accountNumber= prepareString($accountNumber);
    $iban= prepareString($iban);
    $bic= prepareString($bic);
    $details= prepareString($details);

    $txt = "INSERT OR REPLACE INTO 'Company_Bank_Details' VALUES ('$companyBankID','$companyID','$type','$bankName','$sortCode','$accountNumber','$iban','$bic','$paymentTermID','$position','$details','$timestamp')";
    if ($isFile) {
        fwrite($file, $txt . "\n");
    } else {
        $s = $xml->addChild('s');
        $s->addAttribute('c', $txt);
    }
    $counter++;
}
$stm->close();

//--------------------------------- CustomerAddress_Hierarchy --------------------------------------------------------


$stm = $db->prepare("SELECT hierarchy_id,country,city,region,postcode,position,active,address,lat,lng,note1,note2,timestamp FROM CustomerAddress_Hierarchy WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($hierarchy_id,$country,$city,$region,$postcode,$position,$active,$address,$lat,$lng,$note1,$note2,$timestamp);
while ($stm->fetch()) {

    $country= prepareString($country);
    $city= prepareString($city);
    $region= prepareString($region);
    $postcode= prepareString($postcode);
    $address= prepareString($address);
    $note1= prepareString($note1);
    $note2= prepareString($note2);
    $active= prepareString($active);


    $txt="INSERT OR REPLACE INTO 'CustomerAddress_Hierarchy' VALUES ('$hierarchy_id','$country','$city','$region','$postcode','$position','$active','$address','$lat','$lng','$note1','$note2','$timestamp')";
    if($isFile)
    {
        fwrite($file,$txt."\n");
    }
    else
    {
        $s = $xml->addChild('s');
        $s->addAttribute('c',$txt);
    }
    $counter++;
}
$stm-> close();

//--------------------------------- ZA_Custom_Tables --------------------------------------------------------

$stm = $db->prepare("SELECT custom_table_id,custom_table_code,custom_table_name,display_name,linked_table,status,type,position,update_app,editable,required,timestamp FROM ZA_Custom_Tables WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($custom_table_id,$custom_table_code,$custom_table_name,$display_name,$linked_table,$status,$type,$position,$update_app,$editable,$required,$timestamp);
while ($stm->fetch()) {

    $custom_table_code= prepareString($custom_table_code);
    $custom_table_name= prepareString($custom_table_name);
    $display_name= prepareString($display_name);
    $linked_table= prepareString($linked_table);
    $status= prepareString($status);
    $type= prepareString($type);
    $update_app= prepareString($update_app);
    $editable= prepareString($editable);
    $required= prepareString($required);

    $txt="INSERT OR REPLACE INTO 'ZA_Custom_Tables' VALUES ('$custom_table_id','$custom_table_code','$custom_table_name','$display_name','$linked_table','$status','$type','$position','$update_app','$editable','$required','$timestamp')";
    if($isFile)
    {
        fwrite($file,$txt."\n");
    }
    else
    {
        $s = $xml->addChild('s');
        $s->addAttribute('c',$txt);
    }
    $counter++;
}
$stm-> close();

//--------------------------------- ZA_Custom_Table_Fields --------------------------------------------------------

$stm = $db->prepare("SELECT custom_table_id, custom_table_field, display_name, type, visible, position, default_values, css_style, class,editable,required, timestamp FROM ZA_Custom_Table_Fields WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm->bind_result($custom_table_id,$custom_table_field,$display_name,$type,$visible,$position,$default_values,$css_style,$class,$editable,$required,$timestamp);
while ($stm->fetch()) {

    $custom_table_field= prepareString($custom_table_field);
    $display_name= prepareString($display_name);
    $type= prepareString($type);
    $visible= prepareString($visible);
    $default_values= prepareString($default_values);
    $css_style= prepareString($css_style);
    $class= prepareString($class);
    $editable= prepareString($editable);
    $required= prepareString($required);

    $txt="INSERT OR REPLACE INTO 'ZA_Custom_Table_Fields' VALUES ('$custom_table_id','$custom_table_field','$display_name','$type','$visible','$position','$default_values','$css_style','$class','$editable','$required','$timestamp')";
    if($isFile)
    {
        fwrite($file,$txt."\n");
    }
    else
    {
        $s = $xml->addChild('s');
        $s->addAttribute('c',$txt);
    }
    $counter++;
}
$stm-> close();

//--------------------------------- Truck_Types --------------------------------------------------------

$stm = $db->prepare("SELECT truck_type_id, truck_type_name, number_of_columns, number_of_rows, number_of_levels, status, details, notes, created_by, position, creation_date, timestamp FROM Truck_Types WHERE timestamp >='$lastUpdate'");
$stm->execute();
$stm->bind_result($truckTypeID, $truckTypeName, $numberOfColumns, $numberOfRows, $numberOfLevels, $status, $details, $notes, $createdBy, $position, $creationDate, $timestamp);
while ($stm->fetch()) {
    $truckTypeName= prepareString($truckTypeName);
    $details= prepareString($details);
    $notes= prepareString($notes);
    $status= prepareString($status);

    $txt = "INSERT OR REPLACE INTO 'Truck_Types' VALUES ('$truckTypeID','$truckTypeName','$numberOfColumns','$numberOfRows','$numberOfLevels','$status','$details','$notes','$createdBy','$position','$creationDate','$timestamp')";
    if ($isFile) {
        fwrite($file, $txt . "\n");
    } else {
        $s = $xml->addChild('s');
        $s->addAttribute('c', $txt);
    }
    $counter++;
}
$stm->close();

//--------------------------------- Truck_Type_Positions --------------------------------------------------------

$stm = $db->prepare("SELECT truck_type_position_id, truck_type_id, position_name, column_number, `row_number`, level_number, volume, salesperson_id, group_id, category_id, details, status, creation_date, timestamp FROM Truck_Type_Positions WHERE timestamp >='$lastUpdate'");
$stm->execute();
$stm->bind_result($truckTypePositionID, $truckTypeID, $positionName, $columnNumber, $rowNumber, $levelNumber, $volume, $salespersonID, $groupID, $categoryID, $details, $status, $creationDate, $timestamp);
while ($stm->fetch()) {
    $positionName= prepareString($positionName);
    $details= prepareString($details);
    $status= prepareString($status);

    $txt = "INSERT OR REPLACE INTO 'Truck_Type_Positions' VALUES ('$truckTypePositionID','$truckTypeID','$positionName','$columnNumber','$rowNumber','$levelNumber','$volume','$salespersonID','$groupID','$categoryID','$details','$status','$creationDate','$timestamp')";
    if ($isFile) {
        fwrite($file, $txt . "\n");
    } else {
        $s = $xml->addChild('s');
        $s->addAttribute('c', $txt);
    }
    $counter++;
}
$stm->close();

//--------------------------------- Truck_Type_Trucks --------------------------------------------------------

$stm = $db->prepare("SELECT truck_id, truck_type_id, truck_code, truck_name, from_table, from_field, status, creation_date, timestamp FROM Truck_Type_Trucks WHERE timestamp >='$lastUpdate'");
$stm->execute();
$stm->bind_result($truckID, $truckTypeID, $truckCode, $truckName, $fromTable, $fromField, $status, $creationDate, $timestamp);
while ($stm->fetch()) {
    $truckCode= prepareString($truckCode);
    $truckName= prepareString($truckName);
    $fromTable= prepareString($fromTable);
    $fromField= prepareString($fromField);
    $status= prepareString($status);

    $txt = "INSERT OR REPLACE INTO 'Truck_Type_Trucks' VALUES ('$truckID','$truckTypeID','$truckCode','$truckName','$fromTable','$fromField','$status','$creationDate','$timestamp')";
    if ($isFile) {
        fwrite($file, $txt . "\n");
    } else {
        $s = $xml->addChild('s');
        $s->addAttribute('c', $txt);
    }
    $counter++;
}
$stm->close();

//--------------------------------- ERP_Reports --------------------------------------------------------
$stm = $db->prepare("SELECT report_id, salesperson_id, code, name, type, erp, icon, timestamp  FROM ERP_Reports WHERE timestamp >='$lastUpdate'");
$stm->execute();
$stm->bind_result($reportID, $salespersonID, $code, $name, $type, $erp, $icon, $timestamp);
while ($stm->fetch()) {
    $code= prepareString($code);
    $name= prepareString($name);
    $type= prepareString($type);
    $erp= prepareString($erp);
    $icon= prepareString($icon);

    $txt = "INSERT OR REPLACE INTO 'ERP_Reports' VALUES ('$reportID','$salespersonID','$code','$name','$type','$erp','$icon','$timestamp')";
    if ($isFile) {
        fwrite($file, $txt . "\n");
    } else {
        $s = $xml->addChild('s');
        $s->addAttribute('c', $txt);
    }
    $counter++;
}
$stm->close();

//--------------------------------- Dynamic Custom Tables (UDT) --------------------------------------------------------
$customTables = array();
$stm = $db->prepare("SELECT custom_table_id, custom_table_name FROM ZA_Custom_Tables WHERE NOT linked_table='' AND status = 'yes' AND update_app = 'yes'");
$stm-> execute();
$stm->bind_result($customTableID, $customTableName);
while ($stm->fetch()) {
    $line = new stdClass();
    $line->id = $customTableID;
    $line->table = $customTableName;
    array_push($customTables,$line);
}
$stm-> close();


foreach($customTables as $customTable){
    $customTableFields = array('id');
    $stm = $db->prepare("SELECT custom_table_field FROM ZA_Custom_Table_Fields WHERE custom_table_id='$customTable->id' ");
    $stm-> execute();
    $stm->bind_result($customTableField);
    while ($stm->fetch()) {
        array_push($customTableFields,$customTableField);
    }
    $stm-> close();
    array_push($customTableFields,'timestamp');

    if(count($customTableFields)>0){
        $stm = $db->prepare("SELECT ".implode(',',$customTableFields)." FROM ".$customTable->table." WHERE timestamp >='$lastUpdate'");
        $stm-> execute();
        $result = $stm->get_result();
        while($row = $result->fetch_array())
        {
            $txt = "INSERT OR REPLACE INTO '" . $customTable->table . "'(".implode(',',$customTableFields).") VALUES (";
            foreach ($customTableFields as $customTableField) {
                $txt .= "'" . prepareString($row[$customTableField]) . "',";
            }
            $txt = substr($txt, 0, -1);
            $txt .= ")";
            if ($isFile) {
                fwrite($file, $txt . "\n");
            } else {
                $s = $xml->addChild('s');
                $s->addAttribute('c', $txt);
            }
        }
        $stm-> close();

    }

}
//---------------------------------/Dynamic Custom Tables (UDT)/--------------------------------------------------------


//---------------------------------ZE_Rebate-----------------------------------
$stm =  $db->prepare("SELECT rebate_id, rebate_code, type_id, customer_id, category_id, item_id, valid_from, valid_until, status, qty, value, qty_awarded, value_awarded, discount_percent_awarded, max_qty_awared, max_value_awarded, inserted_date, salesperson_id, timestamp FROM ZE_Rebates WHERE timestamp >='$lastUpdate'");
$stm->execute();
$stm->bind_result($rebateID, $rebateCode, $typeID, $customerID, $categoryID, $itemID, $validFrom, $validUntil, $status, $qty, $value, $qtyAwarded, $valueAwarded, $discountPercentAwarded, $maxQtyAwarded, $maxValueAwarded, $insertedDate, $salespersonID, $timestamp);
while ($stm->fetch()) {
    $rebateCode= prepareString($rebateCode);
    $validFrom= prepareString($validFrom);
    $validUntil= prepareString($validUntil);
    $status= prepareString($status);
    $insertedDate= prepareString($insertedDate);

    $txt = "INSERT OR REPLACE INTO 'ZE_Rebates' VALUES ('$rebateID','$rebateCode','$typeID','$customerID','$categoryID','$itemID','$validFrom','$validUntil','$status','$qty','$value','$qtyAwarded','$valueAwarded','$discountPercentAwarded','$maxQtyAwarded','$maxValueAwarded','$insertedDate','$salespersonID','$timestamp')";
    if ($isFile) {
        fwrite($file, $txt . "\n");
    } else {
        $s = $xml->addChild('s');
        $s->addAttribute('c', $txt);
    }
    $counter++;

}
$stm->close();


//--------------------------ZE_Rebates_Transactions---------------------------------
$stm =  $db->prepare("SELECT rebate_transaction_id, rebate_id, rebate_transaction_date, year, month, qty_sales, value_sales, qty_awarded, calculated_value, value_awarded, exported, paid_value, timestamp FROM ZE_Rebates_Transactions WHERE timestamp >='$lastUpdate'");
$stm->execute();
$stm->bind_result($rebateTransactionID, $rebateID, $rebateTransactionDate, $year, $month, $qtySales, $valueSales, $qtyAwarded, $calculatedValue, $valueAwarded, $exported, $paidValue, $timestamp);
while ($stm->fetch()) {
    $rebateTransactionDate= prepareString($rebateTransactionDate);
    $exported= prepareString($exported);

    $txt = "INSERT OR REPLACE INTO 'ZE_Rebates_Transactions' VALUES ('$rebateTransactionID','$rebateID','$rebateTransactionDate','$year','$month','$qtySales','$valueSales','$qtyAwarded','$calculatedValue','$valueAwarded','$exported','$paidValue','$timestamp')";
    if ($isFile) {
        fwrite($file, $txt . "\n");
    } else {
        $s = $xml->addChild('s');
        $s->addAttribute('c', $txt);
    }

    $counter++;

}
$stm->close();

//--------------------------Customer_Attachment---------------------------------
$stm =  $db->prepare("SELECT customer_attachment_id, customer_id, attachment_name, attachment_url, attachment_order, timestamp FROM Customer_Attachment WHERE timestamp >='$lastUpdate'");
$stm->execute();
$stm->bind_result($customerAttachmentID, $customerID, $attachmentName, $attachmentURL, $attachmentOrder, $timestamp);
while ($stm->fetch()) {
    $attachmentName= prepareString($attachmentName);
    $attachmentURL= prepareString($attachmentURL);

    $txt = "INSERT OR REPLACE INTO 'Customer_Attachment' VALUES ('$customerAttachmentID','$customerID','$attachmentName','$attachmentURL','$attachmentOrder','$timestamp')";
    if ($isFile) {
        fwrite($file, $txt . "\n");
    } else {
        $s = $xml->addChild('s');
        $s->addAttribute('c', $txt);
    }

    $counter++;

}
$stm->close();

//--------------------------Invoice_Suggested_Ordering---------------------------------
$stm =  $db->prepare("SELECT suggested_ordering_id, item_id, customer_id, invoice_id,return_id,customer_stock_taking_id, date, customer_stock, return_qty, suggested_qty, invoiced_qty, customer_sales, offer, timestamp FROM Invoice_Suggested_Ordering WHERE timestamp >='$lastUpdate'");
$stm->execute();
$stm->bind_result($suggestedOrderingID, $itemID, $customerID, $invoiceID, $returnID, $customerStockTakingID, $date, $customerStock, $returnQty, $suggestedQty, $invoicedQty, $customerSales, $offer, $timestamp);
while ($stm->fetch()) {
    $date= prepareString($date);
    $offer= prepareString($offer);

    $txt = "INSERT OR REPLACE INTO 'Invoice_Suggested_Ordering' VALUES ('$suggestedOrderingID','$itemID','$customerID','$invoiceID','$returnID','$customerStockTakingID','$date','$customerStock','$returnQty','$suggestedQty','$invoicedQty','$customerSales','$offer','$timestamp')";
    if ($isFile) {
        fwrite($file, $txt . "\n");
    } else {
        $s = $xml->addChild('s');
        $s->addAttribute('c', $txt);
    }

    $counter++;

}
$stm->close();

//--------------------------Supervisor_Month_Planning---------------------------------
$stm =  $db->prepare("SELECT month_year, salesperson_id, submitted, route_control_planned, work_with_planned, route_control_completed, work_with_completed, initial_submission, final_submission, timestamp FROM Supervisor_Month_Planning WHERE timestamp >='$lastUpdate'");
$stm->execute();
$stm->bind_result($monthYear, $salespersonID, $submitted, $routeControlPlanned, $workWithPlanned, $routeControlCompleted, $workWithCompleted, $initialSubmission, $finalSubmission, $timestamp);
while ($stm->fetch()) {
    $submitted= prepareString($submitted);
    $routeControlPlanned= prepareString($routeControlPlanned);
    $workWithPlanned= prepareString($workWithPlanned);
    $routeControlCompleted= prepareString($routeControlCompleted);
    $workWithCompleted= prepareString($workWithCompleted);
    $initialSubmission= prepareString($initialSubmission);
    $finalSubmission= prepareString($finalSubmission);

    $txt = "INSERT OR REPLACE INTO 'Supervisor_Month_Planning' VALUES ('$monthYear','$salespersonID','$submitted','$routeControlPlanned','$workWithPlanned','$routeControlCompleted','$workWithCompleted','$initialSubmission','$finalSubmission','$timestamp')";
    if ($isFile) {
        fwrite($file, $txt . "\n");
    } else {
        $s = $xml->addChild('s');
        $s->addAttribute('c', $txt);
    }

    $counter++;

}
$stm->close();

//--------------------------Approval_Requests---------------------------------
$stm =  $db->prepare("SELECT request_id, company_id, device_id, salesperson_id, customer_id, customer_group_id, category_id, item_id, document_id, document_type, request_type, request_time, status, response_time, response_salesperson_id, response_device_id, response_reason, valid_from, valid_until, title, details, notes, timestamp FROM Approval_Requests WHERE timestamp >='$lastUpdate' $activationWindow");
$stm->execute();
$stm->bind_result($requestID, $companyID, $deviceID, $salespersonID, $customerID, $customerGroupID, $categoryID, $itemID, $documentID, $documentType, $requestType, $requestTime, $status, $responseTime, $responseSalespersonID, $responseDeviceID, $responseReason, $validFrom, $validUntil, $title, $details, $notes, $timestamp);
while ($stm->fetch()) {
    $requestType= prepareString($requestType);
    $status= prepareString($status);
    $responseReason= prepareString($responseReason);
    $title= prepareString($title);
    $details= prepareString($details);
    $notes= prepareString($notes);

    $txt = "INSERT OR REPLACE INTO 'Approval_Requests' VALUES ('$requestID','$companyID','$deviceID','$salespersonID','$customerID','$customerGroupID','$categoryID','$itemID','$documentID','$documentType','$requestType','$requestTime','$status','$responseTime','$responseSalespersonID','$responseDeviceID','$responseReason','$validFrom','$validUntil','$title','$details','$notes','$timestamp')";
    if ($isFile) {
        fwrite($file, $txt . "\n");
    } else {
        $s = $xml->addChild('s');
        $s->addAttribute('c', $txt);
    }

    $counter++;

}
$stm->close();

//----------------------------Action_Numbering---------------------------

$stm = $db->prepare("SELECT numbering_id,company_id,salesperson_id,action,prefix,preceding_device_prefix,begin_number,title,details,notes,position,active,timestamp FROM Action_Numbering WHERE timestamp >='$lastUpdate' $activationWindow");
$stm-> execute();
$stm-> bind_result($numberingID, $companyID, $salesPesronID, $aciton,$prefix,$precedingDevicePrefix,$beginNumber,$title,$details,$notes,$position,$active,$timestamp);

while ($stm->fetch()) {

    $action = prepareString($action);
    $prefix = prepareString($prefix);
    $precedingDevicePrefix = prepareString($precedingDevicePrefix);
    $title = prepareString($title);
    $active = prepareString($active);


    $txt="INSERT OR REPLACE INTO  'Action_Numbering' VALUES ('$numberingID','$companyID','$salesPesronID','$aciton','$prefix','$precedingDevicePrefix','$beginNumber','$title','$details','$notes','$position','$active','$timestamp')";
    if($isFile)
    {
        fwrite($file,$txt."\n");
    }
    else
    {
        $s = $xml->addChild('s');
        $s->addAttribute('c',$txt);
    }

    $counter++;
}
$stm-> close();


//--------------------------Related_Items---------------------------------
$stm =  $db->prepare("SELECT item_id, related_item_id, position, timestamp FROM Related_Items WHERE timestamp >='$lastUpdate'");
$stm->execute();
$stm->bind_result($itemID, $relatedItemID, $position, $timestamp);
while ($stm->fetch()) {
    $txt = "INSERT OR REPLACE INTO 'Related_Items' VALUES ('$itemID','$relatedItemID','$position','$timestamp')";
    if ($isFile) {
        fwrite($file, $txt . "\n");
    } else {
        $s = $xml->addChild('s');
        $s->addAttribute('c', $txt);
    }

    $counter++;

}
$stm->close();

//--------------------------Warehouse_Transactions_Request_Transactions---------------------------------
$stm =  $db->prepare("SELECT request_id, transaction_id, salesperson_id, transaction_date, notes, status, timestamp FROM Warehouse_Transactions_Request_Transactions WHERE timestamp >='$lastUpdate'  $activationWindow");
$stm->execute();
$stm->bind_result($requestID, $transactionID, $salespersonID, $transactionDate, $notes, $status, $timestamp);
while ($stm->fetch()) {
    $notes = prepareString($notes);
    $status = prepareString($status);

    $txt = "INSERT OR REPLACE INTO 'Warehouse_Transactions_Request_Transactions' VALUES ('$requestID','$transactionID','$salespersonID','$transactionDate','$notes','$status','$timestamp')";
    if ($isFile) {
        fwrite($file, $txt . "\n");
    } else {
        $s = $xml->addChild('s');
        $s->addAttribute('c', $txt);
    }
}
$stm->close();

//--------------------------------SC_Filter_CustomerGroups---------------------------------
$stm =  $db->prepare("SELECT filter_id, group_id, timestamp FROM SC_Filter_CustomerGroups WHERE timestamp >='$lastUpdate'");
$stm->execute();
$stm->bind_result($filterID, $groupID, $timestamp);
while ($stm->fetch()) {
    $txt = "INSERT OR REPLACE INTO 'SC_Filter_CustomerGroups' VALUES ('$filterID','$groupID','$timestamp')";
    if ($isFile) {
        fwrite($file, $txt . "\n");
    } else {
        $s = $xml->addChild('s');
        $s->addAttribute('c', $txt);
    }
}



//Companies

$stm = $db->prepare("SELECT company_id,company_code,company_name,company_report_name,logo,registration_code,tic_code,vat_code,website,email,line1,line2,line3,line4,line5,line6,line7,timestamp FROM Companies WHERE timestamp >='$lastUpdate'");
$stm-> execute();
$stm-> bind_result($companyID,$companyCode,$companyName,$companyReportName,$logo,$registrationCode,$ticCode,$vatCode,$website,$email,$line1,$line2,$line3,$line4,$line5,$line6,$line7,$timestamp);
while ($stm->fetch()) {
    
 
$companyCode= prepareString($companyCode);
$companyName= prepareString($companyName);
$companyReportName= prepareString($companyReportName);
$logo= prepareString($logo);
$registrationCode= prepareString($registrationCode);
$ticCode= prepareString($ticCode);
$vatCode= prepareString($vatCode);
$website= prepareString($website);
$email= prepareString($email);
$line1= prepareString($line1);
$line2= prepareString($line2);
$line3= prepareString($line3);
$line4= prepareString($line4);
$line5= prepareString($line5);
$line6= prepareString($line6);
$line7= prepareString($line7);

    
    
    
    
   
    $txt="INSERT OR REPLACE INTO  'Companies' VALUES ('$companyID','$companyCode','$companyName','$companyReportName','$logo','$registrationCode','$ticCode','$vatCode','$website','$email','$line1','$line2','$line3','$line4','$line5','$line6','$line7','$timestamp')";
    if($isFile)
   {
      fwrite($file,$txt."\n");
   }
   else
   {
     $s = $xml->addChild('s');
     $s->addAttribute('c',$txt);
   }
$counter++;
}
$stm-> close();

$s = $xml->addChild('num');

$s->addAttribute('number',$counter);
$s = $xml->addChild('l');
	
	

             $s->addAttribute('link',$activateLink.'sync'.$devID.'.txt');

 fclose($file);
 
 $date = new DateTime();
fwrite($myfile,"End Time : ".$date->getTimestamp()."\n");
 fclose($myfile);
print($xml->asXML());




function prepareString($a)
{
    $charToReplace=array("'","\"","\n","<",">","\r");
    $a=str_replace($charToReplace,"",$a);
    return $a;
}



?>